/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelmemoryusage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage.KernelMemoryAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.memory.MemoryUsageTreeModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernelmemoryusage.Messages;
import org.eclipse.tracecompass.internal.tmf.core.model.filters.FetchParametersUtils;
import org.eclipse.tracecompass.internal.tmf.core.model.xy.AbstractTreeCommonXDataProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.YModel;
import org.eclipse.tracecompass.tmf.core.model.filters.SelectionTimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeModel;
import org.eclipse.tracecompass.tmf.core.model.xy.IYModel;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

@NonNullByDefault
public class KernelMemoryUsageDataProvider
extends AbstractTreeCommonXDataProvider<KernelMemoryAnalysisModule, MemoryUsageTreeModel> {
    public static final String ID = "org.eclipse.tracecompass.analysis.os.linux.core.kernelmemoryusage";
    private static final int TOTAL_TID = -2;
    private final KernelAnalysisModule fKernelModule;
    private final Map<String, String> fProcessNameMap = new HashMap<String, String>();

    public static @Nullable KernelMemoryUsageDataProvider create(ITmfTrace trace) {
        KernelMemoryAnalysisModule module = (KernelMemoryAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelMemoryAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.core.kernelmemory");
        KernelAnalysisModule kernelModule = (KernelAnalysisModule)TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)trace, KernelAnalysisModule.class, (String)"org.eclipse.tracecompass.analysis.os.linux.kernel");
        if (module != null && kernelModule != null) {
            module.schedule();
            return new KernelMemoryUsageDataProvider(trace, module, kernelModule);
        }
        return null;
    }

    private KernelMemoryUsageDataProvider(ITmfTrace trace, KernelMemoryAnalysisModule module, KernelAnalysisModule kernelModule) {
        super(trace, (TmfStateSystemAnalysisModule)module);
        this.fKernelModule = kernelModule;
    }

    protected @Nullable Collection<IYModel> getYSeriesModels(ITmfStateSystem ss, Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        SelectionTimeQueryFilter filter = FetchParametersUtils.createSelectionTimeQuery(fetchParameters);
        if (filter == null) {
            return null;
        }
        long[] xValues = filter.getTimesRequested();
        long currentEnd = ss.getCurrentEndTime();
        double[] totalKernelMemoryValues = new double[xValues.length];
        Map<Integer, IYModel> selectedSeries = this.initSeries(ss, filter);
        List threadQuarkList = ss.getSubAttributes(-1, false);
        if (threadQuarkList.isEmpty()) {
            return Collections.emptyList();
        }
        Collection times = KernelMemoryUsageDataProvider.getTimes((TimeQueryFilter)filter, (long)ss.getStartTime(), (long)currentEnd);
        for (ITmfStateInterval interval : ss.query2D((Collection)threadQuarkList, times)) {
            if (monitor != null && monitor.isCanceled()) {
                return null;
            }
            Object object = interval.getValue();
            if (!(object instanceof Number)) continue;
            double value = ((Number)object).doubleValue();
            int from = Arrays.binarySearch(xValues, interval.getStartTime());
            from = from >= 0 ? from : -1 - from;
            int to = Arrays.binarySearch(xValues, from, xValues.length, interval.getEndTime());
            to = to >= 0 ? to + 1 : -1 - to;
            int i2 = from;
            while (i2 < to) {
                int n = i2++;
                totalKernelMemoryValues[n] = totalKernelMemoryValues[n] + value;
            }
            IYModel selectedThreadValues = selectedSeries.get(interval.getAttribute());
            if (selectedThreadValues == null) continue;
            Arrays.fill(selectedThreadValues.getData(), from, to, value);
        }
        List endState = ss.queryFullState(Long.min(filter.getEnd(), currentEnd));
        double d = KernelMemoryUsageDataProvider.extractTotalValueShift(ss, endState);
        Arrays.setAll(totalKernelMemoryValues, i -> totalKernelMemoryValues[i] + d);
        for (Map.Entry<Integer, IYModel> entry : selectedSeries.entrySet()) {
            Object value;
            int lowestMemoryQuark = ss.optQuarkRelative(entry.getKey().intValue(), new String[]{"lowestMemory"});
            if (lowestMemoryQuark == -2 || !((value = ((ITmfStateInterval)endState.get(lowestMemoryQuark)).getValue()) instanceof Number)) continue;
            double[] threadValues = entry.getValue().getData();
            double shift = ((Number)value).doubleValue();
            Arrays.setAll(threadValues, i -> threadValues[i] - shift);
        }
        ImmutableList.Builder ySeries = ImmutableList.builder();
        String total = String.valueOf(this.getTrace().getName()) + ":total";
        ySeries.add((Object)new YModel(this.getId(-1), total, totalKernelMemoryValues));
        ySeries.addAll(selectedSeries.values());
        return ySeries.build();
    }

    private Map<Integer, IYModel> initSeries(ITmfStateSystem ss, SelectionTimeQueryFilter filter) {
        int length = filter.getTimesRequested().length;
        HashMap<Integer, IYModel> map = new HashMap<Integer, IYModel>();
        for (Map.Entry entry : this.getSelectedEntries(filter).entrySet()) {
            String selectedThreadName = String.valueOf(this.getTrace().getName()) + ':' + ss.getAttributeName(((Integer)entry.getValue()).intValue());
            map.put((Integer)entry.getValue(), (IYModel)new YModel(((Long)entry.getKey()).longValue(), selectedThreadName, new double[length]));
        }
        return map;
    }

    private static double extractTotalValueShift(ITmfStateSystem ss, List<ITmfStateInterval> endState) {
        double totalKernelMemoryValuesShift = 0.0;
        List threadQuarkList = ss.getQuarks(new String[]{"*", "lowestMemory"});
        for (Integer threadQuark : threadQuarkList) {
            ITmfStateInterval lowestMemoryInterval = endState.get(threadQuark);
            Object val = lowestMemoryInterval.getValue();
            if (!(val instanceof Number)) continue;
            totalKernelMemoryValuesShift -= ((Number)val).doubleValue();
        }
        return totalKernelMemoryValuesShift;
    }

    protected TmfTreeModel<MemoryUsageTreeModel> getTree(ITmfStateSystem ss, Map<String, Object> parameters, @Nullable IProgressMonitor monitor) throws StateSystemDisposedException {
        TimeQueryFilter filter = FetchParametersUtils.createTimeQuery(parameters);
        if (filter == null) {
            return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
        }
        long start = filter.getStart();
        long end = filter.getEnd();
        List active = null;
        Boolean isFiltered = DataProviderParameterUtils.extractIsFiltered(parameters);
        if (isFiltered != null && isFiltered.booleanValue()) {
            if (start == end || start > ss.getCurrentEndTime() || end < ss.getStartTime()) {
                return new TmfTreeModel(Collections.emptyList(), Collections.emptyList());
            }
            active = ss.queryFullState(Long.max(start, ss.getStartTime()));
        }
        ArrayList<MemoryUsageTreeModel> nodes = new ArrayList<MemoryUsageTreeModel>();
        List threadQuarkList = ss.getSubAttributes(-1, false);
        long totalId = this.getId(-1);
        nodes.add(new MemoryUsageTreeModel(totalId, -1L, -2, Collections.singletonList(this.getTrace().getName())));
        for (Integer threadQuark : threadQuarkList) {
            if (active != null && (threadQuark >= active.size() || ((ITmfStateInterval)active.get(threadQuark)).getEndTime() >= end)) continue;
            String tidString = ss.getAttributeName(threadQuark.intValue());
            String procname = this.fProcessNameMap.computeIfAbsent(tidString, string -> this.getProcessName((String)string, end));
            long id = this.getId(threadQuark);
            nodes.add(new MemoryUsageTreeModel(id, totalId, KernelMemoryUsageDataProvider.parseTid(tidString), Collections.singletonList(procname)));
        }
        return new TmfTreeModel(Collections.emptyList(), nodes);
    }

    private static int parseTid(String tidString) {
        try {
            return Integer.parseInt(tidString);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private String getProcessName(String tid, long ts) {
        if (tid.equals("other")) {
            return tid;
        }
        String execName = KernelThreadInformationProvider.getExecutableName(this.fKernelModule, Integer.parseInt(tid), ts);
        return execName != null ? execName : tid;
    }

    public String getId() {
        return ID;
    }

    protected boolean isCacheable() {
        return false;
    }

    protected String getTitle() {
        return Objects.requireNonNull(Messages.KernelMemoryUsageDataProvider_title);
    }
}

