/*******************************************************************************
 * Copyright (c) 2000, 2021 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *    IBM Corporation - initial API and implementation
 *******************************************************************************/

/* Note: This file was auto-generated by org.eclipse.swt.tools.internal.JNIGenerator */
/* DO NOT EDIT - your changes will be lost. */

#include "swt.h"
#include "os_structs.h"
#include "os_stats.h"

#ifndef OS_NATIVE
#define OS_NATIVE(func) Java_org_eclipse_swt_internal_win32_OS_##func
#endif

#ifndef NO_ACCEL_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(ACCEL_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ACCEL_1sizeof_FUNC);
	rc = (jint)ACCEL_sizeof();
	OS_NATIVE_EXIT(env, that, ACCEL_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_ACTCTX_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(ACTCTX_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ACTCTX_1sizeof_FUNC);
	rc = (jint)ACTCTX_sizeof();
	OS_NATIVE_EXIT(env, that, ACTCTX_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_AbortDoc
JNIEXPORT jint JNICALL OS_NATIVE(AbortDoc)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, AbortDoc_FUNC);
	rc = (jint)AbortDoc((HDC)arg0);
	OS_NATIVE_EXIT(env, that, AbortDoc_FUNC);
	return rc;
}
#endif

#ifndef NO_ActivateActCtx
JNIEXPORT jboolean JNICALL OS_NATIVE(ActivateActCtx)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1)
{
	jlong *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ActivateActCtx_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)ActivateActCtx((HANDLE)arg0, (ULONG_PTR*)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, ActivateActCtx_FUNC);
	return rc;
}
#endif

#ifndef NO_ActivateKeyboardLayout
JNIEXPORT jlong JNICALL OS_NATIVE(ActivateKeyboardLayout)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ActivateKeyboardLayout_FUNC);
	rc = (jlong)ActivateKeyboardLayout((HKL)arg0, arg1);
	OS_NATIVE_EXIT(env, that, ActivateKeyboardLayout_FUNC);
	return rc;
}
#endif

#ifndef NO_AddFontResourceEx
JNIEXPORT jint JNICALL OS_NATIVE(AddFontResourceEx)
	(JNIEnv *env, jclass that, jcharArray arg0, jint arg1, jlong arg2)
{
	jchar *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, AddFontResourceEx_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)AddFontResourceEx(lparg0, arg1, (PVOID)arg2);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, AddFontResourceEx_FUNC);
	return rc;
}
#endif

#ifndef NO_AdjustWindowRectEx
JNIEXPORT jboolean JNICALL OS_NATIVE(AdjustWindowRectEx)
	(JNIEnv *env, jclass that, jobject arg0, jint arg1, jboolean arg2, jint arg3)
{
	RECT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, AdjustWindowRectEx_FUNC);
	if (arg0) if ((lparg0 = getRECTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)AdjustWindowRectEx(lparg0, arg1, arg2, arg3);
fail:
	if (arg0 && lparg0) setRECTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, AdjustWindowRectEx_FUNC);
	return rc;
}
#endif

#ifndef NO_AllowSetForegroundWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(AllowSetForegroundWindow)
	(JNIEnv *env, jclass that, jint arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, AllowSetForegroundWindow_FUNC);
	rc = (jboolean)AllowSetForegroundWindow(arg0);
	OS_NATIVE_EXIT(env, that, AllowSetForegroundWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_AlphaBlend
JNIEXPORT jboolean JNICALL OS_NATIVE(AlphaBlend)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jobject arg10)
{
	BLENDFUNCTION _arg10, *lparg10=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, AlphaBlend_FUNC);
	if (arg10) if ((lparg10 = getBLENDFUNCTIONFields(env, arg10, &_arg10)) == NULL) goto fail;
	rc = (jboolean)AlphaBlend((HDC)arg0, arg1, arg2, arg3, arg4, (HDC)arg5, arg6, arg7, arg8, arg9, *lparg10);
fail:
	if (arg10 && lparg10) setBLENDFUNCTIONFields(env, arg10, lparg10);
	OS_NATIVE_EXIT(env, that, AlphaBlend_FUNC);
	return rc;
}
#endif

#ifndef NO_Arc
JNIEXPORT jboolean JNICALL OS_NATIVE(Arc)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jint arg8)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Arc_FUNC);
	rc = (jboolean)Arc((HDC)arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	OS_NATIVE_EXIT(env, that, Arc_FUNC);
	return rc;
}
#endif

#ifndef NO_AssocQueryString
JNIEXPORT jint JNICALL OS_NATIVE(AssocQueryString)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jcharArray arg2, jcharArray arg3, jcharArray arg4, jintArray arg5)
{
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, AssocQueryString_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetCharArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	rc = (jint)AssocQueryString(arg0, arg1, lparg2, lparg3, lparg4, (DWORD *)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseCharArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, JNI_ABORT);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, AssocQueryString_FUNC);
	return rc;
}
#endif

#ifndef NO_BITMAPINFOHEADER_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(BITMAPINFOHEADER_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BITMAPINFOHEADER_1sizeof_FUNC);
	rc = (jint)BITMAPINFOHEADER_sizeof();
	OS_NATIVE_EXIT(env, that, BITMAPINFOHEADER_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_BITMAP_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(BITMAP_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BITMAP_1sizeof_FUNC);
	rc = (jint)BITMAP_sizeof();
	OS_NATIVE_EXIT(env, that, BITMAP_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_BLENDFUNCTION_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(BLENDFUNCTION_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BLENDFUNCTION_1sizeof_FUNC);
	rc = (jint)BLENDFUNCTION_sizeof();
	OS_NATIVE_EXIT(env, that, BLENDFUNCTION_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_BP_1PAINTPARAMS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(BP_1PAINTPARAMS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BP_1PAINTPARAMS_1sizeof_FUNC);
	rc = (jint)BP_PAINTPARAMS_sizeof();
	OS_NATIVE_EXIT(env, that, BP_1PAINTPARAMS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_BUTTON_1IMAGELIST_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(BUTTON_1IMAGELIST_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BUTTON_1IMAGELIST_1sizeof_FUNC);
	rc = (jint)BUTTON_IMAGELIST_sizeof();
	OS_NATIVE_EXIT(env, that, BUTTON_1IMAGELIST_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_BeginBufferedPaint
JNIEXPORT jlong JNICALL OS_NATIVE(BeginBufferedPaint)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2, jobject arg3, jlongArray arg4)
{
	RECT _arg1, *lparg1=NULL;
	BP_PAINTPARAMS _arg3, *lparg3=NULL;
	jlong *lparg4=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, BeginBufferedPaint_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getBP_PAINTPARAMSFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetLongArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jlong)BeginBufferedPaint((HDC)arg0, lparg1, arg2, lparg3, (HDC*)lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseLongArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) setBP_PAINTPARAMSFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, BeginBufferedPaint_FUNC);
	return rc;
}
#endif

#ifndef NO_BeginDeferWindowPos
JNIEXPORT jlong JNICALL OS_NATIVE(BeginDeferWindowPos)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, BeginDeferWindowPos_FUNC);
	rc = (jlong)BeginDeferWindowPos(arg0);
	OS_NATIVE_EXIT(env, that, BeginDeferWindowPos_FUNC);
	return rc;
}
#endif

#ifndef NO_BeginPaint
JNIEXPORT jlong JNICALL OS_NATIVE(BeginPaint)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	PAINTSTRUCT _arg1, *lparg1=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, BeginPaint_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jlong)BeginPaint((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setPAINTSTRUCTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, BeginPaint_FUNC);
	return rc;
}
#endif

#ifndef NO_BitBlt
JNIEXPORT jboolean JNICALL OS_NATIVE(BitBlt)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, BitBlt_FUNC);
	rc = (jboolean)BitBlt((HDC)arg0, arg1, arg2, arg3, arg4, (HDC)arg5, arg6, arg7, arg8);
	OS_NATIVE_EXIT(env, that, BitBlt_FUNC);
	return rc;
}
#endif

#ifndef NO_BringWindowToTop
JNIEXPORT jboolean JNICALL OS_NATIVE(BringWindowToTop)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, BringWindowToTop_FUNC);
	rc = (jboolean)BringWindowToTop((HWND)arg0);
	OS_NATIVE_EXIT(env, that, BringWindowToTop_FUNC);
	return rc;
}
#endif

#ifndef NO_BufferedPaintInit
JNIEXPORT jint JNICALL OS_NATIVE(BufferedPaintInit)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BufferedPaintInit_FUNC);
	rc = (jint)BufferedPaintInit();
	OS_NATIVE_EXIT(env, that, BufferedPaintInit_FUNC);
	return rc;
}
#endif

#ifndef NO_BufferedPaintUnInit
JNIEXPORT jint JNICALL OS_NATIVE(BufferedPaintUnInit)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, BufferedPaintUnInit_FUNC);
	rc = (jint)BufferedPaintUnInit();
	OS_NATIVE_EXIT(env, that, BufferedPaintUnInit_FUNC);
	return rc;
}
#endif

#ifndef NO_CANDIDATEFORM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(CANDIDATEFORM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CANDIDATEFORM_1sizeof_FUNC);
	rc = (jint)CANDIDATEFORM_sizeof();
	OS_NATIVE_EXIT(env, that, CANDIDATEFORM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_CHOOSECOLOR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(CHOOSECOLOR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CHOOSECOLOR_1sizeof_FUNC);
	rc = (jint)CHOOSECOLOR_sizeof();
	OS_NATIVE_EXIT(env, that, CHOOSECOLOR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_CHOOSEFONT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(CHOOSEFONT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CHOOSEFONT_1sizeof_FUNC);
	rc = (jint)CHOOSEFONT_sizeof();
	OS_NATIVE_EXIT(env, that, CHOOSEFONT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_CIDA_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(CIDA_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CIDA_1sizeof_FUNC);
	rc = (jint)CIDA_sizeof();
	OS_NATIVE_EXIT(env, that, CIDA_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_COMBOBOXINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(COMBOBOXINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, COMBOBOXINFO_1sizeof_FUNC);
	rc = (jint)COMBOBOXINFO_sizeof();
	OS_NATIVE_EXIT(env, that, COMBOBOXINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_COMPOSITIONFORM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(COMPOSITIONFORM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, COMPOSITIONFORM_1sizeof_FUNC);
	rc = (jint)COMPOSITIONFORM_sizeof();
	OS_NATIVE_EXIT(env, that, COMPOSITIONFORM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_CREATESTRUCT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(CREATESTRUCT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CREATESTRUCT_1sizeof_FUNC);
	rc = (jint)CREATESTRUCT_sizeof();
	OS_NATIVE_EXIT(env, that, CREATESTRUCT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_CallNextHookEx
JNIEXPORT jlong JNICALL OS_NATIVE(CallNextHookEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CallNextHookEx_FUNC);
	rc = (jlong)CallNextHookEx((HHOOK)arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, CallNextHookEx_FUNC);
	return rc;
}
#endif

#ifndef NO_CallWindowProc
JNIEXPORT jlong JNICALL OS_NATIVE(CallWindowProc)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CallWindowProc_FUNC);
	rc = (jlong)CallWindowProc((WNDPROC)arg0, (HWND)arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, CallWindowProc_FUNC);
	return rc;
}
#endif

#ifndef NO_CharLower
JNIEXPORT jlong JNICALL OS_NATIVE(CharLower)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CharLower_FUNC);
	rc = (jlong)CharLower((LPWSTR)arg0);
	OS_NATIVE_EXIT(env, that, CharLower_FUNC);
	return rc;
}
#endif

#ifndef NO_CharUpper
JNIEXPORT jlong JNICALL OS_NATIVE(CharUpper)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CharUpper_FUNC);
	rc = (jlong)CharUpper((LPWSTR)arg0);
	OS_NATIVE_EXIT(env, that, CharUpper_FUNC);
	return rc;
}
#endif

#ifndef NO_ChildWindowFromPointEx
JNIEXPORT jlong JNICALL OS_NATIVE(ChildWindowFromPointEx)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	POINT _arg1, *lparg1=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ChildWindowFromPointEx_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jlong)ChildWindowFromPointEx((HWND)arg0, *lparg1, (UINT)arg2);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, ChildWindowFromPointEx_FUNC);
	return rc;
}
#endif

#ifndef NO_ChooseColor
JNIEXPORT jboolean JNICALL OS_NATIVE(ChooseColor)
	(JNIEnv *env, jclass that, jobject arg0)
{
	CHOOSECOLOR _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ChooseColor_FUNC);
	if (arg0) if ((lparg0 = getCHOOSECOLORFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)ChooseColor(lparg0);
fail:
	if (arg0 && lparg0) setCHOOSECOLORFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, ChooseColor_FUNC);
	return rc;
}
#endif

#ifndef NO_ChooseFont
JNIEXPORT jboolean JNICALL OS_NATIVE(ChooseFont)
	(JNIEnv *env, jclass that, jobject arg0)
{
	CHOOSEFONT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ChooseFont_FUNC);
	if (arg0) if ((lparg0 = getCHOOSEFONTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)ChooseFont(lparg0);
fail:
	if (arg0 && lparg0) setCHOOSEFONTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, ChooseFont_FUNC);
	return rc;
}
#endif

#ifndef NO_ClientToScreen
JNIEXPORT jboolean JNICALL OS_NATIVE(ClientToScreen)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ClientToScreen_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ClientToScreen((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, ClientToScreen_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseClipboard
JNIEXPORT jboolean JNICALL OS_NATIVE(CloseClipboard)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, CloseClipboard_FUNC);
	rc = (jboolean)CloseClipboard();
	OS_NATIVE_EXIT(env, that, CloseClipboard_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseEnhMetaFile
JNIEXPORT jlong JNICALL OS_NATIVE(CloseEnhMetaFile)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CloseEnhMetaFile_FUNC);
	rc = (jlong)CloseEnhMetaFile((HDC)arg0);
	OS_NATIVE_EXIT(env, that, CloseEnhMetaFile_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseGestureInfoHandle
JNIEXPORT jlong JNICALL OS_NATIVE(CloseGestureInfoHandle)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CloseGestureInfoHandle_FUNC);
	rc = (jlong)CloseGestureInfoHandle((HGESTUREINFO)arg0);
	OS_NATIVE_EXIT(env, that, CloseGestureInfoHandle_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseHandle
JNIEXPORT jboolean JNICALL OS_NATIVE(CloseHandle)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, CloseHandle_FUNC);
	rc = (jboolean)CloseHandle((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, CloseHandle_FUNC);
	return rc;
}
#endif

#ifndef NO_ClosePrinter
JNIEXPORT jboolean JNICALL OS_NATIVE(ClosePrinter)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ClosePrinter_FUNC);
	rc = (jboolean)ClosePrinter((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, ClosePrinter_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseThemeData
JNIEXPORT jint JNICALL OS_NATIVE(CloseThemeData)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CloseThemeData_FUNC);
	rc = (jint)CloseThemeData((HTHEME)arg0);
	OS_NATIVE_EXIT(env, that, CloseThemeData_FUNC);
	return rc;
}
#endif

#ifndef NO_CloseTouchInputHandle
JNIEXPORT jboolean JNICALL OS_NATIVE(CloseTouchInputHandle)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, CloseTouchInputHandle_FUNC);
	rc = (jboolean)CloseTouchInputHandle((HTOUCHINPUT)arg0);
	OS_NATIVE_EXIT(env, that, CloseTouchInputHandle_FUNC);
	return rc;
}
#endif

#ifndef NO_CoInternetIsFeatureEnabled
JNIEXPORT jint JNICALL OS_NATIVE(CoInternetIsFeatureEnabled)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CoInternetIsFeatureEnabled_FUNC);
	rc = (jint)CoInternetIsFeatureEnabled(arg0, arg1);
	OS_NATIVE_EXIT(env, that, CoInternetIsFeatureEnabled_FUNC);
	return rc;
}
#endif

#ifndef NO_CoInternetSetFeatureEnabled
JNIEXPORT jint JNICALL OS_NATIVE(CoInternetSetFeatureEnabled)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jboolean arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CoInternetSetFeatureEnabled_FUNC);
	rc = (jint)CoInternetSetFeatureEnabled(arg0, arg1, (BOOL)arg2);
	OS_NATIVE_EXIT(env, that, CoInternetSetFeatureEnabled_FUNC);
	return rc;
}
#endif

#ifndef NO_CoTaskMemAlloc
JNIEXPORT jlong JNICALL OS_NATIVE(CoTaskMemAlloc)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CoTaskMemAlloc_FUNC);
	rc = (jlong)CoTaskMemAlloc((ULONG)arg0);
	OS_NATIVE_EXIT(env, that, CoTaskMemAlloc_FUNC);
	return rc;
}
#endif

#ifndef NO_CoTaskMemFree
JNIEXPORT void JNICALL OS_NATIVE(CoTaskMemFree)
	(JNIEnv *env, jclass that, jlong arg0)
{
	OS_NATIVE_ENTER(env, that, CoTaskMemFree_FUNC);
	CoTaskMemFree((LPVOID)arg0);
	OS_NATIVE_EXIT(env, that, CoTaskMemFree_FUNC);
}
#endif

#ifndef NO_CombineRgn
JNIEXPORT jint JNICALL OS_NATIVE(CombineRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jint arg3)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CombineRgn_FUNC);
	rc = (jint)CombineRgn((HRGN)arg0, (HRGN)arg1, (HRGN)arg2, arg3);
	OS_NATIVE_EXIT(env, that, CombineRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_CopyImage
JNIEXPORT jlong JNICALL OS_NATIVE(CopyImage)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CopyImage_FUNC);
	rc = (jlong)CopyImage((HANDLE)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, CopyImage_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateAcceleratorTable
JNIEXPORT jlong JNICALL OS_NATIVE(CreateAcceleratorTable)
	(JNIEnv *env, jclass that, jbyteArray arg0, jint arg1)
{
	jbyte *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateAcceleratorTable_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jlong)CreateAcceleratorTable((LPACCEL)lparg0, arg1);
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateAcceleratorTable_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateActCtx
JNIEXPORT jlong JNICALL OS_NATIVE(CreateActCtx)
	(JNIEnv *env, jclass that, jobject arg0)
{
	ACTCTX _arg0, *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateActCtx_FUNC);
	if (arg0) if ((lparg0 = getACTCTXFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jlong)CreateActCtx(lparg0);
fail:
	OS_NATIVE_EXIT(env, that, CreateActCtx_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateBitmap
JNIEXPORT jlong JNICALL OS_NATIVE(CreateBitmap)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2, jint arg3, jbyteArray arg4)
{
	jbyte *lparg4=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateBitmap_FUNC);
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
	rc = (jlong)CreateBitmap(arg0, arg1, arg2, arg3, (CONST VOID *)lparg4);
fail:
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateBitmap_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateCaret
JNIEXPORT jboolean JNICALL OS_NATIVE(CreateCaret)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, CreateCaret_FUNC);
	rc = (jboolean)CreateCaret((HWND)arg0, (HBITMAP)arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, CreateCaret_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateCompatibleBitmap
JNIEXPORT jlong JNICALL OS_NATIVE(CreateCompatibleBitmap)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateCompatibleBitmap_FUNC);
	rc = (jlong)CreateCompatibleBitmap((HDC)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, CreateCompatibleBitmap_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateCompatibleDC
JNIEXPORT jlong JNICALL OS_NATIVE(CreateCompatibleDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateCompatibleDC_FUNC);
	rc = (jlong)CreateCompatibleDC((HDC)arg0);
	OS_NATIVE_EXIT(env, that, CreateCompatibleDC_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateCursor
JNIEXPORT jlong JNICALL OS_NATIVE(CreateCursor)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jbyteArray arg5, jbyteArray arg6)
{
	jbyte *lparg5=NULL;
	jbyte *lparg6=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateCursor_FUNC);
		if (arg5) if ((lparg5 = (*env)->GetPrimitiveArrayCritical(env, arg5, NULL)) == NULL) goto fail;
		if (arg6) if ((lparg6 = (*env)->GetPrimitiveArrayCritical(env, arg6, NULL)) == NULL) goto fail;
	rc = (jlong)CreateCursor((HINSTANCE)arg0, arg1, arg2, arg3, arg4, (CONST VOID *)lparg5, (CONST VOID *)lparg6);
fail:
		if (arg6 && lparg6) (*env)->ReleasePrimitiveArrayCritical(env, arg6, lparg6, JNI_ABORT);
		if (arg5 && lparg5) (*env)->ReleasePrimitiveArrayCritical(env, arg5, lparg5, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateCursor_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateDC
JNIEXPORT jlong JNICALL OS_NATIVE(CreateDC)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jlong arg2, jlong arg3)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateDC_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)CreateDC((LPWSTR)lparg0, (LPWSTR)lparg1, (LPWSTR)arg2, (CONST DEVMODEW *)arg3);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, CreateDC_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateDIBSection__JJI_3JJI
JNIEXPORT jlong JNICALL OS_NATIVE(CreateDIBSection__JJI_3JJI)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlongArray arg3, jlong arg4, jint arg5)
{
	jlong *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateDIBSection__JJI_3JJI_FUNC);
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)CreateDIBSection((HDC)arg0, (BITMAPINFO *)arg1, arg2, (VOID **)lparg3, (HANDLE)arg4, arg5);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, CreateDIBSection__JJI_3JJI_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateDIBSection__J_3BI_3JJI
JNIEXPORT jlong JNICALL OS_NATIVE(CreateDIBSection__J_3BI_3JJI)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2, jlongArray arg3, jlong arg4, jint arg5)
{
	jbyte *lparg1=NULL;
	jlong *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateDIBSection__J_3BI_3JJI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)CreateDIBSection((HDC)arg0, (BITMAPINFO *)lparg1, arg2, (VOID **)lparg3, (HANDLE)arg4, arg5);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, 0);
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateDIBSection__J_3BI_3JJI_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateEnhMetaFile
JNIEXPORT jlong JNICALL OS_NATIVE(CreateEnhMetaFile)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jobject arg2, jcharArray arg3)
{
	jchar *lparg1=NULL;
	RECT _arg2, *lparg2=NULL;
	jchar *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateEnhMetaFile_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getRECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)CreateEnhMetaFile((HDC)arg0, (LPCWSTR)lparg1, lparg2, (LPCWSTR)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateEnhMetaFile_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateFontIndirect__J
JNIEXPORT jlong JNICALL OS_NATIVE(CreateFontIndirect__J)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateFontIndirect__J_FUNC);
	rc = (jlong)CreateFontIndirect((LPLOGFONTW)arg0);
	OS_NATIVE_EXIT(env, that, CreateFontIndirect__J_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateFontIndirect__Lorg_eclipse_swt_internal_win32_LOGFONT_2
JNIEXPORT jlong JNICALL OS_NATIVE(CreateFontIndirect__Lorg_eclipse_swt_internal_win32_LOGFONT_2)
	(JNIEnv *env, jclass that, jobject arg0)
{
	LOGFONT _arg0, *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateFontIndirect__Lorg_eclipse_swt_internal_win32_LOGFONT_2_FUNC);
	if (arg0) if ((lparg0 = getLOGFONTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jlong)CreateFontIndirect(lparg0);
fail:
	OS_NATIVE_EXIT(env, that, CreateFontIndirect__Lorg_eclipse_swt_internal_win32_LOGFONT_2_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateIconIndirect
JNIEXPORT jlong JNICALL OS_NATIVE(CreateIconIndirect)
	(JNIEnv *env, jclass that, jobject arg0)
{
	ICONINFO _arg0, *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateIconIndirect_FUNC);
	if (arg0) if ((lparg0 = getICONINFOFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jlong)CreateIconIndirect(lparg0);
fail:
	OS_NATIVE_EXIT(env, that, CreateIconIndirect_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateMenu
JNIEXPORT jlong JNICALL OS_NATIVE(CreateMenu)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateMenu_FUNC);
	rc = (jlong)CreateMenu();
	OS_NATIVE_EXIT(env, that, CreateMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_CreatePatternBrush
JNIEXPORT jlong JNICALL OS_NATIVE(CreatePatternBrush)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreatePatternBrush_FUNC);
	rc = (jlong)CreatePatternBrush((HBITMAP)arg0);
	OS_NATIVE_EXIT(env, that, CreatePatternBrush_FUNC);
	return rc;
}
#endif

#ifndef NO_CreatePen
JNIEXPORT jlong JNICALL OS_NATIVE(CreatePen)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreatePen_FUNC);
	rc = (jlong)CreatePen(arg0, arg1, (COLORREF)arg2);
	OS_NATIVE_EXIT(env, that, CreatePen_FUNC);
	return rc;
}
#endif

#ifndef NO_CreatePolygonRgn
JNIEXPORT jlong JNICALL OS_NATIVE(CreatePolygonRgn)
	(JNIEnv *env, jclass that, jintArray arg0, jint arg1, jint arg2)
{
	jint *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreatePolygonRgn_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetIntArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jlong)CreatePolygonRgn((CONST POINT *)lparg0, arg1, arg2);
fail:
	if (arg0 && lparg0) (*env)->ReleaseIntArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, CreatePolygonRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_CreatePopupMenu
JNIEXPORT jlong JNICALL OS_NATIVE(CreatePopupMenu)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreatePopupMenu_FUNC);
	rc = (jlong)CreatePopupMenu();
	OS_NATIVE_EXIT(env, that, CreatePopupMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateProcess
JNIEXPORT jboolean JNICALL OS_NATIVE(CreateProcess)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3, jboolean arg4, jint arg5, jlong arg6, jlong arg7, jobject arg8, jobject arg9)
{
	STARTUPINFO _arg8, *lparg8=NULL;
	PROCESS_INFORMATION _arg9, *lparg9=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, CreateProcess_FUNC);
	if (arg8) if ((lparg8 = getSTARTUPINFOFields(env, arg8, &_arg8)) == NULL) goto fail;
	if (arg9) if ((lparg9 = &_arg9) == NULL) goto fail;
	rc = (jboolean)CreateProcess((LPCWSTR)arg0, (LPWSTR)arg1, (LPSECURITY_ATTRIBUTES)arg2, (LPSECURITY_ATTRIBUTES)arg3, arg4, arg5, (LPVOID)arg6, (LPWSTR)arg7, lparg8, lparg9);
fail:
	if (arg9 && lparg9) setPROCESS_INFORMATIONFields(env, arg9, lparg9);
	OS_NATIVE_EXIT(env, that, CreateProcess_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateRectRgn
JNIEXPORT jlong JNICALL OS_NATIVE(CreateRectRgn)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2, jint arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateRectRgn_FUNC);
	rc = (jlong)CreateRectRgn(arg0, arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, CreateRectRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateSolidBrush
JNIEXPORT jlong JNICALL OS_NATIVE(CreateSolidBrush)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateSolidBrush_FUNC);
	rc = (jlong)CreateSolidBrush((COLORREF)arg0);
	OS_NATIVE_EXIT(env, that, CreateSolidBrush_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateStreamOnHGlobal
JNIEXPORT jint JNICALL OS_NATIVE(CreateStreamOnHGlobal)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1, jlongArray arg2)
{
	jlong *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, CreateStreamOnHGlobal_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)CreateStreamOnHGlobal((HGLOBAL)arg0, (BOOL)arg1, (LPSTREAM *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, CreateStreamOnHGlobal_FUNC);
	return rc;
}
#endif

#ifndef NO_CreateWindowEx
JNIEXPORT jlong JNICALL OS_NATIVE(CreateWindowEx)
	(JNIEnv *env, jclass that, jint arg0, jcharArray arg1, jcharArray arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jlong arg8, jlong arg9, jlong arg10, jobject arg11)
{
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	CREATESTRUCT _arg11, *lparg11=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, CreateWindowEx_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg11) if ((lparg11 = getCREATESTRUCTFields(env, arg11, &_arg11)) == NULL) goto fail;
	rc = (jlong)CreateWindowEx(arg0, (LPWSTR)lparg1, (LPWSTR)lparg2, arg3, arg4, arg5, arg6, arg7, (HWND)arg8, (HMENU)arg9, (HINSTANCE)arg10, lparg11);
fail:
	if (arg11 && lparg11) setCREATESTRUCTFields(env, arg11, lparg11);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, CreateWindowEx_FUNC);
	return rc;
}
#endif

#ifndef NO_DEVMODE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DEVMODE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DEVMODE_1sizeof_FUNC);
	rc = (jint)DEVMODE_sizeof();
	OS_NATIVE_EXIT(env, that, DEVMODE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DIBSECTION_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DIBSECTION_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DIBSECTION_1sizeof_FUNC);
	rc = (jint)DIBSECTION_sizeof();
	OS_NATIVE_EXIT(env, that, DIBSECTION_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DOCHOSTUIINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DOCHOSTUIINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DOCHOSTUIINFO_1sizeof_FUNC);
	rc = (jint)DOCHOSTUIINFO_sizeof();
	OS_NATIVE_EXIT(env, that, DOCHOSTUIINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DOCINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DOCINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DOCINFO_1sizeof_FUNC);
	rc = (jint)DOCINFO_sizeof();
	OS_NATIVE_EXIT(env, that, DOCINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DRAWITEMSTRUCT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DRAWITEMSTRUCT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DRAWITEMSTRUCT_1sizeof_FUNC);
	rc = (jint)DRAWITEMSTRUCT_sizeof();
	OS_NATIVE_EXIT(env, that, DRAWITEMSTRUCT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DROPFILES_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(DROPFILES_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DROPFILES_1sizeof_FUNC);
	rc = (jint)DROPFILES_sizeof();
	OS_NATIVE_EXIT(env, that, DROPFILES_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_DefFrameProc
JNIEXPORT jlong JNICALL OS_NATIVE(DefFrameProc)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3, jlong arg4)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, DefFrameProc_FUNC);
	rc = (jlong)DefFrameProc((HWND)arg0, (HWND)arg1, arg2, (WPARAM)arg3, (LPARAM)arg4);
	OS_NATIVE_EXIT(env, that, DefFrameProc_FUNC);
	return rc;
}
#endif

#ifndef NO_DefMDIChildProc
JNIEXPORT jlong JNICALL OS_NATIVE(DefMDIChildProc)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, DefMDIChildProc_FUNC);
	rc = (jlong)DefMDIChildProc((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, DefMDIChildProc_FUNC);
	return rc;
}
#endif

#ifndef NO_DefWindowProc
JNIEXPORT jlong JNICALL OS_NATIVE(DefWindowProc)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, DefWindowProc_FUNC);
	rc = (jlong)DefWindowProc((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, DefWindowProc_FUNC);
	return rc;
}
#endif

#ifndef NO_DeferWindowPos
JNIEXPORT jlong JNICALL OS_NATIVE(DeferWindowPos)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, DeferWindowPos_FUNC);
	rc = (jlong)DeferWindowPos((HDWP)arg0, (HWND)arg1, (HWND)arg2, arg3, arg4, arg5, arg6, arg7);
	OS_NATIVE_EXIT(env, that, DeferWindowPos_FUNC);
	return rc;
}
#endif

#ifndef NO_DeleteDC
JNIEXPORT jboolean JNICALL OS_NATIVE(DeleteDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DeleteDC_FUNC);
	rc = (jboolean)DeleteDC((HDC)arg0);
	OS_NATIVE_EXIT(env, that, DeleteDC_FUNC);
	return rc;
}
#endif

#ifndef NO_DeleteEnhMetaFile
JNIEXPORT jboolean JNICALL OS_NATIVE(DeleteEnhMetaFile)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DeleteEnhMetaFile_FUNC);
	rc = (jboolean)DeleteEnhMetaFile((HENHMETAFILE)arg0);
	OS_NATIVE_EXIT(env, that, DeleteEnhMetaFile_FUNC);
	return rc;
}
#endif

#ifndef NO_DeleteMenu
JNIEXPORT jboolean JNICALL OS_NATIVE(DeleteMenu)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DeleteMenu_FUNC);
	rc = (jboolean)DeleteMenu((HMENU)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, DeleteMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_DeleteObject
JNIEXPORT jboolean JNICALL OS_NATIVE(DeleteObject)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DeleteObject_FUNC);
	rc = (jboolean)DeleteObject((HGDIOBJ)arg0);
	OS_NATIVE_EXIT(env, that, DeleteObject_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyAcceleratorTable
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyAcceleratorTable)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyAcceleratorTable_FUNC);
	rc = (jboolean)DestroyAcceleratorTable((HACCEL)arg0);
	OS_NATIVE_EXIT(env, that, DestroyAcceleratorTable_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyCaret
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyCaret)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyCaret_FUNC);
	rc = (jboolean)DestroyCaret();
	OS_NATIVE_EXIT(env, that, DestroyCaret_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyCursor
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyCursor)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyCursor_FUNC);
	rc = (jboolean)DestroyCursor((HCURSOR)arg0);
	OS_NATIVE_EXIT(env, that, DestroyCursor_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyIcon
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyIcon)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyIcon_FUNC);
	rc = (jboolean)DestroyIcon((HICON)arg0);
	OS_NATIVE_EXIT(env, that, DestroyIcon_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyMenu
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyMenu)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyMenu_FUNC);
	rc = (jboolean)DestroyMenu((HMENU)arg0);
	OS_NATIVE_EXIT(env, that, DestroyMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_DestroyWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(DestroyWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DestroyWindow_FUNC);
	rc = (jboolean)DestroyWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, DestroyWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_DispatchMessage
JNIEXPORT jlong JNICALL OS_NATIVE(DispatchMessage)
	(JNIEnv *env, jclass that, jobject arg0)
{
	MSG _arg0, *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, DispatchMessage_FUNC);
	if (arg0) if ((lparg0 = getMSGFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jlong)DispatchMessage(lparg0);
fail:
	if (arg0 && lparg0) setMSGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, DispatchMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_DocumentProperties
JNIEXPORT jint JNICALL OS_NATIVE(DocumentProperties)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jcharArray arg2, jlong arg3, jlong arg4, jint arg5)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DocumentProperties_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)DocumentProperties((HWND)arg0, (HANDLE)arg1, (LPWSTR)lparg2, (PDEVMODEW)arg3, (PDEVMODEW)arg4, arg5);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, DocumentProperties_FUNC);
	return rc;
}
#endif

#ifndef NO_DragDetect
JNIEXPORT jboolean JNICALL OS_NATIVE(DragDetect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DragDetect_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)DragDetect((HWND)arg0, *lparg1);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, DragDetect_FUNC);
	return rc;
}
#endif

#ifndef NO_DragFinish
JNIEXPORT void JNICALL OS_NATIVE(DragFinish)
	(JNIEnv *env, jclass that, jlong arg0)
{
	OS_NATIVE_ENTER(env, that, DragFinish_FUNC);
	DragFinish((HDROP)arg0);
	OS_NATIVE_EXIT(env, that, DragFinish_FUNC);
}
#endif

#ifndef NO_DragQueryFile
JNIEXPORT jint JNICALL OS_NATIVE(DragQueryFile)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jcharArray arg2, jint arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DragQueryFile_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)DragQueryFile((HDROP)arg0, arg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, DragQueryFile_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawEdge
JNIEXPORT jboolean JNICALL OS_NATIVE(DrawEdge)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2, jint arg3)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DrawEdge_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)DrawEdge((HDC)arg0, lparg1, arg2, arg3);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, DrawEdge_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawFocusRect
JNIEXPORT jboolean JNICALL OS_NATIVE(DrawFocusRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DrawFocusRect_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)DrawFocusRect((HDC)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, DrawFocusRect_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawFrameControl
JNIEXPORT jboolean JNICALL OS_NATIVE(DrawFrameControl)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2, jint arg3)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DrawFrameControl_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)DrawFrameControl((HDC)arg0, lparg1, arg2, arg3);
fail:
	OS_NATIVE_EXIT(env, that, DrawFrameControl_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawIconEx
JNIEXPORT jboolean JNICALL OS_NATIVE(DrawIconEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jlong arg3, jint arg4, jint arg5, jint arg6, jlong arg7, jint arg8)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DrawIconEx_FUNC);
	rc = (jboolean)DrawIconEx((HDC)arg0, arg1, arg2, (HICON)arg3, arg4, arg5, arg6, (HBRUSH)arg7, arg8);
	OS_NATIVE_EXIT(env, that, DrawIconEx_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawMenuBar
JNIEXPORT jboolean JNICALL OS_NATIVE(DrawMenuBar)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DrawMenuBar_FUNC);
	rc = (jboolean)DrawMenuBar((HWND)arg0);
	OS_NATIVE_EXIT(env, that, DrawMenuBar_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawText
JNIEXPORT jint JNICALL OS_NATIVE(DrawText)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jobject arg3, jint arg4)
{
	jchar *lparg1=NULL;
	RECT _arg3, *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DrawText_FUNC);
	if (arg3) if ((lparg3 = getRECTFields(env, arg3, &_arg3)) == NULL) goto fail;
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)DrawText((HDC)arg0, (LPWSTR)lparg1, arg2, lparg3, arg4);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	if (arg3 && lparg3) setRECTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, DrawText_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawThemeBackground
JNIEXPORT jint JNICALL OS_NATIVE(DrawThemeBackground)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jobject arg4, jobject arg5)
{
	RECT _arg4, *lparg4=NULL;
	RECT _arg5, *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DrawThemeBackground_FUNC);
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg5) if ((lparg5 = getRECTFields(env, arg5, &_arg5)) == NULL) goto fail;
	rc = (jint)DrawThemeBackground((HTHEME)arg0, (HDC)arg1, arg2, arg3, lparg4, lparg5);
fail:
	OS_NATIVE_EXIT(env, that, DrawThemeBackground_FUNC);
	return rc;
}
#endif

#ifndef NO_DrawThemeText
JNIEXPORT jint JNICALL OS_NATIVE(DrawThemeText)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jcharArray arg4, jint arg5, jint arg6, jint arg7, jobject arg8)
{
	jchar *lparg4=NULL;
	RECT _arg8, *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, DrawThemeText_FUNC);
	if (arg4) if ((lparg4 = (*env)->GetCharArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = getRECTFields(env, arg8, &_arg8)) == NULL) goto fail;
	rc = (jint)DrawThemeText((HTHEME)arg0, (HDC)arg1, arg2, arg3, lparg4, arg5, arg6, arg7, lparg8);
fail:
	if (arg4 && lparg4) (*env)->ReleaseCharArrayElements(env, arg4, lparg4, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, DrawThemeText_FUNC);
	return rc;
}
#endif

#ifndef NO_DuplicateHandle
JNIEXPORT jboolean JNICALL OS_NATIVE(DuplicateHandle)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlongArray arg3, jint arg4, jboolean arg5, jint arg6)
{
	jlong *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DuplicateHandle_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)DuplicateHandle((HANDLE)arg0, (HANDLE)arg1, (HANDLE)arg2, (LPHANDLE)lparg3, (DWORD)arg4, arg5, (DWORD)arg6);
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, DuplicateHandle_FUNC);
	return rc;
}
#endif

#ifndef NO_DwmSetWindowAttribute
JNIEXPORT jboolean JNICALL OS_NATIVE(DwmSetWindowAttribute)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jint arg3)
{
	jint *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, DwmSetWindowAttribute_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jboolean)DwmSetWindowAttribute((HDC)arg0, arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, DwmSetWindowAttribute_FUNC);
	return rc;
}
#endif

#ifndef NO_EMREXTCREATEFONTINDIRECTW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(EMREXTCREATEFONTINDIRECTW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EMREXTCREATEFONTINDIRECTW_1sizeof_FUNC);
	rc = (jint)EMREXTCREATEFONTINDIRECTW_sizeof();
	OS_NATIVE_EXIT(env, that, EMREXTCREATEFONTINDIRECTW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_EMR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(EMR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EMR_1sizeof_FUNC);
	rc = (jint)EMR_sizeof();
	OS_NATIVE_EXIT(env, that, EMR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_EXTLOGFONTW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(EXTLOGFONTW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EXTLOGFONTW_1sizeof_FUNC);
	rc = (jint)EXTLOGFONTW_sizeof();
	OS_NATIVE_EXIT(env, that, EXTLOGFONTW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_Ellipse
JNIEXPORT jboolean JNICALL OS_NATIVE(Ellipse)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Ellipse_FUNC);
	rc = (jboolean)Ellipse((HDC)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, Ellipse_FUNC);
	return rc;
}
#endif

#ifndef NO_EnableMenuItem
JNIEXPORT jboolean JNICALL OS_NATIVE(EnableMenuItem)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnableMenuItem_FUNC);
	rc = (jboolean)EnableMenuItem((HMENU)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, EnableMenuItem_FUNC);
	return rc;
}
#endif

#ifndef NO_EnableScrollBar
JNIEXPORT jboolean JNICALL OS_NATIVE(EnableScrollBar)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnableScrollBar_FUNC);
	rc = (jboolean)EnableScrollBar((HWND)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, EnableScrollBar_FUNC);
	return rc;
}
#endif

#ifndef NO_EnableWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(EnableWindow)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnableWindow_FUNC);
	rc = (jboolean)EnableWindow((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, EnableWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_EndBufferedPaint
JNIEXPORT jint JNICALL OS_NATIVE(EndBufferedPaint)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EndBufferedPaint_FUNC);
	rc = (jint)EndBufferedPaint((HPAINTBUFFER)arg0, arg1);
	OS_NATIVE_EXIT(env, that, EndBufferedPaint_FUNC);
	return rc;
}
#endif

#ifndef NO_EndDeferWindowPos
JNIEXPORT jboolean JNICALL OS_NATIVE(EndDeferWindowPos)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EndDeferWindowPos_FUNC);
	rc = (jboolean)EndDeferWindowPos((HDWP)arg0);
	OS_NATIVE_EXIT(env, that, EndDeferWindowPos_FUNC);
	return rc;
}
#endif

#ifndef NO_EndDoc
JNIEXPORT jint JNICALL OS_NATIVE(EndDoc)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EndDoc_FUNC);
	rc = (jint)EndDoc((HDC)arg0);
	OS_NATIVE_EXIT(env, that, EndDoc_FUNC);
	return rc;
}
#endif

#ifndef NO_EndPage
JNIEXPORT jint JNICALL OS_NATIVE(EndPage)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EndPage_FUNC);
	rc = (jint)EndPage((HDC)arg0);
	OS_NATIVE_EXIT(env, that, EndPage_FUNC);
	return rc;
}
#endif

#ifndef NO_EndPaint
JNIEXPORT jint JNICALL OS_NATIVE(EndPaint)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	PAINTSTRUCT _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EndPaint_FUNC);
	if (arg1) if ((lparg1 = getPAINTSTRUCTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jint)EndPaint((HWND)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, EndPaint_FUNC);
	return rc;
}
#endif

#ifndef NO_EnumDisplayMonitors
JNIEXPORT jboolean JNICALL OS_NATIVE(EnumDisplayMonitors)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2, jint arg3)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnumDisplayMonitors_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)EnumDisplayMonitors((HDC)arg0, lparg1, (MONITORENUMPROC)arg2, (LPARAM)arg3);
fail:
	OS_NATIVE_EXIT(env, that, EnumDisplayMonitors_FUNC);
	return rc;
}
#endif

#ifndef NO_EnumEnhMetaFile
JNIEXPORT jboolean JNICALL OS_NATIVE(EnumEnhMetaFile)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jlong arg3, jobject arg4)
{
	RECT _arg4, *lparg4=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnumEnhMetaFile_FUNC);
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
	rc = (jboolean)EnumEnhMetaFile((HDC)arg0, (HENHMETAFILE)arg1, (ENHMFENUMPROC)arg2, (LPVOID)arg3, lparg4);
fail:
	if (arg4 && lparg4) setRECTFields(env, arg4, lparg4);
	OS_NATIVE_EXIT(env, that, EnumEnhMetaFile_FUNC);
	return rc;
}
#endif

#ifndef NO_EnumFontFamilies
JNIEXPORT jint JNICALL OS_NATIVE(EnumFontFamilies)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jlong arg2, jlong arg3)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, EnumFontFamilies_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)EnumFontFamilies((HDC)arg0, (LPCWSTR)lparg1, (FONTENUMPROCW)arg2, (LPARAM)arg3);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, EnumFontFamilies_FUNC);
	return rc;
}
#endif

#ifndef NO_EnumSystemLanguageGroups
JNIEXPORT jboolean JNICALL OS_NATIVE(EnumSystemLanguageGroups)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnumSystemLanguageGroups_FUNC);
	rc = (jboolean)EnumSystemLanguageGroups((LANGUAGEGROUP_ENUMPROCW)arg0, arg1, (LONG_PTR)arg2);
	OS_NATIVE_EXIT(env, that, EnumSystemLanguageGroups_FUNC);
	return rc;
}
#endif

#ifndef NO_EnumSystemLocales
JNIEXPORT jboolean JNICALL OS_NATIVE(EnumSystemLocales)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EnumSystemLocales_FUNC);
	rc = (jboolean)EnumSystemLocales((LOCALE_ENUMPROCW)arg0, arg1);
	OS_NATIVE_EXIT(env, that, EnumSystemLocales_FUNC);
	return rc;
}
#endif

#ifndef NO_EqualRect
JNIEXPORT jboolean JNICALL OS_NATIVE(EqualRect)
	(JNIEnv *env, jclass that, jobject arg0, jobject arg1)
{
	RECT _arg0, *lparg0=NULL;
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, EqualRect_FUNC);
	if (arg0) if ((lparg0 = getRECTFields(env, arg0, &_arg0)) == NULL) goto fail;
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)EqualRect(lparg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, EqualRect_FUNC);
	return rc;
}
#endif

#ifndef NO_ExcludeClipRect
JNIEXPORT jint JNICALL OS_NATIVE(ExcludeClipRect)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ExcludeClipRect_FUNC);
	rc = (jint)ExcludeClipRect((HDC)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, ExcludeClipRect_FUNC);
	return rc;
}
#endif

#ifndef NO_ExpandEnvironmentStrings
JNIEXPORT jint JNICALL OS_NATIVE(ExpandEnvironmentStrings)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ExpandEnvironmentStrings_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)ExpandEnvironmentStrings(lparg0, lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ExpandEnvironmentStrings_FUNC);
	return rc;
}
#endif

#ifndef NO_ExtCreatePen
JNIEXPORT jlong JNICALL OS_NATIVE(ExtCreatePen)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jobject arg2, jint arg3, jintArray arg4)
{
	LOGBRUSH _arg2, *lparg2=NULL;
	jint *lparg4=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ExtCreatePen_FUNC);
	if (arg2) if ((lparg2 = getLOGBRUSHFields(env, arg2, &_arg2)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jlong)ExtCreatePen(arg0, arg1, lparg2, arg3, (CONST DWORD *)lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	OS_NATIVE_EXIT(env, that, ExtCreatePen_FUNC);
	return rc;
}
#endif

#ifndef NO_ExtCreateRegion
JNIEXPORT jlong JNICALL OS_NATIVE(ExtCreateRegion)
	(JNIEnv *env, jclass that, jfloatArray arg0, jint arg1, jintArray arg2)
{
	jfloat *lparg0=NULL;
	jint *lparg2=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ExtCreateRegion_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetFloatArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jlong)ExtCreateRegion((XFORM *)lparg0, arg1, (CONST RGNDATA *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg0 && lparg0) (*env)->ReleaseFloatArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, ExtCreateRegion_FUNC);
	return rc;
}
#endif

#ifndef NO_ExtTextOut
JNIEXPORT jboolean JNICALL OS_NATIVE(ExtTextOut)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jobject arg4, jcharArray arg5, jint arg6, jintArray arg7)
{
	RECT _arg4, *lparg4=NULL;
	jchar *lparg5=NULL;
	jint *lparg7=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ExtTextOut_FUNC);
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
		if (arg5) if ((lparg5 = (*env)->GetPrimitiveArrayCritical(env, arg5, NULL)) == NULL) goto fail;
		if (arg7) if ((lparg7 = (*env)->GetPrimitiveArrayCritical(env, arg7, NULL)) == NULL) goto fail;
	rc = (jboolean)ExtTextOut((HDC)arg0, arg1, arg2, arg3, lparg4, (LPWSTR)lparg5, arg6, (CONST INT *)lparg7);
fail:
		if (arg7 && lparg7) (*env)->ReleasePrimitiveArrayCritical(env, arg7, lparg7, JNI_ABORT);
		if (arg5 && lparg5) (*env)->ReleasePrimitiveArrayCritical(env, arg5, lparg5, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ExtTextOut_FUNC);
	return rc;
}
#endif

#ifndef NO_ExtractIconEx
JNIEXPORT jint JNICALL OS_NATIVE(ExtractIconEx)
	(JNIEnv *env, jclass that, jcharArray arg0, jint arg1, jlongArray arg2, jlongArray arg3, jint arg4)
{
	jchar *lparg0=NULL;
	jlong *lparg2=NULL;
	jlong *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ExtractIconEx_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetLongArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)ExtractIconEx((LPWSTR)lparg0, arg1, (HICON FAR *)lparg2, (HICON FAR *)lparg3, arg4);
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseLongArrayElements(env, arg2, lparg2, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, ExtractIconEx_FUNC);
	return rc;
}
#endif

#ifndef NO_FLICK_1DATA_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(FLICK_1DATA_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, FLICK_1DATA_1sizeof_FUNC);
	rc = (jint)FLICK_DATA_sizeof();
	OS_NATIVE_EXIT(env, that, FLICK_1DATA_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_FLICK_1POINT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(FLICK_1POINT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, FLICK_1POINT_1sizeof_FUNC);
	rc = (jint)FLICK_POINT_sizeof();
	OS_NATIVE_EXIT(env, that, FLICK_1POINT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_FillRect
JNIEXPORT jint JNICALL OS_NATIVE(FillRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2)
{
	RECT _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, FillRect_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jint)FillRect((HDC)arg0, lparg1, (HBRUSH)arg2);
fail:
	OS_NATIVE_EXIT(env, that, FillRect_FUNC);
	return rc;
}
#endif

#ifndef NO_GCP_1RESULTS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(GCP_1RESULTS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GCP_1RESULTS_1sizeof_FUNC);
	rc = (jint)GCP_RESULTS_sizeof();
	OS_NATIVE_EXIT(env, that, GCP_1RESULTS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GESTURECONFIG_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(GESTURECONFIG_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GESTURECONFIG_1sizeof_FUNC);
	rc = (jint)GESTURECONFIG_sizeof();
	OS_NATIVE_EXIT(env, that, GESTURECONFIG_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GESTUREINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(GESTUREINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GESTUREINFO_1sizeof_FUNC);
	rc = (jint)GESTUREINFO_sizeof();
	OS_NATIVE_EXIT(env, that, GESTUREINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GID_1ROTATE_1ANGLE_1FROM_1ARGUMENT
JNIEXPORT jdouble JNICALL OS_NATIVE(GID_1ROTATE_1ANGLE_1FROM_1ARGUMENT)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jdouble rc = 0;
	OS_NATIVE_ENTER(env, that, GID_1ROTATE_1ANGLE_1FROM_1ARGUMENT_FUNC);
	rc = (jdouble)GID_ROTATE_ANGLE_FROM_ARGUMENT(arg0);
	OS_NATIVE_EXIT(env, that, GID_1ROTATE_1ANGLE_1FROM_1ARGUMENT_FUNC);
	return rc;
}
#endif

#ifndef NO_GRADIENT_1RECT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(GRADIENT_1RECT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GRADIENT_1RECT_1sizeof_FUNC);
	rc = (jint)GRADIENT_RECT_sizeof();
	OS_NATIVE_EXIT(env, that, GRADIENT_1RECT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GUITHREADINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(GUITHREADINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GUITHREADINFO_1sizeof_FUNC);
	rc = (jint)GUITHREADINFO_sizeof();
	OS_NATIVE_EXIT(env, that, GUITHREADINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_GdiSetBatchLimit
JNIEXPORT jint JNICALL OS_NATIVE(GdiSetBatchLimit)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GdiSetBatchLimit_FUNC);
	rc = (jint)GdiSetBatchLimit((DWORD)arg0);
	OS_NATIVE_EXIT(env, that, GdiSetBatchLimit_FUNC);
	return rc;
}
#endif

#ifndef NO_GetACP
JNIEXPORT jint JNICALL OS_NATIVE(GetACP)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetACP_FUNC);
	rc = (jint)GetACP();
	OS_NATIVE_EXIT(env, that, GetACP_FUNC);
	return rc;
}
#endif

#ifndef NO_GetActiveWindow
JNIEXPORT jlong JNICALL OS_NATIVE(GetActiveWindow)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetActiveWindow_FUNC);
	rc = (jlong)GetActiveWindow();
	OS_NATIVE_EXIT(env, that, GetActiveWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_GetBkColor
JNIEXPORT jint JNICALL OS_NATIVE(GetBkColor)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetBkColor_FUNC);
	rc = (jint)GetBkColor((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetBkColor_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCapture
JNIEXPORT jlong JNICALL OS_NATIVE(GetCapture)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetCapture_FUNC);
	rc = (jlong)GetCapture();
	OS_NATIVE_EXIT(env, that, GetCapture_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCaretPos
JNIEXPORT jboolean JNICALL OS_NATIVE(GetCaretPos)
	(JNIEnv *env, jclass that, jobject arg0)
{
	POINT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetCaretPos_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	rc = (jboolean)GetCaretPos(lparg0);
fail:
	if (arg0 && lparg0) setPOINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, GetCaretPos_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCharABCWidths
JNIEXPORT jboolean JNICALL OS_NATIVE(GetCharABCWidths)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetCharABCWidths_FUNC);
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)GetCharABCWidths((HDC)arg0, arg1, arg2, (LPABC)lparg3);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, GetCharABCWidths_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCharWidth
JNIEXPORT jboolean JNICALL OS_NATIVE(GetCharWidth)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetCharWidth_FUNC);
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)GetCharWidth((HDC)arg0, arg1, arg2, (LPINT)lparg3);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, GetCharWidth_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCharacterPlacement
JNIEXPORT jint JNICALL OS_NATIVE(GetCharacterPlacement)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jint arg3, jobject arg4, jint arg5)
{
	jchar *lparg1=NULL;
	GCP_RESULTS _arg4, *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetCharacterPlacement_FUNC);
	if (arg4) if ((lparg4 = getGCP_RESULTSFields(env, arg4, &_arg4)) == NULL) goto fail;
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetCharacterPlacement((HDC)arg0, (LPWSTR)lparg1, arg2, arg3, lparg4, arg5);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	if (arg4 && lparg4) setGCP_RESULTSFields(env, arg4, lparg4);
	OS_NATIVE_EXIT(env, that, GetCharacterPlacement_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClassInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetClassInfo)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jobject arg2)
{
	jchar *lparg1=NULL;
	WNDCLASS _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetClassInfo_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getWNDCLASSFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)GetClassInfo((HINSTANCE)arg0, (LPWSTR)lparg1, lparg2);
fail:
	if (arg2 && lparg2) setWNDCLASSFields(env, arg2, lparg2);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GetClassInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClassName
JNIEXPORT jint JNICALL OS_NATIVE(GetClassName)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetClassName_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetClassName((HWND)arg0, lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetClassName_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClientRect
JNIEXPORT jboolean JNICALL OS_NATIVE(GetClientRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetClientRect_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jboolean)GetClientRect((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetClientRect_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClipBox
JNIEXPORT jint JNICALL OS_NATIVE(GetClipBox)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetClipBox_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jint)GetClipBox((HDC)arg0, lparg1);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetClipBox_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClipRgn
JNIEXPORT jint JNICALL OS_NATIVE(GetClipRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetClipRgn_FUNC);
	rc = (jint)GetClipRgn((HDC)arg0, (HRGN)arg1);
	OS_NATIVE_EXIT(env, that, GetClipRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClipboardData
JNIEXPORT jlong JNICALL OS_NATIVE(GetClipboardData)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetClipboardData_FUNC);
	rc = (jlong)GetClipboardData(arg0);
	OS_NATIVE_EXIT(env, that, GetClipboardData_FUNC);
	return rc;
}
#endif

#ifndef NO_GetClipboardFormatName
JNIEXPORT jint JNICALL OS_NATIVE(GetClipboardFormatName)
	(JNIEnv *env, jclass that, jint arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetClipboardFormatName_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetClipboardFormatName(arg0, (LPWSTR)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetClipboardFormatName_FUNC);
	return rc;
}
#endif

#ifndef NO_GetComboBoxInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetComboBoxInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	COMBOBOXINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetComboBoxInfo_FUNC);
	if (arg1) if ((lparg1 = getCOMBOBOXINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetComboBoxInfo((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setCOMBOBOXINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetComboBoxInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCurrentObject
JNIEXPORT jlong JNICALL OS_NATIVE(GetCurrentObject)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetCurrentObject_FUNC);
	rc = (jlong)GetCurrentObject((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetCurrentObject_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCurrentProcess
JNIEXPORT jlong JNICALL OS_NATIVE(GetCurrentProcess)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetCurrentProcess_FUNC);
	rc = (jlong)GetCurrentProcess();
	OS_NATIVE_EXIT(env, that, GetCurrentProcess_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCurrentProcessExplicitAppUserModelID
JNIEXPORT jint JNICALL OS_NATIVE(GetCurrentProcessExplicitAppUserModelID)
	(JNIEnv *env, jclass that, jlongArray arg0)
{
	jlong *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetCurrentProcessExplicitAppUserModelID_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetLongArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)GetCurrentProcessExplicitAppUserModelID((PWSTR *)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseLongArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, GetCurrentProcessExplicitAppUserModelID_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCurrentProcessId
JNIEXPORT jint JNICALL OS_NATIVE(GetCurrentProcessId)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetCurrentProcessId_FUNC);
	rc = (jint)GetCurrentProcessId();
	OS_NATIVE_EXIT(env, that, GetCurrentProcessId_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCurrentThreadId
JNIEXPORT jint JNICALL OS_NATIVE(GetCurrentThreadId)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetCurrentThreadId_FUNC);
	rc = (jint)GetCurrentThreadId();
	OS_NATIVE_EXIT(env, that, GetCurrentThreadId_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCursor
JNIEXPORT jlong JNICALL OS_NATIVE(GetCursor)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetCursor_FUNC);
	rc = (jlong)GetCursor();
	OS_NATIVE_EXIT(env, that, GetCursor_FUNC);
	return rc;
}
#endif

#ifndef NO_GetCursorPos
JNIEXPORT jboolean JNICALL OS_NATIVE(GetCursorPos)
	(JNIEnv *env, jclass that, jobject arg0)
{
	POINT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetCursorPos_FUNC);
	if (arg0) if ((lparg0 = getPOINTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)GetCursorPos(lparg0);
fail:
	if (arg0 && lparg0) setPOINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, GetCursorPos_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDC
JNIEXPORT jlong JNICALL OS_NATIVE(GetDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetDC_FUNC);
	rc = (jlong)GetDC((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetDC_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDCEx
JNIEXPORT jlong JNICALL OS_NATIVE(GetDCEx)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetDCEx_FUNC);
	rc = (jlong)GetDCEx((HWND)arg0, (HRGN)arg1, arg2);
	OS_NATIVE_EXIT(env, that, GetDCEx_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDIBColorTable
JNIEXPORT jint JNICALL OS_NATIVE(GetDIBColorTable)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jbyteArray arg3)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDIBColorTable_FUNC);
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)GetDIBColorTable((HDC)arg0, arg1, arg2, (RGBQUAD *)lparg3);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, GetDIBColorTable_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDIBits
JNIEXPORT jint JNICALL OS_NATIVE(GetDIBits)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jbyteArray arg4, jbyteArray arg5, jint arg6)
{
	jbyte *lparg4=NULL;
	jbyte *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDIBits_FUNC);
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
		if (arg5) if ((lparg5 = (*env)->GetPrimitiveArrayCritical(env, arg5, NULL)) == NULL) goto fail;
	rc = (jint)GetDIBits((HDC)arg0, (HBITMAP)arg1, arg2, arg3, (LPVOID)lparg4, (LPBITMAPINFO)lparg5, arg6);
fail:
		if (arg5 && lparg5) (*env)->ReleasePrimitiveArrayCritical(env, arg5, lparg5, 0);
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
	OS_NATIVE_EXIT(env, that, GetDIBits_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDesktopWindow
JNIEXPORT jlong JNICALL OS_NATIVE(GetDesktopWindow)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetDesktopWindow_FUNC);
	rc = (jlong)GetDesktopWindow();
	OS_NATIVE_EXIT(env, that, GetDesktopWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDeviceCaps
JNIEXPORT jint JNICALL OS_NATIVE(GetDeviceCaps)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDeviceCaps_FUNC);
	rc = (jint)GetDeviceCaps((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetDeviceCaps_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDialogBaseUnits
JNIEXPORT jint JNICALL OS_NATIVE(GetDialogBaseUnits)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDialogBaseUnits_FUNC);
	rc = (jint)GetDialogBaseUnits();
	OS_NATIVE_EXIT(env, that, GetDialogBaseUnits_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDlgItem
JNIEXPORT jlong JNICALL OS_NATIVE(GetDlgItem)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetDlgItem_FUNC);
	rc = (jlong)GetDlgItem((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetDlgItem_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDoubleClickTime
JNIEXPORT jint JNICALL OS_NATIVE(GetDoubleClickTime)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDoubleClickTime_FUNC);
	rc = (jint)GetDoubleClickTime();
	OS_NATIVE_EXIT(env, that, GetDoubleClickTime_FUNC);
	return rc;
}
#endif

#ifndef NO_GetDpiForMonitor
JNIEXPORT jint JNICALL OS_NATIVE(GetDpiForMonitor)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetDpiForMonitor_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
/*
	rc = (jint)GetDpiForMonitor(arg0, arg1, lparg2, lparg3);
*/
	{
		OS_LOAD_FUNCTION(fp, GetDpiForMonitor)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(jlong, jint, jint *, jint *))fp)(arg0, arg1, lparg2, lparg3);
		}
	}
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, GetDpiForMonitor_FUNC);
	return rc;
}
#endif

#ifndef NO_GetFocus
JNIEXPORT jlong JNICALL OS_NATIVE(GetFocus)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetFocus_FUNC);
	rc = (jlong)GetFocus();
	OS_NATIVE_EXIT(env, that, GetFocus_FUNC);
	return rc;
}
#endif

#ifndef NO_GetFontLanguageInfo
JNIEXPORT jint JNICALL OS_NATIVE(GetFontLanguageInfo)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetFontLanguageInfo_FUNC);
	rc = (jint)GetFontLanguageInfo((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetFontLanguageInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetForegroundWindow
JNIEXPORT jlong JNICALL OS_NATIVE(GetForegroundWindow)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetForegroundWindow_FUNC);
	rc = (jlong)GetForegroundWindow();
	OS_NATIVE_EXIT(env, that, GetForegroundWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_GetGUIThreadInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetGUIThreadInfo)
	(JNIEnv *env, jclass that, jint arg0, jobject arg1)
{
	GUITHREADINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetGUIThreadInfo_FUNC);
	if (arg1) if ((lparg1 = getGUITHREADINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetGUIThreadInfo((DWORD)arg0, (LPGUITHREADINFO)lparg1);
fail:
	if (arg1 && lparg1) setGUITHREADINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetGUIThreadInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetGestureInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetGestureInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	GESTUREINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetGestureInfo_FUNC);
	if (arg1) if ((lparg1 = getGESTUREINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetGestureInfo((HGESTUREINFO)arg0, lparg1);
fail:
	if (arg1 && lparg1) setGESTUREINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetGestureInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetGlyphIndices
JNIEXPORT jint JNICALL OS_NATIVE(GetGlyphIndices)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jshortArray arg3, jint arg4)
{
	jchar *lparg1=NULL;
	jshort *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetGlyphIndices_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetShortArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)GetGlyphIndices((HDC)arg0, lparg1, arg2, (LPWORD)lparg3, arg4);
fail:
	if (arg3 && lparg3) (*env)->ReleaseShortArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GetGlyphIndices_FUNC);
	return rc;
}
#endif

#ifndef NO_GetGraphicsMode
JNIEXPORT jint JNICALL OS_NATIVE(GetGraphicsMode)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetGraphicsMode_FUNC);
	rc = (jint)GetGraphicsMode((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetGraphicsMode_FUNC);
	return rc;
}
#endif

#ifndef NO_GetIconInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetIconInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	ICONINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetIconInfo_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jboolean)GetIconInfo((HICON)arg0, lparg1);
fail:
	if (arg1 && lparg1) setICONINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetIconInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetKeyState
JNIEXPORT jshort JNICALL OS_NATIVE(GetKeyState)
	(JNIEnv *env, jclass that, jint arg0)
{
	jshort rc = 0;
	OS_NATIVE_ENTER(env, that, GetKeyState_FUNC);
	rc = (jshort)GetKeyState(arg0);
	OS_NATIVE_EXIT(env, that, GetKeyState_FUNC);
	return rc;
}
#endif

#ifndef NO_GetKeyboardLayout
JNIEXPORT jlong JNICALL OS_NATIVE(GetKeyboardLayout)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetKeyboardLayout_FUNC);
	rc = (jlong)GetKeyboardLayout(arg0);
	OS_NATIVE_EXIT(env, that, GetKeyboardLayout_FUNC);
	return rc;
}
#endif

#ifndef NO_GetKeyboardLayoutList
JNIEXPORT jint JNICALL OS_NATIVE(GetKeyboardLayoutList)
	(JNIEnv *env, jclass that, jint arg0, jlongArray arg1)
{
	jlong *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetKeyboardLayoutList_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetKeyboardLayoutList(arg0, (HKL FAR *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetKeyboardLayoutList_FUNC);
	return rc;
}
#endif

#ifndef NO_GetKeyboardState
JNIEXPORT jboolean JNICALL OS_NATIVE(GetKeyboardState)
	(JNIEnv *env, jclass that, jbyteArray arg0)
{
	jbyte *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetKeyboardState_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetByteArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jboolean)GetKeyboardState((PBYTE)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseByteArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, GetKeyboardState_FUNC);
	return rc;
}
#endif

#ifndef NO_GetLastActivePopup
JNIEXPORT jlong JNICALL OS_NATIVE(GetLastActivePopup)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetLastActivePopup_FUNC);
	rc = (jlong)GetLastActivePopup((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetLastActivePopup_FUNC);
	return rc;
}
#endif

#ifndef NO_GetLastError
JNIEXPORT jint JNICALL OS_NATIVE(GetLastError)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetLastError_FUNC);
	rc = (jint)GetLastError();
	OS_NATIVE_EXIT(env, that, GetLastError_FUNC);
	return rc;
}
#endif

#ifndef NO_GetLayeredWindowAttributes
JNIEXPORT jboolean JNICALL OS_NATIVE(GetLayeredWindowAttributes)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jbyteArray arg2, jintArray arg3)
{
	jint *lparg1=NULL;
	jbyte *lparg2=NULL;
	jint *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetLayeredWindowAttributes_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)GetLayeredWindowAttributes((HWND)arg0, (COLORREF *)lparg1, (BYTE *)lparg2, (DWORD *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetLayeredWindowAttributes_FUNC);
	return rc;
}
#endif

#ifndef NO_GetLayout
JNIEXPORT jint JNICALL OS_NATIVE(GetLayout)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetLayout_FUNC);
	rc = (jint)GetLayout((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetLayout_FUNC);
	return rc;
}
#endif

#ifndef NO_GetLocaleInfo
JNIEXPORT jint JNICALL OS_NATIVE(GetLocaleInfo)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jcharArray arg2, jint arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetLocaleInfo_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)GetLocaleInfo(arg0, arg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, GetLocaleInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenu
JNIEXPORT jlong JNICALL OS_NATIVE(GetMenu)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenu_FUNC);
	rc = (jlong)GetMenu((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuBarInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMenuBarInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jobject arg3)
{
	MENUBARINFO _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuBarInfo_FUNC);
	if (arg3) if ((lparg3 = getMENUBARINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)GetMenuBarInfo((HWND)arg0, arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setMENUBARINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, GetMenuBarInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuDefaultItem
JNIEXPORT jint JNICALL OS_NATIVE(GetMenuDefaultItem)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuDefaultItem_FUNC);
	rc = (jint)GetMenuDefaultItem((HMENU)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, GetMenuDefaultItem_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMenuInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	MENUINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuInfo_FUNC);
	if (arg1) if ((lparg1 = getMENUINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetMenuInfo((HMENU)arg0, lparg1);
fail:
	if (arg1 && lparg1) setMENUINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetMenuInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuItemCount
JNIEXPORT jint JNICALL OS_NATIVE(GetMenuItemCount)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuItemCount_FUNC);
	rc = (jint)GetMenuItemCount((HMENU)arg0);
	OS_NATIVE_EXIT(env, that, GetMenuItemCount_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuItemInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMenuItemInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jboolean arg2, jobject arg3)
{
	MENUITEMINFO _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuItemInfo_FUNC);
	if (arg3) if ((lparg3 = getMENUITEMINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)GetMenuItemInfo((HMENU)arg0, arg1, arg2, (LPMENUITEMINFOW)lparg3);
fail:
	if (arg3 && lparg3) setMENUITEMINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, GetMenuItemInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMenuItemRect
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMenuItemRect)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jobject arg3)
{
	RECT _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMenuItemRect_FUNC);
	if (arg3) if ((lparg3 = &_arg3) == NULL) goto fail;
	rc = (jboolean)GetMenuItemRect((HWND)arg0, (HMENU)arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setRECTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, GetMenuItemRect_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMessage)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2, jint arg3)
{
	MSG _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMessage_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	rc = (jboolean)GetMessage(lparg0, (HWND)arg1, arg2, arg3);
fail:
	if (arg0 && lparg0) setMSGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, GetMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMessagePos
JNIEXPORT jint JNICALL OS_NATIVE(GetMessagePos)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetMessagePos_FUNC);
	rc = (jint)GetMessagePos();
	OS_NATIVE_EXIT(env, that, GetMessagePos_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMessageTime
JNIEXPORT jint JNICALL OS_NATIVE(GetMessageTime)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetMessageTime_FUNC);
	rc = (jint)GetMessageTime();
	OS_NATIVE_EXIT(env, that, GetMessageTime_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMetaRgn
JNIEXPORT jint JNICALL OS_NATIVE(GetMetaRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetMetaRgn_FUNC);
	rc = (jint)GetMetaRgn((HDC)arg0, (HRGN)arg1);
	OS_NATIVE_EXIT(env, that, GetMetaRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_GetModuleFileName
JNIEXPORT jint JNICALL OS_NATIVE(GetModuleFileName)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetModuleFileName_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetModuleFileName((HMODULE)arg0, (LPWSTR)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetModuleFileName_FUNC);
	return rc;
}
#endif

#ifndef NO_GetModuleHandle
JNIEXPORT jlong JNICALL OS_NATIVE(GetModuleHandle)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetModuleHandle_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jlong)GetModuleHandle((LPWSTR)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GetModuleHandle_FUNC);
	return rc;
}
#endif

#ifndef NO_GetMonitorInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetMonitorInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	MONITORINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetMonitorInfo_FUNC);
	if (arg1) if ((lparg1 = getMONITORINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetMonitorInfo((HMONITOR)arg0, lparg1);
fail:
	if (arg1 && lparg1) setMONITORINFOFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetMonitorInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetObject__JIJ
JNIEXPORT jint JNICALL OS_NATIVE(GetObject__JIJ)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetObject__JIJ_FUNC);
	rc = (jint)GetObject((HGDIOBJ)arg0, arg1, (LPVOID)arg2);
	OS_NATIVE_EXIT(env, that, GetObject__JIJ_FUNC);
	return rc;
}
#endif

#ifndef NO_GetObject__JILorg_eclipse_swt_internal_win32_BITMAP_2
JNIEXPORT jint JNICALL OS_NATIVE(GetObject__JILorg_eclipse_swt_internal_win32_BITMAP_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	BITMAP _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetObject__JILorg_eclipse_swt_internal_win32_BITMAP_2_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	rc = (jint)GetObject((HGDIOBJ)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setBITMAPFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetObject__JILorg_eclipse_swt_internal_win32_BITMAP_2_FUNC);
	return rc;
}
#endif

#ifndef NO_GetObject__JILorg_eclipse_swt_internal_win32_DIBSECTION_2
JNIEXPORT jint JNICALL OS_NATIVE(GetObject__JILorg_eclipse_swt_internal_win32_DIBSECTION_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	DIBSECTION _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetObject__JILorg_eclipse_swt_internal_win32_DIBSECTION_2_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	rc = (jint)GetObject((HGDIOBJ)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setDIBSECTIONFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetObject__JILorg_eclipse_swt_internal_win32_DIBSECTION_2_FUNC);
	return rc;
}
#endif

#ifndef NO_GetObject__JILorg_eclipse_swt_internal_win32_LOGBRUSH_2
JNIEXPORT jint JNICALL OS_NATIVE(GetObject__JILorg_eclipse_swt_internal_win32_LOGBRUSH_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	LOGBRUSH _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetObject__JILorg_eclipse_swt_internal_win32_LOGBRUSH_2_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	rc = (jint)GetObject((HGDIOBJ)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setLOGBRUSHFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetObject__JILorg_eclipse_swt_internal_win32_LOGBRUSH_2_FUNC);
	return rc;
}
#endif

#ifndef NO_GetObject__JILorg_eclipse_swt_internal_win32_LOGFONT_2
JNIEXPORT jint JNICALL OS_NATIVE(GetObject__JILorg_eclipse_swt_internal_win32_LOGFONT_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	LOGFONT _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetObject__JILorg_eclipse_swt_internal_win32_LOGFONT_2_FUNC);
	if (arg2) if ((lparg2 = &_arg2) == NULL) goto fail;
	rc = (jint)GetObject((HGDIOBJ)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setLOGFONTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetObject__JILorg_eclipse_swt_internal_win32_LOGFONT_2_FUNC);
	return rc;
}
#endif

#ifndef NO_GetOutlineTextMetrics
JNIEXPORT jint JNICALL OS_NATIVE(GetOutlineTextMetrics)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	OUTLINETEXTMETRIC _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetOutlineTextMetrics_FUNC);
	if (arg2) if ((lparg2 = getOUTLINETEXTMETRICFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)GetOutlineTextMetrics((HDC)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setOUTLINETEXTMETRICFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetOutlineTextMetrics_FUNC);
	return rc;
}
#endif

#ifndef NO_GetParent
JNIEXPORT jlong JNICALL OS_NATIVE(GetParent)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetParent_FUNC);
	rc = (jlong)GetParent((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetParent_FUNC);
	return rc;
}
#endif

#ifndef NO_GetPixel
JNIEXPORT jint JNICALL OS_NATIVE(GetPixel)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetPixel_FUNC);
	rc = (jint)GetPixel((HDC)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, GetPixel_FUNC);
	return rc;
}
#endif

#ifndef NO_GetPolyFillMode
JNIEXPORT jint JNICALL OS_NATIVE(GetPolyFillMode)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetPolyFillMode_FUNC);
	rc = (jint)GetPolyFillMode((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetPolyFillMode_FUNC);
	return rc;
}
#endif

#ifndef NO_GetProcessHeap
JNIEXPORT jlong JNICALL OS_NATIVE(GetProcessHeap)
	(JNIEnv *env, jclass that)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetProcessHeap_FUNC);
	rc = (jlong)GetProcessHeap();
	OS_NATIVE_EXIT(env, that, GetProcessHeap_FUNC);
	return rc;
}
#endif

#ifndef NO_GetProfileString
JNIEXPORT jint JNICALL OS_NATIVE(GetProfileString)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jcharArray arg2, jcharArray arg3, jint arg4)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetProfileString_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)GetProfileString((LPWSTR)lparg0, (LPWSTR)lparg1, (LPWSTR)lparg2, (LPWSTR)lparg3, arg4);
fail:
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GetProfileString_FUNC);
	return rc;
}
#endif

#ifndef NO_GetProp
JNIEXPORT jlong JNICALL OS_NATIVE(GetProp)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetProp_FUNC);
	rc = (jlong)GetProp((HWND)arg0, (LPCWSTR)arg1);
	OS_NATIVE_EXIT(env, that, GetProp_FUNC);
	return rc;
}
#endif

#ifndef NO_GetROP2
JNIEXPORT jint JNICALL OS_NATIVE(GetROP2)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetROP2_FUNC);
	rc = (jint)GetROP2((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetROP2_FUNC);
	return rc;
}
#endif

#ifndef NO_GetRandomRgn
JNIEXPORT jint JNICALL OS_NATIVE(GetRandomRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetRandomRgn_FUNC);
	rc = (jint)GetRandomRgn((HDC)arg0, (HRGN)arg1, arg2);
	OS_NATIVE_EXIT(env, that, GetRandomRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_GetRegionData
JNIEXPORT jint JNICALL OS_NATIVE(GetRegionData)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2)
{
	jint *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetRegionData_FUNC);
		if (arg2) if ((lparg2 = (*env)->GetPrimitiveArrayCritical(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)GetRegionData((HRGN)arg0, arg1, (RGNDATA *)lparg2);
fail:
		if (arg2 && lparg2) (*env)->ReleasePrimitiveArrayCritical(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, GetRegionData_FUNC);
	return rc;
}
#endif

#ifndef NO_GetRgnBox
JNIEXPORT jint JNICALL OS_NATIVE(GetRgnBox)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetRgnBox_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jint)GetRgnBox((HRGN)arg0, lparg1);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetRgnBox_FUNC);
	return rc;
}
#endif

#ifndef NO_GetScrollBarInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetScrollBarInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	SCROLLBARINFO _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetScrollBarInfo_FUNC);
	if (arg2) if ((lparg2 = getSCROLLBARINFOFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)GetScrollBarInfo((HWND)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setSCROLLBARINFOFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetScrollBarInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetScrollInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetScrollInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2)
{
	SCROLLINFO _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetScrollInfo_FUNC);
	if (arg2) if ((lparg2 = getSCROLLINFOFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)GetScrollInfo((HWND)arg0, arg1, lparg2);
fail:
	if (arg2 && lparg2) setSCROLLINFOFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, GetScrollInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetStartupInfo
JNIEXPORT void JNICALL OS_NATIVE(GetStartupInfo)
	(JNIEnv *env, jclass that, jobject arg0)
{
	STARTUPINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, GetStartupInfo_FUNC);
	if (arg0) if ((lparg0 = getSTARTUPINFOFields(env, arg0, &_arg0)) == NULL) goto fail;
	GetStartupInfo(lparg0);
fail:
	if (arg0 && lparg0) setSTARTUPINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, GetStartupInfo_FUNC);
}
#endif

#ifndef NO_GetStockObject
JNIEXPORT jlong JNICALL OS_NATIVE(GetStockObject)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetStockObject_FUNC);
	rc = (jlong)GetStockObject(arg0);
	OS_NATIVE_EXIT(env, that, GetStockObject_FUNC);
	return rc;
}
#endif

#ifndef NO_GetSysColor
JNIEXPORT jint JNICALL OS_NATIVE(GetSysColor)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetSysColor_FUNC);
	rc = (jint)GetSysColor(arg0);
	OS_NATIVE_EXIT(env, that, GetSysColor_FUNC);
	return rc;
}
#endif

#ifndef NO_GetSysColorBrush
JNIEXPORT jlong JNICALL OS_NATIVE(GetSysColorBrush)
	(JNIEnv *env, jclass that, jint arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetSysColorBrush_FUNC);
	rc = (jlong)GetSysColorBrush(arg0);
	OS_NATIVE_EXIT(env, that, GetSysColorBrush_FUNC);
	return rc;
}
#endif

#ifndef NO_GetSystemMenu
JNIEXPORT jlong JNICALL OS_NATIVE(GetSystemMenu)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetSystemMenu_FUNC);
	rc = (jlong)GetSystemMenu((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetSystemMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_GetSystemMetrics
JNIEXPORT jint JNICALL OS_NATIVE(GetSystemMetrics)
	(JNIEnv *env, jclass that, jint arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetSystemMetrics_FUNC);
	rc = (jint)GetSystemMetrics(arg0);
	OS_NATIVE_EXIT(env, that, GetSystemMetrics_FUNC);
	return rc;
}
#endif

#ifndef NO_GetTextColor
JNIEXPORT jint JNICALL OS_NATIVE(GetTextColor)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetTextColor_FUNC);
	rc = (jint)GetTextColor((HDC)arg0);
	OS_NATIVE_EXIT(env, that, GetTextColor_FUNC);
	return rc;
}
#endif

#ifndef NO_GetTextExtentPoint32
JNIEXPORT jboolean JNICALL OS_NATIVE(GetTextExtentPoint32)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jobject arg3)
{
	jchar *lparg1=NULL;
	SIZE _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetTextExtentPoint32_FUNC);
	if (arg3) if ((lparg3 = &_arg3) == NULL) goto fail;
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)GetTextExtentPoint32((HDC)arg0, (LPWSTR)lparg1, arg2, lparg3);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	if (arg3 && lparg3) setSIZEFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, GetTextExtentPoint32_FUNC);
	return rc;
}
#endif

#ifndef NO_GetTextMetrics
JNIEXPORT jboolean JNICALL OS_NATIVE(GetTextMetrics)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	TEXTMETRIC _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetTextMetrics_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jboolean)GetTextMetrics((HDC)arg0, lparg1);
fail:
	if (arg1 && lparg1) setTEXTMETRICFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetTextMetrics_FUNC);
	return rc;
}
#endif

#ifndef NO_GetThemePartSize
JNIEXPORT jint JNICALL OS_NATIVE(GetThemePartSize)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jobject arg4, jint arg5, jobject arg6)
{
	RECT _arg4, *lparg4=NULL;
	SIZE _arg6, *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetThemePartSize_FUNC);
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg6) if ((lparg6 = &_arg6) == NULL) goto fail;
	rc = (jint)GetThemePartSize((HTHEME)arg0, (HDC)arg1, arg2, arg3, lparg4, arg5, lparg6);
fail:
	if (arg6 && lparg6) setSIZEFields(env, arg6, lparg6);
	OS_NATIVE_EXIT(env, that, GetThemePartSize_FUNC);
	return rc;
}
#endif

#ifndef NO_GetThemeTextExtent
JNIEXPORT jint JNICALL OS_NATIVE(GetThemeTextExtent)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jcharArray arg4, jint arg5, jint arg6, jobject arg7, jobject arg8)
{
	jchar *lparg4=NULL;
	RECT _arg7, *lparg7=NULL;
	RECT _arg8, *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetThemeTextExtent_FUNC);
	if (arg4) if ((lparg4 = (*env)->GetCharArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = getRECTFields(env, arg7, &_arg7)) == NULL) goto fail;
	if (arg8) if ((lparg8 = &_arg8) == NULL) goto fail;
	rc = (jint)GetThemeTextExtent((HTHEME)arg0, (HDC)arg1, arg2, arg3, lparg4, arg5, arg6, lparg7, lparg8);
fail:
	if (arg8 && lparg8) setRECTFields(env, arg8, lparg8);
	if (arg4 && lparg4) (*env)->ReleaseCharArrayElements(env, arg4, lparg4, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GetThemeTextExtent_FUNC);
	return rc;
}
#endif

#ifndef NO_GetTouchInputInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(GetTouchInputInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetTouchInputInfo_FUNC);
	rc = (jboolean)GetTouchInputInfo((HTOUCHINPUT)arg0, (UINT)arg1, (PTOUCHINPUT)arg2, arg3);
	OS_NATIVE_EXIT(env, that, GetTouchInputInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_GetUpdateRect
JNIEXPORT jboolean JNICALL OS_NATIVE(GetUpdateRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jboolean arg2)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetUpdateRect_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jboolean)GetUpdateRect((HWND)arg0, lparg1, (BOOL)arg2);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetUpdateRect_FUNC);
	return rc;
}
#endif

#ifndef NO_GetUpdateRgn
JNIEXPORT jint JNICALL OS_NATIVE(GetUpdateRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jboolean arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetUpdateRgn_FUNC);
	rc = (jint)GetUpdateRgn((HWND)arg0, (HRGN)arg1, arg2);
	OS_NATIVE_EXIT(env, that, GetUpdateRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_GetVersion
JNIEXPORT jint JNICALL OS_NATIVE(GetVersion)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetVersion_FUNC);
	rc = (jint)GetVersion();
	OS_NATIVE_EXIT(env, that, GetVersion_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindow
JNIEXPORT jlong JNICALL OS_NATIVE(GetWindow)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindow_FUNC);
	rc = (jlong)GetWindow((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowDC
JNIEXPORT jlong JNICALL OS_NATIVE(GetWindowDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowDC_FUNC);
	rc = (jlong)GetWindowDC((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetWindowDC_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowLong
JNIEXPORT jint JNICALL OS_NATIVE(GetWindowLong)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowLong_FUNC);
	rc = (jint)GetWindowLong((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetWindowLong_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowLongPtr
JNIEXPORT jlong JNICALL OS_NATIVE(GetWindowLongPtr)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowLongPtr_FUNC);
	rc = (jlong)GetWindowLongPtr((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, GetWindowLongPtr_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowOrgEx
JNIEXPORT jboolean JNICALL OS_NATIVE(GetWindowOrgEx)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowOrgEx_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetWindowOrgEx((HDC)arg0, lparg1);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetWindowOrgEx_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowPlacement
JNIEXPORT jboolean JNICALL OS_NATIVE(GetWindowPlacement)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	WINDOWPLACEMENT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowPlacement_FUNC);
	if (arg1) if ((lparg1 = getWINDOWPLACEMENTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetWindowPlacement((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setWINDOWPLACEMENTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetWindowPlacement_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowRect
JNIEXPORT jboolean JNICALL OS_NATIVE(GetWindowRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowRect_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)GetWindowRect((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, GetWindowRect_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowRgn
JNIEXPORT jint JNICALL OS_NATIVE(GetWindowRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowRgn_FUNC);
	rc = (jint)GetWindowRgn((HWND)arg0, (HRGN)arg1);
	OS_NATIVE_EXIT(env, that, GetWindowRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowText
JNIEXPORT jint JNICALL OS_NATIVE(GetWindowText)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowText_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetWindowText((HWND)arg0, (LPWSTR)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetWindowText_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowTextLength
JNIEXPORT jint JNICALL OS_NATIVE(GetWindowTextLength)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowTextLength_FUNC);
	rc = (jint)GetWindowTextLength((HWND)arg0);
	OS_NATIVE_EXIT(env, that, GetWindowTextLength_FUNC);
	return rc;
}
#endif

#ifndef NO_GetWindowThreadProcessId
JNIEXPORT jint JNICALL OS_NATIVE(GetWindowThreadProcessId)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1)
{
	jint *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GetWindowThreadProcessId_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)GetWindowThreadProcessId((HWND)arg0, (LPDWORD)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, GetWindowThreadProcessId_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalAddAtom
JNIEXPORT jint JNICALL OS_NATIVE(GlobalAddAtom)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalAddAtom_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)GlobalAddAtom((LPCWSTR)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, GlobalAddAtom_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalAlloc
JNIEXPORT jlong JNICALL OS_NATIVE(GlobalAlloc)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalAlloc_FUNC);
	rc = (jlong)GlobalAlloc(arg0, arg1);
	OS_NATIVE_EXIT(env, that, GlobalAlloc_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalFree
JNIEXPORT jlong JNICALL OS_NATIVE(GlobalFree)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalFree_FUNC);
	rc = (jlong)GlobalFree((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, GlobalFree_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalLock
JNIEXPORT jlong JNICALL OS_NATIVE(GlobalLock)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalLock_FUNC);
	rc = (jlong)GlobalLock((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, GlobalLock_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalSize
JNIEXPORT jint JNICALL OS_NATIVE(GlobalSize)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalSize_FUNC);
	rc = (jint)GlobalSize((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, GlobalSize_FUNC);
	return rc;
}
#endif

#ifndef NO_GlobalUnlock
JNIEXPORT jboolean JNICALL OS_NATIVE(GlobalUnlock)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GlobalUnlock_FUNC);
	rc = (jboolean)GlobalUnlock((HANDLE)arg0);
	OS_NATIVE_EXIT(env, that, GlobalUnlock_FUNC);
	return rc;
}
#endif

#ifndef NO_GradientFill
JNIEXPORT jboolean JNICALL OS_NATIVE(GradientFill)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3, jint arg4, jint arg5)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, GradientFill_FUNC);
	rc = (jboolean)GradientFill((HDC)arg0, (PTRIVERTEX)arg1, (ULONG)arg2, (PVOID)arg3, (ULONG)arg4, (ULONG)arg5);
	OS_NATIVE_EXIT(env, that, GradientFill_FUNC);
	return rc;
}
#endif

#ifndef NO_HDHITTESTINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(HDHITTESTINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, HDHITTESTINFO_1sizeof_FUNC);
	rc = (jint)HDHITTESTINFO_sizeof();
	OS_NATIVE_EXIT(env, that, HDHITTESTINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_HDITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(HDITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, HDITEM_1sizeof_FUNC);
	rc = (jint)HDITEM_sizeof();
	OS_NATIVE_EXIT(env, that, HDITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_HDLAYOUT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(HDLAYOUT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, HDLAYOUT_1sizeof_FUNC);
	rc = (jint)HDLAYOUT_sizeof();
	OS_NATIVE_EXIT(env, that, HDLAYOUT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_HELPINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(HELPINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, HELPINFO_1sizeof_FUNC);
	rc = (jint)HELPINFO_sizeof();
	OS_NATIVE_EXIT(env, that, HELPINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_HIGHCONTRAST_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(HIGHCONTRAST_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, HIGHCONTRAST_1sizeof_FUNC);
	rc = (jint)HIGHCONTRAST_sizeof();
	OS_NATIVE_EXIT(env, that, HIGHCONTRAST_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_HeapAlloc
JNIEXPORT jlong JNICALL OS_NATIVE(HeapAlloc)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, HeapAlloc_FUNC);
	rc = (jlong)HeapAlloc((HANDLE)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, HeapAlloc_FUNC);
	return rc;
}
#endif

#ifndef NO_HeapFree
JNIEXPORT jboolean JNICALL OS_NATIVE(HeapFree)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, HeapFree_FUNC);
	rc = (jboolean)HeapFree((HANDLE)arg0, arg1, (LPVOID)arg2);
	OS_NATIVE_EXIT(env, that, HeapFree_FUNC);
	return rc;
}
#endif

#ifndef NO_HideCaret
JNIEXPORT jboolean JNICALL OS_NATIVE(HideCaret)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, HideCaret_FUNC);
	rc = (jboolean)HideCaret((HWND)arg0);
	OS_NATIVE_EXIT(env, that, HideCaret_FUNC);
	return rc;
}
#endif

#ifndef NO_ICONINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(ICONINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ICONINFO_1sizeof_FUNC);
	rc = (jint)ICONINFO_sizeof();
	OS_NATIVE_EXIT(env, that, ICONINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_IIDFromString
JNIEXPORT jint JNICALL OS_NATIVE(IIDFromString)
	(JNIEnv *env, jclass that, jcharArray arg0, jbyteArray arg1)
{
	jchar *lparg0=NULL;
	jbyte *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, IIDFromString_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)IIDFromString((LPOLESTR)lparg0, (LPIID)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, IIDFromString_FUNC);
	return rc;
}
#endif

#ifndef NO_ILGetSize
JNIEXPORT jint JNICALL OS_NATIVE(ILGetSize)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ILGetSize_FUNC);
	rc = (jint)ILGetSize((PCIDLIST_ABSOLUTE)arg0);
	OS_NATIVE_EXIT(env, that, ILGetSize_FUNC);
	return rc;
}
#endif

#ifndef NO_INITCOMMONCONTROLSEX_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(INITCOMMONCONTROLSEX_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, INITCOMMONCONTROLSEX_1sizeof_FUNC);
	rc = (jint)INITCOMMONCONTROLSEX_sizeof();
	OS_NATIVE_EXIT(env, that, INITCOMMONCONTROLSEX_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_INPUT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(INPUT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, INPUT_1sizeof_FUNC);
	rc = (jint)INPUT_sizeof();
	OS_NATIVE_EXIT(env, that, INPUT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1Add
JNIEXPORT jint JNICALL OS_NATIVE(ImageList_1Add)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1Add_FUNC);
	rc = (jint)ImageList_Add((HIMAGELIST)arg0, (HBITMAP)arg1, (HBITMAP)arg2);
	OS_NATIVE_EXIT(env, that, ImageList_1Add_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1AddMasked
JNIEXPORT jint JNICALL OS_NATIVE(ImageList_1AddMasked)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1AddMasked_FUNC);
	rc = (jint)ImageList_AddMasked((HIMAGELIST)arg0, (HBITMAP)arg1, (COLORREF)arg2);
	OS_NATIVE_EXIT(env, that, ImageList_1AddMasked_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1BeginDrag
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1BeginDrag)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1BeginDrag_FUNC);
	rc = (jboolean)ImageList_BeginDrag((HIMAGELIST)arg0, arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, ImageList_1BeginDrag_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1Create
JNIEXPORT jlong JNICALL OS_NATIVE(ImageList_1Create)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1Create_FUNC);
	rc = (jlong)ImageList_Create(arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, ImageList_1Create_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1Destroy
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1Destroy)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1Destroy_FUNC);
	rc = (jboolean)ImageList_Destroy((HIMAGELIST)arg0);
	OS_NATIVE_EXIT(env, that, ImageList_1Destroy_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1DragEnter
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1DragEnter)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1DragEnter_FUNC);
	rc = (jboolean)ImageList_DragEnter((HWND)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, ImageList_1DragEnter_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1DragLeave
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1DragLeave)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1DragLeave_FUNC);
	rc = (jboolean)ImageList_DragLeave((HWND)arg0);
	OS_NATIVE_EXIT(env, that, ImageList_1DragLeave_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1DragMove
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1DragMove)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1DragMove_FUNC);
	rc = (jboolean)ImageList_DragMove(arg0, arg1);
	OS_NATIVE_EXIT(env, that, ImageList_1DragMove_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1DragShowNolock
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1DragShowNolock)
	(JNIEnv *env, jclass that, jboolean arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1DragShowNolock_FUNC);
	rc = (jboolean)ImageList_DragShowNolock((BOOL)arg0);
	OS_NATIVE_EXIT(env, that, ImageList_1DragShowNolock_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1EndDrag
JNIEXPORT void JNICALL OS_NATIVE(ImageList_1EndDrag)
	(JNIEnv *env, jclass that)
{
	OS_NATIVE_ENTER(env, that, ImageList_1EndDrag_FUNC);
	ImageList_EndDrag();
	OS_NATIVE_EXIT(env, that, ImageList_1EndDrag_FUNC);
}
#endif

#ifndef NO_ImageList_1GetIconSize
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1GetIconSize)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1GetIconSize_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jboolean)ImageList_GetIconSize((HIMAGELIST)arg0, (int *)lparg1, (int *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, ImageList_1GetIconSize_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1GetImageCount
JNIEXPORT jint JNICALL OS_NATIVE(ImageList_1GetImageCount)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1GetImageCount_FUNC);
	rc = (jint)ImageList_GetImageCount((HIMAGELIST)arg0);
	OS_NATIVE_EXIT(env, that, ImageList_1GetImageCount_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1Remove
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1Remove)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1Remove_FUNC);
	rc = (jboolean)ImageList_Remove((HIMAGELIST)arg0, arg1);
	OS_NATIVE_EXIT(env, that, ImageList_1Remove_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1Replace
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1Replace)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1Replace_FUNC);
	rc = (jboolean)ImageList_Replace((HIMAGELIST)arg0, arg1, (HBITMAP)arg2, (HBITMAP)arg3);
	OS_NATIVE_EXIT(env, that, ImageList_1Replace_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1ReplaceIcon
JNIEXPORT jint JNICALL OS_NATIVE(ImageList_1ReplaceIcon)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1ReplaceIcon_FUNC);
	rc = (jint)ImageList_ReplaceIcon((HIMAGELIST)arg0, arg1, (HICON)arg2);
	OS_NATIVE_EXIT(env, that, ImageList_1ReplaceIcon_FUNC);
	return rc;
}
#endif

#ifndef NO_ImageList_1SetIconSize
JNIEXPORT jboolean JNICALL OS_NATIVE(ImageList_1SetIconSize)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImageList_1SetIconSize_FUNC);
	rc = (jboolean)ImageList_SetIconSize((HIMAGELIST)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, ImageList_1SetIconSize_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmEscape
JNIEXPORT jlong JNICALL OS_NATIVE(ImmEscape)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jcharArray arg3)
{
	jchar *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ImmEscape_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)ImmEscape((HKL)arg0, (HIMC)arg1, arg2, (LPVOID)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, ImmEscape_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetCompositionFont
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmGetCompositionFont)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	LOGFONT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetCompositionFont_FUNC);
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jboolean)ImmGetCompositionFont((HIMC)arg0, lparg1);
fail:
	if (arg1 && lparg1) setLOGFONTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, ImmGetCompositionFont_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetCompositionString__JI_3BI
JNIEXPORT jint JNICALL OS_NATIVE(ImmGetCompositionString__JI_3BI)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jbyteArray arg2, jint arg3)
{
	jbyte *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetCompositionString__JI_3BI_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)ImmGetCompositionString((HIMC)arg0, arg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, ImmGetCompositionString__JI_3BI_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetCompositionString__JI_3CI
JNIEXPORT jint JNICALL OS_NATIVE(ImmGetCompositionString__JI_3CI)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jcharArray arg2, jint arg3)
{
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetCompositionString__JI_3CI_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)ImmGetCompositionString((HIMC)arg0, arg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, ImmGetCompositionString__JI_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetCompositionString__JI_3II
JNIEXPORT jint JNICALL OS_NATIVE(ImmGetCompositionString__JI_3II)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jint arg3)
{
	jint *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetCompositionString__JI_3II_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)ImmGetCompositionString((HIMC)arg0, arg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, ImmGetCompositionString__JI_3II_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetContext
JNIEXPORT jlong JNICALL OS_NATIVE(ImmGetContext)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetContext_FUNC);
	rc = (jlong)ImmGetContext((HWND)arg0);
	OS_NATIVE_EXIT(env, that, ImmGetContext_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetConversionStatus
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmGetConversionStatus)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jintArray arg2)
{
	jint *lparg1=NULL;
	jint *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetConversionStatus_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jboolean)ImmGetConversionStatus((HIMC)arg0, (LPDWORD)lparg1, (LPDWORD)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, ImmGetConversionStatus_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetDefaultIMEWnd
JNIEXPORT jlong JNICALL OS_NATIVE(ImmGetDefaultIMEWnd)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetDefaultIMEWnd_FUNC);
	rc = (jlong)ImmGetDefaultIMEWnd((HWND)arg0);
	OS_NATIVE_EXIT(env, that, ImmGetDefaultIMEWnd_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmGetOpenStatus
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmGetOpenStatus)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmGetOpenStatus_FUNC);
	rc = (jboolean)ImmGetOpenStatus((HIMC)arg0);
	OS_NATIVE_EXIT(env, that, ImmGetOpenStatus_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmNotifyIME
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmNotifyIME)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmNotifyIME_FUNC);
	rc = (jboolean)ImmNotifyIME((HIMC)arg0, arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, ImmNotifyIME_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmReleaseContext
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmReleaseContext)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmReleaseContext_FUNC);
	rc = (jboolean)ImmReleaseContext((HWND)arg0, (HIMC)arg1);
	OS_NATIVE_EXIT(env, that, ImmReleaseContext_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmSetCandidateWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmSetCandidateWindow)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	CANDIDATEFORM _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmSetCandidateWindow_FUNC);
	if (arg1) if ((lparg1 = getCANDIDATEFORMFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ImmSetCandidateWindow((HIMC)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, ImmSetCandidateWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmSetCompositionFont
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmSetCompositionFont)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	LOGFONT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmSetCompositionFont_FUNC);
	if (arg1) if ((lparg1 = getLOGFONTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ImmSetCompositionFont((HIMC)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, ImmSetCompositionFont_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmSetCompositionWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmSetCompositionWindow)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	COMPOSITIONFORM _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmSetCompositionWindow_FUNC);
	if (arg1) if ((lparg1 = getCOMPOSITIONFORMFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ImmSetCompositionWindow((HIMC)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, ImmSetCompositionWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmSetConversionStatus
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmSetConversionStatus)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmSetConversionStatus_FUNC);
	rc = (jboolean)ImmSetConversionStatus((HIMC)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, ImmSetConversionStatus_FUNC);
	return rc;
}
#endif

#ifndef NO_ImmSetOpenStatus
JNIEXPORT jboolean JNICALL OS_NATIVE(ImmSetOpenStatus)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ImmSetOpenStatus_FUNC);
	rc = (jboolean)ImmSetOpenStatus((HIMC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, ImmSetOpenStatus_FUNC);
	return rc;
}
#endif

#ifndef NO_InitCommonControlsEx
JNIEXPORT jboolean JNICALL OS_NATIVE(InitCommonControlsEx)
	(JNIEnv *env, jclass that, jobject arg0)
{
	INITCOMMONCONTROLSEX _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InitCommonControlsEx_FUNC);
	if (arg0) if ((lparg0 = getINITCOMMONCONTROLSEXFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)InitCommonControlsEx(lparg0);
fail:
	OS_NATIVE_EXIT(env, that, InitCommonControlsEx_FUNC);
	return rc;
}
#endif

#ifndef NO_InsertMenuItem
JNIEXPORT jboolean JNICALL OS_NATIVE(InsertMenuItem)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jboolean arg2, jobject arg3)
{
	MENUITEMINFO _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InsertMenuItem_FUNC);
	if (arg3) if ((lparg3 = getMENUITEMINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)InsertMenuItem((HMENU)arg0, arg1, arg2, lparg3);
fail:
	OS_NATIVE_EXIT(env, that, InsertMenuItem_FUNC);
	return rc;
}
#endif

#ifndef NO_InternetGetCookie
JNIEXPORT jboolean JNICALL OS_NATIVE(InternetGetCookie)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jcharArray arg2, jintArray arg3)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	jint *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InternetGetCookie_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jboolean)InternetGetCookie((LPCWSTR)lparg0, (LPCWSTR)lparg1, (LPWSTR)lparg2, (LPDWORD)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, InternetGetCookie_FUNC);
	return rc;
}
#endif

#ifndef NO_InternetSetCookie
JNIEXPORT jboolean JNICALL OS_NATIVE(InternetSetCookie)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jcharArray arg2)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InternetSetCookie_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jboolean)InternetSetCookie((LPCWSTR)lparg0, (LPCWSTR)lparg1, (LPCWSTR)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, InternetSetCookie_FUNC);
	return rc;
}
#endif

#ifndef NO_InternetSetOption
JNIEXPORT jboolean JNICALL OS_NATIVE(InternetSetOption)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InternetSetOption_FUNC);
	rc = (jboolean)InternetSetOption((HINTERNET)arg0, arg1, (LPVOID)arg2, arg3);
	OS_NATIVE_EXIT(env, that, InternetSetOption_FUNC);
	return rc;
}
#endif

#ifndef NO_IntersectClipRect
JNIEXPORT jint JNICALL OS_NATIVE(IntersectClipRect)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, IntersectClipRect_FUNC);
	rc = (jint)IntersectClipRect((HDC)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, IntersectClipRect_FUNC);
	return rc;
}
#endif

#ifndef NO_IntersectRect
JNIEXPORT jboolean JNICALL OS_NATIVE(IntersectRect)
	(JNIEnv *env, jclass that, jobject arg0, jobject arg1, jobject arg2)
{
	RECT _arg0, *lparg0=NULL;
	RECT _arg1, *lparg1=NULL;
	RECT _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IntersectRect_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getRECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)IntersectRect(lparg0, lparg1, lparg2);
fail:
	if (arg0 && lparg0) setRECTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, IntersectRect_FUNC);
	return rc;
}
#endif

#ifndef NO_InvalidateRect
JNIEXPORT jboolean JNICALL OS_NATIVE(InvalidateRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jboolean arg2)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InvalidateRect_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)InvalidateRect((HWND)arg0, lparg1, arg2);
fail:
	if (arg1 && lparg1) setRECTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, InvalidateRect_FUNC);
	return rc;
}
#endif

#ifndef NO_InvalidateRgn
JNIEXPORT jboolean JNICALL OS_NATIVE(InvalidateRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jboolean arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, InvalidateRgn_FUNC);
	rc = (jboolean)InvalidateRgn((HWND)arg0, (HRGN)arg1, arg2);
	OS_NATIVE_EXIT(env, that, InvalidateRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_IsAppThemed
JNIEXPORT jboolean JNICALL OS_NATIVE(IsAppThemed)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsAppThemed_FUNC);
	rc = (jboolean)IsAppThemed();
	OS_NATIVE_EXIT(env, that, IsAppThemed_FUNC);
	return rc;
}
#endif

#ifndef NO_IsHungAppWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(IsHungAppWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsHungAppWindow_FUNC);
	rc = (jboolean)IsHungAppWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, IsHungAppWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_IsIconic
JNIEXPORT jboolean JNICALL OS_NATIVE(IsIconic)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsIconic_FUNC);
	rc = (jboolean)IsIconic((HWND)arg0);
	OS_NATIVE_EXIT(env, that, IsIconic_FUNC);
	return rc;
}
#endif

#ifndef NO_IsTouchWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(IsTouchWindow)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1)
{
	jlong *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsTouchWindow_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)IsTouchWindow((HWND)arg0, (PULONG)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, IsTouchWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_IsWindowEnabled
JNIEXPORT jboolean JNICALL OS_NATIVE(IsWindowEnabled)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsWindowEnabled_FUNC);
	rc = (jboolean)IsWindowEnabled((HWND)arg0);
	OS_NATIVE_EXIT(env, that, IsWindowEnabled_FUNC);
	return rc;
}
#endif

#ifndef NO_IsWindowVisible
JNIEXPORT jboolean JNICALL OS_NATIVE(IsWindowVisible)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsWindowVisible_FUNC);
	rc = (jboolean)IsWindowVisible((HWND)arg0);
	OS_NATIVE_EXIT(env, that, IsWindowVisible_FUNC);
	return rc;
}
#endif

#ifndef NO_IsZoomed
JNIEXPORT jboolean JNICALL OS_NATIVE(IsZoomed)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, IsZoomed_FUNC);
	rc = (jboolean)IsZoomed((HWND)arg0);
	OS_NATIVE_EXIT(env, that, IsZoomed_FUNC);
	return rc;
}
#endif

#ifndef NO_KEYBDINPUT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(KEYBDINPUT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, KEYBDINPUT_1sizeof_FUNC);
	rc = (jint)KEYBDINPUT_sizeof();
	OS_NATIVE_EXIT(env, that, KEYBDINPUT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_KillTimer
JNIEXPORT jboolean JNICALL OS_NATIVE(KillTimer)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, KillTimer_FUNC);
	rc = (jboolean)KillTimer((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, KillTimer_FUNC);
	return rc;
}
#endif

#ifndef NO_LITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LITEM_1sizeof_FUNC);
	rc = (jint)LITEM_sizeof();
	OS_NATIVE_EXIT(env, that, LITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LOGBRUSH_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LOGBRUSH_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LOGBRUSH_1sizeof_FUNC);
	rc = (jint)LOGBRUSH_sizeof();
	OS_NATIVE_EXIT(env, that, LOGBRUSH_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LOGFONT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LOGFONT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LOGFONT_1sizeof_FUNC);
	rc = (jint)LOGFONT_sizeof();
	OS_NATIVE_EXIT(env, that, LOGFONT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LOGPEN_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LOGPEN_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LOGPEN_1sizeof_FUNC);
	rc = (jint)LOGPEN_sizeof();
	OS_NATIVE_EXIT(env, that, LOGPEN_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LPtoDP
JNIEXPORT jboolean JNICALL OS_NATIVE(LPtoDP)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, LPtoDP_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)LPtoDP((HDC)arg0, lparg1, arg2);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, LPtoDP_FUNC);
	return rc;
}
#endif

#ifndef NO_LVCOLUMN_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LVCOLUMN_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LVCOLUMN_1sizeof_FUNC);
	rc = (jint)LVCOLUMN_sizeof();
	OS_NATIVE_EXIT(env, that, LVCOLUMN_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LVHITTESTINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LVHITTESTINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LVHITTESTINFO_1sizeof_FUNC);
	rc = (jint)LVHITTESTINFO_sizeof();
	OS_NATIVE_EXIT(env, that, LVHITTESTINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LVINSERTMARK_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LVINSERTMARK_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LVINSERTMARK_1sizeof_FUNC);
	rc = (jint)LVINSERTMARK_sizeof();
	OS_NATIVE_EXIT(env, that, LVINSERTMARK_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LVITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(LVITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LVITEM_1sizeof_FUNC);
	rc = (jint)LVITEM_sizeof();
	OS_NATIVE_EXIT(env, that, LVITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_LineTo
JNIEXPORT jboolean JNICALL OS_NATIVE(LineTo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, LineTo_FUNC);
	rc = (jboolean)LineTo((HDC)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, LineTo_FUNC);
	return rc;
}
#endif

#ifndef NO_LoadBitmap
JNIEXPORT jlong JNICALL OS_NATIVE(LoadBitmap)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, LoadBitmap_FUNC);
	rc = (jlong)LoadBitmap((HINSTANCE)arg0, (LPWSTR)arg1);
	OS_NATIVE_EXIT(env, that, LoadBitmap_FUNC);
	return rc;
}
#endif

#ifndef NO_LoadCursor
JNIEXPORT jlong JNICALL OS_NATIVE(LoadCursor)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, LoadCursor_FUNC);
	rc = (jlong)LoadCursor((HINSTANCE)arg0, (LPWSTR)arg1);
	OS_NATIVE_EXIT(env, that, LoadCursor_FUNC);
	return rc;
}
#endif

#ifndef NO_LoadIcon
JNIEXPORT jlong JNICALL OS_NATIVE(LoadIcon)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, LoadIcon_FUNC);
	rc = (jlong)LoadIcon((HINSTANCE)arg0, (LPWSTR)arg1);
	OS_NATIVE_EXIT(env, that, LoadIcon_FUNC);
	return rc;
}
#endif

#ifndef NO_LoadIconMetric
JNIEXPORT jint JNICALL OS_NATIVE(LoadIconMetric)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlongArray arg3)
{
	jlong *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, LoadIconMetric_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetLongArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)LoadIconMetric((HINSTANCE)arg0, (PCWSTR)arg1, arg2, (HICON *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseLongArrayElements(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, LoadIconMetric_FUNC);
	return rc;
}
#endif

#ifndef NO_LoadImage
JNIEXPORT jlong JNICALL OS_NATIVE(LoadImage)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, LoadImage_FUNC);
	rc = (jlong)LoadImage((HINSTANCE)arg0, (LPWSTR)arg1, arg2, arg3, arg4, arg5);
	OS_NATIVE_EXIT(env, that, LoadImage_FUNC);
	return rc;
}
#endif

#ifndef NO_LocalFree
JNIEXPORT jlong JNICALL OS_NATIVE(LocalFree)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, LocalFree_FUNC);
	rc = (jlong)LocalFree((HLOCAL)arg0);
	OS_NATIVE_EXIT(env, that, LocalFree_FUNC);
	return rc;
}
#endif

#ifndef NO_MARGINS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MARGINS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MARGINS_1sizeof_FUNC);
	rc = (jint)MARGINS_sizeof();
	OS_NATIVE_EXIT(env, that, MARGINS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MCHITTESTINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MCHITTESTINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MCHITTESTINFO_1sizeof_FUNC);
	rc = (jint)MCHITTESTINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MCHITTESTINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MEASUREITEMSTRUCT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MEASUREITEMSTRUCT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MEASUREITEMSTRUCT_1sizeof_FUNC);
	rc = (jint)MEASUREITEMSTRUCT_sizeof();
	OS_NATIVE_EXIT(env, that, MEASUREITEMSTRUCT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MENUBARINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MENUBARINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MENUBARINFO_1sizeof_FUNC);
	rc = (jint)MENUBARINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MENUBARINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MENUINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MENUINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MENUINFO_1sizeof_FUNC);
	rc = (jint)MENUINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MENUINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MENUITEMINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MENUITEMINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MENUITEMINFO_1sizeof_FUNC);
	rc = (jint)MENUITEMINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MENUITEMINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MINMAXINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MINMAXINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MINMAXINFO_1sizeof_FUNC);
	rc = (jint)MINMAXINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MINMAXINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MONITORINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MONITORINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MONITORINFO_1sizeof_FUNC);
	rc = (jint)MONITORINFO_sizeof();
	OS_NATIVE_EXIT(env, that, MONITORINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MOUSEINPUT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MOUSEINPUT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MOUSEINPUT_1sizeof_FUNC);
	rc = (jint)MOUSEINPUT_sizeof();
	OS_NATIVE_EXIT(env, that, MOUSEINPUT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MSG_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(MSG_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MSG_1sizeof_FUNC);
	rc = (jint)MSG_sizeof();
	OS_NATIVE_EXIT(env, that, MSG_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_MapViewOfFile
JNIEXPORT jlong JNICALL OS_NATIVE(MapViewOfFile)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, MapViewOfFile_FUNC);
	rc = (jlong)MapViewOfFile((HANDLE)arg0, (DWORD)arg1, (DWORD)arg2, (DWORD)arg3, arg4);
	OS_NATIVE_EXIT(env, that, MapViewOfFile_FUNC);
	return rc;
}
#endif

#ifndef NO_MapVirtualKey
JNIEXPORT jint JNICALL OS_NATIVE(MapVirtualKey)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MapVirtualKey_FUNC);
	rc = (jint)MapVirtualKey(arg0, arg1);
	OS_NATIVE_EXIT(env, that, MapVirtualKey_FUNC);
	return rc;
}
#endif

#ifndef NO_MapWindowPoints__JJLorg_eclipse_swt_internal_win32_POINT_2I
JNIEXPORT jint JNICALL OS_NATIVE(MapWindowPoints__JJLorg_eclipse_swt_internal_win32_POINT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jint arg3)
{
	POINT _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MapWindowPoints__JJLorg_eclipse_swt_internal_win32_POINT_2I_FUNC);
	if (arg2) if ((lparg2 = getPOINTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)MapWindowPoints((HWND)arg0, (HWND)arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setPOINTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, MapWindowPoints__JJLorg_eclipse_swt_internal_win32_POINT_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_MapWindowPoints__JJLorg_eclipse_swt_internal_win32_RECT_2I
JNIEXPORT jint JNICALL OS_NATIVE(MapWindowPoints__JJLorg_eclipse_swt_internal_win32_RECT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jint arg3)
{
	RECT _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MapWindowPoints__JJLorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
	if (arg2) if ((lparg2 = getRECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)MapWindowPoints((HWND)arg0, (HWND)arg1, (LPPOINT)lparg2, arg3);
fail:
	if (arg2 && lparg2) setRECTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, MapWindowPoints__JJLorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_MessageBeep
JNIEXPORT jboolean JNICALL OS_NATIVE(MessageBeep)
	(JNIEnv *env, jclass that, jint arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, MessageBeep_FUNC);
	rc = (jboolean)MessageBeep(arg0);
	OS_NATIVE_EXIT(env, that, MessageBeep_FUNC);
	return rc;
}
#endif

#ifndef NO_MessageBox
JNIEXPORT jint JNICALL OS_NATIVE(MessageBox)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jcharArray arg2, jint arg3)
{
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MessageBox_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)MessageBox((HWND)arg0, (LPWSTR)lparg1, (LPWSTR)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MessageBox_FUNC);
	return rc;
}
#endif

#ifndef NO_ModifyWorldTransform
JNIEXPORT jboolean JNICALL OS_NATIVE(ModifyWorldTransform)
	(JNIEnv *env, jclass that, jlong arg0, jfloatArray arg1, jint arg2)
{
	jfloat *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ModifyWorldTransform_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetFloatArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)ModifyWorldTransform((HDC)arg0, (XFORM *)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseFloatArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, ModifyWorldTransform_FUNC);
	return rc;
}
#endif

#ifndef NO_MonitorFromWindow
JNIEXPORT jlong JNICALL OS_NATIVE(MonitorFromWindow)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, MonitorFromWindow_FUNC);
	rc = (jlong)MonitorFromWindow((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, MonitorFromWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_MoveMemory__JJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JJI)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	OS_NATIVE_ENTER(env, that, MoveMemory__JJI_FUNC);
	MoveMemory((PVOID)arg0, (CONST VOID *)arg1, arg2);
	OS_NATIVE_EXIT(env, that, MoveMemory__JJI_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_CIDA_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_CIDA_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	CIDA _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_CIDA_2I_FUNC);
	if (arg1) if ((lparg1 = getCIDAFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_CIDA_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_DEVMODE_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_DEVMODE_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	DEVMODE _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DEVMODE_2I_FUNC);
	if (arg1) if ((lparg1 = getDEVMODEFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DEVMODE_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	DOCHOSTUIINFO _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2I_FUNC);
	if (arg1) if ((lparg1 = getDOCHOSTUIINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_DROPFILES_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_DROPFILES_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	DROPFILES _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DROPFILES_2I_FUNC);
	if (arg1) if ((lparg1 = getDROPFILESFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_DROPFILES_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_GRADIENT_1RECT_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_GRADIENT_1RECT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	GRADIENT_RECT _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_GRADIENT_1RECT_2I_FUNC);
	if (arg1) if ((lparg1 = getGRADIENT_RECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_GRADIENT_1RECT_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_LOGFONT_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_LOGFONT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	LOGFONT _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_LOGFONT_2I_FUNC);
	if (arg1) if ((lparg1 = getLOGFONTFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_LOGFONT_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	MEASUREITEMSTRUCT _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2I_FUNC);
	if (arg1) if ((lparg1 = getMEASUREITEMSTRUCTFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_MINMAXINFO_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_MINMAXINFO_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	MINMAXINFO _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MINMAXINFO_2I_FUNC);
	if (arg1) if ((lparg1 = getMINMAXINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MINMAXINFO_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_MSG_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_MSG_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	MSG _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MSG_2I_FUNC);
	if (arg1) if ((lparg1 = getMSGFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_MSG_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMLVCUSTOMDRAW _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2I_FUNC);
	if (arg1) if ((lparg1 = getNMLVCUSTOMDRAWFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVDISPINFO_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVDISPINFO_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMLVDISPINFO _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVDISPINFO_2I_FUNC);
	if (arg1) if ((lparg1 = getNMLVDISPINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMLVDISPINFO_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMTBCUSTOMDRAW _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2I_FUNC);
	if (arg1) if ((lparg1 = getNMTBCUSTOMDRAWFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMTTDISPINFO_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMTTDISPINFO_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMTTDISPINFO _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTTDISPINFO_2I_FUNC);
	if (arg1) if ((lparg1 = getNMTTDISPINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTTDISPINFO_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMTVCUSTOMDRAW _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2I_FUNC);
	if (arg1) if ((lparg1 = getNMTVCUSTOMDRAWFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVDISPINFO_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVDISPINFO_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	NMTVDISPINFO _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVDISPINFO_2I_FUNC);
	if (arg1) if ((lparg1 = getNMTVDISPINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_NMTVDISPINFO_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_RECT_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_RECT_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	RECT _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_SAFEARRAY_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_SAFEARRAY_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	SAFEARRAY _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_SAFEARRAY_2I_FUNC);
	if (arg1) if ((lparg1 = getSAFEARRAYFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_SAFEARRAY_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	SHDRAGIMAGE _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2I_FUNC);
	if (arg1) if ((lparg1 = getSHDRAGIMAGEFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_TRIVERTEX_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_TRIVERTEX_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	TRIVERTEX _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_TRIVERTEX_2I_FUNC);
	if (arg1) if ((lparg1 = getTRIVERTEXFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_TRIVERTEX_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_UDACCEL_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_UDACCEL_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	UDACCEL _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_UDACCEL_2I_FUNC);
	if (arg1) if ((lparg1 = getUDACCELFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_UDACCEL_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__JLorg_eclipse_swt_internal_win32_WINDOWPOS_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__JLorg_eclipse_swt_internal_win32_WINDOWPOS_2I)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jint arg2)
{
	WINDOWPOS _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_WINDOWPOS_2I_FUNC);
	if (arg1) if ((lparg1 = getWINDOWPOSFields(env, arg1, &_arg1)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, MoveMemory__JLorg_eclipse_swt_internal_win32_WINDOWPOS_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3BI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3BI)
	(JNIEnv *env, jclass that, jlong arg0, jbyteArray arg1, jint arg2)
{
	jbyte *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3BI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3BI_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3CI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3CI)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2)
{
	jchar *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3CI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3CI_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3DI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3DI)
	(JNIEnv *env, jclass that, jlong arg0, jdoubleArray arg1, jint arg2)
{
	jdouble *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3DI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3DI_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3FI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3FI)
	(JNIEnv *env, jclass that, jlong arg0, jfloatArray arg1, jint arg2)
{
	jfloat *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3FI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3FI_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3II
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3II)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3II_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3II_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3JI)
	(JNIEnv *env, jclass that, jlong arg0, jlongArray arg1, jint arg2)
{
	jlong *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3JI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__J_3SI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__J_3SI)
	(JNIEnv *env, jclass that, jlong arg0, jshortArray arg1, jint arg2)
{
	jshort *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__J_3SI_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)arg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MoveMemory__J_3SI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	BITMAPINFOHEADER _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setBITMAPINFOHEADERFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2_3BI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2_3BI)
	(JNIEnv *env, jclass that, jobject arg0, jbyteArray arg1, jint arg2)
{
	BITMAPINFOHEADER _arg0, *lparg0=NULL;
	jbyte *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2_3BI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) setBITMAPINFOHEADERFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2_3BI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_CIDA_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_CIDA_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	CIDA _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_CIDA_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setCIDAFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_CIDA_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_DEVMODE_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_DEVMODE_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	DEVMODE _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DEVMODE_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setDEVMODEFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DEVMODE_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	DOCHOSTUIINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setDOCHOSTUIINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DOCHOSTUIINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_DRAWITEMSTRUCT_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_DRAWITEMSTRUCT_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	DRAWITEMSTRUCT _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DRAWITEMSTRUCT_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setDRAWITEMSTRUCTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_DRAWITEMSTRUCT_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_EMREXTCREATEFONTINDIRECTW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_EMREXTCREATEFONTINDIRECTW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	EMREXTCREATEFONTINDIRECTW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_EMREXTCREATEFONTINDIRECTW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setEMREXTCREATEFONTINDIRECTWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_EMREXTCREATEFONTINDIRECTW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_EMR_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_EMR_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	EMR _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_EMR_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setEMRFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_EMR_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1DATA_2_3JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1DATA_2_3JI)
	(JNIEnv *env, jclass that, jobject arg0, jlongArray arg1, jint arg2)
{
	FLICK_DATA _arg0, *lparg0=NULL;
	jlong *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1DATA_2_3JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) setFLICK_DATAFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1DATA_2_3JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1POINT_2_3JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1POINT_2_3JI)
	(JNIEnv *env, jclass that, jobject arg0, jlongArray arg1, jint arg2)
{
	FLICK_POINT _arg0, *lparg0=NULL;
	jlong *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1POINT_2_3JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) setFLICK_POINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_FLICK_1POINT_2_3JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_HDITEM_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_HDITEM_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	HDITEM _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_HDITEM_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setHDITEMFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_HDITEM_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_HELPINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_HELPINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	HELPINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_HELPINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setHELPINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_HELPINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_LOGFONT_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_LOGFONT_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	LOGFONT _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_LOGFONT_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setLOGFONTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_LOGFONT_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	MEASUREITEMSTRUCT _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setMEASUREITEMSTRUCTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MEASUREITEMSTRUCT_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_MINMAXINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_MINMAXINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	MINMAXINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MINMAXINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setMINMAXINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MINMAXINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_MSG_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_MSG_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	MSG _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MSG_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setMSGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_MSG_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMCUSTOMDRAW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMCUSTOMDRAW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMCUSTOMDRAW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMCUSTOMDRAW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMCUSTOMDRAWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMCUSTOMDRAW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMHDR_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMHDR_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMHDR _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMHDR_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMHDRFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMHDR_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMHEADER_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMHEADER_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMHEADER _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMHEADER_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMHEADERFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMHEADER_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMLINK_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMLINK_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMLINK _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLINK_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMLINKFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLINK_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMLISTVIEW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMLISTVIEW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMLISTVIEW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLISTVIEW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMLISTVIEWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLISTVIEW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMLVCUSTOMDRAW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMLVCUSTOMDRAWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVCUSTOMDRAW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVDISPINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVDISPINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMLVDISPINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVDISPINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMLVDISPINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVDISPINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVODSTATECHANGE_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVODSTATECHANGE_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMLVODSTATECHANGE _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVODSTATECHANGE_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMLVODSTATECHANGEFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMLVODSTATECHANGE_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHEVRON_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHEVRON_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMREBARCHEVRON _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHEVRON_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMREBARCHEVRONFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHEVRON_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHILDSIZE_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHILDSIZE_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMREBARCHILDSIZE _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHILDSIZE_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMREBARCHILDSIZEFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMREBARCHILDSIZE_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTBCUSTOMDRAW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTBCUSTOMDRAWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBCUSTOMDRAW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBHOTITEM_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBHOTITEM_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTBHOTITEM _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBHOTITEM_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTBHOTITEMFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTBHOTITEM_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTOOLBAR_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTOOLBAR_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTOOLBAR _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTOOLBAR_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTOOLBARFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTOOLBAR_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTREEVIEW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTREEVIEW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTREEVIEW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTREEVIEW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTREEVIEWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTREEVIEW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTCUSTOMDRAW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTCUSTOMDRAW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTTCUSTOMDRAW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTCUSTOMDRAW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTTCUSTOMDRAWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTCUSTOMDRAW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTDISPINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTDISPINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTTDISPINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTDISPINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTTDISPINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTTDISPINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTVCUSTOMDRAW _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTVCUSTOMDRAWFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVCUSTOMDRAW_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVDISPINFO_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVDISPINFO_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTVDISPINFO _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVDISPINFO_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTVDISPINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVDISPINFO_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVITEMCHANGE_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVITEMCHANGE_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMTVITEMCHANGE _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVITEMCHANGE_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMTVITEMCHANGEFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMTVITEMCHANGE_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_NMUPDOWN_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_NMUPDOWN_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	NMUPDOWN _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMUPDOWN_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setNMUPDOWNFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_NMUPDOWN_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	POINT _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setPOINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2_3JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2_3JI)
	(JNIEnv *env, jclass that, jobject arg0, jlongArray arg1, jint arg2)
{
	POINT _arg0, *lparg0=NULL;
	jlong *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2_3JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	if (arg0 && lparg0) setPOINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_POINT_2_3JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_SAFEARRAY_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_SAFEARRAY_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	SAFEARRAY _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SAFEARRAY_2JI_FUNC);
	if (arg0) if ((lparg0 = getSAFEARRAYFields(env, arg0, &_arg0)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setSAFEARRAYFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SAFEARRAY_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1ITEM_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1ITEM_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	SCRIPT_ITEM _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1ITEM_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setSCRIPT_ITEMFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1ITEM_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1LOGATTR_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1LOGATTR_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	SCRIPT_LOGATTR _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1LOGATTR_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setSCRIPT_LOGATTRFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1LOGATTR_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1PROPERTIES_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1PROPERTIES_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	SCRIPT_PROPERTIES _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1PROPERTIES_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setSCRIPT_PROPERTIESFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_SCRIPT_1PROPERTIES_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_TEXTMETRIC_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_TEXTMETRIC_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	TEXTMETRIC _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_TEXTMETRIC_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setTEXTMETRICFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_TEXTMETRIC_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_TOUCHINPUT_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_TOUCHINPUT_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	TOUCHINPUT _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_TOUCHINPUT_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setTOUCHINPUTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_TOUCHINPUT_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_UDACCEL_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_UDACCEL_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	UDACCEL _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_UDACCEL_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setUDACCELFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_UDACCEL_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory__Lorg_eclipse_swt_internal_win32_WINDOWPOS_2JI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory__Lorg_eclipse_swt_internal_win32_WINDOWPOS_2JI)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2)
{
	WINDOWPOS _arg0, *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_WINDOWPOS_2JI_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
	if (arg0 && lparg0) setWINDOWPOSFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, MoveMemory__Lorg_eclipse_swt_internal_win32_WINDOWPOS_2JI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3BJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3BJI)
	(JNIEnv *env, jclass that, jbyteArray arg0, jlong arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3BJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3BJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3BLorg_eclipse_swt_internal_win32_ACCEL_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3BLorg_eclipse_swt_internal_win32_ACCEL_2I)
	(JNIEnv *env, jclass that, jbyteArray arg0, jobject arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	ACCEL _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3BLorg_eclipse_swt_internal_win32_ACCEL_2I_FUNC);
	if (arg1) if ((lparg1 = getACCELFields(env, arg1, &_arg1)) == NULL) goto fail;
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3BLorg_eclipse_swt_internal_win32_ACCEL_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory___3BLorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2I
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3BLorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2I)
	(JNIEnv *env, jclass that, jbyteArray arg0, jobject arg1, jint arg2)
{
	jbyte *lparg0=NULL;
	BITMAPINFOHEADER _arg1, *lparg1=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3BLorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2I_FUNC);
	if (arg1) if ((lparg1 = getBITMAPINFOHEADERFields(env, arg1, &_arg1)) == NULL) goto fail;
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)lparg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3BLorg_eclipse_swt_internal_win32_BITMAPINFOHEADER_2I_FUNC);
}
#endif

#ifndef NO_MoveMemory___3CJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3CJI)
	(JNIEnv *env, jclass that, jcharArray arg0, jlong arg1, jint arg2)
{
	jchar *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3CJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3CJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3DJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3DJI)
	(JNIEnv *env, jclass that, jdoubleArray arg0, jlong arg1, jint arg2)
{
	jdouble *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3DJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3DJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3FJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3FJI)
	(JNIEnv *env, jclass that, jfloatArray arg0, jlong arg1, jint arg2)
{
	jfloat *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3FJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3FJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3IJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3IJI)
	(JNIEnv *env, jclass that, jintArray arg0, jlong arg1, jint arg2)
{
	jint *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3IJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3IJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3JJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3JJI)
	(JNIEnv *env, jclass that, jlongArray arg0, jlong arg1, jint arg2)
{
	jlong *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3JJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3JJI_FUNC);
}
#endif

#ifndef NO_MoveMemory___3SJI
JNIEXPORT void JNICALL OS_NATIVE(MoveMemory___3SJI)
	(JNIEnv *env, jclass that, jshortArray arg0, jlong arg1, jint arg2)
{
	jshort *lparg0=NULL;
	OS_NATIVE_ENTER(env, that, MoveMemory___3SJI_FUNC);
		if (arg0) if ((lparg0 = (*env)->GetPrimitiveArrayCritical(env, arg0, NULL)) == NULL) goto fail;
	MoveMemory((PVOID)lparg0, (CONST VOID *)arg1, arg2);
fail:
		if (arg0 && lparg0) (*env)->ReleasePrimitiveArrayCritical(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, MoveMemory___3SJI_FUNC);
}
#endif

#ifndef NO_MoveToEx
JNIEXPORT jboolean JNICALL OS_NATIVE(MoveToEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jlong arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, MoveToEx_FUNC);
	rc = (jboolean)MoveToEx((HDC)arg0, arg1, arg2, (LPPOINT)arg3);
	OS_NATIVE_EXIT(env, that, MoveToEx_FUNC);
	return rc;
}
#endif

#ifndef NO_MultiByteToWideChar__IIJI_3CI
JNIEXPORT jint JNICALL OS_NATIVE(MultiByteToWideChar__IIJI_3CI)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jlong arg2, jint arg3, jcharArray arg4, jint arg5)
{
	jchar *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MultiByteToWideChar__IIJI_3CI_FUNC);
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)MultiByteToWideChar(arg0, arg1, (LPCSTR)arg2, arg3, (LPWSTR)lparg4, arg5);
fail:
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
	OS_NATIVE_EXIT(env, that, MultiByteToWideChar__IIJI_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_MultiByteToWideChar__II_3BI_3CI
JNIEXPORT jint JNICALL OS_NATIVE(MultiByteToWideChar__II_3BI_3CI)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jbyteArray arg2, jint arg3, jcharArray arg4, jint arg5)
{
	jbyte *lparg2=NULL;
	jchar *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, MultiByteToWideChar__II_3BI_3CI_FUNC);
		if (arg2) if ((lparg2 = (*env)->GetPrimitiveArrayCritical(env, arg2, NULL)) == NULL) goto fail;
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)MultiByteToWideChar(arg0, arg1, (LPCSTR)lparg2, arg3, (LPWSTR)lparg4, arg5);
fail:
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
		if (arg2 && lparg2) (*env)->ReleasePrimitiveArrayCritical(env, arg2, lparg2, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, MultiByteToWideChar__II_3BI_3CI_FUNC);
	return rc;
}
#endif

#ifndef NO_NMCUSTOMDRAW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMCUSTOMDRAW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMCUSTOMDRAW_1sizeof_FUNC);
	rc = (jint)NMCUSTOMDRAW_sizeof();
	OS_NATIVE_EXIT(env, that, NMCUSTOMDRAW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMHDR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMHDR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMHDR_1sizeof_FUNC);
	rc = (jint)NMHDR_sizeof();
	OS_NATIVE_EXIT(env, that, NMHDR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMHEADER_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMHEADER_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMHEADER_1sizeof_FUNC);
	rc = (jint)NMHEADER_sizeof();
	OS_NATIVE_EXIT(env, that, NMHEADER_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLINK_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLINK_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLINK_1sizeof_FUNC);
	rc = (jint)NMLINK_sizeof();
	OS_NATIVE_EXIT(env, that, NMLINK_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLISTVIEW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLISTVIEW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLISTVIEW_1sizeof_FUNC);
	rc = (jint)NMLISTVIEW_sizeof();
	OS_NATIVE_EXIT(env, that, NMLISTVIEW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLVCUSTOMDRAW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLVCUSTOMDRAW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLVCUSTOMDRAW_1sizeof_FUNC);
	rc = (jint)NMLVCUSTOMDRAW_sizeof();
	OS_NATIVE_EXIT(env, that, NMLVCUSTOMDRAW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLVDISPINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLVDISPINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLVDISPINFO_1sizeof_FUNC);
	rc = (jint)NMLVDISPINFO_sizeof();
	OS_NATIVE_EXIT(env, that, NMLVDISPINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLVFINDITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLVFINDITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLVFINDITEM_1sizeof_FUNC);
	rc = (jint)NMLVFINDITEM_sizeof();
	OS_NATIVE_EXIT(env, that, NMLVFINDITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMLVODSTATECHANGE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMLVODSTATECHANGE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMLVODSTATECHANGE_1sizeof_FUNC);
	rc = (jint)NMLVODSTATECHANGE_sizeof();
	OS_NATIVE_EXIT(env, that, NMLVODSTATECHANGE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMREBARCHEVRON_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMREBARCHEVRON_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMREBARCHEVRON_1sizeof_FUNC);
	rc = (jint)NMREBARCHEVRON_sizeof();
	OS_NATIVE_EXIT(env, that, NMREBARCHEVRON_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMREBARCHILDSIZE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMREBARCHILDSIZE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMREBARCHILDSIZE_1sizeof_FUNC);
	rc = (jint)NMREBARCHILDSIZE_sizeof();
	OS_NATIVE_EXIT(env, that, NMREBARCHILDSIZE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTBCUSTOMDRAW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTBCUSTOMDRAW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTBCUSTOMDRAW_1sizeof_FUNC);
	rc = (jint)NMTBCUSTOMDRAW_sizeof();
	OS_NATIVE_EXIT(env, that, NMTBCUSTOMDRAW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTBHOTITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTBHOTITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTBHOTITEM_1sizeof_FUNC);
	rc = (jint)NMTBHOTITEM_sizeof();
	OS_NATIVE_EXIT(env, that, NMTBHOTITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTOOLBAR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTOOLBAR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTOOLBAR_1sizeof_FUNC);
	rc = (jint)NMTOOLBAR_sizeof();
	OS_NATIVE_EXIT(env, that, NMTOOLBAR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTREEVIEW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTREEVIEW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTREEVIEW_1sizeof_FUNC);
	rc = (jint)NMTREEVIEW_sizeof();
	OS_NATIVE_EXIT(env, that, NMTREEVIEW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTTCUSTOMDRAW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTTCUSTOMDRAW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTTCUSTOMDRAW_1sizeof_FUNC);
	rc = (jint)NMTTCUSTOMDRAW_sizeof();
	OS_NATIVE_EXIT(env, that, NMTTCUSTOMDRAW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTTDISPINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTTDISPINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTTDISPINFO_1sizeof_FUNC);
	rc = (jint)NMTTDISPINFO_sizeof();
	OS_NATIVE_EXIT(env, that, NMTTDISPINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTVCUSTOMDRAW_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTVCUSTOMDRAW_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTVCUSTOMDRAW_1sizeof_FUNC);
	rc = (jint)NMTVCUSTOMDRAW_sizeof();
	OS_NATIVE_EXIT(env, that, NMTVCUSTOMDRAW_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTVDISPINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTVDISPINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTVDISPINFO_1sizeof_FUNC);
	rc = (jint)NMTVDISPINFO_sizeof();
	OS_NATIVE_EXIT(env, that, NMTVDISPINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMTVITEMCHANGE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMTVITEMCHANGE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMTVITEMCHANGE_1sizeof_FUNC);
	rc = (jint)NMTVITEMCHANGE_sizeof();
	OS_NATIVE_EXIT(env, that, NMTVITEMCHANGE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NMUPDOWN_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NMUPDOWN_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NMUPDOWN_1sizeof_FUNC);
	rc = (jint)NMUPDOWN_sizeof();
	OS_NATIVE_EXIT(env, that, NMUPDOWN_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NONCLIENTMETRICS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(NONCLIENTMETRICS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NONCLIENTMETRICS_1sizeof_FUNC);
	rc = (jint)NONCLIENTMETRICS_sizeof();
	OS_NATIVE_EXIT(env, that, NONCLIENTMETRICS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_NOTIFYICONDATA_1V2_1SIZE
JNIEXPORT jint JNICALL OS_NATIVE(NOTIFYICONDATA_1V2_1SIZE)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, NOTIFYICONDATA_1V2_1SIZE_FUNC);
	rc = (jint)NOTIFYICONDATA_V2_SIZE;
	OS_NATIVE_EXIT(env, that, NOTIFYICONDATA_1V2_1SIZE_FUNC);
	return rc;
}
#endif

#ifndef NO_NotifyWinEvent
JNIEXPORT void JNICALL OS_NATIVE(NotifyWinEvent)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jint arg2, jint arg3)
{
	OS_NATIVE_ENTER(env, that, NotifyWinEvent_FUNC);
	NotifyWinEvent((DWORD)arg0, (HWND)arg1, (LONG)arg2, (LONG)arg3);
	OS_NATIVE_EXIT(env, that, NotifyWinEvent_FUNC);
}
#endif

#ifndef NO_OSVERSIONINFOEX_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(OSVERSIONINFOEX_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, OSVERSIONINFOEX_1sizeof_FUNC);
	rc = (jint)OSVERSIONINFOEX_sizeof();
	OS_NATIVE_EXIT(env, that, OSVERSIONINFOEX_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_OUTLINETEXTMETRIC_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(OUTLINETEXTMETRIC_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, OUTLINETEXTMETRIC_1sizeof_FUNC);
	rc = (jint)OUTLINETEXTMETRIC_sizeof();
	OS_NATIVE_EXIT(env, that, OUTLINETEXTMETRIC_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_OffsetRect
JNIEXPORT jboolean JNICALL OS_NATIVE(OffsetRect)
	(JNIEnv *env, jclass that, jobject arg0, jint arg1, jint arg2)
{
	RECT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, OffsetRect_FUNC);
	if (arg0) if ((lparg0 = getRECTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)OffsetRect(lparg0, arg1, arg2);
fail:
	if (arg0 && lparg0) setRECTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, OffsetRect_FUNC);
	return rc;
}
#endif

#ifndef NO_OffsetRgn
JNIEXPORT jint JNICALL OS_NATIVE(OffsetRgn)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, OffsetRgn_FUNC);
	rc = (jint)OffsetRgn((HRGN)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, OffsetRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_OleInitialize
JNIEXPORT jint JNICALL OS_NATIVE(OleInitialize)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, OleInitialize_FUNC);
	rc = (jint)OleInitialize((LPVOID)arg0);
	OS_NATIVE_EXIT(env, that, OleInitialize_FUNC);
	return rc;
}
#endif

#ifndef NO_OleUninitialize
JNIEXPORT void JNICALL OS_NATIVE(OleUninitialize)
	(JNIEnv *env, jclass that)
{
	OS_NATIVE_ENTER(env, that, OleUninitialize_FUNC);
	OleUninitialize();
	OS_NATIVE_EXIT(env, that, OleUninitialize_FUNC);
}
#endif

#ifndef NO_OpenClipboard
JNIEXPORT jboolean JNICALL OS_NATIVE(OpenClipboard)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, OpenClipboard_FUNC);
	rc = (jboolean)OpenClipboard((HWND)arg0);
	OS_NATIVE_EXIT(env, that, OpenClipboard_FUNC);
	return rc;
}
#endif

#ifndef NO_OpenPrinter
JNIEXPORT jboolean JNICALL OS_NATIVE(OpenPrinter)
	(JNIEnv *env, jclass that, jcharArray arg0, jlongArray arg1, jlong arg2)
{
	jchar *lparg0=NULL;
	jlong *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, OpenPrinter_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetLongArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)OpenPrinter((LPWSTR)lparg0, (LPHANDLE)lparg1, (LPPRINTER_DEFAULTSW)arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseLongArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, OpenPrinter_FUNC);
	return rc;
}
#endif

#ifndef NO_OpenProcess
JNIEXPORT jlong JNICALL OS_NATIVE(OpenProcess)
	(JNIEnv *env, jclass that, jint arg0, jboolean arg1, jint arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, OpenProcess_FUNC);
	rc = (jlong)OpenProcess((DWORD)arg0, arg1, (DWORD)arg2);
	OS_NATIVE_EXIT(env, that, OpenProcess_FUNC);
	return rc;
}
#endif

#ifndef NO_OpenThemeData
JNIEXPORT jlong JNICALL OS_NATIVE(OpenThemeData)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1)
{
	jchar *lparg1=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, OpenThemeData_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jlong)OpenThemeData((HWND)arg0, (LPCWSTR)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, OpenThemeData_FUNC);
	return rc;
}
#endif

#ifndef NO_PAINTSTRUCT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(PAINTSTRUCT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PAINTSTRUCT_1sizeof_FUNC);
	rc = (jint)PAINTSTRUCT_sizeof();
	OS_NATIVE_EXIT(env, that, PAINTSTRUCT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_POINT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(POINT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, POINT_1sizeof_FUNC);
	rc = (jint)POINT_sizeof();
	OS_NATIVE_EXIT(env, that, POINT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_PRINTDLG_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(PRINTDLG_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PRINTDLG_1sizeof_FUNC);
	rc = (jint)PRINTDLG_sizeof();
	OS_NATIVE_EXIT(env, that, PRINTDLG_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_PROCESS_1INFORMATION_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(PROCESS_1INFORMATION_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PROCESS_1INFORMATION_1sizeof_FUNC);
	rc = (jint)PROCESS_INFORMATION_sizeof();
	OS_NATIVE_EXIT(env, that, PROCESS_1INFORMATION_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_PROPERTYKEY_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(PROPERTYKEY_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PROPERTYKEY_1sizeof_FUNC);
	rc = (jint)PROPERTYKEY_sizeof();
	OS_NATIVE_EXIT(env, that, PROPERTYKEY_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_PROPVARIANT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(PROPVARIANT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PROPVARIANT_1sizeof_FUNC);
	rc = (jint)PROPVARIANT_sizeof();
	OS_NATIVE_EXIT(env, that, PROPVARIANT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_PSPropertyKeyFromString
JNIEXPORT jint JNICALL OS_NATIVE(PSPropertyKeyFromString)
	(JNIEnv *env, jclass that, jcharArray arg0, jobject arg1)
{
	jchar *lparg0=NULL;
	PROPERTYKEY _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, PSPropertyKeyFromString_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = &_arg1) == NULL) goto fail;
	rc = (jint)PSPropertyKeyFromString((LPCWSTR)lparg0, lparg1);
fail:
	if (arg1 && lparg1) setPROPERTYKEYFields(env, arg1, lparg1);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, PSPropertyKeyFromString_FUNC);
	return rc;
}
#endif

#ifndef NO_PatBlt
JNIEXPORT jboolean JNICALL OS_NATIVE(PatBlt)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PatBlt_FUNC);
	rc = (jboolean)PatBlt((HDC)arg0, arg1, arg2, arg3, arg4, arg5);
	OS_NATIVE_EXIT(env, that, PatBlt_FUNC);
	return rc;
}
#endif

#ifndef NO_PathIsExe
JNIEXPORT jboolean JNICALL OS_NATIVE(PathIsExe)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PathIsExe_FUNC);
	rc = (jboolean)PathIsExe((LPCWSTR)arg0);
	OS_NATIVE_EXIT(env, that, PathIsExe_FUNC);
	return rc;
}
#endif

#ifndef NO_PeekMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(PeekMessage)
	(JNIEnv *env, jclass that, jobject arg0, jlong arg1, jint arg2, jint arg3, jint arg4)
{
	MSG _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PeekMessage_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	rc = (jboolean)PeekMessage(lparg0, (HWND)arg1, arg2, arg3, arg4);
fail:
	if (arg0 && lparg0) setMSGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, PeekMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_Pie
JNIEXPORT jboolean JNICALL OS_NATIVE(Pie)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jint arg7, jint arg8)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Pie_FUNC);
	rc = (jboolean)Pie((HDC)arg0, arg1, arg2, arg3, arg4, arg5, arg6, arg7, arg8);
	OS_NATIVE_EXIT(env, that, Pie_FUNC);
	return rc;
}
#endif

#ifndef NO_Polygon
JNIEXPORT jboolean JNICALL OS_NATIVE(Polygon)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Polygon_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)Polygon((HDC)arg0, (CONST POINT *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, Polygon_FUNC);
	return rc;
}
#endif

#ifndef NO_Polyline
JNIEXPORT jboolean JNICALL OS_NATIVE(Polyline)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Polyline_FUNC);
		if (arg1) if ((lparg1 = (*env)->GetPrimitiveArrayCritical(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)Polyline((HDC)arg0, (CONST POINT *)lparg1, arg2);
fail:
		if (arg1 && lparg1) (*env)->ReleasePrimitiveArrayCritical(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, Polyline_FUNC);
	return rc;
}
#endif

#ifndef NO_PostMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(PostMessage)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PostMessage_FUNC);
	rc = (jboolean)PostMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, PostMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_PostThreadMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(PostThreadMessage)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jlong arg2, jlong arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PostThreadMessage_FUNC);
	rc = (jboolean)PostThreadMessage(arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, PostThreadMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_PrintDlg
JNIEXPORT jboolean JNICALL OS_NATIVE(PrintDlg)
	(JNIEnv *env, jclass that, jobject arg0)
{
	PRINTDLG _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PrintDlg_FUNC);
	if (arg0) if ((lparg0 = getPRINTDLGFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)PrintDlg(lparg0);
fail:
	if (arg0 && lparg0) setPRINTDLGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, PrintDlg_FUNC);
	return rc;
}
#endif

#ifndef NO_PrintWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(PrintWindow)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PrintWindow_FUNC);
	rc = (jboolean)PrintWindow((HWND)arg0, (HDC)arg1, arg2);
	OS_NATIVE_EXIT(env, that, PrintWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_PtInRect
JNIEXPORT jboolean JNICALL OS_NATIVE(PtInRect)
	(JNIEnv *env, jclass that, jobject arg0, jobject arg1)
{
	RECT _arg0, *lparg0=NULL;
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PtInRect_FUNC);
	if (arg0) if ((lparg0 = getRECTFields(env, arg0, &_arg0)) == NULL) goto fail;
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)PtInRect(lparg0, *lparg1);
fail:
	OS_NATIVE_EXIT(env, that, PtInRect_FUNC);
	return rc;
}
#endif

#ifndef NO_PtInRegion
JNIEXPORT jboolean JNICALL OS_NATIVE(PtInRegion)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, PtInRegion_FUNC);
	rc = (jboolean)PtInRegion((HRGN)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, PtInRegion_FUNC);
	return rc;
}
#endif

#ifndef NO_REBARBANDINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(REBARBANDINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, REBARBANDINFO_1sizeof_FUNC);
	rc = (jint)REBARBANDINFO_sizeof();
	OS_NATIVE_EXIT(env, that, REBARBANDINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_RECT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(RECT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RECT_1sizeof_FUNC);
	rc = (jint)RECT_sizeof();
	OS_NATIVE_EXIT(env, that, RECT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_RectInRegion
JNIEXPORT jboolean JNICALL OS_NATIVE(RectInRegion)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RectInRegion_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)RectInRegion((HRGN)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, RectInRegion_FUNC);
	return rc;
}
#endif

#ifndef NO_Rectangle
JNIEXPORT jboolean JNICALL OS_NATIVE(Rectangle)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Rectangle_FUNC);
	rc = (jboolean)Rectangle((HDC)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, Rectangle_FUNC);
	return rc;
}
#endif

#ifndef NO_RedrawWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(RedrawWindow)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jlong arg2, jint arg3)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RedrawWindow_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)RedrawWindow((HWND)arg0, lparg1, (HRGN)arg2, arg3);
fail:
	OS_NATIVE_EXIT(env, that, RedrawWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_RegCloseKey
JNIEXPORT jint JNICALL OS_NATIVE(RegCloseKey)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegCloseKey_FUNC);
	rc = (jint)RegCloseKey((HKEY)arg0);
	OS_NATIVE_EXIT(env, that, RegCloseKey_FUNC);
	return rc;
}
#endif

#ifndef NO_RegCreateKeyEx
JNIEXPORT jint JNICALL OS_NATIVE(RegCreateKeyEx)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jcharArray arg3, jint arg4, jint arg5, jlong arg6, jlongArray arg7, jlongArray arg8)
{
	jchar *lparg1=NULL;
	jchar *lparg3=NULL;
	jlong *lparg7=NULL;
	jlong *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegCreateKeyEx_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetLongArrayElements(env, arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = (*env)->GetLongArrayElements(env, arg8, NULL)) == NULL) goto fail;
	rc = (jint)RegCreateKeyEx((HKEY)arg0, (LPCWSTR)lparg1, arg2, (LPWSTR)lparg3, arg4, arg5, (LPSECURITY_ATTRIBUTES)arg6, (PHKEY)lparg7, (LPDWORD)lparg8);
fail:
	if (arg8 && lparg8) (*env)->ReleaseLongArrayElements(env, arg8, lparg8, 0);
	if (arg7 && lparg7) (*env)->ReleaseLongArrayElements(env, arg7, lparg7, 0);
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegCreateKeyEx_FUNC);
	return rc;
}
#endif

#ifndef NO_RegDeleteValue
JNIEXPORT jint JNICALL OS_NATIVE(RegDeleteValue)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1)
{
	jchar *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegDeleteValue_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)RegDeleteValue((HKEY)arg0, (LPCWSTR)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegDeleteValue_FUNC);
	return rc;
}
#endif

#ifndef NO_RegEnumKeyEx
JNIEXPORT jint JNICALL OS_NATIVE(RegEnumKeyEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jcharArray arg2, jintArray arg3, jintArray arg4, jcharArray arg5, jintArray arg6, jlong arg7)
{
	jchar *lparg2=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jchar *lparg5=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegEnumKeyEx_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetCharArrayElements(env, arg5, NULL)) == NULL) goto fail;
	if (arg6) if ((lparg6 = (*env)->GetIntArrayElements(env, arg6, NULL)) == NULL) goto fail;
	rc = (jint)RegEnumKeyEx((HKEY)arg0, arg1, (LPWSTR)lparg2, (LPDWORD)lparg3, (LPDWORD)lparg4, (LPWSTR)lparg5, (LPDWORD)lparg6, (PFILETIME)arg7);
fail:
	if (arg6 && lparg6) (*env)->ReleaseIntArrayElements(env, arg6, lparg6, 0);
	if (arg5 && lparg5) (*env)->ReleaseCharArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, RegEnumKeyEx_FUNC);
	return rc;
}
#endif

#ifndef NO_RegOpenKeyEx
JNIEXPORT jint JNICALL OS_NATIVE(RegOpenKeyEx)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jint arg3, jlongArray arg4)
{
	jchar *lparg1=NULL;
	jlong *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegOpenKeyEx_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetLongArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)RegOpenKeyEx((HKEY)arg0, (LPCWSTR)lparg1, arg2, arg3, (PHKEY)lparg4);
fail:
	if (arg4 && lparg4) (*env)->ReleaseLongArrayElements(env, arg4, lparg4, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegOpenKeyEx_FUNC);
	return rc;
}
#endif

#ifndef NO_RegQueryValueEx__J_3CJ_3I_3C_3I
JNIEXPORT jint JNICALL OS_NATIVE(RegQueryValueEx__J_3CJ_3I_3C_3I)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jlong arg2, jintArray arg3, jcharArray arg4, jintArray arg5)
{
	jchar *lparg1=NULL;
	jint *lparg3=NULL;
	jchar *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegQueryValueEx__J_3CJ_3I_3C_3I_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetCharArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	rc = (jint)RegQueryValueEx((HKEY)arg0, (LPCWSTR)lparg1, (LPDWORD)arg2, (LPDWORD)lparg3, (LPBYTE)lparg4, (LPDWORD)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseCharArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegQueryValueEx__J_3CJ_3I_3C_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_RegQueryValueEx__J_3CJ_3I_3I_3I
JNIEXPORT jint JNICALL OS_NATIVE(RegQueryValueEx__J_3CJ_3I_3I_3I)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jlong arg2, jintArray arg3, jintArray arg4, jintArray arg5)
{
	jchar *lparg1=NULL;
	jint *lparg3=NULL;
	jint *lparg4=NULL;
	jint *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegQueryValueEx__J_3CJ_3I_3I_3I_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetIntArrayElements(env, arg5, NULL)) == NULL) goto fail;
	rc = (jint)RegQueryValueEx((HKEY)arg0, (LPCWSTR)lparg1, (LPDWORD)arg2, (LPDWORD)lparg3, (LPBYTE)lparg4, (LPDWORD)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseIntArrayElements(env, arg5, lparg5, 0);
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegQueryValueEx__J_3CJ_3I_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_RegSetValueEx
JNIEXPORT jint JNICALL OS_NATIVE(RegSetValueEx)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jint arg2, jint arg3, jintArray arg4, jint arg5)
{
	jchar *lparg1=NULL;
	jint *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegSetValueEx_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg4) if ((lparg4 = (*env)->GetIntArrayElements(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)RegSetValueEx((HKEY)arg0, (LPCWSTR)lparg1, arg2, arg3, (const BYTE*)lparg4, arg5);
fail:
	if (arg4 && lparg4) (*env)->ReleaseIntArrayElements(env, arg4, lparg4, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegSetValueEx_FUNC);
	return rc;
}
#endif

#ifndef NO_RegisterClass
JNIEXPORT jint JNICALL OS_NATIVE(RegisterClass)
	(JNIEnv *env, jclass that, jobject arg0)
{
	WNDCLASS _arg0, *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegisterClass_FUNC);
	if (arg0) if ((lparg0 = getWNDCLASSFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jint)RegisterClass(lparg0);
fail:
	OS_NATIVE_EXIT(env, that, RegisterClass_FUNC);
	return rc;
}
#endif

#ifndef NO_RegisterClipboardFormat
JNIEXPORT jint JNICALL OS_NATIVE(RegisterClipboardFormat)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegisterClipboardFormat_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)RegisterClipboardFormat((LPCWSTR)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegisterClipboardFormat_FUNC);
	return rc;
}
#endif

#ifndef NO_RegisterTouchWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(RegisterTouchWindow)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RegisterTouchWindow_FUNC);
	rc = (jboolean)RegisterTouchWindow((HWND)arg0, (ULONG)arg1);
	OS_NATIVE_EXIT(env, that, RegisterTouchWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_RegisterWindowMessage
JNIEXPORT jint JNICALL OS_NATIVE(RegisterWindowMessage)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RegisterWindowMessage_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)RegisterWindowMessage((LPCWSTR)lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, RegisterWindowMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_ReleaseCapture
JNIEXPORT jboolean JNICALL OS_NATIVE(ReleaseCapture)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ReleaseCapture_FUNC);
	rc = (jboolean)ReleaseCapture();
	OS_NATIVE_EXIT(env, that, ReleaseCapture_FUNC);
	return rc;
}
#endif

#ifndef NO_ReleaseDC
JNIEXPORT jint JNICALL OS_NATIVE(ReleaseDC)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ReleaseDC_FUNC);
	rc = (jint)ReleaseDC((HWND)arg0, (HDC)arg1);
	OS_NATIVE_EXIT(env, that, ReleaseDC_FUNC);
	return rc;
}
#endif

#ifndef NO_RemoveMenu
JNIEXPORT jboolean JNICALL OS_NATIVE(RemoveMenu)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RemoveMenu_FUNC);
	rc = (jboolean)RemoveMenu((HMENU)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, RemoveMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_RemoveProp
JNIEXPORT jlong JNICALL OS_NATIVE(RemoveProp)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, RemoveProp_FUNC);
	rc = (jlong)RemoveProp((HWND)arg0, (LPCWSTR)arg1);
	OS_NATIVE_EXIT(env, that, RemoveProp_FUNC);
	return rc;
}
#endif

#ifndef NO_ReplyMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(ReplyMessage)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ReplyMessage_FUNC);
	rc = (jboolean)ReplyMessage(arg0);
	OS_NATIVE_EXIT(env, that, ReplyMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_RestoreDC
JNIEXPORT jboolean JNICALL OS_NATIVE(RestoreDC)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RestoreDC_FUNC);
	rc = (jboolean)RestoreDC((HDC)arg0, (int)arg1);
	OS_NATIVE_EXIT(env, that, RestoreDC_FUNC);
	return rc;
}
#endif

#ifndef NO_RoundRect
JNIEXPORT jboolean JNICALL OS_NATIVE(RoundRect)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, RoundRect_FUNC);
	rc = (jboolean)RoundRect((HDC)arg0, arg1, arg2, arg3, arg4, arg5, arg6);
	OS_NATIVE_EXIT(env, that, RoundRect_FUNC);
	return rc;
}
#endif

#ifndef NO_RtlGetVersion
JNIEXPORT jint JNICALL OS_NATIVE(RtlGetVersion)
	(JNIEnv *env, jclass that, jobject arg0)
{
	OSVERSIONINFOEX _arg0, *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, RtlGetVersion_FUNC);
	if (arg0) if ((lparg0 = getOSVERSIONINFOEXFields(env, arg0, &_arg0)) == NULL) goto fail;
/*
	rc = (jint)RtlGetVersion(lparg0);
*/
	{
		OS_LOAD_FUNCTION(fp, RtlGetVersion)
		if (fp) {
			rc = (jint)((jint (CALLING_CONVENTION*)(OSVERSIONINFOEX *))fp)(lparg0);
		}
	}
fail:
	if (arg0 && lparg0) setOSVERSIONINFOEXFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, RtlGetVersion_FUNC);
	return rc;
}
#endif

#ifndef NO_SAFEARRAYBOUND_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SAFEARRAYBOUND_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SAFEARRAYBOUND_1sizeof_FUNC);
	rc = (jint)SAFEARRAYBOUND_sizeof();
	OS_NATIVE_EXIT(env, that, SAFEARRAYBOUND_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SAFEARRAY_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SAFEARRAY_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SAFEARRAY_1sizeof_FUNC);
	rc = (jint)SAFEARRAY_sizeof();
	OS_NATIVE_EXIT(env, that, SAFEARRAY_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1ANALYSIS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1ANALYSIS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1ANALYSIS_1sizeof_FUNC);
	rc = (jint)SCRIPT_ANALYSIS_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1ANALYSIS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1CONTROL_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1CONTROL_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1CONTROL_1sizeof_FUNC);
	rc = (jint)SCRIPT_CONTROL_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1CONTROL_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1FONTPROPERTIES_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1FONTPROPERTIES_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1FONTPROPERTIES_1sizeof_FUNC);
	rc = (jint)SCRIPT_FONTPROPERTIES_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1FONTPROPERTIES_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1ITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1ITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1ITEM_1sizeof_FUNC);
	rc = (jint)SCRIPT_ITEM_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1ITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1LOGATTR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1LOGATTR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1LOGATTR_1sizeof_FUNC);
	rc = (jint)SCRIPT_LOGATTR_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1LOGATTR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1PROPERTIES_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1PROPERTIES_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1PROPERTIES_1sizeof_FUNC);
	rc = (jint)SCRIPT_PROPERTIES_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1PROPERTIES_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1STATE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1STATE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1STATE_1sizeof_FUNC);
	rc = (jint)SCRIPT_STATE_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1STATE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCRIPT_1STRING_1ANALYSIS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCRIPT_1STRING_1ANALYSIS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCRIPT_1STRING_1ANALYSIS_1sizeof_FUNC);
	rc = (jint)SCRIPT_STRING_ANALYSIS_sizeof();
	OS_NATIVE_EXIT(env, that, SCRIPT_1STRING_1ANALYSIS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCROLLBARINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCROLLBARINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCROLLBARINFO_1sizeof_FUNC);
	rc = (jint)SCROLLBARINFO_sizeof();
	OS_NATIVE_EXIT(env, that, SCROLLBARINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SCROLLINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SCROLLINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SCROLLINFO_1sizeof_FUNC);
	rc = (jint)SCROLLINFO_sizeof();
	OS_NATIVE_EXIT(env, that, SCROLLINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SHDRAGIMAGE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SHDRAGIMAGE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SHDRAGIMAGE_1sizeof_FUNC);
	rc = (jint)SHDRAGIMAGE_sizeof();
	OS_NATIVE_EXIT(env, that, SHDRAGIMAGE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SHELLEXECUTEINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SHELLEXECUTEINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SHELLEXECUTEINFO_1sizeof_FUNC);
	rc = (jint)SHELLEXECUTEINFO_sizeof();
	OS_NATIVE_EXIT(env, that, SHELLEXECUTEINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SHFILEINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SHFILEINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SHFILEINFO_1sizeof_FUNC);
	rc = (jint)SHFILEINFO_sizeof();
	OS_NATIVE_EXIT(env, that, SHFILEINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SHGetFileInfo
JNIEXPORT jlong JNICALL OS_NATIVE(SHGetFileInfo)
	(JNIEnv *env, jclass that, jcharArray arg0, jint arg1, jobject arg2, jint arg3, jint arg4)
{
	jchar *lparg0=NULL;
	SHFILEINFO _arg2, *lparg2=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SHGetFileInfo_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getSHFILEINFOFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jlong)SHGetFileInfo((LPCWSTR)lparg0, arg1, lparg2, arg3, arg4);
fail:
	if (arg2 && lparg2) setSHFILEINFOFields(env, arg2, lparg2);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SHGetFileInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_SIZE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SIZE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SIZE_1sizeof_FUNC);
	rc = (jint)SIZE_sizeof();
	OS_NATIVE_EXIT(env, that, SIZE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_STARTUPINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(STARTUPINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, STARTUPINFO_1sizeof_FUNC);
	rc = (jint)STARTUPINFO_sizeof();
	OS_NATIVE_EXIT(env, that, STARTUPINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SYSTEMTIME_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(SYSTEMTIME_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SYSTEMTIME_1sizeof_FUNC);
	rc = (jint)SYSTEMTIME_sizeof();
	OS_NATIVE_EXIT(env, that, SYSTEMTIME_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_SaveDC
JNIEXPORT jint JNICALL OS_NATIVE(SaveDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SaveDC_FUNC);
	rc = (jint)SaveDC((HDC)arg0);
	OS_NATIVE_EXIT(env, that, SaveDC_FUNC);
	return rc;
}
#endif

#ifndef NO_ScreenToClient
JNIEXPORT jboolean JNICALL OS_NATIVE(ScreenToClient)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	POINT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ScreenToClient_FUNC);
	if (arg1) if ((lparg1 = getPOINTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ScreenToClient((HWND)arg0, lparg1);
fail:
	if (arg1 && lparg1) setPOINTFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, ScreenToClient_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptApplyDigitSubstitution
JNIEXPORT jint JNICALL OS_NATIVE(ScriptApplyDigitSubstitution)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1, jobject arg2)
{
	SCRIPT_CONTROL _arg1, *lparg1=NULL;
	SCRIPT_STATE _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptApplyDigitSubstitution_FUNC);
	if (arg1) if ((lparg1 = getSCRIPT_CONTROLFields(env, arg1, &_arg1)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getSCRIPT_STATEFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)ScriptApplyDigitSubstitution((const SCRIPT_DIGITSUBSTITUTE*)arg0, (SCRIPT_CONTROL*)lparg1, (SCRIPT_STATE*)lparg2);
fail:
	if (arg2 && lparg2) setSCRIPT_STATEFields(env, arg2, lparg2);
	if (arg1 && lparg1) setSCRIPT_CONTROLFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, ScriptApplyDigitSubstitution_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptBreak
JNIEXPORT jint JNICALL OS_NATIVE(ScriptBreak)
	(JNIEnv *env, jclass that, jcharArray arg0, jint arg1, jobject arg2, jlong arg3)
{
	jchar *lparg0=NULL;
	SCRIPT_ANALYSIS _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptBreak_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = getSCRIPT_ANALYSISFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)ScriptBreak((const WCHAR *)lparg0, arg1, (const SCRIPT_ANALYSIS *)lparg2, (SCRIPT_LOGATTR *)arg3);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ScriptBreak_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptCPtoX
JNIEXPORT jint JNICALL OS_NATIVE(ScriptCPtoX)
	(JNIEnv *env, jclass that, jint arg0, jboolean arg1, jint arg2, jint arg3, jlong arg4, jlong arg5, jlong arg6, jobject arg7, jintArray arg8)
{
	SCRIPT_ANALYSIS _arg7, *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptCPtoX_FUNC);
	if (arg7) if ((lparg7 = getSCRIPT_ANALYSISFields(env, arg7, &_arg7)) == NULL) goto fail;
	if (arg8) if ((lparg8 = (*env)->GetIntArrayElements(env, arg8, NULL)) == NULL) goto fail;
	rc = (jint)ScriptCPtoX(arg0, arg1, arg2, arg3, (const WORD *)arg4, (const SCRIPT_VISATTR *)arg5, (const int *)arg6, (const SCRIPT_ANALYSIS *)lparg7, (int *)lparg8);
fail:
	if (arg8 && lparg8) (*env)->ReleaseIntArrayElements(env, arg8, lparg8, 0);
	OS_NATIVE_EXIT(env, that, ScriptCPtoX_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptCacheGetHeight
JNIEXPORT jint JNICALL OS_NATIVE(ScriptCacheGetHeight)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jintArray arg2)
{
	jint *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptCacheGetHeight_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)ScriptCacheGetHeight((HDC)arg0, (SCRIPT_CACHE *)arg1, (long *)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, ScriptCacheGetHeight_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptFreeCache
JNIEXPORT jint JNICALL OS_NATIVE(ScriptFreeCache)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptFreeCache_FUNC);
	rc = (jint)ScriptFreeCache((SCRIPT_CACHE *)arg0);
	OS_NATIVE_EXIT(env, that, ScriptFreeCache_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptGetCMap
JNIEXPORT jint JNICALL OS_NATIVE(ScriptGetCMap)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jshortArray arg5)
{
	jchar *lparg2=NULL;
	jshort *lparg5=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptGetCMap_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = (*env)->GetShortArrayElements(env, arg5, NULL)) == NULL) goto fail;
	rc = (jint)ScriptGetCMap((HDC)arg0, (SCRIPT_CACHE *)arg1, (const WCHAR *)lparg2, arg3, arg4, (WORD*)lparg5);
fail:
	if (arg5 && lparg5) (*env)->ReleaseShortArrayElements(env, arg5, lparg5, 0);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ScriptGetCMap_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptGetFontProperties
JNIEXPORT jint JNICALL OS_NATIVE(ScriptGetFontProperties)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2)
{
	SCRIPT_FONTPROPERTIES _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptGetFontProperties_FUNC);
	if (arg2) if ((lparg2 = getSCRIPT_FONTPROPERTIESFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)ScriptGetFontProperties((HDC)arg0, (SCRIPT_CACHE *)arg1, (SCRIPT_FONTPROPERTIES *)lparg2);
fail:
	if (arg2 && lparg2) setSCRIPT_FONTPROPERTIESFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, ScriptGetFontProperties_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptGetLogicalWidths
JNIEXPORT jint JNICALL OS_NATIVE(ScriptGetLogicalWidths)
	(JNIEnv *env, jclass that, jobject arg0, jint arg1, jint arg2, jlong arg3, jlong arg4, jlong arg5, jintArray arg6)
{
	SCRIPT_ANALYSIS _arg0, *lparg0=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptGetLogicalWidths_FUNC);
	if (arg0) if ((lparg0 = getSCRIPT_ANALYSISFields(env, arg0, &_arg0)) == NULL) goto fail;
	if (arg6) if ((lparg6 = (*env)->GetIntArrayElements(env, arg6, NULL)) == NULL) goto fail;
	rc = (jint)ScriptGetLogicalWidths((const SCRIPT_ANALYSIS *)lparg0, arg1, arg2, (const int *)arg3, (const WORD *)arg4, (const SCRIPT_VISATTR *)arg5, (int *)lparg6);
fail:
	if (arg6 && lparg6) (*env)->ReleaseIntArrayElements(env, arg6, lparg6, 0);
	OS_NATIVE_EXIT(env, that, ScriptGetLogicalWidths_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptGetProperties
JNIEXPORT jint JNICALL OS_NATIVE(ScriptGetProperties)
	(JNIEnv *env, jclass that, jlongArray arg0, jintArray arg1)
{
	jlong *lparg0=NULL;
	jint *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptGetProperties_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetLongArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jint)ScriptGetProperties((const SCRIPT_PROPERTIES ***)lparg0, (int *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseLongArrayElements(env, arg0, lparg0, 0);
	OS_NATIVE_EXIT(env, that, ScriptGetProperties_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptItemize
JNIEXPORT jint JNICALL OS_NATIVE(ScriptItemize)
	(JNIEnv *env, jclass that, jcharArray arg0, jint arg1, jint arg2, jobject arg3, jobject arg4, jlong arg5, jintArray arg6)
{
	jchar *lparg0=NULL;
	SCRIPT_CONTROL _arg3, *lparg3=NULL;
	SCRIPT_STATE _arg4, *lparg4=NULL;
	jint *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptItemize_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = getSCRIPT_CONTROLFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getSCRIPT_STATEFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg6) if ((lparg6 = (*env)->GetIntArrayElements(env, arg6, NULL)) == NULL) goto fail;
	rc = (jint)ScriptItemize((const WCHAR *)lparg0, arg1, arg2, (const SCRIPT_CONTROL *)lparg3, (const SCRIPT_STATE *)lparg4, (SCRIPT_ITEM *)arg5, (int *)lparg6);
fail:
	if (arg6 && lparg6) (*env)->ReleaseIntArrayElements(env, arg6, lparg6, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ScriptItemize_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptJustify
JNIEXPORT jint JNICALL OS_NATIVE(ScriptJustify)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jlong arg5)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptJustify_FUNC);
	rc = (jint)ScriptJustify((SCRIPT_VISATTR *)arg0, (const int *)arg1, arg2, arg3, arg4, (int *)arg5);
	OS_NATIVE_EXIT(env, that, ScriptJustify_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptLayout
JNIEXPORT jint JNICALL OS_NATIVE(ScriptLayout)
	(JNIEnv *env, jclass that, jint arg0, jbyteArray arg1, jintArray arg2, jintArray arg3)
{
	jbyte *lparg1=NULL;
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptLayout_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetByteArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)ScriptLayout(arg0, (const BYTE *)lparg1, (int *)lparg2, (int *)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseByteArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ScriptLayout_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptPlace
JNIEXPORT jint JNICALL OS_NATIVE(ScriptPlace)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2, jint arg3, jlong arg4, jobject arg5, jlong arg6, jlong arg7, jintArray arg8)
{
	SCRIPT_ANALYSIS _arg5, *lparg5=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptPlace_FUNC);
	if (arg5) if ((lparg5 = getSCRIPT_ANALYSISFields(env, arg5, &_arg5)) == NULL) goto fail;
	if (arg8) if ((lparg8 = (*env)->GetIntArrayElements(env, arg8, NULL)) == NULL) goto fail;
	rc = (jint)ScriptPlace((HDC)arg0, (SCRIPT_CACHE *)arg1, (const WORD *)arg2, arg3, (const SCRIPT_VISATTR *)arg4, (SCRIPT_ANALYSIS *)lparg5, (int *)arg6, (GOFFSET *)arg7, (ABC *)lparg8);
fail:
	if (arg8 && lparg8) (*env)->ReleaseIntArrayElements(env, arg8, lparg8, 0);
	if (arg5 && lparg5) setSCRIPT_ANALYSISFields(env, arg5, lparg5);
	OS_NATIVE_EXIT(env, that, ScriptPlace_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptShape
JNIEXPORT jint JNICALL OS_NATIVE(ScriptShape)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jcharArray arg2, jint arg3, jint arg4, jobject arg5, jlong arg6, jlong arg7, jlong arg8, jintArray arg9)
{
	jchar *lparg2=NULL;
	SCRIPT_ANALYSIS _arg5, *lparg5=NULL;
	jint *lparg9=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptShape_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg5) if ((lparg5 = getSCRIPT_ANALYSISFields(env, arg5, &_arg5)) == NULL) goto fail;
	if (arg9) if ((lparg9 = (*env)->GetIntArrayElements(env, arg9, NULL)) == NULL) goto fail;
	rc = (jint)ScriptShape((HDC)arg0, (SCRIPT_CACHE *)arg1, (const WCHAR *)lparg2, arg3, arg4, (SCRIPT_ANALYSIS *)lparg5, (WORD *)arg6, (WORD *)arg7, (SCRIPT_VISATTR *)arg8, (int *)lparg9);
fail:
	if (arg9 && lparg9) (*env)->ReleaseIntArrayElements(env, arg9, lparg9, 0);
	if (arg5 && lparg5) setSCRIPT_ANALYSISFields(env, arg5, lparg5);
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, ScriptShape_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptStringAnalyse
JNIEXPORT jint JNICALL OS_NATIVE(ScriptStringAnalyse)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6, jobject arg7, jobject arg8, jlong arg9, jlong arg10, jlong arg11, jlong arg12)
{
	SCRIPT_CONTROL _arg7, *lparg7=NULL;
	SCRIPT_STATE _arg8, *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptStringAnalyse_FUNC);
	if (arg7) if ((lparg7 = getSCRIPT_CONTROLFields(env, arg7, &_arg7)) == NULL) goto fail;
	if (arg8) if ((lparg8 = getSCRIPT_STATEFields(env, arg8, &_arg8)) == NULL) goto fail;
	rc = (jint)ScriptStringAnalyse((HDC)arg0, (const void*)arg1, arg2, arg3, arg4, arg5, arg6, lparg7, lparg8, (const int*)arg9, (SCRIPT_TABDEF*)arg10, (const BYTE*)arg11, (SCRIPT_STRING_ANALYSIS*)arg12);
fail:
	if (arg8 && lparg8) setSCRIPT_STATEFields(env, arg8, lparg8);
	if (arg7 && lparg7) setSCRIPT_CONTROLFields(env, arg7, lparg7);
	OS_NATIVE_EXIT(env, that, ScriptStringAnalyse_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptStringFree
JNIEXPORT jint JNICALL OS_NATIVE(ScriptStringFree)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptStringFree_FUNC);
	rc = (jint)ScriptStringFree((SCRIPT_STRING_ANALYSIS*)arg0);
	OS_NATIVE_EXIT(env, that, ScriptStringFree_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptStringOut
JNIEXPORT jint JNICALL OS_NATIVE(ScriptStringOut)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jobject arg4, jint arg5, jint arg6, jboolean arg7)
{
	RECT _arg4, *lparg4=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptStringOut_FUNC);
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
	rc = (jint)ScriptStringOut(*(SCRIPT_STRING_ANALYSIS*)arg0, arg1, arg2, arg3, lparg4, arg5, arg6, arg7);
fail:
	if (arg4 && lparg4) setRECTFields(env, arg4, lparg4);
	OS_NATIVE_EXIT(env, that, ScriptStringOut_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptTextOut
JNIEXPORT jint JNICALL OS_NATIVE(ScriptTextOut)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jobject arg5, jobject arg6, jlong arg7, jint arg8, jlong arg9, jint arg10, jlong arg11, jlong arg12, jlong arg13)
{
	RECT _arg5, *lparg5=NULL;
	SCRIPT_ANALYSIS _arg6, *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptTextOut_FUNC);
	if (arg5) if ((lparg5 = getRECTFields(env, arg5, &_arg5)) == NULL) goto fail;
	if (arg6) if ((lparg6 = getSCRIPT_ANALYSISFields(env, arg6, &_arg6)) == NULL) goto fail;
	rc = (jint)ScriptTextOut((const HDC)arg0, (SCRIPT_CACHE *)arg1, arg2, arg3, arg4, (const RECT *)lparg5, (const SCRIPT_ANALYSIS *)lparg6, (const WCHAR *)arg7, arg8, (const WORD *)arg9, arg10, (const int *)arg11, (const int *)arg12, (const GOFFSET *)arg13);
fail:
	OS_NATIVE_EXIT(env, that, ScriptTextOut_FUNC);
	return rc;
}
#endif

#ifndef NO_ScriptXtoCP
JNIEXPORT jint JNICALL OS_NATIVE(ScriptXtoCP)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jint arg2, jlong arg3, jlong arg4, jlong arg5, jobject arg6, jintArray arg7, jintArray arg8)
{
	SCRIPT_ANALYSIS _arg6, *lparg6=NULL;
	jint *lparg7=NULL;
	jint *lparg8=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScriptXtoCP_FUNC);
	if (arg6) if ((lparg6 = getSCRIPT_ANALYSISFields(env, arg6, &_arg6)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetIntArrayElements(env, arg7, NULL)) == NULL) goto fail;
	if (arg8) if ((lparg8 = (*env)->GetIntArrayElements(env, arg8, NULL)) == NULL) goto fail;
	rc = (jint)ScriptXtoCP(arg0, arg1, arg2, (const WORD *)arg3, (const SCRIPT_VISATTR *)arg4, (const int *)arg5, (const SCRIPT_ANALYSIS *)lparg6, (int *)lparg7, (int *)lparg8);
fail:
	if (arg8 && lparg8) (*env)->ReleaseIntArrayElements(env, arg8, lparg8, 0);
	if (arg7 && lparg7) (*env)->ReleaseIntArrayElements(env, arg7, lparg7, 0);
	OS_NATIVE_EXIT(env, that, ScriptXtoCP_FUNC);
	return rc;
}
#endif

#ifndef NO_ScrollWindowEx
JNIEXPORT jint JNICALL OS_NATIVE(ScrollWindowEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jobject arg3, jobject arg4, jlong arg5, jobject arg6, jint arg7)
{
	RECT _arg3, *lparg3=NULL;
	RECT _arg4, *lparg4=NULL;
	RECT _arg6, *lparg6=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ScrollWindowEx_FUNC);
	if (arg3) if ((lparg3 = getRECTFields(env, arg3, &_arg3)) == NULL) goto fail;
	if (arg4) if ((lparg4 = getRECTFields(env, arg4, &_arg4)) == NULL) goto fail;
	if (arg6) if ((lparg6 = getRECTFields(env, arg6, &_arg6)) == NULL) goto fail;
	rc = (jint)ScrollWindowEx((HWND)arg0, arg1, arg2, lparg3, lparg4, (HRGN)arg5, lparg6, arg7);
fail:
	if (arg6 && lparg6) setRECTFields(env, arg6, lparg6);
	if (arg4 && lparg4) setRECTFields(env, arg4, lparg4);
	if (arg3 && lparg3) setRECTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, ScrollWindowEx_FUNC);
	return rc;
}
#endif

#ifndef NO_SelectClipRgn
JNIEXPORT jint JNICALL OS_NATIVE(SelectClipRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SelectClipRgn_FUNC);
	rc = (jint)SelectClipRgn((HDC)arg0, (HRGN)arg1);
	OS_NATIVE_EXIT(env, that, SelectClipRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_SelectObject
JNIEXPORT jlong JNICALL OS_NATIVE(SelectObject)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SelectObject_FUNC);
	rc = (jlong)SelectObject((HDC)arg0, (HGDIOBJ)arg1);
	OS_NATIVE_EXIT(env, that, SelectObject_FUNC);
	return rc;
}
#endif

#ifndef NO_SendInput
JNIEXPORT jint JNICALL OS_NATIVE(SendInput)
	(JNIEnv *env, jclass that, jint arg0, jobject arg1, jint arg2)
{
	INPUT _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SendInput_FUNC);
	if (arg1) if ((lparg1 = getINPUTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jint)SendInput(arg0, lparg1, arg2);
fail:
	OS_NATIVE_EXIT(env, that, SendInput_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJJ
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJJ)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jlong arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJJ_FUNC);
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)arg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJJ_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_BUTTON_1IMAGELIST_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_BUTTON_1IMAGELIST_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	BUTTON_IMAGELIST _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_BUTTON_1IMAGELIST_2_FUNC);
	if (arg3) if ((lparg3 = getBUTTON_IMAGELISTFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setBUTTON_IMAGELISTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_BUTTON_1IMAGELIST_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_HDHITTESTINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_HDHITTESTINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	HDHITTESTINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDHITTESTINFO_2_FUNC);
	if (arg3) if ((lparg3 = getHDHITTESTINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setHDHITTESTINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDHITTESTINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_HDITEM_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_HDITEM_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	HDITEM _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDITEM_2_FUNC);
	if (arg3) if ((lparg3 = getHDITEMFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setHDITEMFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDITEM_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_HDLAYOUT_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_HDLAYOUT_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	HDLAYOUT _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDLAYOUT_2_FUNC);
	if (arg3) if ((lparg3 = getHDLAYOUTFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setHDLAYOUTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_HDLAYOUT_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_LITEM_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_LITEM_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	LITEM _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LITEM_2_FUNC);
	if (arg3) if ((lparg3 = getLITEMFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setLITEMFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LITEM_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_LVCOLUMN_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_LVCOLUMN_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	LVCOLUMN _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVCOLUMN_2_FUNC);
	if (arg3) if ((lparg3 = getLVCOLUMNFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setLVCOLUMNFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVCOLUMN_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_LVHITTESTINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_LVHITTESTINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	LVHITTESTINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVHITTESTINFO_2_FUNC);
	if (arg3) if ((lparg3 = getLVHITTESTINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setLVHITTESTINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVHITTESTINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_LVINSERTMARK_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_LVINSERTMARK_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	LVINSERTMARK _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVINSERTMARK_2_FUNC);
	if (arg3) if ((lparg3 = getLVINSERTMARKFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setLVINSERTMARKFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVINSERTMARK_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_LVITEM_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_LVITEM_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	LVITEM _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVITEM_2_FUNC);
	if (arg3) if ((lparg3 = getLVITEMFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setLVITEMFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_LVITEM_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_MARGINS_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_MARGINS_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	MARGINS _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_MARGINS_2_FUNC);
	if (arg3) if ((lparg3 = getMARGINSFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setMARGINSFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_MARGINS_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_MCHITTESTINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_MCHITTESTINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	MCHITTESTINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_MCHITTESTINFO_2_FUNC);
	if (arg3) if ((lparg3 = getMCHITTESTINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setMCHITTESTINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_MCHITTESTINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_REBARBANDINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_REBARBANDINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	REBARBANDINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_REBARBANDINFO_2_FUNC);
	if (arg3) if ((lparg3 = getREBARBANDINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setREBARBANDINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_REBARBANDINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_RECT_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_RECT_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	RECT _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_RECT_2_FUNC);
	if (arg3) if ((lparg3 = getRECTFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setRECTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_RECT_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	SHDRAGIMAGE _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2_FUNC);
	if (arg3) if ((lparg3 = getSHDRAGIMAGEFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setSHDRAGIMAGEFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SHDRAGIMAGE_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_SIZE_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_SIZE_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	SIZE _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SIZE_2_FUNC);
	if (arg3) if ((lparg3 = getSIZEFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setSIZEFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SIZE_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_SYSTEMTIME_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_SYSTEMTIME_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	SYSTEMTIME _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SYSTEMTIME_2_FUNC);
	if (arg3) if ((lparg3 = getSYSTEMTIMEFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setSYSTEMTIMEFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_SYSTEMTIME_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTONINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTONINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TBBUTTONINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTONINFO_2_FUNC);
	if (arg3) if ((lparg3 = getTBBUTTONINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTBBUTTONINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTONINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTON_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTON_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TBBUTTON _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTON_2_FUNC);
	if (arg3) if ((lparg3 = getTBBUTTONFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTBBUTTONFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TBBUTTON_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TCHITTESTINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TCHITTESTINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TCHITTESTINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TCHITTESTINFO_2_FUNC);
	if (arg3) if ((lparg3 = getTCHITTESTINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTCHITTESTINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TCHITTESTINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TCITEM_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TCITEM_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TCITEM _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TCITEM_2_FUNC);
	if (arg3) if ((lparg3 = getTCITEMFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTCITEMFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TCITEM_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TOOLINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TOOLINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TOOLINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TOOLINFO_2_FUNC);
	if (arg3) if ((lparg3 = getTOOLINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTOOLINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TOOLINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TVHITTESTINFO_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TVHITTESTINFO_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TVHITTESTINFO _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVHITTESTINFO_2_FUNC);
	if (arg3) if ((lparg3 = getTVHITTESTINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTVHITTESTINFOFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVHITTESTINFO_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TVINSERTSTRUCT_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TVINSERTSTRUCT_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TVINSERTSTRUCT _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVINSERTSTRUCT_2_FUNC);
	if (arg3) if ((lparg3 = getTVINSERTSTRUCTFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTVINSERTSTRUCTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVINSERTSTRUCT_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TVITEM_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TVITEM_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TVITEM _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVITEM_2_FUNC);
	if (arg3) if ((lparg3 = getTVITEMFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTVITEMFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVITEM_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_TVSORTCB_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_TVSORTCB_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	TVSORTCB _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVSORTCB_2_FUNC);
	if (arg3) if ((lparg3 = getTVSORTCBFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setTVSORTCBFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_TVSORTCB_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJLorg_eclipse_swt_internal_win32_UDACCEL_2
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJLorg_eclipse_swt_internal_win32_UDACCEL_2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jobject arg3)
{
	UDACCEL _arg3, *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_UDACCEL_2_FUNC);
	if (arg3) if ((lparg3 = getUDACCELFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) setUDACCELFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJLorg_eclipse_swt_internal_win32_UDACCEL_2_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJ_3C
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJ_3C)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jcharArray arg3)
{
	jchar *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJ_3C_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJ_3C_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JIJ_3I
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JIJ_3I)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2, jintArray arg3)
{
	jint *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JIJ_3I_FUNC);
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)arg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	OS_NATIVE_EXIT(env, that, SendMessage__JIJ_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_SendMessage__JI_3I_3I
JNIEXPORT jlong JNICALL OS_NATIVE(SendMessage__JI_3I_3I)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jintArray arg2, jintArray arg3)
{
	jint *lparg2=NULL;
	jint *lparg3=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SendMessage__JI_3I_3I_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetIntArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jlong)SendMessage((HWND)arg0, arg1, (WPARAM)lparg2, (LPARAM)lparg3);
fail:
	if (arg3 && lparg3) (*env)->ReleaseIntArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, SendMessage__JI_3I_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_SetActiveWindow
JNIEXPORT jlong JNICALL OS_NATIVE(SetActiveWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetActiveWindow_FUNC);
	rc = (jlong)SetActiveWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, SetActiveWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_SetBkColor
JNIEXPORT jint JNICALL OS_NATIVE(SetBkColor)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetBkColor_FUNC);
	rc = (jint)SetBkColor((HDC)arg0, (COLORREF)arg1);
	OS_NATIVE_EXIT(env, that, SetBkColor_FUNC);
	return rc;
}
#endif

#ifndef NO_SetBkMode
JNIEXPORT jint JNICALL OS_NATIVE(SetBkMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetBkMode_FUNC);
	rc = (jint)SetBkMode((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetBkMode_FUNC);
	return rc;
}
#endif

#ifndef NO_SetBrushOrgEx
JNIEXPORT jboolean JNICALL OS_NATIVE(SetBrushOrgEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jobject arg3)
{
	POINT _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetBrushOrgEx_FUNC);
	if (arg3) if ((lparg3 = &_arg3) == NULL) goto fail;
	rc = (jboolean)SetBrushOrgEx((HDC)arg0, arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setPOINTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SetBrushOrgEx_FUNC);
	return rc;
}
#endif

#ifndef NO_SetCapture
JNIEXPORT jlong JNICALL OS_NATIVE(SetCapture)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetCapture_FUNC);
	rc = (jlong)SetCapture((HWND)arg0);
	OS_NATIVE_EXIT(env, that, SetCapture_FUNC);
	return rc;
}
#endif

#ifndef NO_SetCaretPos
JNIEXPORT jboolean JNICALL OS_NATIVE(SetCaretPos)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetCaretPos_FUNC);
	rc = (jboolean)SetCaretPos(arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetCaretPos_FUNC);
	return rc;
}
#endif

#ifndef NO_SetCurrentProcessExplicitAppUserModelID
JNIEXPORT jint JNICALL OS_NATIVE(SetCurrentProcessExplicitAppUserModelID)
	(JNIEnv *env, jclass that, jcharArray arg0)
{
	jchar *lparg0=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetCurrentProcessExplicitAppUserModelID_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jint)SetCurrentProcessExplicitAppUserModelID(lparg0);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SetCurrentProcessExplicitAppUserModelID_FUNC);
	return rc;
}
#endif

#ifndef NO_SetCursor
JNIEXPORT jlong JNICALL OS_NATIVE(SetCursor)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetCursor_FUNC);
	rc = (jlong)SetCursor((HCURSOR)arg0);
	OS_NATIVE_EXIT(env, that, SetCursor_FUNC);
	return rc;
}
#endif

#ifndef NO_SetCursorPos
JNIEXPORT jboolean JNICALL OS_NATIVE(SetCursorPos)
	(JNIEnv *env, jclass that, jint arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetCursorPos_FUNC);
	rc = (jboolean)SetCursorPos(arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetCursorPos_FUNC);
	return rc;
}
#endif

#ifndef NO_SetDIBColorTable
JNIEXPORT jint JNICALL OS_NATIVE(SetDIBColorTable)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jbyteArray arg3)
{
	jbyte *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetDIBColorTable_FUNC);
		if (arg3) if ((lparg3 = (*env)->GetPrimitiveArrayCritical(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)SetDIBColorTable((HDC)arg0, arg1, arg2, (RGBQUAD *)lparg3);
fail:
		if (arg3 && lparg3) (*env)->ReleasePrimitiveArrayCritical(env, arg3, lparg3, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SetDIBColorTable_FUNC);
	return rc;
}
#endif

#ifndef NO_SetFocus
JNIEXPORT jlong JNICALL OS_NATIVE(SetFocus)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetFocus_FUNC);
	rc = (jlong)SetFocus((HWND)arg0);
	OS_NATIVE_EXIT(env, that, SetFocus_FUNC);
	return rc;
}
#endif

#ifndef NO_SetForegroundWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(SetForegroundWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetForegroundWindow_FUNC);
	rc = (jboolean)SetForegroundWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, SetForegroundWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_SetGestureConfig
JNIEXPORT jboolean JNICALL OS_NATIVE(SetGestureConfig)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jobject arg3, jint arg4)
{
	GESTURECONFIG _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetGestureConfig_FUNC);
	if (arg3) if ((lparg3 = getGESTURECONFIGFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)SetGestureConfig((HWND)arg0, arg1, arg2, lparg3, arg4);
fail:
	OS_NATIVE_EXIT(env, that, SetGestureConfig_FUNC);
	return rc;
}
#endif

#ifndef NO_SetGraphicsMode
JNIEXPORT jint JNICALL OS_NATIVE(SetGraphicsMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetGraphicsMode_FUNC);
	rc = (jint)SetGraphicsMode((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetGraphicsMode_FUNC);
	return rc;
}
#endif

#ifndef NO_SetLayeredWindowAttributes
JNIEXPORT jboolean JNICALL OS_NATIVE(SetLayeredWindowAttributes)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jbyte arg2, jint arg3)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetLayeredWindowAttributes_FUNC);
	rc = (jboolean)SetLayeredWindowAttributes((HWND)arg0, arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, SetLayeredWindowAttributes_FUNC);
	return rc;
}
#endif

#ifndef NO_SetLayout
JNIEXPORT jint JNICALL OS_NATIVE(SetLayout)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetLayout_FUNC);
	rc = (jint)SetLayout((HDC)arg0, (DWORD)arg1);
	OS_NATIVE_EXIT(env, that, SetLayout_FUNC);
	return rc;
}
#endif

#ifndef NO_SetMenu
JNIEXPORT jboolean JNICALL OS_NATIVE(SetMenu)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetMenu_FUNC);
	rc = (jboolean)SetMenu((HWND)arg0, (HMENU)arg1);
	OS_NATIVE_EXIT(env, that, SetMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_SetMenuDefaultItem
JNIEXPORT jboolean JNICALL OS_NATIVE(SetMenuDefaultItem)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetMenuDefaultItem_FUNC);
	rc = (jboolean)SetMenuDefaultItem((HMENU)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, SetMenuDefaultItem_FUNC);
	return rc;
}
#endif

#ifndef NO_SetMenuInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(SetMenuInfo)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	MENUINFO _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetMenuInfo_FUNC);
	if (arg1) if ((lparg1 = getMENUINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)SetMenuInfo((HMENU)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, SetMenuInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_SetMenuItemInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(SetMenuItemInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jboolean arg2, jobject arg3)
{
	MENUITEMINFO _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetMenuItemInfo_FUNC);
	if (arg3) if ((lparg3 = getMENUITEMINFOFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)SetMenuItemInfo((HMENU)arg0, arg1, arg2, lparg3);
fail:
	OS_NATIVE_EXIT(env, that, SetMenuItemInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_SetMetaRgn
JNIEXPORT jint JNICALL OS_NATIVE(SetMetaRgn)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetMetaRgn_FUNC);
	rc = (jint)SetMetaRgn((HDC)arg0);
	OS_NATIVE_EXIT(env, that, SetMetaRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_SetParent
JNIEXPORT jlong JNICALL OS_NATIVE(SetParent)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetParent_FUNC);
	rc = (jlong)SetParent((HWND)arg0, (HWND)arg1);
	OS_NATIVE_EXIT(env, that, SetParent_FUNC);
	return rc;
}
#endif

#ifndef NO_SetPixel
JNIEXPORT jint JNICALL OS_NATIVE(SetPixel)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetPixel_FUNC);
	rc = (jint)SetPixel((HDC)arg0, arg1, arg2, arg3);
	OS_NATIVE_EXIT(env, that, SetPixel_FUNC);
	return rc;
}
#endif

#ifndef NO_SetPolyFillMode
JNIEXPORT jint JNICALL OS_NATIVE(SetPolyFillMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetPolyFillMode_FUNC);
	rc = (jint)SetPolyFillMode((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetPolyFillMode_FUNC);
	return rc;
}
#endif

#ifndef NO_SetProcessDPIAware
JNIEXPORT jboolean JNICALL OS_NATIVE(SetProcessDPIAware)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetProcessDPIAware_FUNC);
	rc = (jboolean)SetProcessDPIAware();
	OS_NATIVE_EXIT(env, that, SetProcessDPIAware_FUNC);
	return rc;
}
#endif

#ifndef NO_SetProp
JNIEXPORT jboolean JNICALL OS_NATIVE(SetProp)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jlong arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetProp_FUNC);
	rc = (jboolean)SetProp((HWND)arg0, (LPCWSTR)arg1, (HANDLE)arg2);
	OS_NATIVE_EXIT(env, that, SetProp_FUNC);
	return rc;
}
#endif

#ifndef NO_SetROP2
JNIEXPORT jint JNICALL OS_NATIVE(SetROP2)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetROP2_FUNC);
	rc = (jint)SetROP2((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetROP2_FUNC);
	return rc;
}
#endif

#ifndef NO_SetRect
JNIEXPORT jboolean JNICALL OS_NATIVE(SetRect)
	(JNIEnv *env, jclass that, jobject arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	RECT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetRect_FUNC);
	if (arg0) if ((lparg0 = &_arg0) == NULL) goto fail;
	rc = (jboolean)SetRect(lparg0, arg1, arg2, arg3, arg4);
fail:
	if (arg0 && lparg0) setRECTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, SetRect_FUNC);
	return rc;
}
#endif

#ifndef NO_SetRectRgn
JNIEXPORT jboolean JNICALL OS_NATIVE(SetRectRgn)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetRectRgn_FUNC);
	rc = (jboolean)SetRectRgn((HRGN)arg0, arg1, arg2, arg3, arg4);
	OS_NATIVE_EXIT(env, that, SetRectRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_SetScrollInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(SetScrollInfo)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jobject arg2, jboolean arg3)
{
	SCROLLINFO _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetScrollInfo_FUNC);
	if (arg2) if ((lparg2 = getSCROLLINFOFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)SetScrollInfo((HWND)arg0, arg1, lparg2, arg3);
fail:
	OS_NATIVE_EXIT(env, that, SetScrollInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_SetStretchBltMode
JNIEXPORT jint JNICALL OS_NATIVE(SetStretchBltMode)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetStretchBltMode_FUNC);
	rc = (jint)SetStretchBltMode((HDC)arg0, arg1);
	OS_NATIVE_EXIT(env, that, SetStretchBltMode_FUNC);
	return rc;
}
#endif

#ifndef NO_SetTextColor
JNIEXPORT jint JNICALL OS_NATIVE(SetTextColor)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetTextColor_FUNC);
	rc = (jint)SetTextColor((HDC)arg0, (COLORREF)arg1);
	OS_NATIVE_EXIT(env, that, SetTextColor_FUNC);
	return rc;
}
#endif

#ifndef NO_SetTimer
JNIEXPORT jlong JNICALL OS_NATIVE(SetTimer)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jlong arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetTimer_FUNC);
	rc = (jlong)SetTimer((HWND)arg0, arg1, arg2, (TIMERPROC)arg3);
	OS_NATIVE_EXIT(env, that, SetTimer_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowLong
JNIEXPORT jint JNICALL OS_NATIVE(SetWindowLong)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowLong_FUNC);
	rc = (jint)SetWindowLong((HWND)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, SetWindowLong_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowLongPtr
JNIEXPORT jlong JNICALL OS_NATIVE(SetWindowLongPtr)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jlong arg2)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowLongPtr_FUNC);
	rc = (jlong)SetWindowLongPtr((HWND)arg0, arg1, (LONG_PTR)arg2);
	OS_NATIVE_EXIT(env, that, SetWindowLongPtr_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowOrgEx
JNIEXPORT jboolean JNICALL OS_NATIVE(SetWindowOrgEx)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jobject arg3)
{
	POINT _arg3, *lparg3=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowOrgEx_FUNC);
	if (arg3) if ((lparg3 = getPOINTFields(env, arg3, &_arg3)) == NULL) goto fail;
	rc = (jboolean)SetWindowOrgEx((HDC)arg0, arg1, arg2, lparg3);
fail:
	if (arg3 && lparg3) setPOINTFields(env, arg3, lparg3);
	OS_NATIVE_EXIT(env, that, SetWindowOrgEx_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowPlacement
JNIEXPORT jboolean JNICALL OS_NATIVE(SetWindowPlacement)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	WINDOWPLACEMENT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowPlacement_FUNC);
	if (arg1) if ((lparg1 = getWINDOWPLACEMENTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)SetWindowPlacement((HWND)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, SetWindowPlacement_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowPos
JNIEXPORT jboolean JNICALL OS_NATIVE(SetWindowPos)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jint arg2, jint arg3, jint arg4, jint arg5, jint arg6)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowPos_FUNC);
	rc = (jboolean)SetWindowPos((HWND)arg0, (HWND)arg1, arg2, arg3, arg4, arg5, arg6);
	OS_NATIVE_EXIT(env, that, SetWindowPos_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowRgn
JNIEXPORT jint JNICALL OS_NATIVE(SetWindowRgn)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jboolean arg2)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowRgn_FUNC);
	rc = (jint)SetWindowRgn((HWND)arg0, (HRGN)arg1, arg2);
	OS_NATIVE_EXIT(env, that, SetWindowRgn_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowText
JNIEXPORT jboolean JNICALL OS_NATIVE(SetWindowText)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1)
{
	jchar *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowText_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)SetWindowText((HWND)arg0, (LPCWSTR)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SetWindowText_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowTheme
JNIEXPORT jint JNICALL OS_NATIVE(SetWindowTheme)
	(JNIEnv *env, jclass that, jlong arg0, jcharArray arg1, jcharArray arg2)
{
	jchar *lparg1=NULL;
	jchar *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowTheme_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetCharArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)SetWindowTheme((HWND)arg0, (LPCWSTR)lparg1, (LPCWSTR)lparg2);
fail:
	if (arg2 && lparg2) (*env)->ReleaseCharArrayElements(env, arg2, lparg2, JNI_ABORT);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SetWindowTheme_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWindowsHookEx
JNIEXPORT jlong JNICALL OS_NATIVE(SetWindowsHookEx)
	(JNIEnv *env, jclass that, jint arg0, jlong arg1, jlong arg2, jint arg3)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, SetWindowsHookEx_FUNC);
	rc = (jlong)SetWindowsHookEx(arg0, (HOOKPROC)arg1, (HINSTANCE)arg2, arg3);
	OS_NATIVE_EXIT(env, that, SetWindowsHookEx_FUNC);
	return rc;
}
#endif

#ifndef NO_SetWorldTransform
JNIEXPORT jboolean JNICALL OS_NATIVE(SetWorldTransform)
	(JNIEnv *env, jclass that, jlong arg0, jfloatArray arg1)
{
	jfloat *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SetWorldTransform_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetFloatArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)SetWorldTransform((HDC)arg0, (XFORM *)lparg1);
fail:
	if (arg1 && lparg1) (*env)->ReleaseFloatArrayElements(env, arg1, lparg1, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, SetWorldTransform_FUNC);
	return rc;
}
#endif

#ifndef NO_ShellExecuteEx
JNIEXPORT jboolean JNICALL OS_NATIVE(ShellExecuteEx)
	(JNIEnv *env, jclass that, jobject arg0)
{
	SHELLEXECUTEINFO _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ShellExecuteEx_FUNC);
	if (arg0) if ((lparg0 = getSHELLEXECUTEINFOFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)ShellExecuteEx(lparg0);
fail:
	if (arg0 && lparg0) setSHELLEXECUTEINFOFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, ShellExecuteEx_FUNC);
	return rc;
}
#endif

#ifndef NO_Shell_1NotifyIcon
JNIEXPORT jboolean JNICALL OS_NATIVE(Shell_1NotifyIcon)
	(JNIEnv *env, jclass that, jint arg0, jobject arg1)
{
	NOTIFYICONDATA _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, Shell_1NotifyIcon_FUNC);
	if (arg1) if ((lparg1 = getNOTIFYICONDATAFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)Shell_NotifyIcon(arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, Shell_1NotifyIcon_FUNC);
	return rc;
}
#endif

#ifndef NO_ShowCaret
JNIEXPORT jboolean JNICALL OS_NATIVE(ShowCaret)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ShowCaret_FUNC);
	rc = (jboolean)ShowCaret((HWND)arg0);
	OS_NATIVE_EXIT(env, that, ShowCaret_FUNC);
	return rc;
}
#endif

#ifndef NO_ShowOwnedPopups
JNIEXPORT jboolean JNICALL OS_NATIVE(ShowOwnedPopups)
	(JNIEnv *env, jclass that, jlong arg0, jboolean arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ShowOwnedPopups_FUNC);
	rc = (jboolean)ShowOwnedPopups((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, ShowOwnedPopups_FUNC);
	return rc;
}
#endif

#ifndef NO_ShowScrollBar
JNIEXPORT jboolean JNICALL OS_NATIVE(ShowScrollBar)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jboolean arg2)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ShowScrollBar_FUNC);
	rc = (jboolean)ShowScrollBar((HWND)arg0, arg1, arg2);
	OS_NATIVE_EXIT(env, that, ShowScrollBar_FUNC);
	return rc;
}
#endif

#ifndef NO_ShowWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(ShowWindow)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ShowWindow_FUNC);
	rc = (jboolean)ShowWindow((HWND)arg0, arg1);
	OS_NATIVE_EXIT(env, that, ShowWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_StartDoc
JNIEXPORT jint JNICALL OS_NATIVE(StartDoc)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	DOCINFO _arg1, *lparg1=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, StartDoc_FUNC);
	if (arg1) if ((lparg1 = getDOCINFOFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jint)StartDoc((HDC)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, StartDoc_FUNC);
	return rc;
}
#endif

#ifndef NO_StartPage
JNIEXPORT jint JNICALL OS_NATIVE(StartPage)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, StartPage_FUNC);
	rc = (jint)StartPage((HDC)arg0);
	OS_NATIVE_EXIT(env, that, StartPage_FUNC);
	return rc;
}
#endif

#ifndef NO_StretchBlt
JNIEXPORT jboolean JNICALL OS_NATIVE(StretchBlt)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, StretchBlt_FUNC);
	rc = (jboolean)StretchBlt((HDC)arg0, arg1, arg2, arg3, arg4, (HDC)arg5, arg6, arg7, arg8, arg9, arg10);
	OS_NATIVE_EXIT(env, that, StretchBlt_FUNC);
	return rc;
}
#endif

#ifndef NO_SystemParametersInfo__IILorg_eclipse_swt_internal_win32_HIGHCONTRAST_2I
JNIEXPORT jboolean JNICALL OS_NATIVE(SystemParametersInfo__IILorg_eclipse_swt_internal_win32_HIGHCONTRAST_2I)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jobject arg2, jint arg3)
{
	HIGHCONTRAST _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_HIGHCONTRAST_2I_FUNC);
	if (arg2) if ((lparg2 = getHIGHCONTRASTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)SystemParametersInfo(arg0, arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setHIGHCONTRASTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_HIGHCONTRAST_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_SystemParametersInfo__IILorg_eclipse_swt_internal_win32_NONCLIENTMETRICS_2I
JNIEXPORT jboolean JNICALL OS_NATIVE(SystemParametersInfo__IILorg_eclipse_swt_internal_win32_NONCLIENTMETRICS_2I)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jobject arg2, jint arg3)
{
	NONCLIENTMETRICS _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_NONCLIENTMETRICS_2I_FUNC);
	if (arg2) if ((lparg2 = getNONCLIENTMETRICSFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)SystemParametersInfo(arg0, arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setNONCLIENTMETRICSFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_NONCLIENTMETRICS_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_SystemParametersInfo__IILorg_eclipse_swt_internal_win32_RECT_2I
JNIEXPORT jboolean JNICALL OS_NATIVE(SystemParametersInfo__IILorg_eclipse_swt_internal_win32_RECT_2I)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jobject arg2, jint arg3)
{
	RECT _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
	if (arg2) if ((lparg2 = getRECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)SystemParametersInfo(arg0, arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setRECTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, SystemParametersInfo__IILorg_eclipse_swt_internal_win32_RECT_2I_FUNC);
	return rc;
}
#endif

#ifndef NO_SystemParametersInfo__II_3II
JNIEXPORT jboolean JNICALL OS_NATIVE(SystemParametersInfo__II_3II)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jintArray arg2, jint arg3)
{
	jint *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, SystemParametersInfo__II_3II_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jboolean)SystemParametersInfo(arg0, arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, SystemParametersInfo__II_3II_FUNC);
	return rc;
}
#endif

#ifndef NO_TBBUTTONINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TBBUTTONINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TBBUTTONINFO_1sizeof_FUNC);
	rc = (jint)TBBUTTONINFO_sizeof();
	OS_NATIVE_EXIT(env, that, TBBUTTONINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TBBUTTON_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TBBUTTON_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TBBUTTON_1sizeof_FUNC);
	rc = (jint)TBBUTTON_sizeof();
	OS_NATIVE_EXIT(env, that, TBBUTTON_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TCHITTESTINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TCHITTESTINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TCHITTESTINFO_1sizeof_FUNC);
	rc = (jint)TCHITTESTINFO_sizeof();
	OS_NATIVE_EXIT(env, that, TCHITTESTINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TCITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TCITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TCITEM_1sizeof_FUNC);
	rc = (jint)TCITEM_sizeof();
	OS_NATIVE_EXIT(env, that, TCITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TEXTMETRIC_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TEXTMETRIC_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TEXTMETRIC_1sizeof_FUNC);
	rc = (jint)TEXTMETRIC_sizeof();
	OS_NATIVE_EXIT(env, that, TEXTMETRIC_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TF_1DA_1COLOR_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TF_1DA_1COLOR_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TF_1DA_1COLOR_1sizeof_FUNC);
	rc = (jint)TF_DA_COLOR_sizeof();
	OS_NATIVE_EXIT(env, that, TF_1DA_1COLOR_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TF_1DISPLAYATTRIBUTE_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TF_1DISPLAYATTRIBUTE_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TF_1DISPLAYATTRIBUTE_1sizeof_FUNC);
	rc = (jint)TF_DISPLAYATTRIBUTE_sizeof();
	OS_NATIVE_EXIT(env, that, TF_1DISPLAYATTRIBUTE_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TOOLINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TOOLINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TOOLINFO_1sizeof_FUNC);
	rc = (jint)TOOLINFO_sizeof();
	OS_NATIVE_EXIT(env, that, TOOLINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TOUCHINPUT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TOUCHINPUT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TOUCHINPUT_1sizeof_FUNC);
	rc = (jint)TOUCHINPUT_sizeof();
	OS_NATIVE_EXIT(env, that, TOUCHINPUT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TRACKMOUSEEVENT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TRACKMOUSEEVENT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TRACKMOUSEEVENT_1sizeof_FUNC);
	rc = (jint)TRACKMOUSEEVENT_sizeof();
	OS_NATIVE_EXIT(env, that, TRACKMOUSEEVENT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TRIVERTEX_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TRIVERTEX_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TRIVERTEX_1sizeof_FUNC);
	rc = (jint)TRIVERTEX_sizeof();
	OS_NATIVE_EXIT(env, that, TRIVERTEX_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TVHITTESTINFO_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TVHITTESTINFO_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TVHITTESTINFO_1sizeof_FUNC);
	rc = (jint)TVHITTESTINFO_sizeof();
	OS_NATIVE_EXIT(env, that, TVHITTESTINFO_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TVINSERTSTRUCT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TVINSERTSTRUCT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TVINSERTSTRUCT_1sizeof_FUNC);
	rc = (jint)TVINSERTSTRUCT_sizeof();
	OS_NATIVE_EXIT(env, that, TVINSERTSTRUCT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TVITEM_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TVITEM_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TVITEM_1sizeof_FUNC);
	rc = (jint)TVITEM_sizeof();
	OS_NATIVE_EXIT(env, that, TVITEM_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_TVSORTCB_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(TVSORTCB_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TVSORTCB_1sizeof_FUNC);
	rc = (jint)TVSORTCB_sizeof();
	OS_NATIVE_EXIT(env, that, TVSORTCB_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_ToUnicode
JNIEXPORT jint JNICALL OS_NATIVE(ToUnicode)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jbyteArray arg2, jcharArray arg3, jint arg4, jint arg5)
{
	jbyte *lparg2=NULL;
	jchar *lparg3=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, ToUnicode_FUNC);
	if (arg2) if ((lparg2 = (*env)->GetByteArrayElements(env, arg2, NULL)) == NULL) goto fail;
	if (arg3) if ((lparg3 = (*env)->GetCharArrayElements(env, arg3, NULL)) == NULL) goto fail;
	rc = (jint)ToUnicode(arg0, arg1, (PBYTE)lparg2, (LPWSTR)lparg3, arg4, arg5);
fail:
	if (arg3 && lparg3) (*env)->ReleaseCharArrayElements(env, arg3, lparg3, 0);
	if (arg2 && lparg2) (*env)->ReleaseByteArrayElements(env, arg2, lparg2, 0);
	OS_NATIVE_EXIT(env, that, ToUnicode_FUNC);
	return rc;
}
#endif

#ifndef NO_TrackMouseEvent
JNIEXPORT jboolean JNICALL OS_NATIVE(TrackMouseEvent)
	(JNIEnv *env, jclass that, jobject arg0)
{
	TRACKMOUSEEVENT _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TrackMouseEvent_FUNC);
	if (arg0) if ((lparg0 = getTRACKMOUSEEVENTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)TrackMouseEvent(lparg0);
fail:
	if (arg0 && lparg0) setTRACKMOUSEEVENTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, TrackMouseEvent_FUNC);
	return rc;
}
#endif

#ifndef NO_TrackPopupMenu
JNIEXPORT jboolean JNICALL OS_NATIVE(TrackPopupMenu)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jobject arg6)
{
	RECT _arg6, *lparg6=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TrackPopupMenu_FUNC);
	if (arg6) if ((lparg6 = getRECTFields(env, arg6, &_arg6)) == NULL) goto fail;
	rc = (jboolean)TrackPopupMenu((HMENU)arg0, arg1, arg2, arg3, arg4, (HWND)arg5, lparg6);
fail:
	if (arg6 && lparg6) setRECTFields(env, arg6, lparg6);
	OS_NATIVE_EXIT(env, that, TrackPopupMenu_FUNC);
	return rc;
}
#endif

#ifndef NO_TranslateAccelerator
JNIEXPORT jint JNICALL OS_NATIVE(TranslateAccelerator)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2)
{
	MSG _arg2, *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, TranslateAccelerator_FUNC);
	if (arg2) if ((lparg2 = getMSGFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jint)TranslateAccelerator((HWND)arg0, (HACCEL)arg1, lparg2);
fail:
	if (arg2 && lparg2) setMSGFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, TranslateAccelerator_FUNC);
	return rc;
}
#endif

#ifndef NO_TranslateCharsetInfo
JNIEXPORT jboolean JNICALL OS_NATIVE(TranslateCharsetInfo)
	(JNIEnv *env, jclass that, jlong arg0, jintArray arg1, jint arg2)
{
	jint *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TranslateCharsetInfo_FUNC);
	if (arg1) if ((lparg1 = (*env)->GetIntArrayElements(env, arg1, NULL)) == NULL) goto fail;
	rc = (jboolean)TranslateCharsetInfo((DWORD *)arg0, (LPCHARSETINFO)lparg1, arg2);
fail:
	if (arg1 && lparg1) (*env)->ReleaseIntArrayElements(env, arg1, lparg1, 0);
	OS_NATIVE_EXIT(env, that, TranslateCharsetInfo_FUNC);
	return rc;
}
#endif

#ifndef NO_TranslateMDISysAccel
JNIEXPORT jboolean JNICALL OS_NATIVE(TranslateMDISysAccel)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	MSG _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TranslateMDISysAccel_FUNC);
	if (arg1) if ((lparg1 = getMSGFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)TranslateMDISysAccel((HWND)arg0, (LPMSG)lparg1);
fail:
	if (arg1 && lparg1) setMSGFields(env, arg1, lparg1);
	OS_NATIVE_EXIT(env, that, TranslateMDISysAccel_FUNC);
	return rc;
}
#endif

#ifndef NO_TranslateMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(TranslateMessage)
	(JNIEnv *env, jclass that, jobject arg0)
{
	MSG _arg0, *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TranslateMessage_FUNC);
	if (arg0) if ((lparg0 = getMSGFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jboolean)TranslateMessage(lparg0);
fail:
	if (arg0 && lparg0) setMSGFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, TranslateMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_TransparentBlt
JNIEXPORT jboolean JNICALL OS_NATIVE(TransparentBlt)
	(JNIEnv *env, jclass that, jlong arg0, jint arg1, jint arg2, jint arg3, jint arg4, jlong arg5, jint arg6, jint arg7, jint arg8, jint arg9, jint arg10)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TransparentBlt_FUNC);
	rc = (jboolean)TransparentBlt((HDC)arg0, arg1, arg2, arg3, arg4, (HDC)arg5, arg6, arg7, arg8, arg9, arg10);
	OS_NATIVE_EXIT(env, that, TransparentBlt_FUNC);
	return rc;
}
#endif

#ifndef NO_TreeView_1GetItemRect
JNIEXPORT jboolean JNICALL OS_NATIVE(TreeView_1GetItemRect)
	(JNIEnv *env, jclass that, jlong arg0, jlong arg1, jobject arg2, jboolean arg3)
{
	RECT _arg2, *lparg2=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, TreeView_1GetItemRect_FUNC);
	if (arg2) if ((lparg2 = getRECTFields(env, arg2, &_arg2)) == NULL) goto fail;
	rc = (jboolean)TreeView_GetItemRect((HWND)arg0, (HTREEITEM)arg1, lparg2, arg3);
fail:
	if (arg2 && lparg2) setRECTFields(env, arg2, lparg2);
	OS_NATIVE_EXIT(env, that, TreeView_1GetItemRect_FUNC);
	return rc;
}
#endif

#ifndef NO_UDACCEL_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(UDACCEL_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, UDACCEL_1sizeof_FUNC);
	rc = (jint)UDACCEL_sizeof();
	OS_NATIVE_EXIT(env, that, UDACCEL_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_UnhookWindowsHookEx
JNIEXPORT jboolean JNICALL OS_NATIVE(UnhookWindowsHookEx)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, UnhookWindowsHookEx_FUNC);
	rc = (jboolean)UnhookWindowsHookEx((HHOOK)arg0);
	OS_NATIVE_EXIT(env, that, UnhookWindowsHookEx_FUNC);
	return rc;
}
#endif

#ifndef NO_UnmapViewOfFile
JNIEXPORT jboolean JNICALL OS_NATIVE(UnmapViewOfFile)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, UnmapViewOfFile_FUNC);
	rc = (jboolean)UnmapViewOfFile((LPCVOID)arg0);
	OS_NATIVE_EXIT(env, that, UnmapViewOfFile_FUNC);
	return rc;
}
#endif

#ifndef NO_UnregisterClass
JNIEXPORT jboolean JNICALL OS_NATIVE(UnregisterClass)
	(JNIEnv *env, jclass that, jcharArray arg0, jlong arg1)
{
	jchar *lparg0=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, UnregisterClass_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	rc = (jboolean)UnregisterClass((LPCWSTR)lparg0, (HINSTANCE)arg1);
fail:
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, UnregisterClass_FUNC);
	return rc;
}
#endif

#ifndef NO_UnregisterTouchWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(UnregisterTouchWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, UnregisterTouchWindow_FUNC);
	rc = (jboolean)UnregisterTouchWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, UnregisterTouchWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_UpdateWindow
JNIEXPORT jboolean JNICALL OS_NATIVE(UpdateWindow)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, UpdateWindow_FUNC);
	rc = (jboolean)UpdateWindow((HWND)arg0);
	OS_NATIVE_EXIT(env, that, UpdateWindow_FUNC);
	return rc;
}
#endif

#ifndef NO_UrlCreateFromPath
JNIEXPORT jint JNICALL OS_NATIVE(UrlCreateFromPath)
	(JNIEnv *env, jclass that, jcharArray arg0, jcharArray arg1, jintArray arg2, jint arg3)
{
	jchar *lparg0=NULL;
	jchar *lparg1=NULL;
	jint *lparg2=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, UrlCreateFromPath_FUNC);
	if (arg0) if ((lparg0 = (*env)->GetCharArrayElements(env, arg0, NULL)) == NULL) goto fail;
	if (arg1) if ((lparg1 = (*env)->GetCharArrayElements(env, arg1, NULL)) == NULL) goto fail;
	if (arg2) if ((lparg2 = (*env)->GetIntArrayElements(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)UrlCreateFromPath((LPCWSTR)lparg0, (LPWSTR)lparg1, (DWORD *)lparg2, arg3);
fail:
	if (arg2 && lparg2) (*env)->ReleaseIntArrayElements(env, arg2, lparg2, 0);
	if (arg1 && lparg1) (*env)->ReleaseCharArrayElements(env, arg1, lparg1, 0);
	if (arg0 && lparg0) (*env)->ReleaseCharArrayElements(env, arg0, lparg0, JNI_ABORT);
	OS_NATIVE_EXIT(env, that, UrlCreateFromPath_FUNC);
	return rc;
}
#endif

#ifndef NO_ValidateRect
JNIEXPORT jboolean JNICALL OS_NATIVE(ValidateRect)
	(JNIEnv *env, jclass that, jlong arg0, jobject arg1)
{
	RECT _arg1, *lparg1=NULL;
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, ValidateRect_FUNC);
	if (arg1) if ((lparg1 = getRECTFields(env, arg1, &_arg1)) == NULL) goto fail;
	rc = (jboolean)ValidateRect((HWND)arg0, lparg1);
fail:
	OS_NATIVE_EXIT(env, that, ValidateRect_FUNC);
	return rc;
}
#endif

#ifndef NO_VkKeyScan
JNIEXPORT jshort JNICALL OS_NATIVE(VkKeyScan)
	(JNIEnv *env, jclass that, jshort arg0)
{
	jshort rc = 0;
	OS_NATIVE_ENTER(env, that, VkKeyScan_FUNC);
	rc = (jshort)VkKeyScan((WCHAR)arg0);
	OS_NATIVE_EXIT(env, that, VkKeyScan_FUNC);
	return rc;
}
#endif

#ifndef NO_WINDOWPLACEMENT_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(WINDOWPLACEMENT_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, WINDOWPLACEMENT_1sizeof_FUNC);
	rc = (jint)WINDOWPLACEMENT_sizeof();
	OS_NATIVE_EXIT(env, that, WINDOWPLACEMENT_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_WINDOWPOS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(WINDOWPOS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, WINDOWPOS_1sizeof_FUNC);
	rc = (jint)WINDOWPOS_sizeof();
	OS_NATIVE_EXIT(env, that, WINDOWPOS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_WNDCLASS_1sizeof
JNIEXPORT jint JNICALL OS_NATIVE(WNDCLASS_1sizeof)
	(JNIEnv *env, jclass that)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, WNDCLASS_1sizeof_FUNC);
	rc = (jint)WNDCLASS_sizeof();
	OS_NATIVE_EXIT(env, that, WNDCLASS_1sizeof_FUNC);
	return rc;
}
#endif

#ifndef NO_WaitMessage
JNIEXPORT jboolean JNICALL OS_NATIVE(WaitMessage)
	(JNIEnv *env, jclass that)
{
	jboolean rc = 0;
	OS_NATIVE_ENTER(env, that, WaitMessage_FUNC);
	rc = (jboolean)WaitMessage();
	OS_NATIVE_EXIT(env, that, WaitMessage_FUNC);
	return rc;
}
#endif

#ifndef NO_WideCharToMultiByte__II_3CIJI_3B_3I
JNIEXPORT jint JNICALL OS_NATIVE(WideCharToMultiByte__II_3CIJI_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jcharArray arg2, jint arg3, jlong arg4, jint arg5, jbyteArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jbyte *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, WideCharToMultiByte__II_3CIJI_3B_3I_FUNC);
	if (arg6) if ((lparg6 = (*env)->GetByteArrayElements(env, arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetIntArrayElements(env, arg7, NULL)) == NULL) goto fail;
		if (arg2) if ((lparg2 = (*env)->GetPrimitiveArrayCritical(env, arg2, NULL)) == NULL) goto fail;
	rc = (jint)WideCharToMultiByte(arg0, arg1, (LPCWSTR)lparg2, arg3, (LPSTR)arg4, arg5, (LPCSTR)lparg6, (LPBOOL)lparg7);
fail:
		if (arg2 && lparg2) (*env)->ReleasePrimitiveArrayCritical(env, arg2, lparg2, JNI_ABORT);
	if (arg7 && lparg7) (*env)->ReleaseIntArrayElements(env, arg7, lparg7, 0);
	if (arg6 && lparg6) (*env)->ReleaseByteArrayElements(env, arg6, lparg6, 0);
	OS_NATIVE_EXIT(env, that, WideCharToMultiByte__II_3CIJI_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_WideCharToMultiByte__II_3CI_3BI_3B_3I
JNIEXPORT jint JNICALL OS_NATIVE(WideCharToMultiByte__II_3CI_3BI_3B_3I)
	(JNIEnv *env, jclass that, jint arg0, jint arg1, jcharArray arg2, jint arg3, jbyteArray arg4, jint arg5, jbyteArray arg6, jintArray arg7)
{
	jchar *lparg2=NULL;
	jbyte *lparg4=NULL;
	jbyte *lparg6=NULL;
	jint *lparg7=NULL;
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, WideCharToMultiByte__II_3CI_3BI_3B_3I_FUNC);
	if (arg6) if ((lparg6 = (*env)->GetByteArrayElements(env, arg6, NULL)) == NULL) goto fail;
	if (arg7) if ((lparg7 = (*env)->GetIntArrayElements(env, arg7, NULL)) == NULL) goto fail;
		if (arg2) if ((lparg2 = (*env)->GetPrimitiveArrayCritical(env, arg2, NULL)) == NULL) goto fail;
		if (arg4) if ((lparg4 = (*env)->GetPrimitiveArrayCritical(env, arg4, NULL)) == NULL) goto fail;
	rc = (jint)WideCharToMultiByte(arg0, arg1, (LPCWSTR)lparg2, arg3, (LPSTR)lparg4, arg5, (LPCSTR)lparg6, (LPBOOL)lparg7);
fail:
		if (arg4 && lparg4) (*env)->ReleasePrimitiveArrayCritical(env, arg4, lparg4, 0);
		if (arg2 && lparg2) (*env)->ReleasePrimitiveArrayCritical(env, arg2, lparg2, JNI_ABORT);
	if (arg7 && lparg7) (*env)->ReleaseIntArrayElements(env, arg7, lparg7, 0);
	if (arg6 && lparg6) (*env)->ReleaseByteArrayElements(env, arg6, lparg6, 0);
	OS_NATIVE_EXIT(env, that, WideCharToMultiByte__II_3CI_3BI_3B_3I_FUNC);
	return rc;
}
#endif

#ifndef NO_WindowFromDC
JNIEXPORT jlong JNICALL OS_NATIVE(WindowFromDC)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, WindowFromDC_FUNC);
	rc = (jlong)WindowFromDC((HDC)arg0);
	OS_NATIVE_EXIT(env, that, WindowFromDC_FUNC);
	return rc;
}
#endif

#ifndef NO_WindowFromPoint
JNIEXPORT jlong JNICALL OS_NATIVE(WindowFromPoint)
	(JNIEnv *env, jclass that, jobject arg0)
{
	POINT _arg0, *lparg0=NULL;
	jlong rc = 0;
	OS_NATIVE_ENTER(env, that, WindowFromPoint_FUNC);
	if (arg0) if ((lparg0 = getPOINTFields(env, arg0, &_arg0)) == NULL) goto fail;
	rc = (jlong)WindowFromPoint(*lparg0);
fail:
	if (arg0 && lparg0) setPOINTFields(env, arg0, lparg0);
	OS_NATIVE_EXIT(env, that, WindowFromPoint_FUNC);
	return rc;
}
#endif

#ifndef NO_wcslen
JNIEXPORT jint JNICALL OS_NATIVE(wcslen)
	(JNIEnv *env, jclass that, jlong arg0)
{
	jint rc = 0;
	OS_NATIVE_ENTER(env, that, wcslen_FUNC);
	rc = (jint)wcslen((const wchar_t *)arg0);
	OS_NATIVE_EXIT(env, that, wcslen_FUNC);
	return rc;
}
#endif

