/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.business.internal.tool;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sirius.business.api.helper.task.InitInterpreterVariablesTask;
import org.eclipse.sirius.business.api.helper.task.TaskHelper;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.sequence.SequenceDDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.SequenceDiagram;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.description.MessageEndVariable;
import org.eclipse.sirius.diagram.sequence.description.tool.CombinedFragmentCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ExecutionCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InstanceRoleReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.InteractionUseCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.MessageCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ObservationPointCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.OperandCreationTool;
import org.eclipse.sirius.diagram.sequence.description.tool.ReorderTool;
import org.eclipse.sirius.diagram.sequence.description.tool.StateCreationTool;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.ExecutionCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.FrameCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.InstanceRoleCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.MessageCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.ObservationPointCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.OperandCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceGenericToolCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequencePaneBasedSelectionWizardCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.SequenceSelectionWizardCommandBuilder;
import org.eclipse.sirius.diagram.sequence.internal.tool.command.builders.StateCreationCommandBuilder;
import org.eclipse.sirius.diagram.sequence.ordering.EventEnd;
import org.eclipse.sirius.diagram.sequence.ordering.SingleEventEnd;
import org.eclipse.sirius.diagram.ui.tools.internal.commands.emf.EMFCommandFactoryUI;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.CommandBuilder;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.tool.ElementVariable;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;

public final class ToolCommandBuilder {
    private ToolCommandBuilder() {
    }

    public static SiriusCommand buildReorderCommand(SequenceDDiagram sequenceDDiagram, ReorderTool reorderTool, EObject event, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(event);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)event);
        SiriusCommand result = new SiriusCommand(domain, new IdentifiedElementQuery((IdentifiedElement)reorderTool).getLabel());
        if (reorderTool.getOnEventMovedOperation().getFirstModelOperations() != null) {
            result.getTasks().add(ToolCommandBuilder.buildVariablesInitializationTask(reorderTool, event, startingEndPredecessor, finishingEndPredecessor));
            TaskHelper taskHelper = new TaskHelper(modelAccessor, (UICallBack)new EMFCommandFactoryUI());
            result.getTasks().add(taskHelper.buildTaskFromModelOperation((DRepresentation)sequenceDDiagram, event, reorderTool.getOnEventMovedOperation().getFirstModelOperations()));
        }
        return result;
    }

    private static InitInterpreterVariablesTask buildVariablesInitializationTask(ReorderTool reorderTool, EObject event, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        HashMap<MessageEndVariable, EventEnd> variables = new HashMap<MessageEndVariable, EventEnd>();
        variables.put(reorderTool.getStartingEndPredecessorAfter(), startingEndPredecessor);
        variables.put(reorderTool.getFinishingEndPredecessorAfter(), finishingEndPredecessor);
        return new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)event), null);
    }

    public static SiriusCommand buildInstanceRoleReorderCommand(SequenceDDiagram sequenceDDiagram, InstanceRoleReorderTool reorderTool, EObject element, EObject predecessorBefore, EObject predecessorAfter) {
        ModelAccessor modelAccessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(element);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)element);
        SiriusCommand result = new SiriusCommand(domain, new IdentifiedElementQuery((IdentifiedElement)reorderTool).getLabel());
        if (reorderTool.getInstanceRoleMoved().getFirstModelOperations() != null) {
            result.getTasks().add(ToolCommandBuilder.buildVariablesInitializationTask(reorderTool, element, predecessorBefore, predecessorAfter));
            TaskHelper taskHelper = new TaskHelper(modelAccessor, (UICallBack)new EMFCommandFactoryUI());
            result.getTasks().add(taskHelper.buildTaskFromModelOperation((DRepresentation)sequenceDDiagram, element, reorderTool.getInstanceRoleMoved().getFirstModelOperations()));
        }
        return result;
    }

    private static InitInterpreterVariablesTask buildVariablesInitializationTask(InstanceRoleReorderTool reorderTool, EObject element, EObject predecessorBefore, EObject predecessorAfter) {
        HashMap<ElementVariable, EObject> variables = new HashMap<ElementVariable, EObject>();
        variables.put(reorderTool.getPredecessorBefore(), predecessorBefore);
        variables.put(reorderTool.getPredecessorAfter(), predecessorAfter);
        return new InitInterpreterVariablesTask(variables, InterpreterUtil.getInterpreter((EObject)element), null);
    }

    public static Command buildCreateMessageCommand(EdgeTarget source, EdgeTarget target, MessageCreationTool tool, EventEnd startingEndBefore, EventEnd finishingEndBefore) {
        MessageCreationCommandBuilder builder = new MessageCreationCommandBuilder(tool, source, target, startingEndBefore, finishingEndBefore);
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, (EObject)source);
    }

    private static Command getCommand(CommandBuilder builder, EObject dObject) {
        ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(dObject);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)dObject);
        EMFCommandFactoryUI uiCallback = new EMFCommandFactoryUI();
        builder.init(accessor, domain, (UICallBack)uiCallback);
        return builder.buildCommand();
    }

    private static Command getCommand(CommandBuilder builder, Session session) {
        EMFCommandFactoryUI uiCallback = new EMFCommandFactoryUI();
        builder.init(session.getModelAccessor(), session.getTransactionalEditingDomain(), (UICallBack)uiCallback);
        return builder.buildCommand();
    }

    public static Command buildCreateInstanceRoleCommandFromTool(DDiagram diagram, InstanceRoleCreationTool tool, EObject predecessor, Point location) {
        InstanceRoleCreationCommandBuilder builder = new InstanceRoleCreationCommandBuilder(tool, diagram, predecessor, location);
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, (EObject)diagram);
    }

    public static Command buildCreateExecutionCommandFromTool(DNode node, ExecutionCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, Point location) {
        ExecutionCreationCommandBuilder builder = new ExecutionCreationCommandBuilder(tool, node, startingEndPredecessor, finishingEndPredecessor, location);
        Session session = SessionManager.INSTANCE.getSession(node.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }

    public static Command buildCreateObservationPointCommandFromTool(DDiagramElement diagramElement, ObservationPointCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        ObservationPointCreationCommandBuilder builder = new ObservationPointCreationCommandBuilder(tool, diagramElement, startingEndPredecessor, finishingEndPredecessor);
        Session session = SessionManager.INSTANCE.getSession(diagramElement.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }

    public static Command buildCreateObservationPointCommandFromTool(DDiagram diagram, ObservationPointCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        ObservationPointCreationCommandBuilder builder = new ObservationPointCreationCommandBuilder(tool, diagram, startingEndPredecessor, finishingEndPredecessor);
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, (EObject)diagram);
    }

    public static Command buildCreateStateCommandFromTool(DNode node, StateCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        StateCreationCommandBuilder builder = new StateCreationCommandBuilder(tool, node, startingEndPredecessor, finishingEndPredecessor);
        Session session = SessionManager.INSTANCE.getSession(node.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }

    public static Command buildCreateInteractionUseCommandFromTool(DDiagram diagram, InteractionUseCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<EObject> coverage) {
        return ToolCommandBuilder.buildCreateFrameCommandFromTool(diagram, tool, startingEndPredecessor, finishingEndPredecessor, coverage);
    }

    public static Command buildCreateCombinedFragmentCommandFromTool(DDiagram diagram, CombinedFragmentCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<EObject> coverage) {
        return ToolCommandBuilder.buildCreateFrameCommandFromTool(diagram, tool, startingEndPredecessor, finishingEndPredecessor, coverage);
    }

    private static Command buildCreateFrameCommandFromTool(DDiagram diagram, ContainerCreationDescription tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor, List<EObject> coverage) {
        FrameCreationCommandBuilder builder = new FrameCreationCommandBuilder(tool, diagram, startingEndPredecessor, finishingEndPredecessor, coverage);
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, (EObject)diagram);
    }

    public static Command buildCreateOperantCommandFromTool(DDiagramElementContainer nodeContainer, OperandCreationTool tool, EventEnd startingEndPredecessor, EventEnd finishingEndPredecessor) {
        OperandCreationCommandBuilder builder = new OperandCreationCommandBuilder(tool, nodeContainer, startingEndPredecessor, finishingEndPredecessor);
        Session session = SessionManager.INSTANCE.getSession(nodeContainer.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }

    public static boolean isStartingEventEndOfCombinedFragment(SequenceDiagram sequenceDiagram, EventEnd startingEndPredecessor) {
        if (sequenceDiagram != null && startingEndPredecessor instanceof SingleEventEnd && ((SingleEventEnd)startingEndPredecessor).isStart()) {
            ISequenceEvent ise = EventEndHelper.findISequenceEvent((SingleEventEnd)startingEndPredecessor, sequenceDiagram);
            return ise instanceof CombinedFragment;
        }
        return false;
    }

    public static Command buildSequenceGenericToolCommandFromTool(EObject containerView, ToolDescription tool, EventEnd endBefore, Point location, Diagram diagram) {
        SequenceGenericToolCommandBuilder builder = new SequenceGenericToolCommandBuilder(tool, containerView, endBefore, location, diagram);
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, containerView);
    }

    public static Command buildSequencePaneBasedSelectionWizardCommandFromTool(PaneBasedSelectionWizardDescription tool, DSemanticDecorator dContainer, Collection<EObject> selectedElement, EventEnd endBefore, Point location) {
        SequencePaneBasedSelectionWizardCommandBuilder builder = new SequencePaneBasedSelectionWizardCommandBuilder(tool, dContainer, selectedElement, endBefore, location);
        Session session = SessionManager.INSTANCE.getSession(dContainer.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }

    public static Command buildSequenceSelectionWizardCommandFromTool(SelectionWizardDescription tool, DSemanticDecorator dContainer, Collection<EObject> selectedElement, EventEnd endBefore, Point location) {
        SequenceSelectionWizardCommandBuilder builder = new SequenceSelectionWizardCommandBuilder(tool, dContainer, selectedElement, endBefore, location);
        Session session = SessionManager.INSTANCE.getSession(dContainer.getTarget());
        return ToolCommandBuilder.getCommand((CommandBuilder)builder, session);
    }
}

