/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.infra.tools.databinding.AggregatedObservable;
import org.eclipse.papyrus.infra.widgets.providers.ComboLabelProvider;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.papyrus.infra.widgets.providers.UnsetObject;

public class ComboObservableValue
extends AbstractObservableValue
implements ISelectionChangedListener {
    protected ComboViewer viewer;
    protected Object currentValue;
    protected AggregatedObservable modelProperty;

    public ComboObservableValue(ComboViewer viewer, IObservableValue modelProperty) {
        this.viewer = viewer;
        viewer.setLabelProvider((IBaseLabelProvider)new ComboLabelProvider(viewer.getLabelProvider()));
        if (modelProperty instanceof AggregatedObservable) {
            this.modelProperty = (AggregatedObservable)modelProperty;
        }
        viewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public Object getValueType() {
        return Object.class;
    }

    protected Object doGetValue() {
        ISelection selection = this.viewer.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement == UnsetObject.instance) {
                return null;
            }
            if (firstElement == UnchangedObject.instance) {
                return null;
            }
            return firstElement;
        }
        return null;
    }

    protected void doSetValue(Object value) {
        this.currentValue = value;
        if (this.modelProperty != null && this.modelProperty.hasDifferentValues()) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)UnchangedObject.instance));
        } else if (value == null) {
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)UnsetObject.instance));
        } else {
            this.viewer.setSelection((ISelection)new StructuredSelection(value));
        }
    }

    public synchronized void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        super.dispose();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (((IStructuredSelection)event.getSelection()).getFirstElement() != UnchangedObject.instance) {
            Object newValue;
            final Object oldValue = this.currentValue;
            this.currentValue = newValue = this.doGetValue();
            this.fireValueChange(new ValueDiff(){

                public Object getOldValue() {
                    return oldValue;
                }

                public Object getNewValue() {
                    return newValue;
                }
            });
        }
    }
}

