/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.nattable.provider;

import org.eclipse.core.runtime.Assert;
import org.eclipse.papyrus.infra.emf.nattable.provider.EMFEObjectHeaderLabelProvider;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TreeFillingConfiguration;
import org.eclipse.papyrus.infra.nattable.utils.LabelProviderCellContextElementWrapper;
import org.eclipse.papyrus.infra.nattable.utils.NattableConfigAttributes;
import org.eclipse.papyrus.infra.widgets.Activator;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractEmptyLineRowHeaderLabelProvider
extends EMFEObjectHeaderLabelProvider {
    private final String kindId;

    public AbstractEmptyLineRowHeaderLabelProvider(String tableKind) {
        Assert.isNotNull((Object)tableKind);
        Assert.isTrue((!tableKind.isEmpty() ? 1 : 0) != 0);
        this.kindId = tableKind;
    }

    @Override
    public boolean accept(Object element) {
        String currentTableKindId = "";
        if (element instanceof LabelProviderCellContextElementWrapper) {
            LabelProviderCellContextElementWrapper wrapper = (LabelProviderCellContextElementWrapper)element;
            INattableModelManager manager = (INattableModelManager)wrapper.getConfigRegistry().getConfigAttribute(NattableConfigAttributes.NATTABLE_MODEL_MANAGER_CONFIG_ATTRIBUTE, "NORMAL", new String[]{"nattable_model_manager_id"});
            currentTableKindId = manager.getTable().getTableKindId();
            element = ((LabelProviderCellContextElementWrapper)element).getObject();
        }
        return this.kindId.equals(currentTableKindId) && element instanceof ITreeItemAxis && ((ITreeItemAxis)element).getElement() == null;
    }

    @Override
    public String getText(Object element) {
        ITreeItemAxis axis;
        ITreeItemAxis parentAxis;
        Object parentElement;
        if (element instanceof LabelProviderCellContextElementWrapper) {
            element = ((LabelProviderCellContextElementWrapper)element).getObject();
        }
        if (element instanceof ITreeItemAxis && (parentElement = (parentAxis = (axis = (ITreeItemAxis)element).getParent()).getElement()) instanceof TreeFillingConfiguration) {
            TreeFillingConfiguration conf = (TreeFillingConfiguration)parentElement;
            return this.getCreationHeaderMessage(conf);
        }
        return "";
    }

    protected abstract String getCreationHeaderMessage(TreeFillingConfiguration var1);

    @Override
    public Image getImage(Object element) {
        return Activator.getDefault().getImage("/icons/Add_12x12.gif");
    }
}

