/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.build.elements;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.examples.xtext.build.elements.AbstractSerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.AlternativesSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.ListOfSerializationNode;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationElement;
import org.eclipse.ocl.examples.xtext.build.elements.SerializationNode;
import org.eclipse.ocl.examples.xtext.serializer.DiagnosticStringBuilder;
import org.eclipse.ocl.examples.xtext.serializer.GrammarCardinality;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.Alternatives;
import org.eclipse.xtext.CompoundElement;

public class ListOfListOfSerializationNode
extends AbstractSerializationElement {
    private @NonNull List<@NonNull List<@NonNull SerializationNode>> listOfListOfNodes;

    public ListOfListOfSerializationNode() {
        this.listOfListOfNodes = new ArrayList<List<SerializationNode>>();
    }

    public ListOfListOfSerializationNode(@NonNull List<@NonNull List<@NonNull SerializationNode>> listOfListOfNodes) {
        this.listOfListOfNodes = listOfListOfNodes;
        assert (listOfListOfNodes.size() < 20);
    }

    @Override
    public @NonNull ListOfListOfSerializationNode addConcatenation(@NonNull SerializationElement additionalSerializationElement) {
        if (additionalSerializationElement.isNull()) {
            return this;
        }
        if (additionalSerializationElement.isNode()) {
            SerializationNode additionalSerializationNode = additionalSerializationElement.asNode();
            for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
                this.appendNodeToList(listOfNodes, additionalSerializationNode);
            }
            return this;
        }
        if (additionalSerializationElement.isList()) {
            ListOfSerializationNode additionalListOfNodes = additionalSerializationElement.asList();
            List<@NonNull SerializationNode> additionalNodes = additionalListOfNodes.getNodes();
            for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
                for (SerializationNode additionalNode : additionalNodes) {
                    this.appendNodeToList(listOfNodes, additionalNode);
                }
            }
            return this;
        }
        if (additionalSerializationElement.isListOfList()) {
            ArrayList<@NonNull List<@NonNull SerializationNode>> newListOfList = new ArrayList<List<SerializationNode>>();
            List<@NonNull List<@NonNull SerializationNode>> additionalListOfListOfNodes = additionalSerializationElement.asListOfList().getLists();
            if (this.listOfListOfNodes.size() > 0) {
                for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
                    for (List<SerializationNode> additionalListOfNodes : additionalListOfListOfNodes) {
                        ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>(listOfNodes);
                        newList.addAll(additionalListOfNodes);
                        newListOfList.add(newList);
                    }
                }
            } else {
                newListOfList.addAll(additionalListOfListOfNodes);
            }
            return new ListOfListOfSerializationNode(newListOfList);
        }
        throw new UnsupportedOperationException();
    }

    public @NonNull ListOfListOfSerializationNode addConjunction(@NonNull SerializationElement additionalSerializationElement) {
        if (additionalSerializationElement.isNull()) {
            this.listOfListOfNodes.add(new ArrayList());
            return this;
        }
        if (additionalSerializationElement.isNode()) {
            this.appendNodeToListOfList(this.listOfListOfNodes, additionalSerializationElement.asNode());
            return this;
        }
        if (additionalSerializationElement.isList()) {
            throw new IllegalStateException();
        }
        if (additionalSerializationElement.isListOfList()) {
            List<@NonNull List<@NonNull SerializationNode>> additionalListOfListOfNodes = additionalSerializationElement.asListOfList().getLists();
            this.listOfListOfNodes.addAll(additionalListOfListOfNodes);
            return this;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull ListOfListOfSerializationNode asListOfList() {
        return this;
    }

    @Override
    public @NonNull SerializationNode freezeAlternatives(@NonNull Alternatives alternatives) {
        ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>();
        for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
            assert (listOfNodes.size() == 1);
            newList.add(listOfNodes.get(0));
        }
        return new AlternativesSerializationNode(alternatives, GrammarCardinality.toEnum((AbstractElement)alternatives), newList);
    }

    @Override
    public @NonNull SerializationElement freezeSequences(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality, boolean isRootAlternative) {
        ArrayList<@NonNull List<@NonNull SerializationNode>> newListOfList = new ArrayList<List<SerializationNode>>();
        for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
            SerializationElement frozenSequence = ListOfListOfSerializationNode.createFrozenSequence(compoundElement, grammarCardinality, listOfNodes, isRootAlternative);
            if (frozenSequence.isListOfList()) {
                newListOfList.addAll(frozenSequence.asListOfList().getLists());
                continue;
            }
            if (frozenSequence.isList()) {
                newListOfList.add(frozenSequence.asList().getNodes());
                continue;
            }
            if (frozenSequence.isNode()) {
                this.appendNodeToListOfList(newListOfList, frozenSequence.asNode());
                continue;
            }
            throw new UnsupportedOperationException();
        }
        this.listOfListOfNodes = newListOfList;
        return this;
    }

    public @NonNull List<@NonNull List<@NonNull SerializationNode>> getLists() {
        return this.listOfListOfNodes;
    }

    @Override
    public boolean isListOfList() {
        return true;
    }

    @Override
    public boolean noUnassignedParserRuleCall() {
        for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
            for (SerializationNode serializationNode : listOfNodes) {
                if (serializationNode.noUnassignedParserRuleCall()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean onlyRootUnassignedSerializationRuleCall(boolean isRootAlternative) {
        for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
            for (SerializationNode serializationNode : listOfNodes) {
                if (serializationNode.onlyRootUnassignedSerializationRuleCall(isRootAlternative)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public @NonNull SerializationElement setGrammarCardinality(@NonNull CompoundElement compoundElement, @NonNull GrammarCardinality grammarCardinality) {
        if (grammarCardinality.isOne()) {
            return this;
        }
        ArrayList<@NonNull List<@NonNull SerializationNode>> newListOfList = new ArrayList<List<SerializationNode>>();
        if (this.listOfListOfNodes.size() > 0) {
            for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
                ArrayList<@NonNull SerializationNode> newList = new ArrayList<SerializationNode>(listOfNodes.size());
                for (SerializationNode node : listOfNodes) {
                    newList.add(node.setGrammarCardinality(compoundElement, grammarCardinality));
                    newListOfList.add(newList);
                }
            }
        }
        return new ListOfListOfSerializationNode(newListOfList);
    }

    @Override
    public void toString(@NonNull DiagnosticStringBuilder s, int depth) {
        s.append("{");
        if (this.listOfListOfNodes.size() > 0) {
            for (List<SerializationNode> listOfNodes : this.listOfListOfNodes) {
                s.appendIndentation(depth);
                s.append("|\t{");
                if (listOfNodes.size() > 0) {
                    for (SerializationNode serializationNode : listOfNodes) {
                        s.appendIndentation(depth + 1);
                        s.append("+\t");
                        serializationNode.toString(s, depth + 2);
                    }
                    s.appendIndentation(depth + 1);
                }
                s.append("}");
            }
            s.appendIndentation(depth);
        }
        s.append("}");
    }
}

