/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.RendererRegistry;
import org.eclipse.mat.report.TestSuite;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.LinkedPart;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.PageSnippets;
import org.eclipse.mat.report.internal.QueryPart;
import org.eclipse.mat.report.internal.RenderingInfo;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.report.internal.SectionPart;
import org.eclipse.mat.util.FileUtils;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.MessageUtil;
import org.osgi.framework.Bundle;

public class ResultRenderer {
    static final String DIR_PAGES = "pages";
    static final String DIR_ICONS = "icons";
    private TestSuite suite;
    private IOutputter html;
    private List<HtmlArtefact> artefacts = new ArrayList<HtmlArtefact>();
    private File directory;
    private Map<URI, String> icon2name = new HashMap<URI, String>();
    private static final String PREFIX = "$nl$/META-INF/html/";

    public ResultRenderer() {
        this.html = RendererRegistry.instance().match("html", IResult.class);
    }

    public TestSuite getSuite() {
        return this.suite;
    }

    public void beginSuite(TestSuite suite, AbstractPart part) throws IOException {
        this.suite = suite;
        this.prepareTempDirectory();
        HtmlArtefact index = new HtmlArtefact(part, this.directory, "index.html", part.spec().getName());
        suite.addResult(index.getFile());
        part.putObject("artefact", index);
    }

    public void endSuite(AbstractPart part) throws IOException {
        this.renderTableOfContents(part);
        for (HtmlArtefact artefact : this.artefacts) {
            artefact.close();
        }
        this.copyIcons();
        this.zipResult();
    }

    private void copyIcons() throws IOException {
        if (!this.icon2name.isEmpty()) {
            File iconDir = new File(this.directory, DIR_ICONS);
            if (!iconDir.mkdir()) {
                ReportPlugin.log(2, MessageUtil.format(Messages.FileUtils_FailedToMakeDirectory, iconDir));
            }
            for (Map.Entry<URI, String> entry : this.icon2name.entrySet()) {
                this.copyResource(entry.getKey().toURL(), new File(iconDir, entry.getValue()));
            }
        }
    }

    public void beginSection(SectionPart section) throws IOException {
        int order = 1;
        AbstractPart p = section;
        while (p.getParent() != null) {
            p = p.getParent();
            ++order;
        }
        HtmlArtefact srcArtefact = (HtmlArtefact)section.getObject("artefact");
        if (srcArtefact == null) {
            srcArtefact = (HtmlArtefact)section.getParent().getObject("artefact");
        }
        HtmlArtefact artefact = this.createNewFileIfNecessary(srcArtefact, section, order);
        if (order == 1 || srcArtefact != artefact) {
            PageSnippets.heading(artefact, section, order, false, true);
        } else {
            PageSnippets.heading(artefact, section, order, true, false);
            PageSnippets.beginExpandableDiv(artefact, section, false);
            section.putObject("isExpandable", true);
        }
    }

    public void endSection(SectionPart section) {
        if (section.getObject("isExpandable") != null) {
            HtmlArtefact artefact = (HtmlArtefact)section.getObject("artefact");
            PageSnippets.endDiv(artefact);
        }
    }

    public void process(QueryPart test, IResult result, RenderingInfo rInfo) throws IOException {
        String format = test.params().get("format", "html");
        IOutputter outputter = this.html;
        if (result != null && (outputter = RendererRegistry.instance().match(format, result.getClass())) == null) {
            ReportPlugin.log(2, MessageUtil.format(Messages.ResultRenderer_Error_OutputterNotFound, format, result.getClass().getName()));
            outputter = this.html;
        }
        if ("html".equals(format) || outputter.equals(this.html)) {
            this.doProcess(outputter, test, result, rInfo, true);
        } else {
            this.doProcessAlien(format, outputter, test, result, rInfo);
        }
    }

    public void processLink(LinkedPart linkedPart) {
        HtmlArtefact srcArtefact = (HtmlArtefact)linkedPart.getObject("artefact");
        if (srcArtefact == null) {
            srcArtefact = (HtmlArtefact)linkedPart.getParent().getObject("artefact");
        }
        String src = String.valueOf(srcArtefact.getPathToRoot()) + linkedPart.linkedTo.getDataFile().getUrl();
        srcArtefact.append("<a href=\"").append(src).append("\">").append(linkedPart.spec().getName()).append("</a>");
    }

    private void doProcessAlien(String format, IOutputter outputter, QueryPart test, IResult result, RenderingInfo info) throws IOException {
        String filename;
        HtmlArtefact artefact = (HtmlArtefact)test.getObject("artefact");
        if (artefact == null) {
            artefact = (HtmlArtefact)test.getParent().getObject("artefact");
        }
        if ((filename = test.getDataFile().getSuggestedFile()) == null) {
            filename = test.params().shallow().get("filename");
        }
        if (filename == null) {
            filename = DIR_PAGES + File.separator + FileUtils.toFilename(test.spec().getName(), test.getId(), format);
        }
        test.getDataFile().setUrl(filename);
        PageSnippets.linkedHeading(artefact, test, 5, filename);
        try (FileWriter writer = new FileWriter(new File(this.directory, filename));){
            outputter.process(info, result, writer);
        }
    }

    private void doProcess(IOutputter outputter, QueryPart test, IResult result, RenderingInfo rInfo, boolean firstPass) throws IOException {
        boolean isImportant;
        boolean isOverviewDetailsPattern;
        HtmlArtefact srcArtefact = (HtmlArtefact)test.getObject("artefact");
        if (srcArtefact == null) {
            srcArtefact = (HtmlArtefact)test.getParent().getObject("artefact");
        }
        HtmlArtefact artefact = this.createNewFileIfNecessary(srcArtefact, test, 5);
        String pattern = test.params().shallow().get("rendering.pattern");
        boolean bl = isOverviewDetailsPattern = firstPass && "overview_details".equals(pattern);
        if (!isOverviewDetailsPattern) {
            PageSnippets.queryHeading(artefact, test, srcArtefact != artefact);
            PageSnippets.beginExpandableDiv(artefact, test, srcArtefact != artefact);
        }
        if (isImportant = test.params().shallow().getBoolean("html.is_important", false)) {
            artefact.append("<div class=\"important\">");
        }
        outputter.embedd(rInfo, result, artefact.writer);
        if (isOverviewDetailsPattern) {
            String filename = test.getDataFile().getSuggestedFile();
            if (filename == null) {
                filename = "pages/" + test.getId() + ".html";
            }
            artefact.append("<div>");
            PageSnippets.link(artefact, filename, Messages.ResultRenderer_Label_Details);
            artefact.append("</div>");
            HtmlArtefact details = new HtmlArtefact(test.getParent(), this.directory, filename, test.getParent().spec().getName());
            test.getDataFile().setUrl(details.getRelativePathName());
            for (AbstractPart part : test.getParent().getChildren()) {
                part.putObject("artefact", details);
            }
            this.doProcess(outputter, test, result, rInfo, false);
        }
        if (isImportant) {
            artefact.append("</div>");
        }
        if (!isOverviewDetailsPattern) {
            PageSnippets.endDiv(artefact);
        }
    }

    String addIcon(URL icon, AbstractPart part) {
        URI iconKey;
        if (icon == null) {
            return null;
        }
        try {
            iconKey = icon.toURI();
        }
        catch (URISyntaxException e) {
            return null;
        }
        String name = this.icon2name.get(iconKey);
        if (name == null) {
            String f = icon.getFile();
            int p = f.lastIndexOf(46);
            String extension = p < 0 ? f : f.substring(p);
            name = "i" + this.icon2name.size() + extension;
            this.icon2name.put(iconKey, name);
        }
        HtmlArtefact artefact = (HtmlArtefact)part.getObject("artefact");
        return String.valueOf(artefact.getPathToRoot()) + DIR_ICONS + "/" + name;
    }

    File getOutputDirectory(AbstractPart part) {
        HtmlArtefact artefact = (HtmlArtefact)part.getObject("artefact");
        return artefact == null ? this.directory : artefact.getFile().getParentFile();
    }

    String getPathToRoot(AbstractPart part) {
        HtmlArtefact artefact = (HtmlArtefact)part.getObject("artefact");
        return artefact == null ? "" : artefact.getPathToRoot();
    }

    IQueryContext getQueryContext() {
        return this.suite.getQueryContext();
    }

    private void prepareTempDirectory() throws IOException {
        this.directory = FileUtils.createTempDirectory("report", null);
        this.copyResource("$nl$/META-INF/html/styles.css", new File(this.directory, "styles.css"));
        this.copyResource("$nl$/META-INF/html/styles-dark.css", new File(this.directory, "styles-dark.css"));
        this.copyResource("$nl$/META-INF/html/code.js", new File(this.directory, "code.js"));
        File imgDir = new File(this.directory, "img");
        if (!imgDir.mkdir()) {
            ReportPlugin.log(2, MessageUtil.format(Messages.FileUtils_FailedToMakeDirectory, imgDir));
        }
        this.copyResource("$nl$/META-INF/html/img/open.gif", new File(imgDir, "open.gif"));
        this.copyResource("$nl$/META-INF/html/img/success.gif", new File(imgDir, "success.gif"));
        this.copyResource("$nl$/META-INF/html/img/warning.gif", new File(imgDir, "warning.gif"));
        this.copyResource("$nl$/META-INF/html/img/error.gif", new File(imgDir, "error.gif"));
        this.copyResource("$nl$/META-INF/html/img/empty.gif", new File(imgDir, "empty.gif"));
        this.copyResource("$nl$/META-INF/html/img/fork.gif", new File(imgDir, "fork.gif"));
        this.copyResource("$nl$/META-INF/html/img/line.gif", new File(imgDir, "line.gif"));
        this.copyResource("$nl$/META-INF/html/img/corner.gif", new File(imgDir, "corner.gif"));
        this.copyResource("$nl$/META-INF/html/img/opened.gif", new File(imgDir, "opened.gif"));
        this.copyResource("$nl$/META-INF/html/img/closed.gif", new File(imgDir, "closed.gif"));
        this.copyResource("$nl$/META-INF/html/img/nochildren.gif", new File(imgDir, "nochildren.gif"));
        File pagesDir = new File(this.directory, DIR_PAGES);
        if (!pagesDir.mkdir()) {
            ReportPlugin.log(2, MessageUtil.format(Messages.FileUtils_FailedToMakeDirectory, pagesDir));
        }
    }

    private void copyResource(String resource, File target) throws FileNotFoundException, IOException {
        Path path = new Path(resource);
        InputStream resourceStream = FileLocator.openStream((Bundle)ReportPlugin.getDefault().getBundle(), (IPath)path, (boolean)true);
        if (resourceStream == null) {
            throw new FileNotFoundException(resource);
        }
        try (FileOutputStream out = new FileOutputStream(target);){
            FileUtils.copy(resourceStream, out);
        }
        finally {
            resourceStream.close();
        }
    }

    private void copyResource(URL resource, File target) throws FileNotFoundException, IOException {
        try (InputStream in = resource.openStream();
             FileOutputStream out = new FileOutputStream(target);){
            FileUtils.copy(in, out);
        }
    }

    private HtmlArtefact createNewFileIfNecessary(HtmlArtefact artefact, AbstractPart part, int order) throws IOException {
        boolean isSeparateFile = part.params().shallow().getBoolean("html.separate_file", false);
        boolean isEmbedded = part.params().shallow().getBoolean("$embedded", false);
        if (isSeparateFile || isEmbedded) {
            String filename = part.getDataFile().getSuggestedFile();
            if (filename == null) {
                filename = part.params().shallow().get("filename");
            }
            if (filename == null) {
                filename = "pages/" + FileUtils.toFilename(part.spec().getName(), part.getId(), "html");
            }
            part.getDataFile().setUrl(filename);
            HtmlArtefact newArtefact = new HtmlArtefact(part, this.directory, filename, part.spec().getName());
            if (!isEmbedded) {
                PageSnippets.linkedHeading(artefact, part, order, newArtefact.getRelativePathName());
            }
            artefact = newArtefact;
        }
        part.putObject("artefact", artefact);
        part.getDataFile().setUrl(artefact.getRelativePathName());
        return artefact;
    }

    private void renderTableOfContents(AbstractPart part) throws IOException {
        HtmlArtefact toc = new HtmlArtefact(null, this.directory, "toc.html", Messages.ResultRenderer_Label_TableOfContents);
        toc.append("<h1>" + Messages.ResultRenderer_Label_TableOfContents + "</h1>\n");
        this.renderResult(toc, part, 0);
    }

    private void renderResult(HtmlArtefact toc, AbstractPart parent, int depth) {
        String plang = depth == 0 ? PageSnippets.getLang(parent) : "";
        toc.append("<ul").append(plang).append(" class=\"collapsible_").append(depth < 3 ? "opened" : "closed").append("\">");
        for (AbstractPart part : parent.getChildren()) {
            String lang = PageSnippets.getLang(part);
            toc.append("<li").append(lang).append(">");
            if (part.getStatus() != null) {
                toc.append("<img src=\"img/").append(String.valueOf(part.getStatus().name().toLowerCase(Locale.ENGLISH)) + ".gif\" alt=\"").append(part.getStatus().toString()).append("\"> ");
            }
            HtmlArtefact page = (HtmlArtefact)part.getObject("artefact");
            AbstractPart p = part;
            while (page == null) {
                p = p.getParent();
                page = (HtmlArtefact)p.getObject("artefact");
            }
            PageSnippets.beginLink(toc, page.getRelativePathName(), part);
            toc.append(HTMLUtils.escapeText(part.spec().getName()));
            PageSnippets.endLink(toc);
            if (!part.children.isEmpty()) {
                this.renderResult(toc, part, depth + 1);
            }
            toc.append("</li>");
        }
        toc.append("</ul>");
    }

    /*
     * Exception decompiling
     */
    boolean sameZipContents(File existingZip, File targetZip) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 25[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void zipResult() throws IOException {
        File targetZip = this.suite.getOutput();
        int MAX_RENAMES = 99;
        File originalZip = targetZip;
        File existingZip = null;
        ZipOutputStream zos = null;
        int n = 1;
        while (targetZip.exists() && n <= 99) {
            if (targetZip.canWrite() && !targetZip.isDirectory()) {
                try {
                    zos = new ZipOutputStream(new FileOutputStream(targetZip));
                    break;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            String fn = originalZip.getName();
            int dot = fn.lastIndexOf(46);
            String fn2 = String.valueOf(fn.substring(0, dot)) + "_" + n + fn.substring(dot);
            existingZip = targetZip;
            targetZip = new File(originalZip.getParentFile(), fn2);
            ++n;
        }
        if (zos == null) {
            zos = new ZipOutputStream(new FileOutputStream(targetZip));
        }
        try {
            this.zipDir(this.directory.getPath().length() + 1, this.directory, zos);
        }
        finally {
            zos.close();
        }
        if (existingZip != null && this.sameZipContents(existingZip, targetZip) && targetZip.delete()) {
            targetZip = existingZip;
        }
        this.suite.addResult(targetZip);
    }

    private void zipDir(int commonPath, File zipDir, ZipOutputStream zos) throws IOException {
        String[] dirList = zipDir.list();
        if (dirList == null) {
            return;
        }
        byte[] readBuffer = new byte[2156];
        int bytesIn = 0;
        int i = 0;
        while (i < dirList.length) {
            File f = new File(zipDir, dirList[i]);
            if (f.isDirectory()) {
                this.zipDir(commonPath, f, zos);
            } else {
                try (FileInputStream fis = new FileInputStream(f);){
                    String path = f.getPath().substring(commonPath);
                    ZipEntry anEntry = new ZipEntry(path);
                    zos.putNextEntry(anEntry);
                    while ((bytesIn = fis.read(readBuffer)) != -1) {
                        zos.write(readBuffer, 0, bytesIn);
                    }
                }
            }
            ++i;
        }
    }

    class HtmlArtefact {
        private File file;
        private PrintWriter writer;
        private String pathToRoot;
        private String relativeURL;

        private HtmlArtefact(AbstractPart part, File directory, String relativeURL, String title) throws IOException {
            this.file = new File(directory, relativeURL.replace('/', File.separatorChar));
            String encoding = System.getProperty("file.encoding");
            this.writer = new PrintWriter(this.file, encoding);
            this.pathToRoot = "";
            int ii = 0;
            while (ii < relativeURL.length()) {
                if (relativeURL.charAt(ii) == '/') {
                    this.pathToRoot = String.valueOf(this.pathToRoot) + "../";
                }
                ++ii;
            }
            this.relativeURL = relativeURL;
            ResultRenderer.this.artefacts.add(this);
            PageSnippets.beginPage(part, this, title, encoding);
        }

        public HtmlArtefact append(String s) {
            this.writer.append(s);
            return this;
        }

        public void close() {
            try {
                PageSnippets.endPage(this);
            }
            finally {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
        }

        public String toString() {
            return this.file.getAbsolutePath();
        }

        public File getFile() {
            return this.file;
        }

        public String getPathToRoot() {
            return this.pathToRoot;
        }

        public String getRelativePathName() {
            return this.relativeURL;
        }
    }

    static interface Key {
        public static final String IS_EXPANDABLE = "isExpandable";
        public static final String ARTEFACT = "artefact";
    }
}

