/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.util.ArrayList;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.m2e.pde.BNDInstructions;
import org.eclipse.m2e.pde.MavenTargetBundle;
import org.eclipse.m2e.pde.MavenTargetDependency;
import org.eclipse.m2e.pde.MavenTargetLocation;
import org.eclipse.m2e.pde.MissingMetadataMode;
import org.eclipse.m2e.pde.ui.Activator;
import org.eclipse.m2e.pde.ui.editor.MavenArtifactInstructionsWizard;
import org.eclipse.m2e.pde.ui.editor.MavenTargetLocationWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

public class MavenTargetLocationEditor
implements ITargetLocationHandler {
    public boolean canEdit(ITargetDefinition target, TreePath treePath) {
        Object root = treePath.getFirstSegment();
        if (root instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)root;
            if (treePath.getSegmentCount() == 1) {
                return true;
            }
            if (location.getMetadataMode() == MissingMetadataMode.GENERATE) {
                Object lastSegment = treePath.getLastSegment();
                if (lastSegment instanceof DependencyNode) {
                    DependencyNode node = (DependencyNode)lastSegment;
                    MavenTargetBundle bundle = location.getMavenTargetBundle(node.getArtifact());
                    return bundle != null && bundle.isWrapped();
                }
                if (lastSegment instanceof MavenTargetDependency) {
                    MavenTargetDependency dependency = (MavenTargetDependency)lastSegment;
                    MavenTargetBundle bundle = location.getMavenTargetBundle(dependency);
                    return bundle != null && bundle.isWrapped();
                }
            }
        }
        return false;
    }

    public IWizard getEditWizard(ITargetDefinition target, TreePath treePath) {
        Object root = treePath.getFirstSegment();
        if (root instanceof MavenTargetLocation) {
            MavenTargetBundle bundle;
            MavenTargetLocation location = (MavenTargetLocation)root;
            if (treePath.getSegmentCount() == 1) {
                MavenTargetLocationWizard wizard = new MavenTargetLocationWizard(location);
                wizard.setTarget(target);
                return wizard;
            }
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)lastSegment;
                return this.edit(target, location, node.getArtifact());
            }
            if (lastSegment instanceof MavenTargetDependency && (bundle = location.getMavenTargetBundle((MavenTargetDependency)lastSegment)) != null) {
                return this.edit(target, location, bundle.getArtifact());
            }
        }
        return null;
    }

    private IWizard edit(final ITargetDefinition target, final MavenTargetLocation location, Artifact artifact) {
        BNDInstructions instructions = location.getInstructions(artifact);
        MavenArtifactInstructionsWizard wizard = new MavenArtifactInstructionsWizard(instructions){

            @Override
            public boolean performFinish() {
                boolean finish = super.performFinish();
                if (finish) {
                    BNDInstructions instructions = this.getInstructions();
                    ArrayList<BNDInstructions> updatedInstructions = new ArrayList<BNDInstructions>();
                    updatedInstructions.add(instructions);
                    for (BNDInstructions existing : location.getInstructions()) {
                        if (existing.getKey().equals(instructions.getKey())) continue;
                        updatedInstructions.add(instructions);
                    }
                    MavenTargetLocation update = location.withInstructions(updatedInstructions);
                    ITargetLocation[] locations = target.getTargetLocations();
                    int i = 0;
                    while (i < locations.length) {
                        if (locations[i] == location) {
                            locations[i] = update;
                            break;
                        }
                        ++i;
                    }
                    target.setTargetLocations(locations);
                }
                return finish;
            }
        };
        wizard.setWindowTitle(String.valueOf(wizard.getWindowTitle()) + " [" + artifact + "]");
        return wizard;
    }

    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        return treePath.getFirstSegment() instanceof MavenTargetLocation;
    }

    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        ITargetLocation[] targetLocations = target.getTargetLocations();
        Status status = new Status(0, "org.eclipse.m2e.pde.ui", 101, "", null);
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getFirstSegment();
            if (segment instanceof MavenTargetLocation) {
                MavenTargetLocation targetLocation = (MavenTargetLocation)segment;
                try {
                    MavenTargetLocation update = targetLocation.update(monitor);
                    if (update != null) {
                        int i = 0;
                        while (i < targetLocations.length) {
                            if (targetLocations[i] == targetLocation) {
                                targetLocations[i] = update;
                                break;
                            }
                            ++i;
                        }
                        target.setTargetLocations(targetLocations);
                        status = Status.OK_STATUS;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            }
            ++n2;
        }
        return status;
    }

    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        ITargetLocation[] iTargetLocationArray = targetLocations;
        int n = targetLocations.length;
        int n2 = 0;
        while (n2 < n) {
            ITargetLocation location = iTargetLocationArray[n2];
            if (location instanceof MavenTargetLocation) {
                ((MavenTargetLocation)location).refresh();
            }
            ++n2;
        }
        return Status.OK_STATUS;
    }

    public boolean canDisable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getFirstSegment();
        if (segment instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)segment;
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)lastSegment;
                return !location.isExcluded(node.getArtifact());
            }
        }
        return false;
    }

    public boolean canEnable(ITargetDefinition target, TreePath treePath) {
        Object segment = treePath.getFirstSegment();
        if (segment instanceof MavenTargetLocation) {
            MavenTargetLocation location = (MavenTargetLocation)segment;
            Object lastSegment = treePath.getLastSegment();
            if (lastSegment instanceof DependencyNode) {
                DependencyNode node = (DependencyNode)lastSegment;
                return location.isExcluded(node.getArtifact());
            }
        }
        return false;
    }

    public IStatus toggle(ITargetDefinition target, TreePath[] treePaths) {
        int toggled = 0;
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getFirstSegment();
            if (segment instanceof MavenTargetLocation) {
                MavenTargetLocation location = (MavenTargetLocation)segment;
                Object lastSegment = treePath.getLastSegment();
                if (lastSegment instanceof DependencyNode) {
                    DependencyNode node = (DependencyNode)lastSegment;
                    location.setExcluded(node.getArtifact(), !location.isExcluded(node.getArtifact()));
                    target.setTargetLocations(target.getTargetLocations());
                    ++toggled;
                }
            }
            ++n2;
        }
        return toggled > 0 ? new Status(0, Activator.class.getPackageName(), 102, "", null) : Status.CANCEL_STATUS;
    }
}

