/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.pde.ui.editor;

import java.net.URL;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.core.databinding.observable.sideeffect.ISideEffectFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetSideEffects;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.m2e.pde.MavenTargetDependency;
import org.eclipse.m2e.pde.ui.editor.ClipboardParser;
import org.eclipse.m2e.pde.ui.editor.MavenTargetLocationWizard;
import org.eclipse.m2e.pde.ui.editor.Messages;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class MavenTargetDependencyEditor {
    private static final String EDITOR_KEY = "MavenTargetDependencyEditor.editor";
    private static final String DEPENDENCY_KEY = "MavenTargetDependencyEditor.dependency";
    private static final ImageDescriptor ADD_IMAGE_DESCRIPTOR = ImageDescriptor.createFromURL((URL)MavenTargetLocationWizard.class.getResource("/icons/add_obj.png"));
    private CTabFolder tabFolder;

    public MavenTargetDependencyEditor(Composite parent, Collection<MavenTargetDependency> initialItems) {
        this.tabFolder = new CTabFolder(parent, 0x800000);
        final CTabItem addItem = new CTabItem(this.tabFolder, 0);
        addItem.setToolTipText("Add a new item");
        Image image = ADD_IMAGE_DESCRIPTOR.createImage();
        this.tabFolder.addDisposeListener(e -> image.dispose());
        addItem.setImage(image);
        this.tabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                event.doit = MavenTargetDependencyEditor.this.tabFolder.getItemCount() > 2;
            }
        });
        if (initialItems.isEmpty()) {
            this.addNewItems(parent.getDisplay());
        } else {
            for (MavenTargetDependency dependency : initialItems) {
                this.add(dependency.copy());
            }
        }
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item == addItem) {
                    MavenTargetDependencyEditor.this.addNewItems(e.display);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void addNewItems(Display display) {
        Clipboard clipboard = new Clipboard(display);
        String text = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        clipboard.dispose();
        ClipboardParser clipboardParser = new ClipboardParser(text);
        List<MavenTargetDependency> dependencies = clipboardParser.getDependencies();
        if (dependencies.isEmpty()) {
            this.add(new MavenTargetDependency("", "", "", "", ""));
        } else {
            for (MavenTargetDependency mavenTargetDependency : dependencies) {
                this.add(mavenTargetDependency);
            }
        }
        Exception clipboardError = clipboardParser.getError();
        if (clipboardError != null) {
            Platform.getLog(MavenTargetLocationWizard.class).warn(MessageFormat.format(Messages.ClipboardParser_1, clipboardError.getMessage()));
        }
    }

    private void add(MavenTargetDependency dependency) {
        CTabItem newItem = new CTabItem(this.tabFolder, 64);
        newItem.setData(EDITOR_KEY, (Object)new DependencyEditor((Composite)this.tabFolder, dependency, newItem));
        newItem.setData(DEPENDENCY_KEY, (Object)dependency);
        this.tabFolder.setSelection(newItem);
    }

    public Control getControl() {
        return this.tabFolder;
    }

    private static Text fill(Text text) {
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)data);
        return text;
    }

    private static CCombo combo(CCombo combo) {
        GridData data = new GridData();
        data.widthHint = 100;
        combo.setLayoutData((Object)data);
        return combo;
    }

    public Collection<MavenTargetDependency> getRoots() {
        return Arrays.stream(this.tabFolder.getItems()).map(item -> item.getData(DEPENDENCY_KEY)).filter(Objects::nonNull).map(MavenTargetDependency.class::cast).collect(Collectors.toList());
    }

    private static final class DependencyEditor {
        DependencyEditor(Composite parent, MavenTargetDependency dependency, CTabItem item) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            ISideEffectFactory factory = WidgetSideEffects.createFactory((Widget)composite);
            new Label(composite, 0).setText(Messages.MavenTargetDependencyEditor_1);
            ISWTObservableValue groupId = WidgetProperties.text((int)24).observe((Widget)MavenTargetDependencyEditor.fill(new Text(composite, 2048)));
            new Label(composite, 0).setText(Messages.MavenTargetDependencyEditor_2);
            ISWTObservableValue artifactId = WidgetProperties.text((int)24).observe((Widget)MavenTargetDependencyEditor.fill(new Text(composite, 2048)));
            new Label(composite, 0).setText(Messages.MavenTargetDependencyEditor_3);
            ISWTObservableValue version = WidgetProperties.text((int)24).observe((Widget)MavenTargetDependencyEditor.fill(new Text(composite, 2048)));
            new Label(composite, 0).setText(Messages.MavenTargetDependencyEditor_4);
            ISWTObservableValue classifier = WidgetProperties.text((int)24).observe((Widget)MavenTargetDependencyEditor.fill(new Text(composite, 2048)));
            new Label(composite, 0).setText(Messages.MavenTargetDependencyEditor_5);
            CCombo combo = MavenTargetDependencyEditor.combo(new CCombo(composite, 2048));
            combo.add("jar");
            combo.add("bundle");
            combo.add("pom");
            ISWTObservableValue type = WidgetProperties.ccomboSelection().observe((Widget)combo);
            groupId.setValue((Object)dependency.getGroupId());
            artifactId.setValue((Object)dependency.getArtifactId());
            version.setValue((Object)dependency.getVersion());
            classifier.setValue((Object)dependency.getClassifier());
            type.setValue((Object)dependency.getType());
            factory.create(() -> {
                dependency.setArtifactId((String)artifactId.getValue());
                dependency.setGroupId((String)groupId.getValue());
                dependency.setVersion((String)version.getValue());
                dependency.setClassifier((String)classifier.getValue());
                dependency.setType((String)type.getValue());
                String key = dependency.getKey();
                if (key.equals("::jar:")) {
                    item.setText(Messages.MavenTargetDependencyEditor_6);
                } else {
                    item.setText(key);
                }
            });
            item.setControl((Control)composite);
            parent.getDisplay().asyncExec(() -> ((Control)groupId.getWidget()).forceFocus());
        }
    }
}

