/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal.launch;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.jdt.IClassifierClasspathProvider;
import org.eclipse.m2e.jdt.IClasspathManager;
import org.eclipse.m2e.jdt.IMavenClassifierManager;
import org.eclipse.m2e.jdt.MavenJdtPlugin;
import org.eclipse.m2e.jdt.internal.BuildPathManager;
import org.eclipse.m2e.jdt.internal.MavenClasspathHelpers;
import org.eclipse.m2e.jdt.internal.ModuleSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenRuntimeClasspathProvider
extends StandardClasspathProvider {
    private static final Logger log = LoggerFactory.getLogger(MavenRuntimeClasspathProvider.class);
    public static final String MAVEN_SOURCEPATH_PROVIDER = "org.eclipse.m2e.launchconfig.sourcepathProvider";
    public static final String MAVEN_CLASSPATH_PROVIDER = "org.eclipse.m2e.launchconfig.classpathProvider";
    private static final String THIS_PROJECT_CLASSIFIER = "";
    public static final String JDT_JUNIT_TEST = "org.eclipse.jdt.junit.launchconfig";
    public static final String JDT_JAVA_APPLICATION = "org.eclipse.jdt.launching.localJavaApplication";
    public static final String JDT_TESTNG_TEST = "org.testng.eclipse.launchconfig";
    private static final String ATTRIBUTE_ORG_ECLIPSE_JDT_JUNIT_TEST_KIND = "org.eclipse.jdt.junit.TEST_KIND";
    private static final String TESTKIND_ORG_ECLIPSE_JDT_JUNIT_LOADER_JUNIT5 = "org.eclipse.jdt.junit.loader.junit5";
    private static final String ARTIFACT_JUNIT_JUPITER_API = "junit-jupiter-api";
    private static final String ARTIFACT_JUNIT_JUPITER_ENGINE = "junit-jupiter-engine";
    private static final String ARTIFACT_JUNIT_PLATFORM_COMMONS = "junit-platform-commons";
    private static final String ARTIFACT_JUNIT_PLATFORM_ENGINE = "junit-platform-engine";
    private static final String ARTIFACT_JUNIT_PLATFORM_LAUNCHER = "junit-platform-launcher";
    private static final String GROUP_ORG_JUNIT_JUPITER = "org.junit.jupiter";
    private static final String GROUP_ORG_JUNIT_PLATFORM = "org.junit.platform";
    private static final String PROPERTY_M2E_DISABLE_ADD_MISSING_J_UNIT5_EXECUTION_DEPENDENCIES = "m2e.disableAddMissingJUnit5ExecutionDependencies";
    private static final Set<String> supportedTypes = new HashSet<String>();
    IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    static {
        supportedTypes.add(JDT_JAVA_APPLICATION);
        supportedTypes.add(JDT_JUNIT_TEST);
        supportedTypes.add(JDT_TESTNG_TEST);
    }

    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        boolean isModular = JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration);
        boolean useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        if (useDefault) {
            IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
            IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((ILaunchConfiguration)configuration);
            IRuntimeClasspathEntry projectEntry = isModular ? ModuleSupport.newModularProjectRuntimeClasspathEntry(javaProject) : JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)javaProject);
            IRuntimeClasspathEntry mavenEntry = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)new Path("org.eclipse.m2e.MAVEN2_CLASSPATH_CONTAINER"), (int)3);
            ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>();
            if (jreEntry != null) {
                entries.add(jreEntry);
            }
            entries.add(projectEntry);
            entries.add(mavenEntry);
            entries.addAll(Arrays.stream(JavaRuntime.computeUnresolvedRuntimeDependencies((IJavaProject)javaProject, (boolean)true)).filter(e -> e.getType() == 2).collect(Collectors.toList()));
            return entries.toArray(new IRuntimeClasspathEntry[0]);
        }
        if (isModular) {
            IRuntimeClasspathEntry[] runtimeModulePaths = this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_MODULEPATH);
            IRuntimeClasspathEntry[] runtimeClasspaths = this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
            IRuntimeClasspathEntry[] result = Arrays.copyOf(runtimeModulePaths, runtimeModulePaths.length + runtimeClasspaths.length);
            System.arraycopy(runtimeClasspaths, 0, result, runtimeModulePaths.length, runtimeClasspaths.length);
            return result;
        }
        return this.recoverRuntimePath(configuration, IJavaLaunchConfigurationConstants.ATTR_CLASSPATH);
    }

    public IRuntimeClasspathEntry[] resolveClasspath(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        return (IRuntimeClasspathEntry[])MavenPlugin.getMaven().execute((context, monitor1) -> this.resolveClasspath0(entries, configuration, monitor1), (IProgressMonitor)monitor);
    }

    IRuntimeClasspathEntry[] resolveClasspath0(IRuntimeClasspathEntry[] entries, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        boolean isModularConfiguration = JavaRuntime.isModularConfiguration((ILaunchConfiguration)configuration);
        int scope = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE, false) ? 1 : 0;
        LinkedHashSet<IRuntimeClasspathEntry> all = new LinkedHashSet<IRuntimeClasspathEntry>(entries.length);
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            if (entry.getType() == 4 && MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) {
                this.addMavenClasspathEntries(all, entry, configuration, scope, monitor, isModularConfiguration);
            } else if (entry.getType() == 1) {
                if (javaProject.getPath().equals((Object)entry.getPath())) {
                    this.addProjectEntries(all, entry.getPath(), scope, THIS_PROJECT_CLASSIFIER, configuration, monitor, ModuleSupport.determineClasspathPropertyForMainProject(isModularConfiguration, javaProject));
                } else {
                    this.addStandardClasspathEntries(all, entry, configuration);
                }
            } else {
                this.addStandardClasspathEntries(all, entry, configuration);
            }
            ++n2;
        }
        return all.toArray(new IRuntimeClasspathEntry[all.size()]);
    }

    private void addStandardClasspathEntries(Set<IRuntimeClasspathEntry> all, IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (ILaunchConfiguration)configuration);
        Collections.addAll(all, resolved);
    }

    private void addMavenClasspathEntries(Set<IRuntimeClasspathEntry> resolved, IRuntimeClasspathEntry runtimeClasspathEntry, ILaunchConfiguration configuration, int scope, IProgressMonitor monitor, boolean isModularConfiguration) throws CoreException {
        IClasspathEntry[] cp;
        IJavaProject javaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        MavenJdtPlugin plugin = MavenJdtPlugin.getDefault();
        IClasspathManager buildpathManager = plugin.getBuildpathManager();
        IClasspathEntry[] iClasspathEntryArray = cp = buildpathManager.getClasspath(javaProject.getProject(), scope, false, monitor);
        int n = cp.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            int classpathProperty = isModularConfiguration ? ModuleSupport.determineModularClasspathProperty(entry) : 3;
            switch (entry.getEntryKind()) {
                case 2: {
                    this.addProjectEntries(resolved, entry.getPath(), scope, MavenRuntimeClasspathProvider.getArtifactClassifier(entry), configuration, monitor, classpathProperty);
                    break;
                }
                case 1: {
                    resolved.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath(), (int)classpathProperty));
                }
            }
            ++n2;
        }
        if (scope == 0 && TESTKIND_ORG_ECLIPSE_JDT_JUNIT_LOADER_JUNIT5.equals(configuration.getAttribute(ATTRIBUTE_ORG_ECLIPSE_JDT_JUNIT_TEST_KIND, THIS_PROJECT_CLASSIFIER))) {
            this.addMissingJUnit5ExecutionDependencies(resolved, monitor, javaProject);
        }
    }

    private void addMissingJUnit5ExecutionDependencies(Set<IRuntimeClasspathEntry> resolved, IProgressMonitor monitor, IJavaProject javaProject) throws CoreException {
        IMavenProjectFacade facade = this.projectManager.create(javaProject.getProject(), monitor);
        MavenProject mavenProject = facade.getMavenProject(monitor);
        if (Boolean.parseBoolean(mavenProject.getProperties().getProperty(PROPERTY_M2E_DISABLE_ADD_MISSING_J_UNIT5_EXECUTION_DEPENDENCIES, "false"))) {
            return;
        }
        Artifact platformLauncherArtifact = null;
        Artifact platformEngineArtifact = null;
        Artifact jupiterEngineArtifact = null;
        Artifact platformCommonsArtifact = null;
        Artifact jupiterApiArtifact = null;
        for (Artifact a : mavenProject.getArtifacts()) {
            if (!BuildPathManager.SCOPE_FILTER_TEST.include(a) || !a.getArtifactHandler().isAddedToClasspath()) continue;
            String groupId = a.getGroupId();
            String artifactId = a.getArtifactId();
            if (GROUP_ORG_JUNIT_PLATFORM.equals(groupId)) {
                if (ARTIFACT_JUNIT_PLATFORM_LAUNCHER.equals(artifactId)) {
                    platformLauncherArtifact = a;
                    continue;
                }
                if (ARTIFACT_JUNIT_PLATFORM_ENGINE.equals(artifactId)) {
                    platformEngineArtifact = a;
                    continue;
                }
                if (!ARTIFACT_JUNIT_PLATFORM_COMMONS.equals(artifactId)) continue;
                platformCommonsArtifact = a;
                continue;
            }
            if (!GROUP_ORG_JUNIT_JUPITER.equals(groupId)) continue;
            if (ARTIFACT_JUNIT_JUPITER_ENGINE.equals(artifactId)) {
                jupiterEngineArtifact = a;
                continue;
            }
            if (!ARTIFACT_JUNIT_JUPITER_API.equals(artifactId)) continue;
            jupiterApiArtifact = a;
        }
        if (platformCommonsArtifact != null && platformLauncherArtifact == null) {
            this.addResolvedJUnit5Dependency(resolved, GROUP_ORG_JUNIT_PLATFORM, platformCommonsArtifact.getVersion(), ARTIFACT_JUNIT_PLATFORM_LAUNCHER, mavenProject, monitor);
        }
        if (platformCommonsArtifact != null && platformEngineArtifact == null) {
            this.addResolvedJUnit5Dependency(resolved, GROUP_ORG_JUNIT_PLATFORM, platformCommonsArtifact.getVersion(), ARTIFACT_JUNIT_PLATFORM_ENGINE, mavenProject, monitor);
        }
        if (jupiterApiArtifact != null && jupiterEngineArtifact == null) {
            this.addResolvedJUnit5Dependency(resolved, GROUP_ORG_JUNIT_JUPITER, jupiterApiArtifact.getVersion(), ARTIFACT_JUNIT_JUPITER_ENGINE, mavenProject, monitor);
        }
    }

    private void addResolvedJUnit5Dependency(Set<IRuntimeClasspathEntry> resolved, String groupId, String version, String artifactId, MavenProject mavenProject, IProgressMonitor monitor) {
        try {
            File file = MavenPlugin.getMaven().resolve(groupId, artifactId, version, "jar", null, mavenProject.getRemoteArtifactRepositories(), monitor).getFile();
            if (file != null) {
                resolved.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)Path.fromOSString((String)file.getAbsolutePath()), (int)3));
            }
        }
        catch (CoreException ex) {
            log.error("Could not resolve JUnit5 dependency " + groupId + ":" + artifactId + ":" + version, (Throwable)ex);
        }
    }

    protected void addProjectEntries(Set<IRuntimeClasspathEntry> resolved, IPath path, int scope, String classifier, ILaunchConfiguration launchConfiguration, IProgressMonitor monitor, int classpathProperty) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(path.segment(0));
        IMavenProjectFacade projectFacade = this.projectManager.create(project, monitor);
        if (projectFacade == null) {
            return;
        }
        ResolverConfiguration configuration = projectFacade.getResolverConfiguration();
        if (configuration == null) {
            return;
        }
        IJavaProject javaProject = JavaCore.create((IProject)project);
        boolean projectResolved = false;
        IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IRuntimeClasspathEntry rce = null;
            switch (entry.getEntryKind()) {
                case 3: {
                    if (projectResolved) break;
                    IMavenClassifierManager mavenClassifierManager = MavenJdtPlugin.getDefault().getMavenClassifierManager();
                    IClassifierClasspathProvider classifierClasspathProvider = mavenClassifierManager.getClassifierClasspathProvider(projectFacade, classifier);
                    if (scope == 0) {
                        classifierClasspathProvider.setTestClasspath(resolved, projectFacade, monitor, classpathProperty);
                    } else {
                        classifierClasspathProvider.setRuntimeClasspath(resolved, projectFacade, monitor, classpathProperty);
                    }
                    projectResolved = true;
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)javaProject);
                    if (container == null || MavenClasspathHelpers.isMaven2ClasspathContainer(entry.getPath())) break;
                    switch (container.getKind()) {
                        case 1: {
                            rce = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)container.getPath(), (int)3, (IJavaProject)javaProject);
                        }
                    }
                    break;
                }
                case 1: {
                    rce = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath(), (int)(classpathProperty == 3 ? 3 : ModuleSupport.determineModularClasspathProperty(entry)));
                    break;
                }
                case 4: {
                    if ("JRE_LIB".equals(entry.getPath().segment(0))) break;
                    rce = JavaRuntime.newVariableRuntimeClasspathEntry((IPath)entry.getPath());
                    break;
                }
                case 2: {
                    IJavaProject otherProject;
                    IProject res = root.getProject(entry.getPath().segment(0));
                    if (res == null || (otherProject = JavaCore.create((IProject)res)) == null) break;
                    rce = JavaRuntime.newDefaultProjectClasspathEntry((IJavaProject)otherProject);
                    break;
                }
            }
            if (rce != null) {
                this.addStandardClasspathEntries(resolved, rce, launchConfiguration);
            }
            ++n2;
        }
    }

    public static boolean isSupportedType(String id) {
        return supportedTypes.contains(id);
    }

    public static void enable(ILaunchConfiguration config) throws CoreException {
        if (config instanceof ILaunchConfigurationWorkingCopy) {
            MavenRuntimeClasspathProvider.enable((ILaunchConfigurationWorkingCopy)config);
        } else {
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            MavenRuntimeClasspathProvider.enable(wc);
            wc.doSave();
        }
    }

    private static void enable(ILaunchConfigurationWorkingCopy wc) {
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, MAVEN_CLASSPATH_PROVIDER);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, MAVEN_SOURCEPATH_PROVIDER);
    }

    public static void disable(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER, null);
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, null);
        wc.doSave();
    }

    private static String getArtifactClassifier(IClasspathEntry entry) {
        IClasspathAttribute[] attributes;
        IClasspathAttribute[] iClasspathAttributeArray = attributes = entry.getExtraAttributes();
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathAttribute attribute = iClasspathAttributeArray[n2];
            if ("maven.classifier".equals(attribute.getName())) {
                return attribute.getValue();
            }
            ++n2;
        }
        return null;
    }

    public static void enable(IProject project) throws CoreException {
        for (ILaunchConfiguration config : MavenRuntimeClasspathProvider.getLaunchConfiguration(project)) {
            if (!MavenRuntimeClasspathProvider.isSupportedType(config.getType().getIdentifier())) continue;
            MavenRuntimeClasspathProvider.enable(config);
        }
    }

    public static void disable(IProject project) throws CoreException {
        for (ILaunchConfiguration config : MavenRuntimeClasspathProvider.getLaunchConfiguration(project)) {
            if (!MavenRuntimeClasspathProvider.isSupportedType(config.getType().getIdentifier())) continue;
            MavenRuntimeClasspathProvider.disable(config);
        }
    }

    private static List<ILaunchConfiguration> getLaunchConfiguration(IProject project) throws CoreException {
        ILaunchConfiguration[] configurations;
        ArrayList<ILaunchConfiguration> result = new ArrayList<ILaunchConfiguration>();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configurations = launchManager.getLaunchConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
            if (project.getName().equals(projectName)) {
                result.add(config);
            }
            ++n2;
        }
        return result;
    }
}

