/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.controls.internal;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class LaunchBarButtonImageDescriptor
extends CompositeImageDescriptor {
    private Image bgImage;
    private Image mainImage;

    public LaunchBarButtonImageDescriptor(Image mainImage, Image bgImage) {
        this.bgImage = bgImage;
        this.mainImage = mainImage;
    }

    protected Point getSize() {
        Rectangle bounds = this.bgImage.getBounds();
        return new Point(bounds.width - bounds.y, bounds.height - bounds.x);
    }

    protected void drawCompositeImage(int width, int height) {
        this.drawImage(this.bgImage.getImageData(), 0, 0);
        Rectangle bgBounds = this.bgImage.getBounds();
        Rectangle modeBounds = this.mainImage.getBounds();
        int x = (bgBounds.width - bgBounds.x - (modeBounds.width - modeBounds.x)) / 2;
        int y = (bgBounds.height - bgBounds.y - (modeBounds.height - modeBounds.y)) / 2;
        this.drawImage(this.mainImage.getImageData(), x, y);
    }
}

