/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart.IAnnotationEditPart;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.figure.PageflowNodeFigure;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.Pageflow;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowElement;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPackage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.model.PageflowPage;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.properties.PageflowElementPropertySource;
import org.eclipse.jst.jsf.facesconfig.ui.pageflow.synchronization.PFBatchAdapter;
import org.eclipse.jst.jsf.facesconfig.ui.util.WebrootUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class PageflowElementEditPart
extends AbstractGraphicalEditPart
implements IAnnotationEditPart {
    public static final ImageDescriptor IMG_ACTION = EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Action16.gif");
    private Adapter adapter;
    private static final ImageDescriptor IMG_PAGE = EditorPlugin.getDefault().getImageDescriptor("facesconfig/Pageflow_Page.gif");
    private static final ImageDescriptor IMG_NODE = EditorPlugin.getDefault().getImageDescriptor("facesconfig/FacesConfig_Pageflow16.gif");
    private IPropertySource propertySource = null;
    private Image image = null;

    public Adapter createEMFAdapter() {
        return new PFBatchAdapter(){

            public void doNotifyChanged(Notification notification) {
                int type = notification.getEventType();
                int featureId = notification.getFeatureID(PageflowPackage.class);
                if (type == 1) {
                    switch (featureId) {
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            PageflowElementEditPart.this.refreshVisuals();
                        }
                    }
                }
            }
        };
    }

    protected PageflowElementEditPart(PageflowElement element) {
        this.setModel(element);
    }

    public Image getImage(PageflowElement element) {
        if (this.image == null) {
            ImageDescriptor imageDescriptor = null;
            imageDescriptor = element instanceof PageflowPage ? IMG_PAGE : IMG_NODE;
            this.image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
            if (this.image == null) {
                EditorPlugin.getDefault().getImageRegistry().put(imageDescriptor.toString(), imageDescriptor);
                this.image = EditorPlugin.getDefault().getImageRegistry().get(imageDescriptor.toString());
            }
        }
        return this.image;
    }

    public static String getTypeName(PageflowElement element) {
        if (element instanceof Pageflow) {
            return "Pageflow";
        }
        if (element instanceof PageflowPage) {
            return "Page";
        }
        return "[unknown]";
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        this.hookIntoPageflowElement(this.getPageflowElement());
        super.activate();
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.unhookFromPageflowElement(this.getPageflowElement());
        super.deactivate();
    }

    public PageflowElement getPageflowElement() {
        return (PageflowElement)this.getModel();
    }

    protected void refreshVisuals() {
        if (this.getParent() != null) {
            final PageflowElementEditPart part = this;
            if (Thread.currentThread() == PlatformUI.getWorkbench().getDisplay().getThread()) {
                this.refreshVisuals(part);
            } else {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        PageflowElementEditPart.this.refreshVisuals(part);
                    }
                });
            }
        }
    }

    private void refreshVisuals(AbstractGraphicalEditPart part) {
        Point loc = new Point(this.getPageflowElement().getX(), this.getPageflowElement().getY());
        Dimension size = new Dimension(this.getPageflowElement().getWidth(), this.getPageflowElement().getHeight());
        Rectangle r = new Rectangle(loc, size);
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)part, this.getFigure(), (Object)r);
    }

    public Object getAdapter(Class key) {
        if (key == IPropertySource.class) {
            return this.getPropertySource();
        }
        if (key == Adapter.class) {
            if (this.adapter == null) {
                this.adapter = this.createEMFAdapter();
            }
            return this.adapter;
        }
        return super.getAdapter(key);
    }

    private IPropertySource getPropertySource() {
        if (this.propertySource == null) {
            this.propertySource = new PageflowElementPropertySource(this.getPageflowElement());
        }
        return this.propertySource;
    }

    protected void hookIntoPageflowElement(PageflowElement element) {
        if (element != null && !element.eAdapters().contains(this.getAdapter(Adapter.class))) {
            element.eAdapters().add((Object)((Adapter)this.getAdapter(Adapter.class)));
        }
    }

    protected void unhookFromPageflowElement(PageflowElement element) {
        if (element != null) {
            element.eAdapters().remove(this.getAdapter(Adapter.class));
        }
    }

    protected IFigure createFigure() {
        PageflowNodeFigure figure_ = null;
        figure_ = new PageflowNodeFigure();
        PageflowElement elm = this.getPageflowElement();
        if (elm.getName() != null) {
            figure_.setImageText(this.getImage(elm), elm.getName());
        } else {
            figure_.setImageText(this.getImage(elm), PageflowElementEditPart.getTypeName(elm));
        }
        figure_.update();
        return figure_;
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            this.performOpen();
        } else if (request.getType() == "direct edit") {
            this.performDirectEdit();
        }
    }

    protected abstract void performDirectEdit();

    protected abstract void performOpen();

    public abstract void addAnnotation(Annotation var1);

    public abstract void removeAnnotation();

    public IResource getMarkerResource() {
        IResource resource = WebrootUtil.getResource((EObject)this.getModel());
        return resource;
    }
}

