/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.relations;

import java.util.Hashtable;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.relations.IRelation;

public abstract class AbstractRelation
implements IRelation {
    protected static final String SEPARATOR = ";";
    protected PersistentType owner;
    protected PersistentType inverse;
    protected PersistentAttribute ownerAnnotatedAttribute;
    protected PersistentAttribute inverseAnnotatedAttribute;
    protected String ownerAttributeName;
    protected String inverseAttributeName;
    public static final Hashtable<IRelation.RelType, String> relTypeToIdPart = new Hashtable();
    public static final Hashtable<IRelation.RelDir, String> relDirToIdPart = new Hashtable();

    static {
        relTypeToIdPart.put(IRelation.RelType.ONE_TO_ONE, "1-1");
        relTypeToIdPart.put(IRelation.RelType.ONE_TO_MANY, "1-N");
        relTypeToIdPart.put(IRelation.RelType.MANY_TO_ONE, "N-1");
        relTypeToIdPart.put(IRelation.RelType.MANY_TO_MANY, "N-N");
        relDirToIdPart.put(IRelation.RelDir.UNI, "->");
        relDirToIdPart.put(IRelation.RelDir.BI, "<->");
    }

    public AbstractRelation(PersistentType owner, PersistentType inverse) {
        this.owner = owner;
        this.inverse = inverse;
    }

    @Override
    public String getId() {
        return AbstractRelation.generateId(this.owner, this.inverse, this.getOwnerAttributeName(), this.getInverseAttributeName(), this.getRelType(), this.getRelDir());
    }

    @Override
    public PersistentType getOwner() {
        return this.owner;
    }

    @Override
    public PersistentType getInverse() {
        return this.inverse;
    }

    @Override
    public PersistentAttribute getInverseAnnotatedAttribute() {
        return this.inverseAnnotatedAttribute;
    }

    @Override
    public PersistentAttribute getOwnerAnnotatedAttribute() {
        return this.ownerAnnotatedAttribute;
    }

    @Override
    public void setOwnerAnnotatedAttribute(PersistentAttribute ownerAnnotatedAttribute) {
        this.ownerAnnotatedAttribute = ownerAnnotatedAttribute;
    }

    @Override
    public void setInverseAnnotatedAttribute(PersistentAttribute inverseAnnotatedAttribute) {
        this.inverseAnnotatedAttribute = inverseAnnotatedAttribute;
    }

    @Override
    public void setOwnerAttributeName(String ownerAttributeName) {
        this.ownerAttributeName = ownerAttributeName;
    }

    @Override
    public String getOwnerAttributeName() {
        if (this.ownerAnnotatedAttribute != null) {
            return this.ownerAnnotatedAttribute.getName();
        }
        return this.ownerAttributeName;
    }

    @Override
    public void setInverseAttributeName(String inverseAttributeName) {
        this.inverseAttributeName = inverseAttributeName;
    }

    @Override
    public String getInverseAttributeName() {
        if (this.inverseAnnotatedAttribute != null) {
            return this.inverseAnnotatedAttribute.getName();
        }
        return this.inverseAttributeName;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object otherRel) {
        if (!IRelation.class.isInstance(otherRel)) {
            return false;
        }
        return this.getId().equals(((IRelation)otherRel).getId());
    }

    @Override
    public abstract IRelation.RelType getRelType();

    @Override
    public abstract IRelation.RelDir getRelDir();

    public static String generateId(PersistentType owner, PersistentType inverse, String ownerAttributeName, String inverseAttributeName, IRelation.RelType relType, IRelation.RelDir relDir) {
        String id = "";
        id = inverseAttributeName != null ? String.valueOf(owner.getName()) + "-" + inverse.getName() + SEPARATOR + relTypeToIdPart.get((Object)relType) + SEPARATOR + relDirToIdPart.get((Object)relDir) + SEPARATOR + ownerAttributeName + SEPARATOR + inverseAttributeName : String.valueOf(owner.getName()) + "-" + inverse.getName() + SEPARATOR + relTypeToIdPart.get((Object)relType) + SEPARATOR + relDirToIdPart.get((Object)relDir) + SEPARATOR + ownerAttributeName;
        return id;
    }
}

