/*********************************************************************
* Copyright (c) 2011, 2019 SAP SE
*
* This program and the accompanying materials are made
* available under the terms of the Eclipse Public License 2.0
* which is available at https://www.eclipse.org/legal/epl-2.0/
*
* Contributors:
*    SAP SE - initial API, implementation and documentation
*
* SPDX-License-Identifier: EPL-2.0
**********************************************************************/
package org.eclipse.graphiti.examples.chess.features;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.graphiti.examples.chess.Messages;
import org.eclipse.graphiti.examples.mm.chess.Board;
import org.eclipse.graphiti.examples.mm.chess.ChessFactory;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICreateContext;
import org.eclipse.graphiti.features.impl.AbstractCreateFeature;
import org.eclipse.graphiti.mm.pictograms.Diagram;

public class CreateChessBoardFeature extends AbstractCreateFeature {

	public CreateChessBoardFeature(IFeatureProvider fp) {
		super(fp, Messages.CreateChessBoardFeature_name, Messages.CreateChessBoardFeature_description);
	}

	public boolean canCreate(ICreateContext context) {
		if (context.getTargetContainer() instanceof Diagram) {
			// Add new board only in case of an empty diagram
			return context.getTargetContainer().getChildren().size() == 0;
		}
		return false;
	}

	public Object[] create(ICreateContext context) {
		Resource resource = context.getTargetContainer().eResource();

		// Create a new chess board and add it to an EMF resource
		Board board = ChessFactory.eINSTANCE.createBoard();
		resource.getContents().add(board);

		// Delegate to the add feature
		addGraphicalRepresentation(context, board);
		return new Object[] { board };
	}
}
