/**
 */
package org.eclipse.gef.dot.internal.language.fontname;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.gef.dot.internal.language.fontname.FontnameFactory
 * @model kind="package"
 * @generated
 */
public interface FontnamePackage extends EPackage
{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "fontname";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/gef/dot/internal/language/DotFontName";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "fontname";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	FontnamePackage eINSTANCE = org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.FontName <em>Font Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.FontName
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getFontName()
	 * @generated
	 */
	int FONT_NAME = 0;

	/**
	 * The number of structural features of the '<em>Font Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int FONT_NAME_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.PostScriptFontNameImpl <em>Post Script Font Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.PostScriptFontNameImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPostScriptFontName()
	 * @generated
	 */
	int POST_SCRIPT_FONT_NAME = 1;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POST_SCRIPT_FONT_NAME__ALIAS = FONT_NAME_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Post Script Font Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int POST_SCRIPT_FONT_NAME_FEATURE_COUNT = FONT_NAME_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl <em>Pango Font Name</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPangoFontName()
	 * @generated
	 */
	int PANGO_FONT_NAME = 2;

	/**
	 * The feature id for the '<em><b>Style Options List</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PANGO_FONT_NAME__STYLE_OPTIONS_LIST = FONT_NAME_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Families</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PANGO_FONT_NAME__FAMILIES = FONT_NAME_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Final Family</b></em>' attribute list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PANGO_FONT_NAME__FINAL_FAMILY = FONT_NAME_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Pango Font Name</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PANGO_FONT_NAME_FEATURE_COUNT = FONT_NAME_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionsElementImpl <em>Style Options Element</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionsElementImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyleOptionsElement()
	 * @generated
	 */
	int STYLE_OPTIONS_ELEMENT = 3;

	/**
	 * The number of structural features of the '<em>Style Options Element</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STYLE_OPTIONS_ELEMENT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionImpl <em>Style Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyleOption()
	 * @generated
	 */
	int STYLE_OPTION = 4;

	/**
	 * The feature id for the '<em><b>Style</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STYLE_OPTION__STYLE = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Style Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STYLE_OPTION_FEATURE_COUNT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.VariantOptionImpl <em>Variant Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.VariantOptionImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getVariantOption()
	 * @generated
	 */
	int VARIANT_OPTION = 5;

	/**
	 * The feature id for the '<em><b>Variant</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_OPTION__VARIANT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Variant Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int VARIANT_OPTION_FEATURE_COUNT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.WeightOptionImpl <em>Weight Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.WeightOptionImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getWeightOption()
	 * @generated
	 */
	int WEIGHT_OPTION = 6;

	/**
	 * The feature id for the '<em><b>Weight</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEIGHT_OPTION__WEIGHT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Weight Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int WEIGHT_OPTION_FEATURE_COUNT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StretchOptionImpl <em>Stretch Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StretchOptionImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStretchOption()
	 * @generated
	 */
	int STRETCH_OPTION = 7;

	/**
	 * The feature id for the '<em><b>Stretch</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRETCH_OPTION__STRETCH = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Stretch Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STRETCH_OPTION_FEATURE_COUNT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.GravityOptionImpl <em>Gravity Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.GravityOptionImpl
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getGravityOption()
	 * @generated
	 */
	int GRAVITY_OPTION = 8;

	/**
	 * The feature id for the '<em><b>Gravity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAVITY_OPTION__GRAVITY = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Gravity Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GRAVITY_OPTION_FEATURE_COUNT = STYLE_OPTIONS_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.Style <em>Style</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.Style
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyle()
	 * @generated
	 */
	int STYLE = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.Variant <em>Variant</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.Variant
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getVariant()
	 * @generated
	 */
	int VARIANT = 10;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.Weight <em>Weight</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.Weight
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getWeight()
	 * @generated
	 */
	int WEIGHT = 11;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.Stretch <em>Stretch</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.Stretch
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStretch()
	 * @generated
	 */
	int STRETCH = 12;

	/**
	 * The meta object id for the '{@link org.eclipse.gef.dot.internal.language.fontname.Gravity <em>Gravity</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.Gravity
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getGravity()
	 * @generated
	 */
	int GRAVITY = 13;

	/**
	 * The meta object id for the '<em>Post Script Font Alias</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPostScriptFontAlias()
	 * @generated
	 */
	int POST_SCRIPT_FONT_ALIAS = 14;

	/**
	 * The meta object id for the '<em>List</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see java.util.List
	 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getList()
	 * @generated
	 */
	int LIST = 15;


	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.FontName <em>Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Font Name</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.FontName
	 * @generated
	 */
	EClass getFontName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName <em>Post Script Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Post Script Font Name</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName
	 * @generated
	 */
	EClass getPostScriptFontName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName#getAlias <em>Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontName#getAlias()
	 * @see #getPostScriptFontName()
	 * @generated
	 */
	EAttribute getPostScriptFontName_Alias();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.PangoFontName <em>Pango Font Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Pango Font Name</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PangoFontName
	 * @generated
	 */
	EClass getPangoFontName();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getStyleOptionsList <em>Style Options List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Style Options List</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getStyleOptionsList()
	 * @see #getPangoFontName()
	 * @generated
	 */
	EReference getPangoFontName_StyleOptionsList();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getFamilies <em>Families</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Families</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getFamilies()
	 * @see #getPangoFontName()
	 * @generated
	 */
	EAttribute getPangoFontName_Families();

	/**
	 * Returns the meta object for the attribute list '{@link org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getFinalFamily <em>Final Family</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute list '<em>Final Family</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PangoFontName#getFinalFamily()
	 * @see #getPangoFontName()
	 * @generated
	 */
	EAttribute getPangoFontName_FinalFamily();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement <em>Style Options Element</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Style Options Element</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StyleOptionsElement
	 * @generated
	 */
	EClass getStyleOptionsElement();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.StyleOption <em>Style Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Style Option</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StyleOption
	 * @generated
	 */
	EClass getStyleOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.StyleOption#getStyle <em>Style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Style</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StyleOption#getStyle()
	 * @see #getStyleOption()
	 * @generated
	 */
	EAttribute getStyleOption_Style();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.VariantOption <em>Variant Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Variant Option</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.VariantOption
	 * @generated
	 */
	EClass getVariantOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.VariantOption#getVariant <em>Variant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Variant</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.VariantOption#getVariant()
	 * @see #getVariantOption()
	 * @generated
	 */
	EAttribute getVariantOption_Variant();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.WeightOption <em>Weight Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Weight Option</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.WeightOption
	 * @generated
	 */
	EClass getWeightOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.WeightOption#getWeight <em>Weight</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Weight</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.WeightOption#getWeight()
	 * @see #getWeightOption()
	 * @generated
	 */
	EAttribute getWeightOption_Weight();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.StretchOption <em>Stretch Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Stretch Option</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StretchOption
	 * @generated
	 */
	EClass getStretchOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.StretchOption#getStretch <em>Stretch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stretch</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.StretchOption#getStretch()
	 * @see #getStretchOption()
	 * @generated
	 */
	EAttribute getStretchOption_Stretch();

	/**
	 * Returns the meta object for class '{@link org.eclipse.gef.dot.internal.language.fontname.GravityOption <em>Gravity Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gravity Option</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.GravityOption
	 * @generated
	 */
	EClass getGravityOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.gef.dot.internal.language.fontname.GravityOption#getGravity <em>Gravity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Gravity</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.GravityOption#getGravity()
	 * @see #getGravityOption()
	 * @generated
	 */
	EAttribute getGravityOption_Gravity();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.gef.dot.internal.language.fontname.Style <em>Style</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Style</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.Style
	 * @generated
	 */
	EEnum getStyle();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.gef.dot.internal.language.fontname.Variant <em>Variant</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Variant</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.Variant
	 * @generated
	 */
	EEnum getVariant();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.gef.dot.internal.language.fontname.Weight <em>Weight</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Weight</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.Weight
	 * @generated
	 */
	EEnum getWeight();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.gef.dot.internal.language.fontname.Stretch <em>Stretch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Stretch</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.Stretch
	 * @generated
	 */
	EEnum getStretch();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.gef.dot.internal.language.fontname.Gravity <em>Gravity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Gravity</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.Gravity
	 * @generated
	 */
	EEnum getGravity();

	/**
	 * Returns the meta object for data type '{@link org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias <em>Post Script Font Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>Post Script Font Alias</em>'.
	 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias
	 * @model instanceClass="org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias"
	 * @generated
	 */
	EDataType getPostScriptFontAlias();

	/**
	 * Returns the meta object for data type '{@link java.util.List <em>List</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for data type '<em>List</em>'.
	 * @see java.util.List
	 * @model instanceClass="java.util.List" serializeable="false" typeParameters="T"
	 * @generated
	 */
	EDataType getList();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	FontnameFactory getFontnameFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals
	{
		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.FontName <em>Font Name</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.FontName
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getFontName()
		 * @generated
		 */
		EClass FONT_NAME = eINSTANCE.getFontName();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.PostScriptFontNameImpl <em>Post Script Font Name</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.PostScriptFontNameImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPostScriptFontName()
		 * @generated
		 */
		EClass POST_SCRIPT_FONT_NAME = eINSTANCE.getPostScriptFontName();

		/**
		 * The meta object literal for the '<em><b>Alias</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute POST_SCRIPT_FONT_NAME__ALIAS = eINSTANCE.getPostScriptFontName_Alias();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl <em>Pango Font Name</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.PangoFontNameImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPangoFontName()
		 * @generated
		 */
		EClass PANGO_FONT_NAME = eINSTANCE.getPangoFontName();

		/**
		 * The meta object literal for the '<em><b>Style Options List</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PANGO_FONT_NAME__STYLE_OPTIONS_LIST = eINSTANCE.getPangoFontName_StyleOptionsList();

		/**
		 * The meta object literal for the '<em><b>Families</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PANGO_FONT_NAME__FAMILIES = eINSTANCE.getPangoFontName_Families();

		/**
		 * The meta object literal for the '<em><b>Final Family</b></em>' attribute list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PANGO_FONT_NAME__FINAL_FAMILY = eINSTANCE.getPangoFontName_FinalFamily();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionsElementImpl <em>Style Options Element</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionsElementImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyleOptionsElement()
		 * @generated
		 */
		EClass STYLE_OPTIONS_ELEMENT = eINSTANCE.getStyleOptionsElement();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionImpl <em>Style Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StyleOptionImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyleOption()
		 * @generated
		 */
		EClass STYLE_OPTION = eINSTANCE.getStyleOption();

		/**
		 * The meta object literal for the '<em><b>Style</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STYLE_OPTION__STYLE = eINSTANCE.getStyleOption_Style();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.VariantOptionImpl <em>Variant Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.VariantOptionImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getVariantOption()
		 * @generated
		 */
		EClass VARIANT_OPTION = eINSTANCE.getVariantOption();

		/**
		 * The meta object literal for the '<em><b>Variant</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute VARIANT_OPTION__VARIANT = eINSTANCE.getVariantOption_Variant();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.WeightOptionImpl <em>Weight Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.WeightOptionImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getWeightOption()
		 * @generated
		 */
		EClass WEIGHT_OPTION = eINSTANCE.getWeightOption();

		/**
		 * The meta object literal for the '<em><b>Weight</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute WEIGHT_OPTION__WEIGHT = eINSTANCE.getWeightOption_Weight();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.StretchOptionImpl <em>Stretch Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.StretchOptionImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStretchOption()
		 * @generated
		 */
		EClass STRETCH_OPTION = eINSTANCE.getStretchOption();

		/**
		 * The meta object literal for the '<em><b>Stretch</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STRETCH_OPTION__STRETCH = eINSTANCE.getStretchOption_Stretch();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.impl.GravityOptionImpl <em>Gravity Option</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.GravityOptionImpl
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getGravityOption()
		 * @generated
		 */
		EClass GRAVITY_OPTION = eINSTANCE.getGravityOption();

		/**
		 * The meta object literal for the '<em><b>Gravity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GRAVITY_OPTION__GRAVITY = eINSTANCE.getGravityOption_Gravity();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.Style <em>Style</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.Style
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStyle()
		 * @generated
		 */
		EEnum STYLE = eINSTANCE.getStyle();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.Variant <em>Variant</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.Variant
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getVariant()
		 * @generated
		 */
		EEnum VARIANT = eINSTANCE.getVariant();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.Weight <em>Weight</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.Weight
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getWeight()
		 * @generated
		 */
		EEnum WEIGHT = eINSTANCE.getWeight();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.Stretch <em>Stretch</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.Stretch
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getStretch()
		 * @generated
		 */
		EEnum STRETCH = eINSTANCE.getStretch();

		/**
		 * The meta object literal for the '{@link org.eclipse.gef.dot.internal.language.fontname.Gravity <em>Gravity</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.Gravity
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getGravity()
		 * @generated
		 */
		EEnum GRAVITY = eINSTANCE.getGravity();

		/**
		 * The meta object literal for the '<em>Post Script Font Alias</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see org.eclipse.gef.dot.internal.language.fontname.PostScriptFontAlias
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getPostScriptFontAlias()
		 * @generated
		 */
		EDataType POST_SCRIPT_FONT_ALIAS = eINSTANCE.getPostScriptFontAlias();

		/**
		 * The meta object literal for the '<em>List</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see java.util.List
		 * @see org.eclipse.gef.dot.internal.language.fontname.impl.FontnamePackageImpl#getList()
		 * @generated
		 */
		EDataType LIST = eINSTANCE.getList();

	}

} //FontnamePackage
