/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.eclipse.emf.eef.mapping.navigation.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.eef.mapping.navigation.DeclarativeNavigationStep;
import org.eclipse.emf.eef.mapping.navigation.NavigationPackage;
import org.eclipse.emf.eef.mapping.navigation.NavigationStep;
import org.eclipse.emf.eef.mapping.navigation.SmartModelNavigation;

/**
 * This is the item provider adapter for a {@link org.eclipse.emf.eef.mapping.navigation.DeclarativeNavigationStep} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DeclarativeNavigationStepItemProvider extends
		NavigationStepItemProvider implements IEditingDomainItemProvider,
		IStructuredItemContentProvider, ITreeItemContentProvider,
		IItemLabelProvider, IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeclarativeNavigationStepItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addIndexPropertyDescriptor(object);
			addFeaturePropertyDescriptor(object);
			addDiscriminatorTypePropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Index feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addIndexPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(createItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DeclarativeNavigationStep_index_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DeclarativeNavigationStep_index_feature",
						"_UI_DeclarativeNavigationStep_type"),
				NavigationPackage.Literals.DECLARATIVE_NAVIGATION_STEP__INDEX,
				true, false, false,
				ItemPropertyDescriptor.INTEGRAL_VALUE_IMAGE, null, null));
	}

	/**
	 * This adds a property descriptor for the Feature feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	protected void addFeaturePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add(initFeatureItemDescriptor());
	}

	/**
	 * @return
	 * @generated NOT
	 */
	private ItemPropertyDescriptor initFeatureItemDescriptor() {
		return new ItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DeclarativeNavigationStep_feature_feature"),
				getString("_UI_PropertyDescriptor_description",
						"_UI_DeclarativeNavigationStep_feature_feature",
						"_UI_DeclarativeNavigationStep_type"),
				NavigationPackage.Literals.DECLARATIVE_NAVIGATION_STEP__FEATURE,
				true, false, true, null, null, null) {

			@Override
			public Collection<?> getChoiceOfValues(Object object) {
				Collection<?> choiceOfValues = super.getChoiceOfValues(object);
				if (object instanceof NavigationStep) {
					NavigationStep step = (NavigationStep) object;
					EClass currentClass = null;
					if (step.eContainer() instanceof SmartModelNavigation) {
						currentClass = step.owningEClass();
					} else if (step.eContainer() instanceof NavigationStep
							&& NavigationPackage.eINSTANCE
									.getNavigationStep_SubStep() == step
									.eContainingFeature()) {
						currentClass = ((NavigationStep) step.eContainer())
								.currentEClass();
					}

					if (currentClass != null) {
						EList<EStructuralFeature> allStructuralFeatures = currentClass
								.getEAllStructuralFeatures();
						List<EStructuralFeature> results = new ArrayList<EStructuralFeature>();
						for (Object value : choiceOfValues) {
							if (value instanceof EStructuralFeature
									&& allStructuralFeatures.contains(value))
								results.add((EStructuralFeature) value);
						}
						return results;
					}
				}
				return choiceOfValues;
			}

		};
	}

	/**
	 * This adds a property descriptor for the Discriminator Type feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addDiscriminatorTypePropertyDescriptor(Object object) {
		itemPropertyDescriptors
				.add(createItemPropertyDescriptor(
						((ComposeableAdapterFactory) adapterFactory)
								.getRootAdapterFactory(),
						getResourceLocator(),
						getString("_UI_DeclarativeNavigationStep_discriminatorType_feature"),
						getString(
								"_UI_PropertyDescriptor_description",
								"_UI_DeclarativeNavigationStep_discriminatorType_feature",
								"_UI_DeclarativeNavigationStep_type"),
						NavigationPackage.Literals.DECLARATIVE_NAVIGATION_STEP__DISCRIMINATOR_TYPE,
						true, false, true, null, null, null));
	}

	/**
	 * @return
	 * @generated NOT
	 */
	private ItemPropertyDescriptor initializeDiscriminatorTypePropertyDescriptor() {
		return new ItemPropertyDescriptor(
				((ComposeableAdapterFactory) adapterFactory)
						.getRootAdapterFactory(),
				getResourceLocator(),
				getString("_UI_DeclarativeNavigationStep_discriminatorType_feature"),
				getString(
						"_UI_PropertyDescriptor_description",
						"_UI_DeclarativeNavigationStep_discriminatorType_feature",
						"_UI_DeclarativeNavigationStep_type"),
				NavigationPackage.Literals.DECLARATIVE_NAVIGATION_STEP__DISCRIMINATOR_TYPE,
				true, false, true, null, null, null) {

			@Override
			public Collection<?> getChoiceOfValues(Object object) {
				Collection<?> choiceOfValues = super.getChoiceOfValues(object);
				if (object instanceof DeclarativeNavigationStep) {
					DeclarativeNavigationStep step = (DeclarativeNavigationStep) object;
					if (step.getFeature() != null) {
						EClassifier type = step.getFeature().getEType();
						if (type instanceof EClass) {
							EClass targetType = (EClass) type;
							List<EClassifier> result = new ArrayList<EClassifier>();
							for (Object value : choiceOfValues) {
								if (value instanceof EClass
										&& targetType
												.isSuperTypeOf((EClass) value))
									result.add((EClassifier) value);
							}
							return result;
						}
					}
				}
				return choiceOfValues;
			}

		};
	}

	/**
	 * This returns DeclarativeNavigationStep.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(
				object,
				getResourceLocator().getImage(
						"full/obj16/DeclarativeNavigationStep"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		DeclarativeNavigationStep declarativeNavigationStep = (DeclarativeNavigationStep) object;
		return getString("_UI_DeclarativeNavigationStep_type") + " "
				+ declarativeNavigationStep.getIndex();
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(DeclarativeNavigationStep.class)) {
		case NavigationPackage.DECLARATIVE_NAVIGATION_STEP__INDEX:
			fireNotifyChanged(new ViewerNotification(notification,
					notification.getNotifier(), false, true));
			return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(
			Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

}
