/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.spi.cdo;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOObjectReference;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchPointRange;
import org.eclipse.emf.cdo.common.commit.CDOChangeSetData;
import org.eclipse.emf.cdo.common.commit.CDOCommitData;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDProvider;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lob.CDOLob;
import org.eclipse.emf.cdo.common.lob.CDOLobInfo;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.IDurableLockingManager;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.protocol.CDODataInput;
import org.eclipse.emf.cdo.common.protocol.CDOProtocol;
import org.eclipse.emf.cdo.common.protocol.CDOProtocolConstants;
import org.eclipse.emf.cdo.common.revision.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.CDORevisionHandler;
import org.eclipse.emf.cdo.common.revision.CDORevisionKey;
import org.eclipse.emf.cdo.common.security.CDOPermission;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionMessage;
import org.eclipse.emf.cdo.spi.common.CDORawReplicationContext;
import org.eclipse.emf.cdo.spi.common.CDOReplicationContext;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDORevisionAvailabilityInfo;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.CDOIDMapper;
import org.eclipse.emf.cdo.spi.common.revision.CDOReferenceAdjuster;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.util.collection.UnionSet;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.security.operations.AuthorizableOperation;

public interface CDOSessionProtocol
extends CDOProtocol,
InternalCDOPackageRegistry.PackageLoader,
InternalCDOBranchManager.BranchLoader5,
InternalCDORevisionManager.RevisionLoader3,
InternalCDOCommitInfoManager.CommitInfoLoader {
    public RepositoryTimeResult getRepositoryTime();

    public void openedSession();

    public void disablePassiveUpdate();

    public void setPassiveUpdateMode(CDOCommonSession.Options.PassiveUpdateMode var1);

    public void setLockNotificationMode(CDOCommonSession.Options.LockNotificationMode var1);

    public RefreshSessionResult refresh(long var1, Map<CDOBranch, Map<CDOID, InternalCDORevision>> var3, int var4, boolean var5);

    public Object loadChunk(InternalCDORevision var1, EStructuralFeature var2, int var3, int var4, int var5, int var6);

    public void openView(int var1, boolean var2, CDOBranchPoint var3);

    public CDOBranchPoint openView(int var1, boolean var2, String var3, BiConsumer<CDOID, IDurableLockingManager.LockGrade> var4);

    public void switchTarget(int var1, CDOBranchPoint var2, List<InternalCDOObject> var3, List<CDORevisionKey> var4, List<CDOIDAndVersion> var5, OMMonitor var6);

    public void closeView(int var1);

    public void changeSubscription(int var1, List<CDOID> var2, boolean var3, boolean var4);

    public void query(CDOView var1, AbstractQueryIterator<?> var2);

    public boolean cancelQuery(int var1);

    public LockObjectsResult lockObjects2(List<CDORevisionKey> var1, int var2, CDOBranch var3, IRWLockManager.LockType var4, boolean var5, long var6) throws InterruptedException;

    public LockObjectsResult delegateLockObjects(String var1, List<CDORevisionKey> var2, CDOBranch var3, IRWLockManager.LockType var4, boolean var5, long var6) throws InterruptedException;

    public UnlockObjectsResult unlockObjects2(CDOView var1, Collection<CDOID> var2, IRWLockManager.LockType var3, boolean var4);

    public UnlockObjectsResult delegateUnlockObjects(String var1, Collection<CDOID> var2, IRWLockManager.LockType var3, boolean var4);

    public boolean isObjectLocked(CDOView var1, CDOObject var2, IRWLockManager.LockType var3, boolean var4);

    public String changeLockArea(CDOView var1, boolean var2);

    public List<byte[]> queryLobs(Set<byte[]> var1);

    public void loadLob(CDOLobInfo var1, Object var2) throws IOException;

    public CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitDelegation(InternalCDOTransaction.InternalCDOCommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CommitTransactionResult commitXATransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext var1, OMMonitor var2);

    public CDOCommitInfo resetTransaction(int var1, int var2);

    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager var1, boolean var2);

    public Set<Integer> sendRemoteMessage(CDORemoteSessionMessage var1, List<CDORemoteSession> var2);

    public boolean unsubscribeRemoteSessions();

    public void replicateRepository(CDOReplicationContext var1, OMMonitor var2);

    public void replicateRepositoryRaw(CDORawReplicationContext var1, OMMonitor var2);

    public CDOChangeSetData[] loadChangeSets(CDOBranchPointRange ... var1);

    public MergeDataResult loadMergeData2(CDORevisionAvailabilityInfo var1, CDORevisionAvailabilityInfo var2, CDORevisionAvailabilityInfo var3, CDORevisionAvailabilityInfo var4);

    public List<CDOLockState> getLockStates2(int var1, Collection<CDOID> var2, int var3);

    public void enableLockNotifications(int var1, boolean var2);

    public Map<CDORevision, CDOPermission> loadPermissions(InternalCDORevision[] var1);

    public String[] authorizeOperations(AuthorizableOperation[] var1);

    public void requestChangeServerPassword(AtomicReference<char[]> var1);

    public void requestResetCredentials(String var1);

    public boolean requestUnit(int var1, CDOID var2, CDOProtocolConstants.UnitOpcode var3, CDORevisionHandler var4, OMMonitor var5);

    @Deprecated
    public LockObjectsResult lockObjects(List<InternalCDORevision> var1, int var2, CDOBranch var3, IRWLockManager.LockType var4, long var5) throws InterruptedException;

    @Deprecated
    public void unlockObjects(CDOView var1, Collection<CDOID> var2, IRWLockManager.LockType var3);

    @Deprecated
    public CommitTransactionResult commitTransaction(int var1, String var2, boolean var3, CDOIDProvider var4, CDOCommitData var5, Collection<CDOLob<?>> var6, OMMonitor var7);

    @Deprecated
    public CommitTransactionResult commitDelegation(CDOBranch var1, String var2, String var3, CDOCommitData var4, Map<CDOID, EClass> var5, Collection<CDOLob<?>> var6, OMMonitor var7);

    @Deprecated
    public Set<CDOID> loadMergeData(CDORevisionAvailabilityInfo var1, CDORevisionAvailabilityInfo var2, CDORevisionAvailabilityInfo var3, CDORevisionAvailabilityInfo var4);

    @Deprecated
    public CDOLockState[] getLockStates(int var1, Collection<CDOID> var2);

    @Deprecated
    public CDOLockState[] getLockStates(int var1, Collection<CDOID> var2, int var3);

    @Deprecated
    public CDOBranchPoint openView(int var1, boolean var2, String var3);

    @Deprecated
    public void requestChangeCredentials();

    public static final class CommitTransactionResult
    implements CDOBranchPoint {
        private CDOIDProvider idProvider;
        private byte rollbackReason;
        private String rollbackMessage;
        private List<CDOObjectReference> xRefs;
        private CDOBranchPoint branchPoint;
        private long previousTimeStamp;
        private Map<CDOID, CDOID> idMappings = CDOIDUtil.createMap();
        private CDOReferenceAdjuster referenceAdjuster;
        private List<CDOLockDelta> lockDeltas;
        private List<CDOLockState> lockStates;
        private boolean clearResourcePathCache;
        private byte securityImpact;
        private Map<CDOID, CDOPermission> newPermissions;
        private CDOProtocol.CommitData newCommitData;

        public CommitTransactionResult() {
        }

        @Deprecated
        public CommitTransactionResult(CDOIDProvider idProvider, String rollbackMessage, CDOBranchPoint branchPoint, long previousTimeStamp, List<CDOObjectReference> xRefs) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public CommitTransactionResult(CDOIDProvider idProvider, byte rollbackReason, String rollbackMessage, CDOBranchPoint branchPoint, long previousTimeStamp, List<CDOObjectReference> xRefs, boolean clearResourcePathCache) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public CommitTransactionResult(CDOIDProvider idProvider, CDOBranchPoint branchPoint, long previousTimeStamp) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public CommitTransactionResult(CDOIDProvider idProvider, CDOBranchPoint branchPoint, long previousTimeStamp, boolean clearResourcePathCache) {
            throw new UnsupportedOperationException();
        }

        public CDOBranch getBranch() {
            return this.branchPoint.getBranch();
        }

        public long getTimeStamp() {
            return this.branchPoint.getTimeStamp();
        }

        public void setBranchPoint(CDOBranchPoint branchPoint) {
            this.branchPoint = branchPoint;
        }

        public long getPreviousTimeStamp() {
            return this.previousTimeStamp;
        }

        public void setPreviousTimeStamp(long previousTimeStamp) {
            this.previousTimeStamp = previousTimeStamp;
        }

        public CDOReferenceAdjuster getReferenceAdjuster() {
            if (this.referenceAdjuster == null) {
                this.referenceAdjuster = this.createReferenceAdjuster();
            }
            return this.referenceAdjuster;
        }

        public void setReferenceAdjuster(CDOReferenceAdjuster referenceAdjuster) {
            this.referenceAdjuster = referenceAdjuster;
        }

        public byte getRollbackReason() {
            return this.rollbackReason;
        }

        public void setRollbackReason(byte rollbackReason) {
            this.rollbackReason = rollbackReason;
        }

        public String getRollbackMessage() {
            return this.rollbackMessage;
        }

        public void setRollbackMessage(String rollbackMessage) {
            this.rollbackMessage = rollbackMessage;
        }

        public List<CDOObjectReference> getXRefs() {
            return this.xRefs;
        }

        public void setXRefs(List<CDOObjectReference> xRefs) {
            this.xRefs = xRefs;
        }

        public boolean isClearResourcePathCache() {
            return this.clearResourcePathCache;
        }

        public void setClearResourcePathCache(boolean clearResourcePathCache) {
            this.clearResourcePathCache = clearResourcePathCache;
        }

        public byte getSecurityImpact() {
            return this.securityImpact;
        }

        public void setSecurityImpact(byte securityImpact) {
            this.securityImpact = securityImpact;
        }

        public CDOIDProvider getIDProvider() {
            return this.idProvider;
        }

        public void setIDProvider(CDOIDProvider idProvider) {
            this.idProvider = idProvider;
        }

        public Map<CDOID, CDOID> getIDMappings() {
            return this.idMappings;
        }

        public void addIDMapping(CDOID oldID, CDOID newID) {
            this.idMappings.put(oldID, newID);
        }

        public List<CDOLockDelta> getLockDeltas() {
            return this.lockDeltas;
        }

        public void setLockDeltas(List<CDOLockDelta> lockDeltas) {
            this.lockDeltas = lockDeltas;
        }

        public List<CDOLockState> getLockStates() {
            return this.lockStates;
        }

        public void setLockStates(List<CDOLockState> lockStates) {
            this.lockStates = lockStates;
        }

        public Map<CDOID, CDOPermission> getNewPermissions() {
            return this.newPermissions;
        }

        public void addNewPermission(CDOID id, CDOPermission permission) {
            if (this.newPermissions == null) {
                this.newPermissions = CDOIDUtil.createMap();
            }
            this.newPermissions.put(id, permission);
        }

        public CDOProtocol.CommitData getNewCommitData() {
            return this.newCommitData;
        }

        public void setNewCommitData(CDOProtocol.CommitData newCommitData) {
            this.newCommitData = newCommitData;
        }

        protected PostCommitReferenceAdjuster createReferenceAdjuster() {
            return new PostCommitReferenceAdjuster(this.idProvider, new CDOIDMapper(this.idMappings));
        }

        @Deprecated
        public CDOLockState[] getNewLockStates() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public void setNewLockStates(CDOLockState[] newLockStates) {
            throw new UnsupportedOperationException();
        }

        protected static class PostCommitReferenceAdjuster
        implements CDOReferenceAdjuster {
            private CDOIDProvider idProvider;
            private CDOIDMapper idMapper;

            public PostCommitReferenceAdjuster(CDOIDProvider idProvider, CDOIDMapper idMapper) {
                this.idProvider = idProvider;
                this.idMapper = idMapper;
            }

            public Object adjustReference(Object id, EStructuralFeature feature, int index) {
                if (id == null || id == CDOID.NULL) {
                    return id;
                }
                if (this.idProvider != null && (id instanceof CDOID || id instanceof InternalEObject)) {
                    id = this.idProvider.provideCDOID(id);
                }
                return this.idMapper.adjustReference(id, feature, index);
            }
        }
    }

    public static final class LockObjectsResult {
        private final boolean successful;
        private final boolean timedOut;
        private final boolean waitForUpdate;
        private final long requiredTimestamp;
        private final long timestamp;
        private final CDORevisionKey[] staleRevisions;
        private final List<CDOLockDelta> lockDeltas;
        private final List<CDOLockState> lockStates;

        public LockObjectsResult(boolean successful, boolean timedOut, boolean waitForUpdate, long requiredTimestamp, CDORevisionKey[] staleRevisions, List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates, long timestamp) {
            this.successful = successful;
            this.timedOut = timedOut;
            this.waitForUpdate = waitForUpdate;
            this.requiredTimestamp = requiredTimestamp;
            this.staleRevisions = staleRevisions;
            this.lockDeltas = lockDeltas;
            this.lockStates = lockStates;
            this.timestamp = timestamp;
        }

        public boolean isSuccessful() {
            return this.successful;
        }

        public boolean isTimedOut() {
            return this.timedOut;
        }

        public boolean isWaitForUpdate() {
            return this.waitForUpdate;
        }

        public long getRequiredTimestamp() {
            return this.requiredTimestamp;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public CDORevisionKey[] getStaleRevisions() {
            return this.staleRevisions;
        }

        public List<CDOLockDelta> getLockDeltas() {
            return this.lockDeltas;
        }

        public List<CDOLockState> getLockStates() {
            return this.lockStates;
        }

        @Deprecated
        public CDOLockState[] getNewLockStates() {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public LockObjectsResult(boolean successful, boolean timedOut, boolean waitForUpdate, long requiredTimestamp, CDORevisionKey[] staleRevisions) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public LockObjectsResult(boolean successful, boolean timedOut, boolean waitForUpdate, long requiredTimestamp, CDORevisionKey[] staleRevisions, CDOLockState[] newLockStates, long timestamp) {
            throw new UnsupportedOperationException();
        }
    }

    public static final class MergeDataResult {
        private final Set<CDOID> targetIDs = new HashSet<CDOID>();
        private final Set<CDOID> sourceIDs = new HashSet<CDOID>();
        private CDOBranchPoint resultBase;

        public Set<CDOID> getIDs() {
            return new UnionSet(this.sourceIDs, this.targetIDs);
        }

        public Set<CDOID> getTargetIDs() {
            return this.targetIDs;
        }

        public Set<CDOID> getSourceIDs() {
            return this.sourceIDs;
        }

        public CDOBranchPoint getResultBase() {
            return this.resultBase;
        }

        public void setResultBase(CDOBranchPoint resultBase) {
            this.resultBase = resultBase;
        }
    }

    public static final class OpenSessionResult
    extends PlatformObject
    implements CDOCommonRepository {
        private int sessionID;
        private String userID;
        private String uuid;
        private String name;
        private CDOCommonRepository.Type type;
        private CDOCommonRepository.State state;
        private String storeType;
        private final Set<CDOID.ObjectType> objectIDTypes = new HashSet<CDOID.ObjectType>();
        private long repositoryCreationTime;
        private long lastUpdateTime;
        private long openingTime;
        private int tagModCount;
        private RepositoryTimeResult repositoryTimeResult;
        private CDOID rootResourceID;
        private boolean authenticating;
        private boolean supportingAudits;
        private boolean supportingBranches;
        private boolean supportingUnits;
        private boolean serializingCommits;
        private boolean ensuringReferentialIntegrity;
        private boolean authorizingOperations;
        private final List<InternalCDOPackageUnit> packageUnits = new ArrayList<InternalCDOPackageUnit>();
        private CDOCommonRepository.IDGenerationLocation idGenerationLocation;
        private CDOCommonRepository.CommitInfoStorage commitInfoStorage;
        private String[] authorizationResults;

        public OpenSessionResult(CDODataInput in, int sessionID) throws IOException {
            this.sessionID = sessionID;
            this.userID = in.readString();
            this.uuid = in.readString();
            this.name = in.readString();
            this.type = (CDOCommonRepository.Type)in.readEnum(CDOCommonRepository.Type.class);
            this.state = (CDOCommonRepository.State)in.readEnum(CDOCommonRepository.State.class);
            this.storeType = in.readString();
            int types = in.readXInt();
            int i = 0;
            while (i < types) {
                CDOID.ObjectType objectIDType = (CDOID.ObjectType)in.readEnum(CDOID.ObjectType.class);
                this.objectIDTypes.add(objectIDType);
                ++i;
            }
            this.repositoryCreationTime = in.readXLong();
            this.lastUpdateTime = in.readXLong();
            this.openingTime = in.readXLong();
            this.tagModCount = in.readXInt();
            this.rootResourceID = in.readCDOID();
            this.authenticating = in.readBoolean();
            this.supportingAudits = in.readBoolean();
            this.supportingBranches = in.readBoolean();
            this.supportingUnits = in.readBoolean();
            this.serializingCommits = in.readBoolean();
            this.ensuringReferentialIntegrity = in.readBoolean();
            this.authorizingOperations = in.readBoolean();
            this.idGenerationLocation = (CDOCommonRepository.IDGenerationLocation)in.readEnum(CDOCommonRepository.IDGenerationLocation.class);
            this.commitInfoStorage = (CDOCommonRepository.CommitInfoStorage)in.readEnum(CDOCommonRepository.CommitInfoStorage.class);
            int operations = in.readXInt();
            this.authorizationResults = new String[operations];
            int i2 = 0;
            while (i2 < this.authorizationResults.length) {
                this.authorizationResults[i2] = in.readString();
                ++i2;
            }
            CDOPackageUnit[] packageUnits = in.readCDOPackageUnits(null);
            int i3 = 0;
            while (i3 < packageUnits.length) {
                this.packageUnits.add((InternalCDOPackageUnit)packageUnits[i3]);
                ++i3;
            }
        }

        @Deprecated
        public OpenSessionResult(int sessionID, String userID, String repositoryUUID, CDOCommonRepository.Type repositoryType, CDOCommonRepository.State repositoryState, String storeType, Set<CDOID.ObjectType> objectIDTypes, long repositoryCreationTime, long lastUpdateTime, CDOID rootResourceID, boolean repositorySupportingAudits, boolean repositorySupportingBranches, boolean repositorySerializingCommits, boolean repositoryEnsuringReferentialIntegrity, CDOCommonRepository.IDGenerationLocation repositoryIDGenerationLocation) {
            throw new UnsupportedOperationException();
        }

        public int getSessionID() {
            return this.sessionID;
        }

        public String getUserID() {
            return this.userID;
        }

        public String getUUID() {
            return this.uuid;
        }

        public String getName() {
            return this.name;
        }

        public CDOCommonRepository.Type getType() {
            return this.type;
        }

        public CDOCommonRepository.State getState() {
            return this.state;
        }

        public String getStoreType() {
            return this.storeType;
        }

        public Set<CDOID.ObjectType> getObjectIDTypes() {
            return this.objectIDTypes;
        }

        public CDOID getRootResourceID() {
            return this.rootResourceID;
        }

        public long getCreationTime() {
            return this.repositoryCreationTime;
        }

        public boolean isAuthenticating() {
            return this.authenticating;
        }

        public boolean isSupportingAudits() {
            return this.supportingAudits;
        }

        public boolean isSupportingBranches() {
            return this.supportingBranches;
        }

        public boolean isSupportingUnits() {
            return this.supportingUnits;
        }

        @Deprecated
        public boolean isSupportingEcore() {
            return true;
        }

        public boolean isSerializingCommits() {
            return this.serializingCommits;
        }

        public boolean isEnsuringReferentialIntegrity() {
            return this.ensuringReferentialIntegrity;
        }

        public boolean isAuthorizingOperations() {
            return this.authorizingOperations;
        }

        public CDOCommonRepository.IDGenerationLocation getIDGenerationLocation() {
            return this.idGenerationLocation;
        }

        public CDOCommonRepository.CommitInfoStorage getCommitInfoStorage() {
            return this.commitInfoStorage;
        }

        public String[] getAuthorizationResults() {
            return this.authorizationResults;
        }

        public int getTagModCount() {
            return this.tagModCount;
        }

        public long getOpeningTime() {
            return this.openingTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public List<InternalCDOPackageUnit> getPackageUnits() {
            return this.packageUnits;
        }

        public RepositoryTimeResult getRepositoryTimeResult() {
            return this.repositoryTimeResult;
        }

        public void setRepositoryTimeResult(RepositoryTimeResult repositoryTimeResult) {
            this.repositoryTimeResult = repositoryTimeResult;
        }

        public long getTimeStamp() {
            throw new UnsupportedOperationException();
        }

        public boolean waitWhileInitial(IProgressMonitor monitor) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public String getRepositoryUUID() {
            return this.getUUID();
        }

        @Deprecated
        public CDOCommonRepository.Type getRepositoryType() {
            return this.getType();
        }

        @Deprecated
        public CDOCommonRepository.State getRepositoryState() {
            return this.getState();
        }

        @Deprecated
        public long getRepositoryCreationTime() {
            return this.getCreationTime();
        }

        @Deprecated
        public boolean isRepositoryAuthenticating() {
            return this.isAuthenticating();
        }

        @Deprecated
        public boolean isRepositorySupportingAudits() {
            return this.isSupportingAudits();
        }

        @Deprecated
        public boolean isRepositorySupportingBranches() {
            return this.isSupportingBranches();
        }

        @Deprecated
        public boolean isRepositorySupportingEcore() {
            return this.isSupportingEcore();
        }

        @Deprecated
        public boolean isRepositorySerializingCommits() {
            return this.isSerializingCommits();
        }

        @Deprecated
        public boolean isRepositoryEnsuringReferentialIntegrity() {
            return this.isEnsuringReferentialIntegrity();
        }

        @Deprecated
        public CDOCommonRepository.IDGenerationLocation getRepositoryIDGenerationLocation() {
            return this.getIDGenerationLocation();
        }
    }

    public static final class RefreshSessionResult {
        private long lastUpdateTime;
        private List<CDOPackageUnit> packageUnits = new ArrayList<CDOPackageUnit>();
        private Map<CDOBranch, List<InternalCDORevision>> changedObjects = new HashMap<CDOBranch, List<InternalCDORevision>>();
        private Map<CDOBranch, List<CDOIDAndVersion>> detachedObjects = new HashMap<CDOBranch, List<CDOIDAndVersion>>();

        public RefreshSessionResult(long lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        public long getLastUpdateTime() {
            return this.lastUpdateTime;
        }

        public List<CDOPackageUnit> getPackageUnits() {
            return this.packageUnits;
        }

        public List<InternalCDORevision> getChangedObjects(CDOBranch branch) {
            List<InternalCDORevision> list = this.changedObjects.get(branch);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public List<CDOIDAndVersion> getDetachedObjects(CDOBranch branch) {
            List<CDOIDAndVersion> list = this.detachedObjects.get(branch);
            if (list == null) {
                return Collections.emptyList();
            }
            return list;
        }

        public void addPackageUnit(CDOPackageUnit packageUnit) {
            this.packageUnits.add(packageUnit);
        }

        public void addChangedObject(InternalCDORevision revision) {
            InternalCDOBranch branch = revision.getBranch();
            List<InternalCDORevision> list = this.changedObjects.get(branch);
            if (list == null) {
                list = new ArrayList<InternalCDORevision>();
                this.changedObjects.put((CDOBranch)branch, list);
            }
            list.add(revision);
        }

        public void addDetachedObject(CDORevisionKey revision) {
            CDOBranch branch = revision.getBranch();
            List<CDOIDAndVersion> list = this.detachedObjects.get(branch);
            if (list == null) {
                list = new ArrayList<CDOIDAndVersion>();
                this.detachedObjects.put(branch, list);
            }
            list.add((CDOIDAndVersion)revision);
        }

        public static interface Provider {
            public RefreshSessionResult getRefreshSessionResult(Map<CDOBranch, List<InternalCDOView>> var1, Map<CDOBranch, Map<CDOID, InternalCDORevision>> var2);
        }
    }

    public static final class RepositoryTimeResult {
        private long requested;
        private long indicated;
        private long responded;
        private long confirmed;

        public long getRequested() {
            return this.requested;
        }

        public void setRequested(long requested) {
            this.requested = requested;
        }

        public long getIndicated() {
            return this.indicated;
        }

        public void setIndicated(long indicated) {
            this.indicated = indicated;
        }

        public long getResponded() {
            return this.responded;
        }

        public void setResponded(long responded) {
            this.responded = responded;
        }

        public long getConfirmed() {
            return this.confirmed;
        }

        public void setConfirmed(long confirmed) {
            this.confirmed = confirmed;
        }

        public long getAproximateRepositoryOffset() {
            long latency = this.confirmed - this.requested >> 1;
            long shift = this.confirmed - this.responded;
            return shift - latency;
        }

        public long getAproximateRepositoryTime() {
            long offset = this.getAproximateRepositoryOffset();
            return System.currentTimeMillis() + offset;
        }

        public String toString() {
            return MessageFormat.format("RepositoryTime[requested={0}, indicated={1}, responded={2}, confirmed={3}]", CDOCommonUtil.formatTimeStamp((long)this.requested), CDOCommonUtil.formatTimeStamp((long)this.indicated), CDOCommonUtil.formatTimeStamp((long)this.responded), CDOCommonUtil.formatTimeStamp((long)this.confirmed));
        }
    }

    public static final class UnlockObjectsResult {
        private final long timestamp;
        private final List<CDOLockDelta> lockDeltas;
        private final List<CDOLockState> lockStates;

        public UnlockObjectsResult(long timestamp, List<CDOLockDelta> lockDeltas, List<CDOLockState> lockStates) {
            this.timestamp = timestamp;
            this.lockDeltas = lockDeltas;
            this.lockStates = lockStates;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public List<CDOLockDelta> getLockDeltas() {
            return this.lockDeltas;
        }

        public List<CDOLockState> getLockStates() {
            return this.lockStates;
        }

        @Deprecated
        public UnlockObjectsResult(CDOLockState[] newLockStates, long timestamp) {
            throw new UnsupportedOperationException();
        }

        @Deprecated
        public CDOLockState[] getNewLockStates() {
            throw new UnsupportedOperationException();
        }
    }
}

