/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui;

import org.eclipse.bpmn2.di.BPMNDiagram;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.bpmn2.modeler.ui.Bpmn2DiagramEditorInputFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;

public final class Bpmn2DiagramEditorInput
extends DiagramEditorInput {
    public static final String KEY_MODEL_URI = "org.eclipse.bpmn2.modeler.uri";
    private ModelUtil.Bpmn2DiagramType initialDiagramType = ModelUtil.Bpmn2DiagramType.NONE;
    private String targetNamespace;
    private BPMNDiagram bpmnDiagram;
    private URI modelUri;

    public Bpmn2DiagramEditorInput(URI modelUri, URI diagramUri, String providerId) {
        super(diagramUri, providerId);
        this.modelUri = modelUri;
    }

    public ModelUtil.Bpmn2DiagramType getInitialDiagramType() {
        return this.initialDiagramType;
    }

    public void setInitialDiagramType(ModelUtil.Bpmn2DiagramType initialDiagramType) {
        this.initialDiagramType = initialDiagramType;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    public URI getModelUri() {
        return this.modelUri;
    }

    public String getToolTipText() {
        return this.modelUri.toPlatformString(true);
    }

    public String getName() {
        return URI.decode((String)this.modelUri.trimFileExtension().lastSegment());
    }

    public TargetRuntime getRuntime() {
        return TargetRuntime.getRuntime((String)this.targetNamespace, (ModelUtil.Bpmn2DiagramType)this.initialDiagramType);
    }

    public void updateUri(URI diagramFileUri) {
        if (diagramFileUri.isPlatformResource()) {
            this.modelUri = diagramFileUri;
        } else {
            super.updateUri(diagramFileUri);
        }
    }

    public boolean equals(Object obj) {
        String path;
        URI platformUri;
        boolean superEquals = super.equals(obj);
        if (superEquals) {
            return true;
        }
        return obj instanceof FileEditorInput && (platformUri = URI.createPlatformResourceURI((String)(path = ((FileEditorInput)obj).getFile().getFullPath().toString()), (boolean)true)).equals(this.modelUri);
    }

    public BPMNDiagram getBpmnDiagram() {
        return this.bpmnDiagram;
    }

    public void setBpmnDiagram(BPMNDiagram bpmnDiagram) {
        this.bpmnDiagram = bpmnDiagram;
    }

    public String getFactoryId() {
        return Bpmn2DiagramEditorInputFactory.class.getName();
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        boolean exists = this.exists();
        if (!exists) {
            return;
        }
        memento.putString(KEY_MODEL_URI, this.modelUri.toString());
    }
}

