/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.fnmeta;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpel.fnmeta.model.Function;

public class FunctionRegistry {
    Map<String, Function> fRegistryIndex = new HashMap<String, Function>();
    String fLanguageNamespace;

    public FunctionRegistry(String languageNamespace) {
        this.fLanguageNamespace = languageNamespace;
    }

    public Collection<Function> getRegistry() {
        return Collections.unmodifiableCollection(this.fRegistryIndex.values());
    }

    public Function lookupFunction(String ns, String name) {
        return this.fRegistryIndex.get(this.key(ns, name));
    }

    public void add(List<Function> list) {
        for (Function fn : list) {
            this.add(fn);
        }
    }

    public void add(Function fn) {
        String aKey = this.key(fn);
        Function previous = this.fRegistryIndex.get(aKey);
        if (previous != null) {
            return;
        }
        this.fRegistryIndex.put(aKey, fn);
    }

    String key(Function fn) {
        return this.key(fn.getNamespace(), fn.getName());
    }

    String key(String ns, String name) {
        StringBuilder sb = new StringBuilder();
        return sb.append(ns).append(";").append(name).toString();
    }

    public String getLanguageNS() {
        return this.fLanguageNamespace;
    }
}

