/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.core.profiler;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperContentAdapter;
import org.eclipse.viatra.query.runtime.base.core.NavigationHelperImpl;

public final class ProfilingNavigationHelperContentAdapter
extends NavigationHelperContentAdapter {
    long notificationCount = 0L;
    StopWatch watch = new StopWatch();
    boolean isEnabled = false;
    boolean measurement = false;

    public ProfilingNavigationHelperContentAdapter(NavigationHelperImpl navigationHelper, boolean enabled) {
        super(navigationHelper);
        this.isEnabled = enabled;
    }

    @Override
    public void notifyChanged(Notification notification) {
        if (this.isEnabled && !this.measurement) {
            try {
                this.measurement = true;
                ++this.notificationCount;
                this.watch.start();
                super.notifyChanged(notification);
            }
            finally {
                this.watch.stop();
                this.measurement = false;
            }
        } else {
            super.notifyChanged(notification);
        }
    }

    @Override
    public void setTarget(Notifier target) {
        if (this.isEnabled && !this.measurement) {
            try {
                this.measurement = true;
                ++this.notificationCount;
                this.watch.start();
                super.setTarget(target);
            }
            finally {
                this.watch.stop();
                this.measurement = false;
            }
        } else {
            super.setTarget(target);
        }
    }

    @Override
    public void unsetTarget(Notifier target) {
        if (this.isEnabled && !this.measurement) {
            try {
                this.measurement = true;
                ++this.notificationCount;
                this.watch.start();
                super.unsetTarget(target);
            }
            finally {
                this.watch.stop();
                this.measurement = false;
            }
        } else {
            super.unsetTarget(target);
        }
    }

    public long getNotificationCount() {
        return this.notificationCount;
    }

    public long getTotalMeasuredTimeInMS() {
        return this.watch.getTotalElapsedTimeNs() / 1000000L;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void resetMeasurement() {
        this.notificationCount = 0L;
        this.watch.resetTime();
    }

    private static class StopWatch {
        private long currentStartTimeNs = 0L;
        private long totalElapsedTimeNs = 0L;
        private boolean running = false;

        private StopWatch() {
        }

        private void start() {
            this.currentStartTimeNs = System.nanoTime();
            this.running = true;
        }

        private void stop() {
            this.totalElapsedTimeNs = this.getTotalElapsedTimeNs();
            this.running = false;
        }

        private long getCurrentElapsedTimeNs() {
            return System.nanoTime() - this.currentStartTimeNs;
        }

        private long getTotalElapsedTimeNs() {
            return this.running ? this.getCurrentElapsedTimeNs() + this.totalElapsedTimeNs : this.totalElapsedTimeNs;
        }

        private void resetTime() {
            this.currentStartTimeNs = System.currentTimeMillis();
            this.totalElapsedTimeNs = 0L;
        }
    }
}

