/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.registry;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.tm4e.core.TMException;
import org.eclipse.tm4e.core.grammar.IGrammar;
import org.eclipse.tm4e.core.internal.grammar.reader.GrammarReader;
import org.eclipse.tm4e.core.internal.grammars.SyncRegistry;
import org.eclipse.tm4e.core.internal.types.IRawGrammar;
import org.eclipse.tm4e.core.registry.IRegistryOptions;
import org.eclipse.tm4e.core.theme.IRawTheme;
import org.eclipse.tm4e.core.theme.Theme;

public class Registry {
    private final IRegistryOptions locator;
    private final SyncRegistry syncRegistry;

    public Registry() {
        this(IRegistryOptions.DEFAULT_LOCATOR);
    }

    public Registry(IRegistryOptions locator) {
        this.locator = locator;
        this.syncRegistry = new SyncRegistry(Theme.createFromRawTheme(locator.getTheme()));
    }

    public void setTheme(IRawTheme theme) {
        this.syncRegistry.setTheme(Theme.createFromRawTheme(theme));
    }

    public Set<String> getColorMap() {
        return this.syncRegistry.getColorMap();
    }

    public IGrammar loadGrammar(String initialScopeName) {
        return this._loadGrammar(initialScopeName);
    }

    private IGrammar _loadGrammar(String initialScopeName) {
        ArrayList<String> remainingScopeNames = new ArrayList<String>();
        remainingScopeNames.add(initialScopeName);
        ArrayList<String> seenScopeNames = new ArrayList<String>();
        seenScopeNames.add(initialScopeName);
        while (!remainingScopeNames.isEmpty()) {
            String scopeName = (String)remainingScopeNames.remove(0);
            if (this.syncRegistry.lookup(scopeName) != null) continue;
            String filePath = this.locator.getFilePath(scopeName);
            if (filePath == null) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">");
            }
            try {
                InputStream in = this.locator.getInputStream(scopeName);
                IRawGrammar grammar = GrammarReader.readGrammarSync(filePath, in);
                Collection<String> injections = this.locator.getInjections(scopeName);
                Collection<String> deps = this.syncRegistry.addGrammar(grammar, injections);
                for (String dep : deps) {
                    if (seenScopeNames.contains(dep)) continue;
                    seenScopeNames.add(dep);
                    remainingScopeNames.add(dep);
                }
            }
            catch (Throwable e) {
                if (!scopeName.equals(initialScopeName)) continue;
                throw new TMException("Unknown location for grammar <" + initialScopeName + ">", e);
            }
        }
        return this.grammarForScopeName(initialScopeName);
    }

    public IGrammar loadGrammarFromPathSync(File file) throws Exception {
        return this.loadGrammarFromPathSync(file.getPath(), new FileInputStream(file));
    }

    public IGrammar loadGrammarFromPathSync(String path, InputStream in) throws Exception {
        return this.loadGrammarFromPathSync(path, in, 0, null);
    }

    public IGrammar loadGrammarFromPathSync(String path, InputStream in, int initialLanguage, Map<String, Integer> embeddedLanguages) throws Exception {
        IRawGrammar rawGrammar = GrammarReader.readGrammarSync(path, in);
        Collection<String> injections = this.locator.getInjections(rawGrammar.getScopeName());
        this.syncRegistry.addGrammar(rawGrammar, injections);
        return this.grammarForScopeName(rawGrammar.getScopeName(), initialLanguage, embeddedLanguages);
    }

    public IGrammar grammarForScopeName(String scopeName) {
        return this.grammarForScopeName(scopeName, 0, null);
    }

    public IGrammar grammarForScopeName(String scopeName, int initialLanguage, Map<String, Integer> embeddedLanguages) {
        return this.syncRegistry.grammarForScopeName(scopeName, initialLanguage, embeddedLanguages);
    }

    public IRegistryOptions getLocator() {
        return this.locator;
    }
}

