/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSMergeSubscriber;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.ShowAnnotationAction;
import org.eclipse.team.internal.ccvs.ui.actions.ShowResourceInHistoryAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSActionDelegateWrapper;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSChangeSetCapability;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSParticipant;
import org.eclipse.team.internal.ccvs.ui.subscriber.ConfirmMergedAction;
import org.eclipse.team.internal.ccvs.ui.subscriber.MergeUpdateAction;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantDescriptor;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;

public class MergeSynchronizeParticipant
extends CVSParticipant {
    public static final String TOOLBAR_CONTRIBUTION_GROUP = "toolbar_group";
    public static final String CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_1";
    public static final String NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP = "context_group_2";
    private static final String CTX_ROOT = "root";
    private static final String CTX_ROOT_PATH = "root_resource";
    private static final String CTX_START_TAG = "start_tag";
    private static final String CTX_START_TAG_TYPE = "start_tag_type";
    private static final String CTX_END_TAG = "end_tag";
    private static final String CTX_END_TAG_TYPE = "end_tag_type";

    public MergeSynchronizeParticipant() {
    }

    public MergeSynchronizeParticipant(CVSMergeSubscriber subscriber) {
        this.setSubscriber((Subscriber)subscriber);
    }

    public void setSubscriber(Subscriber subscriber) {
        super.setSubscriber(subscriber);
        try {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.cvs.ui.cvsmerge-participant");
            this.setInitializationData(descriptor);
            CVSMergeSubscriber s = (CVSMergeSubscriber)this.getSubscriber();
            this.setSecondaryId(s.getId().getLocalName());
        }
        catch (CoreException e) {
            CVSUIPlugin.log(e);
        }
    }

    public void init(String secondayId, IMemento memento) throws PartInitException {
        super.init(secondayId, memento);
        if (memento != null) {
            ISynchronizeParticipantDescriptor descriptor = TeamUI.getSynchronizeManager().getParticipantDescriptor("org.eclipse.team.cvs.ui.cvsmerge-participant");
            String qualifier = descriptor.getId();
            String localname = secondayId;
            if (qualifier == null || localname == null) {
                throw new PartInitException(CVSUIMessages.MergeSynchronizeParticipant_8);
            }
            try {
                this.setSubscriber((Subscriber)this.read(new QualifiedName(qualifier, localname), memento));
            }
            catch (CVSException e) {
                throw new PartInitException(CVSUIMessages.MergeSynchronizeParticipant_9, (Throwable)e);
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        CVSMergeSubscriber s = (CVSMergeSubscriber)this.getSubscriber();
        this.write(s, memento);
    }

    public void dispose() {
        super.dispose();
        if (TeamUI.getSynchronizeManager().get(this.getId(), this.getSecondaryId()) == null) {
            this.flushStateCache();
        }
    }

    public String getName() {
        return NLS.bind((String)CVSUIMessages.CompareParticipant_0, (Object[])new String[]{((CVSMergeSubscriber)this.getSubscriber()).getName(), Utils.convertSelection((IResource[])this.getSubscriber().roots())});
    }

    protected CVSTag getStartTag() {
        return ((CVSMergeSubscriber)this.getSubscriber()).getStartTag();
    }

    protected CVSTag getEndTag() {
        return ((CVSMergeSubscriber)this.getSubscriber()).getEndTag();
    }

    public static MergeSynchronizeParticipant getMatchingParticipant(IResource[] resources, CVSTag startTag, CVSTag endTag) {
        ISynchronizeParticipantReference[] refs;
        ISynchronizeParticipantReference[] iSynchronizeParticipantReferenceArray = refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                ISynchronizeParticipantReference reference = iSynchronizeParticipantReferenceArray[n2];
                if (reference.getId().equals("org.eclipse.team.cvs.ui.cvsmerge-participant")) {
                    MergeSynchronizeParticipant p;
                    try {
                        p = (MergeSynchronizeParticipant)reference.getParticipant();
                    }
                    catch (TeamException teamException) {
                        break block5;
                    }
                    Object[] roots = p.getResources();
                    Arrays.sort(resources, Utils.resourceComparator);
                    Arrays.sort(roots, Utils.resourceComparator);
                    if (Arrays.equals(resources, roots) && p.getStartTag().equals((Object)startTag) && p.getEndTag().equals((Object)endTag)) {
                        return p;
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    private void write(CVSMergeSubscriber s, IMemento memento) {
        IResource[] roots;
        CVSTag start = s.getStartTag();
        CVSTag end = s.getEndTag();
        memento.putString(CTX_START_TAG, start.getName());
        memento.putInteger(CTX_START_TAG_TYPE, start.getType());
        memento.putString(CTX_END_TAG, end.getName());
        memento.putInteger(CTX_END_TAG_TYPE, end.getType());
        IResource[] iResourceArray = roots = s.roots();
        int n = roots.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            IMemento rootNode = memento.createChild(CTX_ROOT);
            rootNode.putString(CTX_ROOT_PATH, resource.getFullPath().toString());
            ++n2;
        }
    }

    private CVSMergeSubscriber read(QualifiedName id, IMemento memento) throws CVSException {
        CVSTag start = new CVSTag(memento.getString(CTX_START_TAG), memento.getInteger(CTX_START_TAG_TYPE).intValue());
        CVSTag end = new CVSTag(memento.getString(CTX_END_TAG), memento.getInteger(CTX_END_TAG_TYPE).intValue());
        IMemento[] rootNodes = memento.getChildren(CTX_ROOT);
        if (rootNodes == null || rootNodes.length == 0) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_10, (Object[])new String[]{id.toString()}));
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IMemento[] iMementoArray = rootNodes;
        int n = rootNodes.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento rootNode = iMementoArray[n2];
            Path path = new Path(rootNode.getString(CTX_ROOT_PATH));
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path, true);
            if (resource != null) {
                resources.add(resource);
            } else {
                CVSProviderPlugin.log((int)1, (String)NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_11, (Object[])new String[]{path.toString()}), null);
            }
            ++n2;
        }
        if (resources.isEmpty()) {
            throw new CVSException(NLS.bind((String)CVSUIMessages.MergeSynchronizeParticipant_12, (Object[])new String[]{id.toString()}));
        }
        IResource[] roots = resources.toArray(new IResource[resources.size()]);
        return new CVSMergeSubscriber(id, roots, start, end);
    }

    private void flushStateCache() {
        ((CVSMergeSubscriber)this.getSubscriber()).cancel();
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        super.initializeConfiguration(configuration);
        configuration.addMenuGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", TOOLBAR_CONTRIBUTION_GROUP);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.addMenuGroup("org.eclipse.team.ui.P_CONTEXT_MENU", NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP);
        configuration.setSupportedModes(9);
        configuration.setMode(1);
        configuration.addActionContribution((SynchronizePageActionGroup)new MergeParticipantActionContribution());
    }

    protected String getLongTaskName() {
        return this.getName();
    }

    protected String getShortTaskName() {
        return CVSUIMessages.Participant_merging;
    }

    @Override
    protected CVSChangeSetCapability createChangeSetCapability() {
        return null;
    }

    public class MergeParticipantActionContribution
    extends SynchronizePageActionGroup {
        private MergeUpdateAction updateAction;

        public void initialize(ISynchronizePageConfiguration configuration) {
            super.initialize(configuration);
            this.updateAction = new MergeUpdateAction(configuration, this.getVisibleRootsSelectionProvider(), "WorkspaceToolbarUpdateAction.");
            this.updateAction.setPromptBeforeUpdate(true);
            this.appendToGroup("org.eclipse.team.ui.P_TOOLBAR_MENU", MergeSynchronizeParticipant.TOOLBAR_CONTRIBUTION_GROUP, (IAction)this.updateAction);
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", MergeSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new MergeUpdateAction(configuration));
            this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", MergeSynchronizeParticipant.CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new ConfirmMergedAction(configuration));
            if (!configuration.getSite().isModal()) {
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", MergeSynchronizeParticipant.NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new CVSActionDelegateWrapper(new ShowAnnotationAction(), configuration));
                this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", MergeSynchronizeParticipant.NON_MODAL_CONTEXT_MENU_CONTRIBUTION_GROUP, (IAction)new CVSActionDelegateWrapper(new ShowResourceInHistoryAction(), configuration));
            }
        }
    }
}

