/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.TimeZone;
import java.util.Date;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ui.dialogs.DialogArea;
import org.eclipse.ui.PlatformUI;

public class DateTagDialog
extends TrayDialog {
    DateArea dateArea;
    TimeArea timeArea;
    IDialogSettings settings;
    private Date dateEntered;

    public DateTagDialog(Shell parentShell) {
        super(parentShell);
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("DateTagDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("DateTagDialog");
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(CVSUIMessages.DateTagDialog_5);
    }

    protected Control createDialogArea(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.initializeDialogUnits((Control)topLevel);
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        topLevel.setLayout((Layout)layout);
        this.createDateArea(topLevel);
        this.createTimeArea(topLevel);
        this.initializeValues();
        this.updateWidgetEnablements();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.team.cvs.ui.date_tag_dialog_context");
        Dialog.applyDialogFont((Control)parent);
        return topLevel;
    }

    private void createDateArea(Composite topLevel) {
        this.dateArea = new DateArea();
        this.dateArea.createArea(topLevel);
    }

    private void createTimeArea(Composite topLevel) {
        this.timeArea = new TimeArea();
        this.timeArea.createArea(topLevel);
    }

    private void initializeValues() {
        Calendar calendar = Calendar.getInstance();
        this.dateArea.initializeValues(calendar);
        this.timeArea.initializeValues(calendar);
    }

    private void updateWidgetEnablements() {
        this.timeArea.updateWidgetEnablements();
        this.dateArea.updateWidgetEnablements();
    }

    public Date getDate() {
        return this.dateEntered;
    }

    private Date privateGetDate() {
        Calendar calendar = Calendar.getInstance();
        this.dateArea.adjustCalendar(calendar);
        this.timeArea.adjustCalendar(calendar);
        return calendar.getTime();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            MessageDialog dialog;
            this.dateEntered = this.privateGetDate();
            if (this.dateEntered.after(Calendar.getInstance().getTime()) && (dialog = new MessageDialog(this.getShell(), CVSUIMessages.DateTagDialog_6, null, CVSUIMessages.DateTagDialog_7, 4, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 1)).open() == 1) {
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public class DateArea
    extends DialogArea {
        private DateTime date;
        private static final int DateTime_MIN_YEAR = 1752;

        public void createArea(Composite parent) {
            Composite composite = this.createComposite(parent, 2, false);
            this.initializeDialogUnits((Control)composite);
            this.createLabel(composite, CVSUIMessages.DateTagDialog_0, 1);
            this.date = new DateTime(composite, 2080);
        }

        public void initializeValues(Calendar calendar) {
            this.date.setDay(calendar.get(5) - 1);
            this.date.setMonth(calendar.get(2));
            this.date.setYear(calendar.get(1));
            DateTagDialog.this.timeArea.initializeValues(calendar);
        }

        public void updateWidgetEnablements() {
        }

        public void adjustCalendar(Calendar calendar) {
            int dateYear = this.date.getYear();
            int todaysYear = calendar.get(1);
            if (todaysYear < 1752) {
                int extended_year = calendar.get(19);
                dateYear = todaysYear + (dateYear - extended_year);
            }
            calendar.set(dateYear, this.date.getMonth(), this.date.getDay(), 0, 0, 0);
        }
    }

    public class TimeArea
    extends DialogArea {
        private Button includeTime;
        private Button localTime;
        private Button utcTime;
        private DateTime time;

        public void createArea(Composite parent) {
            Composite composite = this.createComposite(parent, 2, false);
            this.initializeDialogUnits((Control)composite);
            this.includeTime = this.createCheckbox(composite, CVSUIMessages.DateTagDialog_1, 2);
            this.createLabel(composite, CVSUIMessages.DateTagDialog_2, 1);
            this.time = new DateTime(composite, 2176);
            this.localTime = this.createRadioButton(composite, CVSUIMessages.DateTagDialog_3, 2);
            this.utcTime = this.createRadioButton(composite, CVSUIMessages.DateTagDialog_4, 2);
            this.includeTime.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    TimeArea.this.updateWidgetEnablements();
                }
            });
        }

        public void initializeValues(Calendar calendar) {
            this.time.setHours(calendar.get(11));
            this.time.setMinutes(calendar.get(12));
            this.time.setSeconds(calendar.get(13));
            this.includeTime.setSelection(DateTagDialog.this.settings.getBoolean("includeTime"));
            this.localTime.setSelection(!DateTagDialog.this.settings.getBoolean("utcTime"));
            this.utcTime.setSelection(DateTagDialog.this.settings.getBoolean("utcTime"));
        }

        public void updateWidgetEnablements() {
            this.time.setEnabled(this.includeTime.getSelection());
            this.localTime.setEnabled(this.includeTime.getSelection());
            this.utcTime.setEnabled(this.includeTime.getSelection());
        }

        public void adjustCalendar(Calendar calendar) {
            if (this.includeTime.getSelection()) {
                calendar.set(11, this.time.getHours());
                calendar.set(12, this.time.getMinutes());
                calendar.set(13, this.time.getSeconds());
                if (this.utcTime.getSelection()) {
                    calendar.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
                }
            }
        }
    }
}

