/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ua.core.cheatsheet.comp;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.pde.internal.ua.core.cheatsheet.comp.CompCSTaskObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModel;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSModelFactory;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSObject;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSParam;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTask;
import org.eclipse.pde.internal.ua.core.icheatsheet.comp.ICompCSTaskObject;
import org.w3c.dom.Element;

public class CompCSTask
extends CompCSTaskObject
implements ICompCSTask {
    private List<ICompCSParam> fFieldParams;
    private static final long serialVersionUID = 1L;

    public CompCSTask(ICompCSModel model, ICompCSObject parent) {
        super(model, parent);
        this.reset();
    }

    @Override
    public List<ICompCSTaskObject> getChildren() {
        return new ArrayList<ICompCSTaskObject>();
    }

    @Override
    public String getName() {
        return this.fFieldName;
    }

    @Override
    public int getType() {
        return 2;
    }

    @Override
    public String getElement() {
        return "task";
    }

    @Override
    protected void parseElement(Element element) {
        super.parseElement(element);
        String name = element.getNodeName();
        ICompCSModelFactory factory = this.getModel().getFactory();
        if (name.equals("param")) {
            ICompCSParam param = factory.createCompCSParam(this);
            this.fFieldParams.add(param);
            param.parse(element);
        }
    }

    @Override
    public void addFieldParam(ICompCSParam param) {
        this.fFieldParams.add(param);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)param, 1);
        }
    }

    @Override
    public ICompCSParam[] getFieldParams() {
        return this.fFieldParams.toArray(new ICompCSParam[this.fFieldParams.size()]);
    }

    @Override
    public void removeFieldParam(ICompCSParam param) {
        this.fFieldParams.remove(param);
        if (this.isEditable()) {
            this.fireStructureChanged((ICompCSObject)param, 2);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.fFieldParams = new ArrayList<ICompCSParam>();
    }

    @Override
    protected void writeElements(String indent, PrintWriter writer) {
        super.writeElements(indent, writer);
        String newIndent = String.valueOf(indent) + "   ";
        for (ICompCSParam param : this.fFieldParams) {
            param.write(newIndent, writer);
        }
    }

    @Override
    public boolean hasFieldParams() {
        return !this.fFieldParams.isEmpty();
    }

    @Override
    public ICompCSParam getFieldParam(String name) {
        if (this.fFieldParams.isEmpty()) {
            return null;
        }
        ListIterator<ICompCSParam> iterator = this.fFieldParams.listIterator();
        while (iterator.hasNext()) {
            ICompCSParam parameter = iterator.next();
            if (!parameter.getFieldName().equals(name)) continue;
            return parameter;
        }
        return null;
    }
}

