/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base;

import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class KeyValuePairs {
    private final String source;
    private final String error;

    public KeyValuePairs(String source, String error) {
        Objects.requireNonNull(source, "KeyValuePairs::source");
        Objects.requireNonNull(error, "KeyValuePairs::error");
        this.source = source;
        this.error = error;
    }

    public KeyValuePairs(String source) {
        this(source, BaseMessages.getString("KeyValuePairs.default_error"));
    }

    public Properties get() throws LicensingException {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (StringReader reader = new StringReader(this.source);){
                properties.load(reader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw this.fail(e);
        }
        return properties;
    }

    private LicensingException fail(IOException e) {
        return new LicensingException(this.error, (Throwable)e);
    }
}

