/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.mylyn.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.internal.tasks.core.RepositoryQuery;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.oomph.preferences.util.PreferencesUtil;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.mylyn.MylynPackage;
import org.eclipse.oomph.setup.mylyn.MylynQueriesTask;
import org.eclipse.oomph.setup.mylyn.Query;
import org.eclipse.oomph.setup.mylyn.impl.Messages;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MylynQueriesTaskImpl
extends SetupTaskImpl
implements MylynQueriesTask {
    protected static final String CONNECTOR_KIND_EDEFAULT = "bugzilla";
    protected String connectorKind = "bugzilla";
    protected static final String REPOSITORY_URL_EDEFAULT = null;
    protected String repositoryURL = REPOSITORY_URL_EDEFAULT;
    protected static final String USER_ID_EDEFAULT = null;
    protected String userID = USER_ID_EDEFAULT;
    protected static final String PASSWORD_EDEFAULT = null;
    protected String password = PASSWORD_EDEFAULT;
    protected EList<Query> queries;
    private TaskRepository repository;
    private Map<Query, RepositoryQuery> repositoryQueries = new HashMap<Query, RepositoryQuery>();

    protected MylynQueriesTaskImpl() {
    }

    protected EClass eStaticClass() {
        return MylynPackage.Literals.MYLYN_QUERIES_TASK;
    }

    @Override
    public String getConnectorKind() {
        return this.connectorKind;
    }

    @Override
    public void setConnectorKind(String newConnectorKind) {
        String oldConnectorKind = this.connectorKind;
        this.connectorKind = newConnectorKind;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldConnectorKind, (Object)this.connectorKind));
        }
    }

    @Override
    public String getRepositoryURL() {
        return this.repositoryURL;
    }

    @Override
    public void setRepositoryURL(String newRepositoryURL) {
        String oldRepositoryURL = this.repositoryURL;
        this.repositoryURL = newRepositoryURL;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldRepositoryURL, (Object)this.repositoryURL));
        }
    }

    @Override
    public EList<Query> getQueries() {
        if (this.queries == null) {
            this.queries = new EObjectContainmentWithInverseEList(Query.class, (InternalEObject)this, 14, 1);
        }
        return this.queries;
    }

    @Override
    public String getUserID() {
        return this.userID;
    }

    @Override
    public void setUserID(String newUserID) {
        String oldUserID = this.userID;
        this.userID = newUserID;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldUserID, (Object)this.userID));
        }
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String newPassword) {
        String oldPassword = this.password;
        this.password = newPassword;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldPassword, (Object)this.password));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getQueries()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 14: {
                return ((InternalEList)this.getQueries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getConnectorKind();
            }
            case 11: {
                return this.getRepositoryURL();
            }
            case 12: {
                return this.getUserID();
            }
            case 13: {
                return this.getPassword();
            }
            case 14: {
                return this.getQueries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setConnectorKind((String)newValue);
                return;
            }
            case 11: {
                this.setRepositoryURL((String)newValue);
                return;
            }
            case 12: {
                this.setUserID((String)newValue);
                return;
            }
            case 13: {
                this.setPassword((String)newValue);
                return;
            }
            case 14: {
                this.getQueries().clear();
                this.getQueries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setConnectorKind(CONNECTOR_KIND_EDEFAULT);
                return;
            }
            case 11: {
                this.setRepositoryURL(REPOSITORY_URL_EDEFAULT);
                return;
            }
            case 12: {
                this.setUserID(USER_ID_EDEFAULT);
                return;
            }
            case 13: {
                this.setPassword(PASSWORD_EDEFAULT);
                return;
            }
            case 14: {
                this.getQueries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return CONNECTOR_KIND_EDEFAULT == null ? this.connectorKind != null : !CONNECTOR_KIND_EDEFAULT.equals(this.connectorKind);
            }
            case 11: {
                return REPOSITORY_URL_EDEFAULT == null ? this.repositoryURL != null : !REPOSITORY_URL_EDEFAULT.equals(this.repositoryURL);
            }
            case 12: {
                return USER_ID_EDEFAULT == null ? this.userID != null : !USER_ID_EDEFAULT.equals(this.userID);
            }
            case 13: {
                return PASSWORD_EDEFAULT == null ? this.password != null : !PASSWORD_EDEFAULT.equals(this.password);
            }
            case 14: {
                return this.queries != null && !this.queries.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (connectorKind: ");
        result.append(this.connectorKind);
        result.append(", repositoryURL: ");
        result.append(this.repositoryURL);
        result.append(", userID: ");
        result.append(this.userID);
        result.append(", password: ");
        result.append(this.password);
        result.append(')');
        return result.toString();
    }

    public boolean isNeeded(SetupTaskContext context) throws Exception {
        String connectorKind = this.getConnectorKind();
        String repositoryURL = this.getRepositoryURL();
        this.repository = TasksUi.getRepositoryManager().getRepository(connectorKind, repositoryURL);
        EList<Query> queries = this.getQueries();
        for (Query query : queries) {
            context.checkCancelation();
            RepositoryQuery repositoryQuery = this.getRepositoryQuery(query);
            if (repositoryQuery != null && !this.isQueryDifferent(query, repositoryQuery)) continue;
            this.repositoryQueries.put(query, repositoryQuery);
        }
        return this.repository == null || !this.repositoryQueries.isEmpty();
    }

    public void perform(SetupTaskContext context) throws Exception {
        String connectorKind = this.getConnectorKind();
        String repositoryURL = this.getRepositoryURL();
        if (this.repository == null) {
            context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_AddingRepository_message, (Object)connectorKind, (Object)repositoryURL));
            this.repository = new TaskRepository(connectorKind, repositoryURL);
            this.repository.setCredentials(AuthenticationType.PROXY, null, true);
        }
        String userID = this.getUserID();
        if (this.isAuthenticate()) {
            AuthenticationCredentials credentials = new AuthenticationCredentials(userID, PreferencesUtil.decrypt((String)this.getPassword()));
            this.repository.setCredentials(AuthenticationType.REPOSITORY, credentials, true);
        }
        TasksUi.getRepositoryManager().addRepository(this.repository);
        if (!this.repositoryQueries.isEmpty()) {
            for (Map.Entry<Query, RepositoryQuery> entry : this.repositoryQueries.entrySet()) {
                Query query = entry.getKey();
                RepositoryQuery repositoryQuery = entry.getValue();
                String summary = query.getSummary();
                if (repositoryQuery == null) {
                    context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_AddingQuery_message, (Object)connectorKind, (Object)summary));
                    String handle = TasksUiPlugin.getTaskList().getUniqueHandleIdentifier();
                    repositoryQuery = new RepositoryQuery(connectorKind, handle);
                    repositoryQuery.setSummary(summary);
                    entry.setValue(repositoryQuery);
                    repositoryQuery.setRepositoryUrl(repositoryURL);
                    this.configureQuery(context, query, repositoryQuery);
                    TasksUiPlugin.getTaskList().addQuery(repositoryQuery);
                    continue;
                }
                context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_ChaningQuery_message, (Object)connectorKind, (Object)summary));
                repositoryQuery.setRepositoryUrl(repositoryURL);
                this.configureQuery(context, query, repositoryQuery);
            }
            HashSet<RepositoryQuery> queries = new HashSet<RepositoryQuery>(this.repositoryQueries.values());
            TasksUiPlugin.getTaskList().notifyElementsChanged(queries);
            AbstractRepositoryConnector connector = TasksUi.getRepositoryManager().getRepositoryConnector(connectorKind);
            TasksUiInternal.synchronizeQueries((AbstractRepositoryConnector)connector, (TaskRepository)this.repository, queries, null, (boolean)true);
        }
    }

    private RepositoryQuery getRepositoryQuery(Query query) throws Exception {
        for (RepositoryQuery repositoryQuery : TasksUiPlugin.getTaskList().getQueries()) {
            if (!ObjectUtil.equals((Object)repositoryQuery.getSummary(), (Object)query.getSummary())) continue;
            return repositoryQuery;
        }
        return null;
    }

    private boolean isQueryDifferent(Query query, RepositoryQuery repositoryQuery) throws Exception {
        String url = StringUtil.safe((String)query.getURL());
        if (!ObjectUtil.equals((Object)repositoryQuery.getUrl(), (Object)url)) {
            return true;
        }
        Map attributes = query.getAttributes().map();
        return !ObjectUtil.equals((Object)repositoryQuery.getAttributes(), (Object)attributes);
    }

    private void configureQuery(SetupTaskContext context, Query query, RepositoryQuery repositoryQuery) {
        String url = StringUtil.safe((String)query.getURL());
        if (!ObjectUtil.equals((Object)url, (Object)repositoryQuery.getUrl())) {
            context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_SettingQuery_message, (Object)url));
            repositoryQuery.setUrl(url);
        }
        Map repositoryAttributes = repositoryQuery.getAttributes();
        Map attributes = query.getAttributes().map();
        for (Map.Entry entry : attributes.entrySet()) {
            String repositoryValue;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (ObjectUtil.equals((Object)value, (Object)(repositoryValue = (String)repositoryAttributes.get(key)))) continue;
            context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_SettingQueryAttribute_message, (Object)key, (Object)value));
            repositoryQuery.setAttribute(key, value);
        }
        for (String key : new ArrayList(repositoryAttributes.keySet())) {
            if (attributes.containsKey(key)) continue;
            context.log(NLS.bind((String)Messages.MylynQueriesTaskImpl_RemovingQueryAttribute_message, (Object)key));
            repositoryQuery.setAttribute(key, null);
        }
    }

    private boolean isAuthenticate() {
        return !StringUtil.isEmpty((String)this.userID) && !"anonymous".equals(this.userID) && !StringUtil.isEmpty((String)this.password) && !" ".equals(this.password);
    }
}

