/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCache;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffCacheEntry;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.branch.LaunchFinder;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class CommandConfirmation {
    public static boolean confirmHardReset(Shell shell, Repository repo) {
        MessageDialog messageDialog;
        String question = UIText.ResetTargetSelectionDialog_ResetConfirmQuestion;
        String launch = LaunchFinder.getRunningLaunchConfiguration(Collections.singleton(repo), null);
        if (launch != null) {
            question = String.valueOf(question) + "\n\n" + MessageFormat.format(UIText.LaunchFinder_RunningLaunchMessage, launch);
        }
        return (messageDialog = new MessageDialog(shell, UIText.ResetTargetSelectionDialog_ResetConfirmTitle, null, question, 3, new String[]{UIText.CommandConfirmationHardResetDialog_resetButtonLabel, IDialogConstants.CANCEL_LABEL}, 0)).open() == 0;
    }

    public static boolean confirmCheckout(Shell shell, Repository repository) {
        return CommandConfirmation.confirmCheckout(shell, Collections.singletonMap(repository, Collections.emptyList()), true);
    }

    public static boolean confirmCheckout(Shell shell, Map<Repository, Collection<String>> repoAndPaths, boolean filesOnly) {
        if (CommandConfirmation.haveChanges(repoAndPaths, filesOnly)) {
            Shell parent;
            MessageDialog messageDialog;
            String question = UIText.DiscardChangesAction_confirmActionMessage;
            String launch = LaunchFinder.getRunningLaunchConfiguration(repoAndPaths.keySet(), null);
            if (launch != null) {
                question = String.valueOf(question) + "\n\n" + MessageFormat.format(UIText.LaunchFinder_RunningLaunchMessage, launch);
            }
            return (messageDialog = new MessageDialog(parent = shell != null ? shell : PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), UIText.DiscardChangesAction_confirmActionTitle, null, question, 5, new String[]{UIText.DiscardChangesAction_discardChangesButtonText, IDialogConstants.CANCEL_LABEL}, 0)).open() == 0;
        }
        return !LaunchFinder.shouldCancelBecauseOfRunningLaunches(repoAndPaths.keySet(), null);
    }

    private static boolean haveChanges(Map<Repository, Collection<String>> paths, boolean filesOnly) {
        for (Map.Entry<Repository, Collection<String>> entry : paths.entrySet()) {
            Repository repo = entry.getKey();
            Assert.isNotNull((Object)repo);
            IndexDiffCacheEntry indexDiff = IndexDiffCache.INSTANCE.getIndexDiffCacheEntry(repo);
            if (indexDiff == null) {
                return true;
            }
            IndexDiffData diff = indexDiff.getIndexDiff();
            if (diff != null && !CommandConfirmation.hasChanges(diff, entry.getValue(), filesOnly)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasChanges(@NonNull IndexDiffData diff, Collection<String> paths, boolean filesOnly) {
        if (paths.isEmpty()) {
            return diff.hasChanges();
        }
        HashSet<String> repoPaths = new HashSet<String>(paths);
        if (repoPaths.contains("")) {
            return diff.hasChanges();
        }
        if (CommandConfirmation.containsAny(repoPaths, diff.getAdded()) || CommandConfirmation.containsAny(repoPaths, diff.getChanged()) || CommandConfirmation.containsAny(repoPaths, diff.getModified()) || CommandConfirmation.containsAny(repoPaths, diff.getRemoved())) {
            return true;
        }
        if (!filesOnly) {
            return CommandConfirmation.containsAnyDirectory(repoPaths, diff.getAdded()) || CommandConfirmation.containsAnyDirectory(repoPaths, diff.getChanged()) || CommandConfirmation.containsAnyDirectory(repoPaths, diff.getModified()) || CommandConfirmation.containsAnyDirectory(repoPaths, diff.getRemoved());
        }
        return false;
    }

    private static boolean containsAny(Set<String> repoPaths, Collection<String> files) {
        return files.stream().anyMatch(repoPaths::contains);
    }

    private static boolean containsAnyDirectory(Set<String> repoPaths, Collection<String> files) {
        String lastDirectory = null;
        for (String file : files) {
            int j = file.lastIndexOf(47);
            if (j <= 0) continue;
            String directory = file.substring(0, j);
            String withTerminator = String.valueOf(directory) + '/';
            if (lastDirectory != null && lastDirectory.startsWith(withTerminator)) continue;
            if (repoPaths.contains(directory)) {
                return true;
            }
            lastDirectory = withTerminator;
            int i = directory.indexOf(47);
            while (i > 0) {
                if (repoPaths.contains(directory.substring(0, i))) {
                    return true;
                }
                i = directory.indexOf(47, i + 1);
            }
        }
        return false;
    }
}

