/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.msw.build;

import java.util.Arrays;
import java.util.Collections;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.cdt.internal.msw.build.IVSVersionConstants;
import org.eclipse.cdt.internal.msw.build.ProcessOutputUtil;
import org.eclipse.cdt.internal.msw.build.VSInstallation;
import org.eclipse.cdt.internal.msw.build.VSVersionNumber;

public class VSInstallationRegistry {
    private static TreeMap<VSVersionNumber, VSInstallation> fVsInstallations;

    public static NavigableMap<VSVersionNumber, VSInstallation> getVsInstallations() {
        if (fVsInstallations == null) {
            VSInstallationRegistry.detectVSInstallations();
        }
        return Collections.unmodifiableNavigableMap(fVsInstallations);
    }

    private static void detectVSInstallations() {
        fVsInstallations = new TreeMap();
        Arrays.asList(IVSVersionConstants.VS2017_BASE_VER, IVSVersionConstants.VS2019_BASE_VER).forEach(version -> {
            VSInstallation insllation = VSInstallationRegistry.detectVSInstallation(version);
            if (insllation != null) {
                fVsInstallations.put((VSVersionNumber)version, insllation);
            }
        });
    }

    private static VSInstallation detectVSInstallation(VSVersionNumber baseVersion) {
        VSVersionNumber upperBound = new VSVersionNumber(baseVersion.get(0) + 1);
        String versionFilterRange = "[" + baseVersion.toString() + "," + upperBound + ")";
        String[] vsInstallationLocation = ProcessOutputUtil.getAllOutputFromCommand("cmd", "/c", "\"\"%ProgramFiles(x86)%\\Microsoft Visual Studio\\Installer\\vswhere.exe\"\"", "-version", versionFilterRange, "-property", "installationPath");
        if (vsInstallationLocation == null || vsInstallationLocation.length == 0 || vsInstallationLocation[0].isEmpty()) {
            return null;
        }
        return new VSInstallation(vsInstallationLocation[0]);
    }
}

