/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.details.tree;

import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.details.tree.ITreeNode;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.swt.graphics.Image;

public abstract class TreeNode
implements ITreeNode {
    public static final Object[] EMPTY_ARRAY = new Object[0];
    protected Object modelObject;
    protected boolean isCondensed;

    public TreeNode(Object modelObject, boolean isCondensed) {
        this.modelObject = modelObject;
        this.isCondensed = isCondensed;
    }

    @Override
    public String getLabel() {
        ILabeledElement label = BPELUtil.adapt(this.modelObject, ILabeledElement.class);
        if (label == null) {
            return null;
        }
        return label.getLabel(this.modelObject);
    }

    @Override
    public String getLabelSuffix() {
        return null;
    }

    public boolean isNodeFlattenable() {
        return false;
    }

    @Override
    public Object getModelObject() {
        return this.modelObject;
    }

    @Override
    public Image getImage() {
        ILabeledElement label = BPELUtil.adapt(this.modelObject, ILabeledElement.class);
        if (label == null) {
            return null;
        }
        return label.getSmallImage(this.modelObject);
    }

    @Override
    public abstract Object[] getChildren();

    @Override
    public abstract boolean hasChildren();
}

