/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.eclipse.bpel.common.extension.model.ExtensionMap;
import org.eclipse.bpel.common.ui.CommonUIPlugin;
import org.eclipse.bpel.common.ui.command.EditModelCommandFramework;
import org.eclipse.bpel.common.ui.command.ICommandFramework;
import org.eclipse.bpel.common.ui.tray.AdaptingSelectionProvider;
import org.eclipse.bpel.common.ui.tray.GraphicalEditorWithPaletteAndTray;
import org.eclipse.bpel.common.ui.tray.MultiViewerSelectionProvider;
import org.eclipse.bpel.model.Activity;
import org.eclipse.bpel.model.Flow;
import org.eclipse.bpel.model.Process;
import org.eclipse.bpel.ui.BPELAdaptingSelectionProvider;
import org.eclipse.bpel.ui.BPELEditDomain;
import org.eclipse.bpel.ui.BPELGraphicalKeyHandler;
import org.eclipse.bpel.ui.BPELMultipageEditorPart;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.GraphicalBPELRootEditPart;
import org.eclipse.bpel.ui.IBPELUIConstants;
import org.eclipse.bpel.ui.IHoverHelperSupport;
import org.eclipse.bpel.ui.LinkNotificationAdapter;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.ModelListenerAdapter;
import org.eclipse.bpel.ui.ProcessContextMenuProvider;
import org.eclipse.bpel.ui.ScrollingBPELGraphicalViewer;
import org.eclipse.bpel.ui.WeakMultiViewerSelectionProvider;
import org.eclipse.bpel.ui.actions.AppendNewAction;
import org.eclipse.bpel.ui.actions.AutoArrangeFlowsAction;
import org.eclipse.bpel.ui.actions.BPELAddChildInTrayAction;
import org.eclipse.bpel.ui.actions.BPELCopyAction;
import org.eclipse.bpel.ui.actions.BPELCutAction;
import org.eclipse.bpel.ui.actions.BPELDeleteAction;
import org.eclipse.bpel.ui.actions.BPELDuplicateAction;
import org.eclipse.bpel.ui.actions.BPELPasteAction;
import org.eclipse.bpel.ui.actions.BPELPrintAction;
import org.eclipse.bpel.ui.actions.ChangeTypeAction;
import org.eclipse.bpel.ui.actions.InsertNewAction;
import org.eclipse.bpel.ui.actions.MakePartner2WayAction;
import org.eclipse.bpel.ui.actions.RenameAction;
import org.eclipse.bpel.ui.actions.RevertAction;
import org.eclipse.bpel.ui.actions.ShowPaletteInPaletteViewAction;
import org.eclipse.bpel.ui.actions.ShowPropertiesViewAction;
import org.eclipse.bpel.ui.actions.ShowViewAction;
import org.eclipse.bpel.ui.actions.ToggleAutoFlowLayout;
import org.eclipse.bpel.ui.actions.ToggleLayoutOrientationAction;
import org.eclipse.bpel.ui.actions.ToggleShowCompensationHandler;
import org.eclipse.bpel.ui.actions.ToggleShowEventHandler;
import org.eclipse.bpel.ui.actions.ToggleShowFaultHandler;
import org.eclipse.bpel.ui.actions.ToggleShowTerminationHandler;
import org.eclipse.bpel.ui.commands.util.ModelAutoUndoRecorder;
import org.eclipse.bpel.ui.dnd.BPELTemplateTransferDropTargetListener;
import org.eclipse.bpel.ui.dnd.BPELTextTransferDropTargetListener;
import org.eclipse.bpel.ui.dnd.FileDropTargetListener;
import org.eclipse.bpel.ui.dnd.TextDropTargetListener;
import org.eclipse.bpel.ui.editparts.CorrelationSetsEditPart;
import org.eclipse.bpel.ui.editparts.FlowEditPart;
import org.eclipse.bpel.ui.editparts.MessageExchangesEditPart;
import org.eclipse.bpel.ui.editparts.PartnerLinksEditPart;
import org.eclipse.bpel.ui.editparts.VariablesEditPart;
import org.eclipse.bpel.ui.editparts.util.BPELEditPartFactory;
import org.eclipse.bpel.ui.editparts.util.BPELTrayEditPartFactory;
import org.eclipse.bpel.ui.factories.AbstractUIObjectFactory;
import org.eclipse.bpel.ui.uiextensionmodel.ProcessExtension;
import org.eclipse.bpel.ui.util.BPELCreationToolEntry;
import org.eclipse.bpel.ui.util.BPELEditModelClient;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.IModelVisitor;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.TransferBuffer;
import org.eclipse.bpel.ui.util.WSDLImportHelper;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDropTargetListener;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.SelectAllAction;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.ZoomInAction;
import org.eclipse.gef.ui.actions.ZoomOutAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.util.WSDLResourceImpl;

public class BPELEditor
extends GraphicalEditorWithPaletteAndTray {
    protected BPELEditModelClient editModelClient;
    protected BPELEditorAdapter editorAdapter;
    private TransferBuffer transferBuffer;
    protected BPELMultipageEditorPart multipageEditor;
    private ModelAutoUndoRecorder modelAutoUndoRecorder;
    private KeyHandler keyHandler;
    ISelectionChangedListener selectionChangeListener;
    ISelectionChangedListener traySelectionChangeListener;
    protected EditPart lastSelectedEditPart;
    private BPELAdaptingSelectionProvider adaptingSelectionProvider;
    private WeakMultiViewerSelectionProvider weakMultiViewerSelectionProvider;
    protected Set<IAction> appendNewActions;
    protected Set<IAction> insertNewActions;
    protected Set<IAction> changeTypeActions;
    protected String contributorID;
    protected ICommandFramework commandFramework;

    public BPELEditor(DefaultEditDomain ed, BPELMultipageEditorPart multipageEditor) {
        this.setEditDomain(ed);
        this.multipageEditor = multipageEditor;
        this.modelAutoUndoRecorder = new ModelAutoUndoRecorder();
    }

    public static BPELEditor getBPELEditor(ResourceSet resourceSet) {
        for (Object next : resourceSet.eAdapters()) {
            if (!(next instanceof BPELEditorAdapter)) continue;
            return ((BPELEditorAdapter)next).getBPELEditor();
        }
        return null;
    }

    public BPELEditModelClient getEditModelClient() {
        return this.editModelClient;
    }

    public void setEditModelClient(BPELEditModelClient cl) {
        this.editModelClient = cl;
    }

    public ResourceSet getResourceSet() {
        return this.getEditModelClient().getEditModel().getResourceSet();
    }

    public Resource getResource() {
        return this.getProcess().eResource();
    }

    public ModelAutoUndoRecorder getModelAutoUndoRecorder() {
        return this.modelAutoUndoRecorder;
    }

    public TransferBuffer getTransferBuffer() {
        return this.transferBuffer;
    }

    public Set<IAction> getAppendNewActions() {
        return this.appendNewActions;
    }

    public Set<IAction> getInsertNewActions() {
        return this.insertNewActions;
    }

    public Set<IAction> getChangeTypeActions() {
        return this.changeTypeActions;
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        GraphicalViewer viewer = this.getGraphicalViewer();
        this.registerViewer((EditPartViewer)viewer);
        GraphicalBPELRootEditPart root = (GraphicalBPELRootEditPart)viewer.getRootEditPart();
        ZoomInAction zoomInAction = new ZoomInAction(root.getZoomManager());
        zoomInAction.setImageDescriptor(CommonUIPlugin.getDefault().getImageRegistry().getDescriptor("elcl16/zoomin.gif"));
        this.getActionRegistry().registerAction((IAction)zoomInAction);
        ZoomOutAction zoomOutAction = new ZoomOutAction(root.getZoomManager());
        zoomOutAction.setImageDescriptor(CommonUIPlugin.getDefault().getImageRegistry().getDescriptor("elcl16/zoomout.gif"));
        this.getActionRegistry().registerAction((IAction)zoomOutAction);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomInAction);
        this.getSite().getKeyBindingService().registerAction((IAction)zoomOutAction);
        ProcessContextMenuProvider provider = new ProcessContextMenuProvider(this, this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getAdaptingSelectionProvider());
        this.getSite().registerContextMenu("org.eclipse.bpel.editor.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
        this.getGraphicalViewer().setKeyHandler(new BPELGraphicalKeyHandler(this.getGraphicalViewer()).setParent(this.getEditorKeyHandler()));
    }

    public void dispose() {
        if (this.editModelClient != null) {
            this.editModelClient.getEditModel().getResourceSet().eAdapters().remove((Object)this.getEditorAdapter());
            this.editModelClient.dispose();
            this.editModelClient = null;
        }
        if (this.getGraphicalViewer() != null) {
            if (this.selectionChangeListener != null) {
                this.getGraphicalViewer().removeSelectionChangedListener(this.selectionChangeListener);
            }
            this.getGraphicalViewer().setContents(null);
            if (this.getGraphicalViewer().getControl() != null && !this.getGraphicalViewer().getControl().isDisposed()) {
                this.getGraphicalViewer().getControl().dispose();
                this.getGraphicalViewer().setControl(null);
            }
        }
        if (this.getTrayViewer() != null) {
            this.getTrayViewer().setContents(null);
        }
        if (this.getEditDomain() != null) {
            this.getEditDomain().setPaletteViewer(null);
        }
        if (this.transferBuffer != null) {
            this.transferBuffer.dispose();
        }
        this.lastSelectedEditPart = null;
        super.dispose();
        if (this.adaptingSelectionProvider != null) {
            this.getSite().setSelectionProvider(null);
            this.adaptingSelectionProvider = null;
        }
        if (this.getEditDomain() != null) {
            ((BPELEditDomain)this.getEditDomain()).setProcess(null);
        }
        this.modelAutoUndoRecorder = null;
        if (this.getSelectionActions() != null) {
            this.getSelectionActions().clear();
        }
        if (this.getPropertyActions() != null) {
            this.getPropertyActions().clear();
        }
        if (this.getActionRegistry() != null) {
            this.getActionRegistry().dispose();
            this.setActionRegistry(null);
        }
    }

    public void doSave(IProgressMonitor progressMonitor) {
        Resource artifactsResource;
        this.getCommandFramework().applyCurrentChange();
        this.removeUnusedExtensions();
        if (this.getEditModelClient().getArtifactsResourceInfo() != null && (artifactsResource = this.getEditModelClient().getArtifactsResourceInfo().getResource()) instanceof WSDLResourceImpl && !artifactsResource.getContents().isEmpty()) {
            Definition def = (Definition)artifactsResource.getContents().get(0);
            String TNS = def.getTargetNamespace();
            if (TNS == null) {
                TNS = def.getNamespace("tns");
                if (TNS == null) {
                    TNS = "UGGH";
                }
                def.setTargetNamespace(TNS);
            } else {
                def.addNamespace("tns", TNS);
            }
            def.getEImports().clear();
            WSDLImportHelper.addAllImportsAndNamespaces(def, (IResource)this.getEditModelClient().getPrimaryResourceInfo().getFile());
            ((DefinitionImpl)def).updateElement();
        }
        try {
            this.getExtensionsResource().setModified(false);
            this.getEditModelClient().saveAll(progressMonitor);
        }
        finally {
            this.updateTitle();
        }
        IFile bpelFile = this.getEditModelClient().getPrimaryResourceInfo().getFile();
        long modificationStamp = bpelFile.getLocalTimeStamp();
        ProcessExtension processExtension = (ProcessExtension)ModelHelper.getExtension((EObject)this.getProcess());
        if (processExtension != null) {
            processExtension.setModificationStamp(modificationStamp);
            this.getExtensionsResource().setModified(true);
        }
        this.getEditModelClient().saveAll(progressMonitor);
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
        this.getCommandFramework().applyCurrentChange();
        this.performSaveAs();
        this.updateTitle();
    }

    protected boolean performSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.setOriginalFile(this.getFileInput());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        if (path != null) {
            return this.getEditModelClient().savePrimaryResourceAs(ResourcesPlugin.getWorkspace().getRoot().getFile(path), this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor());
        }
        return false;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
                PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), "org.eclipse.bpel.ui.editor_palette");
            }
        };
    }

    protected void initializeGraphicalViewer() {
        this.getGraphicalViewer().setEditPartFactory((EditPartFactory)new BPELEditPartFactory());
        BPELUIPlugin.INSTANCE.getPreferenceStore().setValue("pref_show_freeform_flow", true);
        GraphicalViewer viewer = this.getGraphicalViewer();
        viewer.setContents((Object)this.getProcess());
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new FileDropTargetListener(viewer, this));
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new TextDropTargetListener(viewer, this));
        viewer.addDropTargetListener((TransferDropTargetListener)new BPELTextTransferDropTargetListener((EditPartViewer)viewer, this));
        viewer.addDropTargetListener((TransferDropTargetListener)new BPELTemplateTransferDropTargetListener((EditPartViewer)viewer));
        this.selectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.size() <= 1 && (o = selection.getFirstElement()) instanceof EditPart) {
                    BPELEditor.this.lastSelectedEditPart = (EditPart)o;
                }
            }
        };
        this.traySelectionChangeListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object o;
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection.size() <= 1 && (o = selection.getFirstElement()) instanceof EditPart) {
                    BPELEditor.this.lastSelectedEditPart = (EditPart)o;
                }
            }
        };
        this.getGraphicalViewer().addSelectionChangedListener(this.selectionChangeListener);
        this.arrangeEditParts(this.getGraphicalViewer());
    }

    public void arrangeEditParts(GraphicalViewer graphicalViewer) {
        ArrayList<FlowEditPart> flowsToArrange = new ArrayList<FlowEditPart>();
        ArrayList<Point> flowChildlocations = new ArrayList<Point>();
        TreeIterator it = this.getProcess().eAllContents();
        while (it.hasNext()) {
            EditPart editPart;
            EObject model = (EObject)it.next();
            if (!(model instanceof Flow)) continue;
            boolean missingLoc = false;
            Iterator it2 = ((Flow)model).getActivities().iterator();
            while (!missingLoc && it2.hasNext()) {
                Activity child = (Activity)it2.next();
                if (child == null) continue;
                Point loc = ModelHelper.getLocation(child);
                if (loc.x == Integer.MIN_VALUE) {
                    missingLoc = true;
                }
                flowChildlocations.add(new Point(loc));
            }
            if (flowChildlocations.size() > 1) {
                int i = 0;
                while (!missingLoc && i < flowChildlocations.size()) {
                    int x = ((Point)flowChildlocations.get((int)i)).x;
                    int y = ((Point)flowChildlocations.get((int)i)).y;
                    int j = i + 1;
                    while (!missingLoc && j < flowChildlocations.size()) {
                        Point loc = (Point)flowChildlocations.get(j);
                        if (loc.x == x && loc.y == y) {
                            missingLoc = true;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (!missingLoc || !((editPart = (EditPart)graphicalViewer.getEditPartRegistry().get(model)) instanceof FlowEditPart)) continue;
            flowsToArrange.add((FlowEditPart)editPart);
        }
        BPELUtil.sortFlowList(flowsToArrange);
        for (FlowEditPart flowEditPart : flowsToArrange) {
            flowEditPart.doImmediateAutoLayout();
        }
    }

    public void commandStackChanged(EventObject event) {
        this.firePropertyChange(257);
        super.commandStackChanged(event);
    }

    protected KeyHandler getKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
        }
        return this.keyHandler;
    }

    protected KeyHandler getEditorKeyHandler() {
        if (this.keyHandler == null) {
            this.keyHandler = new KeyHandler();
            this.keyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000005, (int)0), (IAction)new Action(){

                public void run() {
                    ((ScrollingBPELGraphicalViewer)BPELEditor.this.getGraphicalViewer()).scrollVertical(true);
                }
            });
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000006, (int)0), (IAction)new Action(){

                public void run() {
                    ((ScrollingBPELGraphicalViewer)BPELEditor.this.getGraphicalViewer()).scrollVertical(false);
                }
            });
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000007, (int)0), (IAction)new Action(){

                public void run() {
                    ((ScrollingBPELGraphicalViewer)BPELEditor.this.getGraphicalViewer()).scrollHorizontal(true);
                }
            });
            this.keyHandler.put(KeyStroke.getPressed((int)0x1000008, (int)0), (IAction)new Action(){

                public void run() {
                    ((ScrollingBPELGraphicalViewer)BPELEditor.this.getGraphicalViewer()).scrollHorizontal(false);
                }
            });
        }
        return this.keyHandler;
    }

    protected void replaceSelectionAction(ActionRegistry registry, IAction action) {
        IAction oldAction = registry.getAction((Object)action.getId());
        if (oldAction != null) {
            registry.removeAction(oldAction);
            this.getSelectionActions().remove(oldAction.getId());
        }
        registry.registerAction(action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new SelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        action = new SaveAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        registry.registerAction((IAction)new PrintAction((IWorkbenchPart)this));
        action = new BPELDeleteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELCutAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELCopyAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELPasteAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELDuplicateAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new RevertAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getPropertyActions().add(action.getId());
        action = new RenameAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleAutoFlowLayout((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleShowFaultHandler((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleShowCompensationHandler((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleShowTerminationHandler((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleShowEventHandler((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new AutoArrangeFlowsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new ToggleLayoutOrientationAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        ShowViewAction showViewAction = new ShowPropertiesViewAction();
        showViewAction.setPage(this.getSite().getPage());
        registry.registerAction((IAction)showViewAction);
        showViewAction = new ShowPaletteInPaletteViewAction();
        showViewAction.setPage(this.getSite().getPage());
        registry.registerAction((IAction)showViewAction);
        action = new BPELPrintAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELAddChildInTrayAction((IWorkbenchPart)this, PartnerLinksEditPart.class, Messages.BPELEditor_addPartnerLink, BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/partner_in_pal.gif"));
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELAddChildInTrayAction((IWorkbenchPart)this, VariablesEditPart.class, Messages.BPELEditor_addVariable, BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/variable.gif"));
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELAddChildInTrayAction((IWorkbenchPart)this, CorrelationSetsEditPart.class, Messages.BPELEditor_addCorrelationSet, BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/correlationset.gif"));
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new BPELAddChildInTrayAction((IWorkbenchPart)this, MessageExchangesEditPart.class, Messages.BPELEditor_addMessageExchange, BPELUIPlugin.INSTANCE.getImageDescriptor("obj16/exit.gif"));
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new MakePartner2WayAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    protected void createPaletteDependentActions() {
        Comparator<IAction> actionComparator = new Comparator<IAction>(){
            Collator collator = Collator.getInstance();

            @Override
            public int compare(IAction o1, IAction o2) {
                return this.collator.compare(o1.getText(), o2.getText());
            }
        };
        this.appendNewActions = new TreeSet<IAction>(actionComparator);
        this.insertNewActions = new TreeSet<IAction>(actionComparator);
        this.changeTypeActions = new TreeSet<IAction>(actionComparator);
        this.createPaletteDependentActions((PaletteContainer)this.getPaletteRoot());
    }

    protected void createPaletteDependentActions(PaletteContainer container) {
        ActionRegistry registry = this.getActionRegistry();
        for (Object element : container.getChildren()) {
            if (element instanceof PaletteContainer) {
                this.createPaletteDependentActions((PaletteContainer)element);
                continue;
            }
            if (!(element instanceof BPELCreationToolEntry)) continue;
            BPELCreationToolEntry entry = (BPELCreationToolEntry)((Object)element);
            AbstractUIObjectFactory factory = entry.getUIObjectFactory();
            SelectionAction action = new AppendNewAction((IWorkbenchPart)this, factory);
            this.appendNewActions.add((IAction)action);
            registry.registerAction((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new InsertNewAction((IWorkbenchPart)this, factory);
            registry.registerAction((IAction)action);
            this.insertNewActions.add((IAction)action);
            this.getSelectionActions().add(action.getId());
            action = new ChangeTypeAction((IWorkbenchPart)this, factory);
            registry.registerAction((IAction)action);
            this.changeTypeActions.add((IAction)action);
            this.getSelectionActions().add(action.getId());
        }
    }

    public Process getProcess() {
        IWorkbenchPartSite editorSite = this.getSite();
        if (editorSite instanceof MultiPageEditorSite) {
            return (Process)((MultiPageEditorSite)this.getSite()).getMultiPageEditor().getAdapter(Process.class);
        }
        return null;
    }

    public Resource getExtensionsResource() {
        IWorkbenchPartSite editorSite = this.getSite();
        if (editorSite instanceof MultiPageEditorSite) {
            return (Resource)((MultiPageEditorSite)this.getSite()).getMultiPageEditor().getAdapter(Resource.class);
        }
        return null;
    }

    public ExtensionMap getExtensionMap() {
        IWorkbenchPartSite editorSite = this.getSite();
        if (editorSite instanceof MultiPageEditorSite) {
            return (ExtensionMap)((MultiPageEditorSite)this.getSite()).getMultiPageEditor().getAdapter(ExtensionMap.class);
        }
        return null;
    }

    public ModelListenerAdapter getModelListenerAdapter() {
        IWorkbenchPartSite editorSite = this.getSite();
        if (editorSite instanceof MultiPageEditorSite) {
            return (ModelListenerAdapter)((Object)((MultiPageEditorSite)this.getSite()).getMultiPageEditor().getAdapter(ModelListenerAdapter.class));
        }
        return null;
    }

    public CommandStack getCommandStack() {
        IWorkbenchPartSite editorSite = this.getSite();
        if (editorSite instanceof MultiPageEditorSite) {
            return (CommandStack)((MultiPageEditorSite)this.getSite()).getMultiPageEditor().getAdapter(CommandStack.class);
        }
        return null;
    }

    public void setAutoFlowLayout(boolean autoLayout) {
        BPELUIPlugin.INSTANCE.getPreferenceStore().setValue("pref_auto_flow_layout", autoLayout);
    }

    public boolean getAutoFlowLayout() {
        return BPELUIPlugin.INSTANCE.getPreferenceStore().getBoolean("pref_auto_flow_layout");
    }

    protected void createGraphicalViewer(Composite parent) {
        ScrollingBPELGraphicalViewer viewer = new ScrollingBPELGraphicalViewer();
        viewer.createControl(parent);
        this.setGraphicalViewer((GraphicalViewer)viewer);
        this.configureGraphicalViewer();
        this.hookGraphicalViewer();
        this.initializeGraphicalViewer();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.bpel.ui.editor_canvas");
    }

    protected void hookGraphicalViewer() {
    }

    public void setGraphicalViewer(GraphicalViewer viewer) {
        super.setGraphicalViewer(viewer);
    }

    public void refreshGraphicalViewer() {
        BPELUtil.regenerateVisuals(this.getProcess(), this.getGraphicalViewer());
    }

    public void selectModelObject(Object modelObject) {
        this.setFocus();
        if (modelObject == null) {
            this.adaptingSelectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
        } else {
            this.adaptingSelectionProvider.setSelection((ISelection)new StructuredSelection(modelObject));
        }
    }

    public ISelection getSelection() {
        ISelection editPartSelection = this.getGraphicalViewer().getSelection();
        if (editPartSelection == null || !(editPartSelection instanceof StructuredSelection) || editPartSelection.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        for (Object o : (StructuredSelection)editPartSelection) {
            if (!(o instanceof EditPart)) continue;
            list.add(((EditPart)o).getModel());
        }
        return new StructuredSelection(list);
    }

    public AdaptingSelectionProvider getAdaptingSelectionProvider() {
        if (this.adaptingSelectionProvider == null) {
            this.adaptingSelectionProvider = new BPELAdaptingSelectionProvider();
        }
        return this.adaptingSelectionProvider;
    }

    private MultiViewerSelectionProvider getMultiViewerSelectionProvider() {
        if (this.weakMultiViewerSelectionProvider == null) {
            this.weakMultiViewerSelectionProvider = new WeakMultiViewerSelectionProvider(){
                protected ISelection cachedAdaptingSelection;

                public ISelection getSelection() {
                    if (BPELEditor.this.getAdaptingSelectionProvider().getSelection() != this.cachedAdaptingSelection) {
                        this.cachedSelection = null;
                    }
                    return super.getSelection();
                }
            };
        }
        return this.weakMultiViewerSelectionProvider;
    }

    protected BPELEditorAdapter getEditorAdapter() {
        return this.editorAdapter;
    }

    public GraphicalViewer getGraphicalViewer() {
        return super.getGraphicalViewer();
    }

    public void refreshHoverHelp(EObject modelObject) {
        EditPart editPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(modelObject);
        if (editPart instanceof IHoverHelperSupport) {
            ((IHoverHelperSupport)editPart).refreshHoverHelp();
        }
    }

    public void refreshHoverHelp() {
        BPELUtil.visitModelDepthFirst(this.getProcess(), new IModelVisitor(){

            @Override
            public boolean visit(Object modelObject) {
                EditPart editPart = (EditPart)BPELEditor.this.getGraphicalViewer().getEditPartRegistry().get(modelObject);
                if (editPart == null) {
                    editPart = (EditPart)BPELEditor.this.getTrayViewer().getEditPartRegistry().get(modelObject);
                }
                if (editPart instanceof IHoverHelperSupport) {
                    ((IHoverHelperSupport)editPart).refreshHoverHelp();
                }
                return true;
            }
        });
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getTrayComposite().setState(1);
        this.getTrayComposite().setTrayWidth(150);
        this.getEditorSite().getKeyBindingService();
        this.selectModelObject(this.getProcess());
    }

    protected IFile getFileInput() {
        return (IFile)this.getEditorInput().getAdapter(IFile.class);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        IFile input = (IFile)editorInput.getAdapter(IFile.class);
        if (input == null) {
            throw new PartInitException(Messages.BPELEditor_Cant_read_input_file_1);
        }
        super.init(site, editorInput);
        this.transferBuffer = new TransferBuffer(this.getSite().getShell().getDisplay());
        this.getCommandStack().removeCommandStackListener((CommandStackListener)this);
        ResourceSet resourceSet = this.getEditModelClient().getEditModel().getResourceSet();
        resourceSet.eAdapters().add((Object)this.getModelListenerAdapter());
        this.editorAdapter = new BPELEditorAdapter();
        resourceSet.eAdapters().add((Object)this.editorAdapter);
        this.getModelListenerAdapter().setLinkNotificationAdapter(new LinkNotificationAdapter(this));
        this.getCommandStack().addCommandStackListener((CommandStackListener)this.getModelListenerAdapter());
        this.commandFramework = new EditModelCommandFramework(this.getEditModelClient().getCommandStack());
        this.getCommandStack().addCommandStackListener((CommandStackListener)this);
        this.createPaletteDependentActions();
    }

    public ICommandFramework getCommandFramework() {
        return this.commandFramework;
    }

    public ActionRegistry getActionRegistry() {
        return super.getActionRegistry();
    }

    protected void initializeTrayViewer() {
        GraphicalViewer viewer = this.getTrayViewer();
        viewer.setEditPartFactory((EditPartFactory)new BPELTrayEditPartFactory());
        viewer.setEditDomain((EditDomain)this.getEditDomain());
        this.getEditDomain().addViewer((EditPartViewer)viewer);
        viewer.addSelectionChangedListener(this.traySelectionChangeListener);
        this.registerViewer((EditPartViewer)viewer);
        ProcessContextMenuProvider provider = new ProcessContextMenuProvider(this, this.getActionRegistry());
        viewer.setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.bpel.editor.tray.contextmenu", (MenuManager)provider, this.getSite().getSelectionProvider());
        viewer.setContents((Object)this.getProcess());
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new FileDropTargetListener(this.getTrayViewer(), this));
        viewer.addDropTargetListener((org.eclipse.jface.util.TransferDropTargetListener)new TextDropTargetListener(this.getTrayViewer(), this));
        PlatformUI.getWorkbench().getHelpSystem().setHelp(viewer.getControl(), "org.eclipse.bpel.ui.editor_tray");
    }

    protected void registerViewer(EditPartViewer viewer) {
        this.getAdaptingSelectionProvider().addViewer(viewer);
        this.getMultiViewerSelectionProvider().addViewer(viewer);
    }

    protected void updateTitle() {
        this.setPartName(this.getProcess().getName());
    }

    protected void removeUnusedExtensions() {
        ExtensionMap map = this.getExtensionMap();
        Set keyset = map.keySet();
        Vector<EObject> deleted = new Vector<EObject>();
        for (EObject model : keyset) {
            try {
                if (model.eResource() != null) continue;
                deleted.add(model);
            }
            catch (Exception exception) {
                deleted.add(model);
            }
        }
        int j = 0;
        while (j < deleted.size()) {
            map.remove(deleted.get(j));
            ++j;
        }
    }

    public Definition getArtifactsDefinition() {
        Resource artifactsResource = this.getEditModelClient().getArtifactsResourceInfo().getResource();
        return (Definition)artifactsResource.getContents().get(0);
    }

    protected String getPaletteAdditionsContributorId() {
        return "org.eclipse.bpel.ui.bpeleditor";
    }

    public boolean isHorizontalLayout() {
        boolean result = false;
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        try {
            result = Boolean.valueOf(file.getPersistentProperty(IBPELUIConstants.HORIZONTAL_LAYOUT_PROPERTY));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public void setHorizontalLayout(boolean horizontal) {
        IFile file = (IFile)this.getEditorInput().getAdapter(IFile.class);
        try {
            file.setPersistentProperty(IBPELUIConstants.HORIZONTAL_LAYOUT_PROPERTY, Boolean.toString(horizontal));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public BPELMultipageEditorPart getMultipageEditor() {
        return this.multipageEditor;
    }

    protected class BPELEditorAdapter
    implements Adapter {
        protected BPELEditorAdapter() {
        }

        public Notifier getTarget() {
            return null;
        }

        public void setTarget(Notifier newTarget) {
        }

        public boolean isAdapterForType(Object type) {
            return type == BPELEditorAdapter.class;
        }

        public void notifyChanged(Notification notification) {
        }

        public BPELEditor getBPELEditor() {
            return BPELEditor.this;
        }
    }
}

