/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.client.impl;

import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.ReturnCommand;
import com.google.gwt.rpc.client.ast.RpcCommand;
import com.google.gwt.rpc.client.ast.ValueCommand;
import com.google.gwt.rpc.client.impl.ClientWriterFactory;
import com.google.gwt.rpc.client.impl.SimplePayloadSink;
import com.google.gwt.rpc.client.impl.TypeOverrides;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.client.rpc.SerializationStreamWriter;

public class CommandToStringWriter
implements SerializationStreamWriter {
    private final ToStringCommandSink commandSink = new ToStringCommandSink();
    private final SerializationStreamWriter writer;

    public CommandToStringWriter(TypeOverrides overrides) {
        this.writer = ClientWriterFactory.createWriter(overrides, this.commandSink);
    }

    public String toString() {
        return this.commandSink.toString();
    }

    public void writeBoolean(boolean value) throws SerializationException {
        this.writer.writeBoolean(value);
    }

    public void writeByte(byte value) throws SerializationException {
        this.writer.writeByte(value);
    }

    public void writeChar(char value) throws SerializationException {
        this.writer.writeChar(value);
    }

    public void writeDouble(double value) throws SerializationException {
        this.writer.writeDouble(value);
    }

    public void writeFloat(float value) throws SerializationException {
        this.writer.writeFloat(value);
    }

    public void writeInt(int value) throws SerializationException {
        this.writer.writeInt(value);
    }

    public void writeLong(long value) throws SerializationException {
        this.writer.writeLong(value);
    }

    public void writeObject(Object value) throws SerializationException {
        this.writer.writeObject(value);
    }

    public void writeShort(short value) throws SerializationException {
        this.writer.writeShort(value);
    }

    public void writeString(String value) throws SerializationException {
        this.writer.writeString(value);
    }

    private static class ToStringCommandSink
    extends CommandSink {
        private final ReturnCommand retCommand = new ReturnCommand();

        private ToStringCommandSink() {
        }

        public void accept(RpcCommand command) throws SerializationException {
            this.retCommand.addValue((ValueCommand)command);
        }

        public void finish() throws SerializationException {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            SimplePayloadSink sink = new SimplePayloadSink(sb);
            try {
                sink.accept(this.retCommand);
                sink.finish();
            }
            catch (SerializationException e) {
                throw new RuntimeException("Unable to create payload", e);
            }
            return sb.toString();
        }
    }
}

