/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.ManagerStatus;
import org.mandas.docker.client.messages.swarm.NodeDescription;
import org.mandas.docker.client.messages.swarm.NodeInfo;
import org.mandas.docker.client.messages.swarm.NodeSpec;
import org.mandas.docker.client.messages.swarm.NodeStatus;
import org.mandas.docker.client.messages.swarm.Version;

final class ImmutableNodeInfo
implements NodeInfo {
    private final String id;
    private final Version version;
    private final Date createdAt;
    private final Date updatedAt;
    private final NodeSpec spec;
    private final NodeDescription description;
    private final NodeStatus status;
    @Nullable
    private final ManagerStatus managerStatus;

    private ImmutableNodeInfo(String id, Version version, Date createdAt, Date updatedAt, NodeSpec spec, NodeDescription description, NodeStatus status, @Nullable ManagerStatus managerStatus) {
        this.id = id;
        this.version = version;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.spec = spec;
        this.description = description;
        this.status = status;
        this.managerStatus = managerStatus;
    }

    @Override
    @JsonProperty(value="ID")
    public String id() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Version")
    public Version version() {
        return this.version;
    }

    @Override
    @JsonProperty(value="CreatedAt")
    public Date createdAt() {
        return this.createdAt;
    }

    @Override
    @JsonProperty(value="UpdatedAt")
    public Date updatedAt() {
        return this.updatedAt;
    }

    @Override
    @JsonProperty(value="Spec")
    public NodeSpec spec() {
        return this.spec;
    }

    @Override
    @JsonProperty(value="Description")
    public NodeDescription description() {
        return this.description;
    }

    @Override
    @JsonProperty(value="Status")
    public NodeStatus status() {
        return this.status;
    }

    @Override
    @JsonProperty(value="ManagerStatus")
    @Nullable
    public ManagerStatus managerStatus() {
        return this.managerStatus;
    }

    public final ImmutableNodeInfo withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableNodeInfo(newValue, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withVersion(Version value) {
        if (this.version == value) {
            return this;
        }
        Version newValue = Objects.requireNonNull(value, "version");
        return new ImmutableNodeInfo(this.id, newValue, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withCreatedAt(Date value) {
        if (this.createdAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "createdAt");
        return new ImmutableNodeInfo(this.id, this.version, newValue, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withUpdatedAt(Date value) {
        if (this.updatedAt == value) {
            return this;
        }
        Date newValue = Objects.requireNonNull(value, "updatedAt");
        return new ImmutableNodeInfo(this.id, this.version, this.createdAt, newValue, this.spec, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withSpec(NodeSpec value) {
        if (this.spec == value) {
            return this;
        }
        NodeSpec newValue = Objects.requireNonNull(value, "spec");
        return new ImmutableNodeInfo(this.id, this.version, this.createdAt, this.updatedAt, newValue, this.description, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withDescription(NodeDescription value) {
        if (this.description == value) {
            return this;
        }
        NodeDescription newValue = Objects.requireNonNull(value, "description");
        return new ImmutableNodeInfo(this.id, this.version, this.createdAt, this.updatedAt, this.spec, newValue, this.status, this.managerStatus);
    }

    public final ImmutableNodeInfo withStatus(NodeStatus value) {
        if (this.status == value) {
            return this;
        }
        NodeStatus newValue = Objects.requireNonNull(value, "status");
        return new ImmutableNodeInfo(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, newValue, this.managerStatus);
    }

    public final ImmutableNodeInfo withManagerStatus(@Nullable ManagerStatus value) {
        if (this.managerStatus == value) {
            return this;
        }
        return new ImmutableNodeInfo(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNodeInfo && this.equalTo((ImmutableNodeInfo)another);
    }

    private boolean equalTo(ImmutableNodeInfo another) {
        return this.id.equals(another.id) && this.version.equals(another.version) && this.createdAt.equals(another.createdAt) && this.updatedAt.equals(another.updatedAt) && this.spec.equals(another.spec) && this.description.equals(another.description) && this.status.equals(another.status) && Objects.equals(this.managerStatus, another.managerStatus);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.version.hashCode();
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + this.spec.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.status.hashCode();
        h += (h << 5) + Objects.hashCode(this.managerStatus);
        return h;
    }

    public String toString() {
        return "NodeInfo{id=" + this.id + ", version=" + this.version + ", createdAt=" + this.createdAt + ", updatedAt=" + this.updatedAt + ", spec=" + this.spec + ", description=" + this.description + ", status=" + this.status + ", managerStatus=" + this.managerStatus + "}";
    }

    public static ImmutableNodeInfo copyOf(NodeInfo instance) {
        if (instance instanceof ImmutableNodeInfo) {
            return (ImmutableNodeInfo)instance;
        }
        return ImmutableNodeInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_VERSION = 2L;
        private static final long INIT_BIT_CREATED_AT = 4L;
        private static final long INIT_BIT_UPDATED_AT = 8L;
        private static final long INIT_BIT_SPEC = 16L;
        private static final long INIT_BIT_DESCRIPTION = 32L;
        private static final long INIT_BIT_STATUS = 64L;
        private long initBits = 127L;
        private String id;
        private Version version;
        private Date createdAt;
        private Date updatedAt;
        private NodeSpec spec;
        private NodeDescription description;
        private NodeStatus status;
        private ManagerStatus managerStatus;

        private Builder() {
        }

        public final Builder from(NodeInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.id());
            this.version(instance.version());
            this.createdAt(instance.createdAt());
            this.updatedAt(instance.updatedAt());
            this.spec(instance.spec());
            this.description(instance.description());
            this.status(instance.status());
            ManagerStatus managerStatusValue = instance.managerStatus();
            if (managerStatusValue != null) {
                this.managerStatus(managerStatusValue);
            }
            return this;
        }

        @JsonProperty(value="ID")
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Version")
        public final Builder version(Version version) {
            this.version = Objects.requireNonNull(version, "version");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="CreatedAt")
        public final Builder createdAt(Date createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="UpdatedAt")
        public final Builder updatedAt(Date updatedAt) {
            this.updatedAt = Objects.requireNonNull(updatedAt, "updatedAt");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty(value="Spec")
        public final Builder spec(NodeSpec spec) {
            this.spec = Objects.requireNonNull(spec, "spec");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty(value="Description")
        public final Builder description(NodeDescription description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty(value="Status")
        public final Builder status(NodeStatus status) {
            this.status = Objects.requireNonNull(status, "status");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="ManagerStatus")
        public final Builder managerStatus(@Nullable ManagerStatus managerStatus) {
            this.managerStatus = managerStatus;
            return this;
        }

        public ImmutableNodeInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNodeInfo(this.id, this.version, this.createdAt, this.updatedAt, this.spec, this.description, this.status, this.managerStatus);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("createdAt");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("updatedAt");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("spec");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("status");
            }
            return "Cannot build NodeInfo, some of required attributes are not set " + attributes;
        }
    }
}

