/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath.ui.internal;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceTable;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XPathUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.wst.xml.xpath.ui";
    private static XPathUIPlugin plugin;
    private TemplateStore fXPathTemplateStore;
    private ContributionContextTypeRegistry fXPathContextTypeRegistry;
    private Map<String, List<NamespaceInfo>> namespaceInfo = new ConcurrentHashMap<String, List<NamespaceInfo>>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static XPathUIPlugin getDefault() {
        return plugin;
    }

    public static void log(Exception e) {
        XPathUIPlugin.getDefault().getLog().log((IStatus)new Status(4, PLUGIN_ID, 0, "", (Throwable)e));
    }

    public static void log(CoreException e) {
        XPathUIPlugin.getDefault().getLog().log(e.getStatus());
    }

    public TemplateStore getXPathTemplateStore() {
        if (this.fXPathTemplateStore == null) {
            this.fXPathTemplateStore = new ContributionTemplateStore(this.getXPathTemplateContextRegistry(), this.getPreferenceStore(), "org.eclipse.wst.xml.xpath.ui.xpath_custom_templates");
            try {
                this.fXPathTemplateStore.load();
            }
            catch (IOException iOException) {}
        }
        return this.fXPathTemplateStore;
    }

    public ContextTypeRegistry getXPathTemplateContextRegistry() {
        if (this.fXPathContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("xsl_xpath");
            registry.addContextType("xpath_operator");
            registry.addContextType("xpath_axis");
            registry.addContextType("exslt_function");
            registry.addContextType("xpath_2");
            registry.addContextType("extension_function");
            this.fXPathContextTypeRegistry = registry;
        }
        return this.fXPathContextTypeRegistry;
    }

    public void setNamespaceInfo(Map<String, List<NamespaceInfo>> namespaceInfo) {
        this.namespaceInfo = namespaceInfo;
    }

    public Map<String, List<NamespaceInfo>> getNamespaceInfo() {
        return this.namespaceInfo;
    }

    public List<NamespaceInfo> getNamespaceInfo(IDOMDocument document) {
        XPathUIPlugin plugin = XPathUIPlugin.getDefault();
        String modelID = document.getModel().getId();
        Map<String, List<NamespaceInfo>> namespaceInfo = plugin.getNamespaceInfo();
        List<NamespaceInfo> info = namespaceInfo.get(modelID);
        if (info == null && document.getDocumentElement() != null) {
            info = new ArrayList<NamespaceInfo>();
            NamespaceTable namespaceTable = new NamespaceTable((Document)document);
            namespaceTable.visitElement(document.getDocumentElement());
            Collection namespaces = namespaceTable.getNamespaceInfoCollection();
            info.addAll(namespaces);
            namespaceInfo.put(modelID, info);
            plugin.setNamespaceInfo(namespaceInfo);
            this.ensureDefault(namespaceTable, "xs", "http://www.w3.org/2001/XMLSchema");
        }
        return info;
    }

    private void ensureDefault(NamespaceTable namespaceTable, String prefix, String uri) {
        if (namespaceTable.getURIForPrefix(prefix) == null) {
            namespaceTable.addNamespaceInfo(prefix, uri, null);
        }
    }
}

