/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import java.util.ArrayList;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.Compiler;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.core.util.BindingKeyParser;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class BindingKeyResolver
extends BindingKeyParser {
    Compiler compiler;
    Binding compilerBinding;
    char[][] compoundName;
    int dimension;
    LookupEnvironment environment;
    ReferenceBinding genericType;
    MethodBinding methodBinding;
    char[] secondarySimpleName;
    CompilationUnitDeclaration parsedUnit;
    BlockScope scope;
    TypeBinding typeBinding;
    TypeDeclaration typeDeclaration;
    ArrayList types = new ArrayList();
    int rank = 0;
    int wildcardRank;
    CompilationUnitDeclaration outerMostParsedUnit;

    private BindingKeyResolver(BindingKeyParser parser, Compiler compiler, LookupEnvironment environment, int wildcardRank, CompilationUnitDeclaration outerMostParsedUnit) {
        super(parser);
        this.compiler = compiler;
        this.environment = environment;
        this.wildcardRank = wildcardRank;
        this.outerMostParsedUnit = outerMostParsedUnit;
    }

    public BindingKeyResolver(String key) {
        this(key, null, null);
    }

    public BindingKeyResolver(String key, Compiler compiler, LookupEnvironment environment) {
        super(key);
        this.compiler = compiler;
        this.environment = environment;
    }

    public char[][] compoundName() {
        return this.compoundName;
    }

    @Override
    public void consumeArrayDimension(char[] brakets) {
        this.dimension = brakets.length;
    }

    @Override
    public void consumeBaseType(char[] baseTypeSig) {
        this.compoundName = new char[][]{this.getKey().toCharArray()};
        TypeBinding baseTypeBinding = this.getBaseTypeBinding(baseTypeSig);
        if (baseTypeBinding != null) {
            this.typeBinding = baseTypeBinding;
        }
    }

    @Override
    public void consumeException() {
        this.types = new ArrayList();
    }

    @Override
    public void consumeField(char[] fieldName) {
        FieldBinding[] fields = ((ReferenceBinding)this.typeBinding).availableFields();
        int i = 0;
        int length = fields.length;
        while (i < length) {
            FieldBinding field = fields[i];
            if (CharOperation.equals(fieldName, field.name)) {
                this.typeBinding = null;
                this.compilerBinding = field;
                return;
            }
            ++i;
        }
    }

    @Override
    public void consumeLocalType(char[] uniqueKey) {
        LocalTypeBinding[] localTypeBindings = this.parsedUnit.localTypes;
        int i = 0;
        while (i < this.parsedUnit.localTypeCount) {
            if (CharOperation.equals(uniqueKey, localTypeBindings[i].computeUniqueKey(false))) {
                this.typeBinding = localTypeBindings[i];
                return;
            }
            ++i;
        }
    }

    @Override
    public void consumeLocalVar(char[] varName) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().getScope();
        }
        int i = 0;
        while (i < this.scope.localIndex) {
            LocalVariableBinding local = this.scope.locals[i];
            if (CharOperation.equals(varName, local.name)) {
                this.methodBinding = null;
                this.compilerBinding = local;
                return;
            }
            ++i;
        }
    }

    @Override
    public void consumeMethod(char[] selector, char[] signature) {
        MethodBinding[] methods = ((ReferenceBinding)this.typeBinding).availableMethods();
        int i = 0;
        int methodLength = methods.length;
        while (i < methodLength) {
            char[] methodSignature;
            MethodBinding method = methods[i];
            if ((CharOperation.equals(selector, method.selector) || selector.length == 0 && method.isConstructor()) && CharOperation.equals(signature, methodSignature = method.signature())) {
                this.typeBinding = null;
                this.methodBinding = method;
                this.compilerBinding = this.methodBinding;
                return;
            }
            ++i;
        }
    }

    @Override
    public void consumeMemberType(char[] simpleTypeName) {
        this.typeBinding = this.getTypeBinding(simpleTypeName);
    }

    @Override
    public void consumePackage(char[] pkgName) {
        this.compoundName = CharOperation.splitOn('/', pkgName);
        this.compilerBinding = new PackageBinding(this.compoundName, null, this.environment);
    }

    @Override
    public void consumeParser(BindingKeyParser parser) {
        this.types.add(parser);
    }

    @Override
    public void consumeScope(int scopeNumber) {
        if (this.scope == null) {
            this.scope = this.methodBinding.sourceMethod().getScope();
        }
        if (scopeNumber >= this.scope.subscopeCount) {
            return;
        }
        this.scope = (BlockScope)this.scope.subscopes[scopeNumber];
    }

    @Override
    public void consumeSecondaryType(char[] simpleTypeName) {
        this.secondarySimpleName = simpleTypeName;
    }

    @Override
    public void consumeFullyQualifiedName(char[] fullyQualifiedName) {
        this.compoundName = CharOperation.splitOn('/', fullyQualifiedName);
    }

    @Override
    public void consumeTopLevelType() {
        this.parsedUnit = this.getCompilationUnitDeclaration();
        if (this.parsedUnit != null && this.compiler != null) {
            this.compiler.process(this.parsedUnit, this.compiler.totalUnits + 1);
        }
        if (this.parsedUnit == null) {
            this.typeBinding = this.getBinaryBinding();
        } else {
            char[] typeName = this.secondarySimpleName == null ? this.compoundName[this.compoundName.length - 1] : this.secondarySimpleName;
            this.typeBinding = this.getTypeBinding(typeName);
        }
    }

    @Override
    public void consumeKey() {
        if (this.typeBinding != null) {
            this.typeBinding = this.getArrayBinding(this.dimension, this.typeBinding);
            this.compilerBinding = this.typeBinding;
        }
    }

    @Override
    public void consumeTypeWithCapture() {
        BindingKeyResolver resolver = (BindingKeyResolver)this.types.get(0);
        this.typeBinding = (TypeBinding)resolver.compilerBinding;
    }

    private TypeBinding getArrayBinding(int dim, TypeBinding binding) {
        if (binding == null) {
            return null;
        }
        if (dim == 0) {
            return binding;
        }
        return this.environment.createArrayType(binding, dim);
    }

    private TypeBinding getBaseTypeBinding(char[] signature) {
        switch (signature[0]) {
            case 'I': {
                return TypeBinding.INT;
            }
            case 'Z': {
                return TypeBinding.BOOLEAN;
            }
            case 'V': {
                return TypeBinding.VOID;
            }
            case 'C': {
                return TypeBinding.CHAR;
            }
            case 'D': {
                return TypeBinding.DOUBLE;
            }
            case 'F': {
                return TypeBinding.FLOAT;
            }
            case 'J': {
                return TypeBinding.LONG;
            }
            case 'S': {
                return TypeBinding.SHORT;
            }
            case 'N': {
                return TypeBinding.NULL;
            }
        }
        return null;
    }

    private TypeBinding getBinaryBinding() {
        if (this.compoundName.length == 0) {
            return null;
        }
        return this.environment.getType(this.compoundName);
    }

    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        Object name = this.compoundName;
        if (((char[][])name).length == 0) {
            return null;
        }
        if (this.environment == null) {
            return null;
        }
        ReferenceBinding binding = this.environment.getType((char[][])name);
        if (!(binding instanceof SourceTypeBinding)) {
            if (this.secondarySimpleName == null) {
                return null;
            }
            int length = ((char[][])name).length;
            char[][] cArray = name;
            char[][] cArrayArray = new char[length][];
            name = cArrayArray;
            System.arraycopy(cArray, 0, cArrayArray, 0, length - 1);
            name[length - 1] = this.secondarySimpleName;
            binding = this.environment.getType((char[][])name);
            if (!(binding instanceof SourceTypeBinding)) {
                return null;
            }
        }
        SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)binding;
        if (sourceTypeBinding.scope == null) {
            return null;
        }
        return sourceTypeBinding.scope.compilationUnitScope().referenceContext;
    }

    public Binding getCompilerBinding() {
        try {
            this.parse();
            return this.compilerBinding;
        }
        catch (RuntimeException e) {
            Util.log(e, "Could not create binding from binding key: " + this.getKey());
            return null;
        }
    }

    private TypeBinding getTypeBinding(char[] simpleTypeName) {
        TypeDeclaration[] typeDeclarations;
        if (this.typeBinding instanceof BinaryTypeBinding) {
            return ((BinaryTypeBinding)this.typeBinding).getMemberType(simpleTypeName);
        }
        Object object = this.typeDeclaration == null ? (this.parsedUnit == null ? null : this.parsedUnit.types) : (typeDeclarations = this.typeDeclaration.memberTypes);
        if (typeDeclarations == null) {
            return null;
        }
        int i = 0;
        int length = typeDeclarations.length;
        while (i < length) {
            TypeDeclaration declaration = typeDeclarations[i];
            if (CharOperation.equals(simpleTypeName, declaration.name)) {
                this.typeDeclaration = declaration;
                return declaration.binding;
            }
            ++i;
        }
        return null;
    }

    private TypeBinding[] getTypeBindingArguments() {
        int size = this.types.size();
        TypeBinding[] arguments = new TypeBinding[size];
        int i = 0;
        while (i < size) {
            BindingKeyResolver resolver = (BindingKeyResolver)this.types.get(i);
            TypeBinding compilerBinding2 = (TypeBinding)resolver.compilerBinding;
            if (compilerBinding2 == null) {
                throw new IllegalArgumentException();
            }
            arguments[i] = compilerBinding2;
            ++i;
        }
        this.types = new ArrayList();
        return arguments;
    }

    @Override
    public void malformedKey() {
        this.compoundName = CharOperation.NO_CHAR_CHAR;
    }

    @Override
    public BindingKeyParser newParser() {
        return new BindingKeyResolver(this, this.compiler, this.environment, this.rank, this.outerMostParsedUnit == null ? this.parsedUnit : this.outerMostParsedUnit);
    }

    public String toString() {
        return this.getKey();
    }
}

