(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define(["require", "exports", "../parser/yamlParser07", "vscode-json-languageservice/lib/umd/services/jsonDocumentSymbols"], factory);
    }
})(function (require, exports) {
    /*---------------------------------------------------------------------------------------------
     *  Copyright (c) Red Hat, Inc. All rights reserved.
     *  Copyright (c) Microsoft Corporation. All rights reserved.
     *  Licensed under the MIT License. See License.txt in the project root for license information.
     *--------------------------------------------------------------------------------------------*/
    'use strict';
    Object.defineProperty(exports, "__esModule", { value: true });
    const yamlParser07_1 = require("../parser/yamlParser07");
    const jsonDocumentSymbols_1 = require("vscode-json-languageservice/lib/umd/services/jsonDocumentSymbols");
    class YAMLDocumentSymbols {
        constructor(schemaService) {
            this.jsonDocumentSymbols = new jsonDocumentSymbols_1.JSONDocumentSymbols(schemaService);
            const origKeyLabel = this.jsonDocumentSymbols.getKeyLabel;
            // override 'getKeyLabel' to handle complex mapping
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
            this.jsonDocumentSymbols.getKeyLabel = (property) => {
                if (typeof property.keyNode.value === 'object') {
                    return property.keyNode.value.value;
                }
                else {
                    return origKeyLabel.call(this.jsonDocumentSymbols, property);
                }
            };
        }
        findDocumentSymbols(document) {
            const doc = yamlParser07_1.parse(document.getText());
            if (!doc || doc['documents'].length === 0) {
                return null;
            }
            let results = [];
            for (const yamlDoc of doc['documents']) {
                if (yamlDoc.root) {
                    results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols(document, yamlDoc));
                }
            }
            return results;
        }
        findHierarchicalDocumentSymbols(document) {
            const doc = yamlParser07_1.parse(document.getText());
            if (!doc || doc['documents'].length === 0) {
                return null;
            }
            let results = [];
            for (const yamlDoc of doc['documents']) {
                if (yamlDoc.root) {
                    results = results.concat(this.jsonDocumentSymbols.findDocumentSymbols2(document, yamlDoc));
                }
            }
            return results;
        }
    }
    exports.YAMLDocumentSymbols = YAMLDocumentSymbols;
});
//# sourceMappingURL=documentSymbols.js.map