/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.color;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.ui.dialogs.color.ColorInfo;
import org.eclipse.wb.internal.swt.support.ColorSupport;
import org.eclipse.wb.internal.swt.support.SwtSupport;

public final class SwtColors {
    private static ColorInfo[] m_systemColors;

    public static ColorInfo[] getSystemColors(JavaInfo javaInfo) {
        if (m_systemColors == null) {
            ArrayList colors = Lists.newArrayList();
            try {
                Field[] fields = SwtSupport.getSwtClass().getFields();
                int i = 0;
                while (i < fields.length) {
                    Field field = fields[i];
                    String name = field.getName();
                    if (name.startsWith("COLOR_")) {
                        colors.add(ColorSupport.createInfo(field));
                    }
                    ++i;
                }
            }
            catch (Throwable e) {
                throw ReflectionUtils.propagate((Throwable)e);
            }
            m_systemColors = colors.toArray(new ColorInfo[colors.size()]);
        }
        return m_systemColors;
    }
}

