/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.platform;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.URL;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.wb.internal.core.utils.platform.PluginUtilities;
import org.osgi.framework.Version;

public class PlatformInfo {
    public static final String UNKNOWN_IDE_NAME = "Unknown IDE";
    public static final PluginVersionIdentifier UNKNOWN_VERSION = new PluginVersionIdentifier(100, 1, 4);
    public static final String UNKNOWN_VERSION_STRING = UNKNOWN_VERSION.toString();
    public static final String UNKNOWN_BUILD_ID = "?BUILD-ID?";
    public static final String UNKNOWN_NL = "?NL?";
    private static String ideName;
    private static String ideVersionString;
    private static String ideNL;
    private static Version eclipseVersion;
    private static String eclipseBuildId;
    private static String eclipseBuildName;
    private static GregorianCalendar eclipseBuildDate;

    private PlatformInfo() {
    }

    public static String getIDEName() {
        if (ideName == null) {
            try {
                if (Platform.getProduct() != null) {
                    ideName = Platform.getProduct().getName();
                }
                if (ideName == null) {
                    ideName = UNKNOWN_IDE_NAME;
                } else if ((ideName = ideName.trim()).length() == 0) {
                    ideName = UNKNOWN_IDE_NAME;
                } else if (ideName.startsWith("Eclipse Pl")) {
                    ideName = "Eclipse";
                } else if (ideName.startsWith("Common OS-independent base of the Eclipse platform")) {
                    ideName = "Eclipse";
                }
            }
            catch (Exception ex) {
                ideName = UNKNOWN_IDE_NAME;
            }
        }
        return ideName;
    }

    public static String getIDEVersionString() {
        if (ideVersionString == null) {
            try {
                String pluginId = null;
                if (Platform.getProduct() != null) {
                    pluginId = Platform.getProduct().getDefiningBundle().getSymbolicName();
                }
                ideVersionString = PluginUtilities.getVersionString(pluginId);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ideVersionString == null || ideVersionString.length() == 0) {
                ideVersionString = UNKNOWN_VERSION_STRING;
            }
        }
        return ideVersionString;
    }

    public static String getIDENL() {
        if (ideNL == null) {
            try {
                ideNL = Platform.getNL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ideNL == null) {
                ideNL = UNKNOWN_NL;
            }
        }
        return ideNL;
    }

    public static Version getEclipseVersion() {
        if (eclipseVersion == null) {
            try {
                Version version;
                eclipseVersion = PluginUtilities.getVersion("org.eclipse.core.runtime");
                if (eclipseVersion.getMajor() == 3 && eclipseVersion.getMinor() == 5 && (version = PluginUtilities.getVersion("org.eclipse.jdt.ui")).getMajor() == 3 && version.getMinor() == 6) {
                    eclipseVersion = version;
                }
                if (eclipseVersion.getQualifier().length() == 0) {
                    eclipseVersion = new Version(eclipseVersion.getMajor(), eclipseVersion.getMinor(), eclipseVersion.getMicro(), "v" + PlatformInfo.readBuildId("org.eclipse.jdt", "about.mappings"));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eclipseVersion == null) {
                eclipseVersion = Version.emptyVersion;
            }
        }
        return eclipseVersion;
    }

    public static String getEclipseBuildId() {
        if (eclipseBuildId == null) {
            try {
                eclipseBuildId = PlatformInfo.readBuildId("org.eclipse.jdt", "about.mappings");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eclipseBuildId == null) {
                eclipseBuildId = UNKNOWN_BUILD_ID;
            }
        }
        return eclipseBuildId;
    }

    public static String getEclipseBuildName() {
        if (eclipseBuildName == null && (eclipseBuildName = "") == null) {
            eclipseBuildName = PlatformInfo.getEclipseBuildId();
        }
        return eclipseBuildName;
    }

    public static Calendar getEclipseBuildDate() {
        if (eclipseBuildDate == null) {
            try {
                String ymd = PlatformInfo.getEclipseBuildId();
                if (Character.isLetter(ymd.charAt(0))) {
                    ymd = ymd.substring(1);
                }
                int y = Integer.parseInt(ymd.substring(0, 4));
                int m = Integer.parseInt(ymd.substring(4, 6)) - 1;
                int d = Integer.parseInt(ymd.substring(6, 8));
                eclipseBuildDate = new GregorianCalendar(y, m, d);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (eclipseBuildDate == null) {
                eclipseBuildDate = new GregorianCalendar(2003, 0, 1);
            }
        }
        return eclipseBuildDate;
    }

    private static String readBuildId(String pluginId, String fileName) {
        InputStream stream = null;
        try {
            String line;
            URL url = PluginUtilities.getUrl(pluginId, fileName);
            stream = url.openStream();
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(stream));
            do {
                if ((line = reader.readLine()) != null) continue;
                return null;
            } while (!line.startsWith("0="));
            String string = line.substring(2).trim();
            return string;
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return null;
    }
}

