/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement;

import java.util.Map;
import org.eclipse.viatra.query.runtime.localsearch.operations.ExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.NACOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.CountOperation;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.AbstractPlanNode;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.OperationKind;
import org.eclipse.viatra.query.tooling.localsearch.ui.debugger.provider.viewelement.PatternBodyNode;

public class SearchOperationNode
extends AbstractPlanNode {
    private final String labelText;
    private final ISearchOperation searchOperation;
    private final boolean matcherBased;
    private final OperationKind operationKind;
    private final Map<Integer, String> variableNameMapping;

    public SearchOperationNode(PatternBodyNode parent, ISearchOperation searchOperation) {
        super(parent);
        this.variableNameMapping = parent.getVariableNameMapping();
        Preconditions.checkArgument((searchOperation != null ? 1 : 0) != 0);
        this.searchOperation = searchOperation;
        this.operationKind = searchOperation instanceof ExtendOperationExecutor ? OperationKind.EXTEND : (searchOperation instanceof NACOperation ? OperationKind.NAC : (searchOperation instanceof CountOperation ? OperationKind.COUNT : OperationKind.CHECK));
        this.matcherBased = searchOperation instanceof IPatternMatcherOperation;
        this.labelText = this.doCalculateLabel();
    }

    private String doCalculateLabel() {
        try {
            return this.searchOperation.toString(this.variableNameMapping::get);
        }
        catch (Exception e) {
            return "Error while calculating label: " + e.getMessage() + "(" + e.getClass().getSimpleName() + ")";
        }
    }

    public OperationKind getOperationKind() {
        return this.operationKind;
    }

    @Override
    public String getLabelText() {
        return this.labelText;
    }

    public ISearchOperation getSearchOperation() {
        return this.searchOperation;
    }

    @Override
    public boolean isMatcherCall() {
        return this.matcherBased;
    }
}

