/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.tabular;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.api.scope.IEngineContext;
import org.eclipse.viatra.query.runtime.api.scope.IIndexingErrorListener;
import org.eclipse.viatra.query.runtime.api.scope.IInstanceObserver;
import org.eclipse.viatra.query.runtime.api.scope.ViatraBaseIndexChangeListener;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.tabular.TabularIndexHost;

class TabularEngineContext
implements IEngineContext,
IBaseIndex {
    private TabularIndexHost indexHost;
    private ViatraQueryEngine engine;
    private Logger logger;
    private List<IIndexingErrorListener> errorListeners = CollectionsFactory.createObserverList();

    public TabularEngineContext(TabularIndexHost server, ViatraQueryEngine engine, IIndexingErrorListener errorListener, Logger logger) {
        this.indexHost = server;
        this.engine = engine;
        this.logger = logger;
        this.addIndexingErrorListener(errorListener);
    }

    @Override
    public IBaseIndex getBaseIndex() {
        return this;
    }

    @Override
    public void dispose() {
    }

    @Override
    public IQueryRuntimeContext getQueryRuntimeContext() {
        return this.indexHost.getRuntimeContext();
    }

    @Override
    public <V> V coalesceTraversals(Callable<V> callable) throws InvocationTargetException {
        try {
            return callable.call();
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void addBaseIndexChangeListener(ViatraBaseIndexChangeListener listener) {
    }

    @Override
    public void removeBaseIndexChangeListener(ViatraBaseIndexChangeListener listener) {
    }

    @Override
    public boolean addInstanceObserver(IInstanceObserver observer, Object observedObject) {
        return true;
    }

    @Override
    public boolean removeInstanceObserver(IInstanceObserver observer, Object observedObject) {
        return true;
    }

    @Override
    public void resampleDerivedFeatures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addIndexingErrorListener(IIndexingErrorListener listener) {
        return this.errorListeners.add(listener);
    }

    @Override
    public boolean removeIndexingErrorListener(IIndexingErrorListener listener) {
        return this.errorListeners.remove(listener);
    }
}

