/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.aggregation.timely;

import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.rete.aggregation.timely.FirstOnlyTimelyColumnAggregatorNode;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;

public class FirstOnlySequentialTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult>
extends FirstOnlyTimelyColumnAggregatorNode<Domain, Accumulator, AggregateResult> {
    public FirstOnlySequentialTimelyColumnAggregatorNode(ReteContainer reteContainer, IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, TupleMask groupMask, TupleMask columnMask) {
        super(reteContainer, operator, groupMask, columnMask);
    }

    @Override
    public void update(Direction direction, Tuple update, Timestamp timestamp) {
        Tuple group = this.groupMask.transform((ITuple)update);
        Tuple value = this.columnMask.transform((ITuple)update);
        Object aggregand = this.runtimeContext.unwrapElement(value.get(0));
        boolean isInsertion = direction == Direction.INSERT;
        Object previousResult = this.getResultRaw(group, timestamp, true);
        Accumulator oldAccumulator = this.getAccumulator(group, timestamp);
        Object oldResult = previousResult == null ? this.operator.getAggregate(oldAccumulator) : this.operator.combine(previousResult, oldAccumulator);
        Object newAccumulator = this.operator.update(oldAccumulator, aggregand, isInsertion);
        Object newResult = previousResult == null ? this.operator.getAggregate(newAccumulator) : this.operator.combine(previousResult, newAccumulator);
        this.storeIfNotNeutral(group, newAccumulator, newResult, timestamp);
        this.propagateWithChecks(group, timestamp, previousResult, previousResult, oldResult, newResult);
        if (!Objects.equals(oldResult, newResult)) {
            Object previousOldResult = oldResult;
            Object previousNewResult = newResult;
            Object currentOldResult = null;
            Object currentNewResult = null;
            TreeMap groupEntries = (TreeMap)this.memory.get(group);
            Timestamp currentTimestamp = groupEntries == null ? null : groupEntries.higherKey(timestamp);
            while (currentTimestamp != null) {
                assert (!Objects.equals(previousOldResult, previousNewResult));
                Accumulator accumulator = this.getAccumulator(group, currentTimestamp);
                currentOldResult = ((FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate)groupEntries.get((Object)currentTimestamp)).result;
                currentNewResult = this.operator.combine(previousNewResult, accumulator);
                assert (!this.operator.isNeutral(accumulator));
                this.propagateWithChecks(group, currentTimestamp, previousOldResult, previousNewResult, currentOldResult, currentNewResult);
                if (Objects.equals(currentOldResult, currentNewResult)) break;
                this.storeIfNotNeutral(group, accumulator, currentNewResult, currentTimestamp);
                previousOldResult = currentOldResult;
                previousNewResult = currentNewResult;
                currentTimestamp = groupEntries.higherKey(currentTimestamp);
            }
        }
    }

    @Override
    protected Accumulator getAccumulator(Tuple group, Timestamp timestamp) {
        TreeMap entryMap = (TreeMap)this.memory.get(group);
        if (entryMap == null) {
            return (Accumulator)this.operator.createNeutral();
        }
        FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate entry = (FirstOnlyTimelyColumnAggregatorNode.CumulativeAggregate)entryMap.get(timestamp);
        if (entry == null) {
            return (Accumulator)this.operator.createNeutral();
        }
        return entry.accumulator;
    }
}

