/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.psystem.rewriters;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.matchers.psystem.PTraceable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IDerivativeModificationReason;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IRewriterTraceCollector;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.IMemoryView;
import org.eclipse.viatra.query.runtime.matchers.util.IMultiLookup;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class MappingTraceCollector
implements IRewriterTraceCollector {
    private final IMultiLookup<PTraceable, PTraceable> traces = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);
    private final IMultiLookup<PTraceable, PTraceable> inverseTraces = CollectionsFactory.createMultiLookup(Object.class, CollectionsFactory.MemoryType.SETS, Object.class);
    private final Map<PTraceable, IDerivativeModificationReason> removals = new HashMap<PTraceable, IDerivativeModificationReason>();
    private final Predicate<PTraceable> removed = this.removals::containsKey;

    @Override
    public Stream<PTraceable> getCanonicalTraceables(PTraceable derivative) {
        return this.findTraceEnds(derivative, this.traces).stream();
    }

    @Override
    public Stream<PTraceable> getRewrittenTraceables(PTraceable source) {
        return this.findTraceEnds(source, this.inverseTraces).stream();
    }

    private Set<PTraceable> findTraceEnds(PTraceable traceable, IMultiLookup<PTraceable, PTraceable> traceRecords) {
        if (traceable instanceof PQuery) {
            return Collections.singleton(traceable);
        }
        HashSet<PTraceable> visited = new HashSet<PTraceable>();
        HashSet<PTraceable> result = new HashSet<PTraceable>();
        LinkedList<PTraceable> queue = new LinkedList<PTraceable>();
        queue.add(traceable);
        while (!queue.isEmpty()) {
            PTraceable aDerivative = (PTraceable)queue.poll();
            visited.add(aDerivative);
            IMemoryView<PTraceable> nextOrigins = traceRecords.lookup(aDerivative);
            if (nextOrigins == null) {
                result.add(aDerivative);
                continue;
            }
            for (PTraceable nextOrigin : nextOrigins) {
                if (visited.contains(nextOrigin)) continue;
                queue.add(nextOrigin);
            }
        }
        return result;
    }

    @Override
    public void addTrace(PTraceable original, PTraceable derivative) {
        this.traces.addPairOrNop(derivative, original);
        this.inverseTraces.addPairOrNop(original, derivative);
        this.removals.remove(original);
    }

    @Override
    public void derivativeRemoved(PTraceable derivative, IDerivativeModificationReason reason) {
        Preconditions.checkState(!this.removals.containsKey(derivative), "Traceable %s removed multiple times", derivative);
        if (!this.inverseTraces.lookupExists(derivative)) {
            this.removals.put(derivative, reason);
        }
    }

    @Override
    public boolean isRemoved(PTraceable traceable) {
        return this.getRewrittenTraceables(traceable).allMatch(this.removed);
    }

    @Override
    public Stream<IDerivativeModificationReason> getRemovalReasons(PTraceable traceable) {
        return this.getRewrittenTraceables(traceable).filter(this.removed).map(this.removals::get);
    }
}

