/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.memories;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.memories.DefaultMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.IdentityMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.NullaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.UnaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.TimelyDefaultMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.TimelyIdentityMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.TimelyNullaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.memories.timely.TimelyUnaryMaskedTupleMemory;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Clearable;
import org.eclipse.viatra.query.runtime.matchers.util.CollectionsFactory;
import org.eclipse.viatra.query.runtime.matchers.util.resumable.MaskedResumable;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Diff;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;

public abstract class MaskedTupleMemory<Timestamp extends Comparable<Timestamp>>
implements Clearable,
MaskedResumable<Timestamp> {
    protected final TupleMask mask;
    protected final Object owner;

    public static <T extends Comparable<T>> MaskedTupleMemory<T> create(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner) {
        return MaskedTupleMemory.create(mask, bucketType, owner, false);
    }

    public static <T extends Comparable<T>> MaskedTupleMemory<T> create(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner, boolean isTimely) {
        return MaskedTupleMemory.create(mask, bucketType, owner, isTimely, false);
    }

    public static <T extends Comparable<T>> MaskedTupleMemory<T> create(TupleMask mask, CollectionsFactory.MemoryType bucketType, Object owner, boolean isTimely, boolean isLazy) {
        if (isTimely) {
            if (bucketType != CollectionsFactory.MemoryType.SETS) {
                throw new IllegalArgumentException("Timely memories only support SETS as the bucket type!");
            }
            if (mask.isIdentity()) {
                return new TimelyIdentityMaskedTupleMemory(mask, owner, isLazy);
            }
            if (mask.getSize() == 0) {
                return new TimelyNullaryMaskedTupleMemory(mask, owner, isLazy);
            }
            if (1 == mask.getSize()) {
                return new TimelyUnaryMaskedTupleMemory(mask, owner, isLazy);
            }
            return new TimelyDefaultMaskedTupleMemory(mask, owner, isLazy);
        }
        if (isLazy) {
            throw new IllegalArgumentException("Lazy maintenance is only supported by timely memories!");
        }
        if (mask.isIdentity()) {
            return new IdentityMaskedTupleMemory(mask, bucketType, owner);
        }
        if (mask.getSize() == 0) {
            return new NullaryMaskedTupleMemory(mask, bucketType, owner);
        }
        if (1 == mask.getSize()) {
            return new UnaryMaskedTupleMemory(mask, bucketType, owner);
        }
        return new DefaultMaskedTupleMemory(mask, bucketType, owner);
    }

    @Override
    public Map<Tuple, Map<Tuple, Diff<Timestamp>>> resumeAt(Timestamp timestamp) {
        throw new UnsupportedOperationException("This is only supported by lazy timely memory implementations!");
    }

    @Override
    public Iterable<Tuple> getResumableSignatures() {
        throw new UnsupportedOperationException("This is only supported by lazy timely memory implementations!");
    }

    @Override
    public Timestamp getResumableTimestamp() {
        return null;
    }

    public void initializeWith(MaskedTupleMemory<Timestamp> other, Timestamp defaultValue) {
        throw new UnsupportedOperationException("This is only supported by timely memory implementations!");
    }

    public boolean isPresentAtInfinity(ITuple signature) {
        return this.get(signature) != null;
    }

    public boolean isTimely() {
        return false;
    }

    public Object getOwner() {
        return this.owner;
    }

    public TupleMask getMask() {
        return this.mask;
    }

    public abstract int getKeysetSize();

    public abstract int getTotalSize();

    public abstract Iterator<Tuple> iterator();

    public abstract Iterable<Tuple> getSignatures();

    public abstract Collection<Tuple> get(ITuple var1);

    public abstract Map<Tuple, Timeline<Timestamp>> getWithTimeline(ITuple var1);

    public Collection<Tuple> getOrEmpty(ITuple signature) {
        Collection<Tuple> result = this.get(signature);
        return result == null ? Collections.emptySet() : result;
    }

    public Map<Tuple, Timeline<Timestamp>> getOrEmptyWithTimeline(ITuple signature) {
        Map<Tuple, Timeline<Timestamp>> result = this.getWithTimeline(signature);
        return result == null ? Collections.emptyMap() : result;
    }

    public boolean remove(Tuple tuple, Tuple signature) {
        throw new UnsupportedOperationException("This is only supported by timeless memory implementations!");
    }

    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        throw new UnsupportedOperationException("This is only supported by timely memory implementations!");
    }

    public boolean remove(Tuple tuple) {
        throw new UnsupportedOperationException("This is only supported by timeless memory implementations!");
    }

    public Diff<Timestamp> removeWithTimestamp(Tuple tuple, Timestamp timestamp) {
        throw new UnsupportedOperationException("This is only supported by timely memory implementations!");
    }

    public boolean add(Tuple tuple, Tuple signature) {
        throw new UnsupportedOperationException("This is only supported by timeless memory implementations!");
    }

    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Tuple signature, Timestamp timestamp) {
        throw new UnsupportedOperationException("This is only supported by timely memory implementations!");
    }

    public boolean add(Tuple tuple) {
        throw new UnsupportedOperationException("This is only supported by timeless memory implementations!");
    }

    public Diff<Timestamp> addWithTimestamp(Tuple tuple, Timestamp timestamp) {
        throw new UnsupportedOperationException("This is only supported by timely memory implementations!");
    }

    protected MaskedTupleMemory(TupleMask mask, Object owner) {
        this.mask = mask;
        this.owner = owner;
    }

    protected IllegalStateException raiseDuplicateInsertion(Tuple tuple) {
        return new IllegalStateException(String.format("Duplicate insertion of tuple %s into %s", tuple, this.owner));
    }

    protected IllegalStateException raiseDuplicateDeletion(Tuple tuple) {
        return new IllegalStateException(String.format("Duplicate deletion of tuple %s from %s", tuple, this.owner));
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "<" + this.mask + ">@" + this.owner;
    }
}

