/**
 * Copyright (c) 2010-2016, Abel Hegedus, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.properties;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryHintOption;

/**
 * @author Abel Hegedus
 */
@SuppressWarnings("all")
public class HintsPropertySource implements IPropertySource {
  private final QueryEvaluationHint hint;
  
  public HintsPropertySource(final QueryEvaluationHint hint) {
    this.hint = hint;
  }
  
  @Override
  public Object getEditableValue() {
    return this;
  }
  
  @Override
  public String toString() {
    final int numOverrides = this.hint.getBackendHintSettings().size();
    switch (numOverrides) {
      case 0:
        return "No hints specified";
      case 1:
        return "1 overridden hint option";
      default:
        return String.format("%d overridden hint options", Integer.valueOf(numOverrides));
    }
  }
  
  @Override
  public IPropertyDescriptor[] getPropertyDescriptors() {
    final String category = "Hints";
    final List<IPropertyDescriptor> hints = Lists.<IPropertyDescriptor>newArrayList();
    final Consumer<QueryHintOption<?>> _function = (QueryHintOption<?> option) -> {
      String _qualifiedName = option.getQualifiedName();
      final PropertyDescriptor property = new PropertyDescriptor(option, _qualifiedName);
      property.setCategory(category);
      hints.add(property);
    };
    this.hint.getBackendHintSettings().keySet().forEach(_function);
    return hints.<IPropertyDescriptor>toArray(new IPropertyDescriptor[0]);
  }
  
  @Override
  public Object getPropertyValue(final Object id) {
    final Object hintValue = this.hint.getBackendHintSettings().get(id);
    return hintValue;
  }
  
  @Override
  public boolean isPropertySet(final Object id) {
    return false;
  }
  
  @Override
  public void resetPropertyValue(final Object id) {
  }
  
  @Override
  public void setPropertyValue(final Object id, final Object value) {
  }
}
