/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.test.internal.AwtScreenshot;

public final class Screenshots {
    public static String takeScreenshot(Class<?> testClass, String name) {
        File resultsDir = Screenshots.getResultsDirectory();
        String filename = new File(resultsDir.getAbsolutePath(), String.valueOf(testClass.getName()) + "." + name + ".png").getAbsolutePath();
        AwtScreenshot.dumpAwtScreenshot(filename);
        return filename;
    }

    public static File getResultsDirectory() {
        File resultsDir = Screenshots.getJunitReportOutput();
        if (resultsDir == null) {
            File eclipseDir = new File("").getAbsoluteFile();
            resultsDir = Screenshots.isRunByGerritHudsonJob() ? new File(eclipseDir, "/../").getAbsoluteFile() : new File(System.getProperty("java.io.tmpdir"));
        }
        resultsDir.mkdirs();
        return resultsDir;
    }

    private static File getJunitReportOutput() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length - 1) {
            if ("-junitReportOutput".equals(args[i])) {
                return new File(args[i + 1]).getAbsoluteFile();
            }
            ++i;
        }
        return null;
    }

    public static boolean isRunByGerritHudsonJob() {
        return System.getProperty("user.dir").matches(".*/(?:eclipse|rt\\.equinox)\\.[^/]+-Gerrit/.*");
    }
}

