/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.revisions.Revision;
import org.eclipse.jface.text.revisions.RevisionInformation;
import org.eclipse.jface.text.source.ILineRange;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSAnnotateBlock;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Annotate;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.AnnotateListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSHistoryPage;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.RemoteAnnotationStorage;
import org.eclipse.team.internal.ccvs.ui.operations.CVSOperation;
import org.eclipse.team.internal.ccvs.ui.operations.CommitterColors;
import org.eclipse.team.internal.core.TeamPlugin;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.history.IHistoryPage;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.team.ui.history.RevisionAnnotationController;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AbstractDecoratedTextEditor;

public class ShowAnnotationOperation
extends CVSOperation {
    private final ICVSResource fCVSResource;
    private final String fRevision;
    private final boolean fBinary;

    public ShowAnnotationOperation(IWorkbenchPart part, ICVSResource cvsResource, String revision, boolean binary) {
        super(part);
        this.fCVSResource = cvsResource;
        this.fRevision = revision;
        this.fBinary = binary;
    }

    @Override
    protected void execute(IProgressMonitor monitor) throws CVSException, InterruptedException {
        monitor.beginTask(null, 100);
        AnnotateListener listener = new AnnotateListener();
        this.fetchAnnotation(listener, this.fCVSResource, this.fRevision, Policy.subMonitorFor(monitor, 80));
        RevisionInformation information = this.createRevisionInformation(listener, Policy.subMonitorFor(monitor, 20));
        Display display = this.getPart().getSite().getShell().getDisplay();
        display.asyncExec(() -> {
            try {
                AbstractDecoratedTextEditor editor = this.getEditor(listener);
                if (editor != null) {
                    editor.showRevisionInformation(information, "org.eclipse.quickdiff.providers.CVSReferenceProvider");
                    IWorkbenchPage page = this.getPart().getSite().getPage();
                    this.showHistoryView(page, editor);
                    page.activate((IWorkbenchPart)editor);
                }
            }
            catch (PartInitException e) {
                CVSException.wrapException((CoreException)((Object)((Object)((Object)e))));
            }
        });
        monitor.done();
    }

    private IHistoryView showHistoryView(IWorkbenchPage page, AbstractDecoratedTextEditor editor) throws PartInitException {
        IHistoryView historyView;
        IHistoryPage historyPage;
        IResource object = this.fCVSResource.getIResource();
        if (object == null) {
            object = editor.getEditorInput();
        }
        if ((historyPage = (historyView = TeamUI.showHistoryFor((IWorkbenchPage)page, (Object)object, null)).getHistoryPage()) instanceof CVSHistoryPage) {
            CVSHistoryPage cvsHistoryPage = (CVSHistoryPage)historyPage;
            cvsHistoryPage.setMode(1);
            cvsHistoryPage.linkWithEditor();
        }
        return historyView;
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.ShowAnnotationOperation_taskName;
    }

    protected boolean hasCharset(ICVSResource cvsResource, InputStream contents) {
        try {
            return TeamPlugin.getCharset((String)cvsResource.getName(), (InputStream)contents) != null;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    private AbstractDecoratedTextEditor getEditor(AnnotateListener listener) throws PartInitException {
        IResource resource = this.fCVSResource.getIResource();
        if (resource instanceof IFile) {
            return RevisionAnnotationController.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (IFile)((IFile)resource));
        }
        if (this.fCVSResource instanceof ICVSRemoteResource) {
            return RevisionAnnotationController.openEditor((IWorkbenchPage)this.getPart().getSite().getPage(), (Object)this.fCVSResource, (IStorage)new RemoteAnnotationStorage((ICVSRemoteFile)this.fCVSResource, listener.getContents()));
        }
        return null;
    }

    private void fetchAnnotation(AnnotateListener listener, ICVSResource cvsResource, String revision, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        ICVSFolder folder = cvsResource.getParent();
        FolderSyncInfo info = folder.getFolderSyncInfo();
        ICVSRepositoryLocation location = KnownRepositories.getInstance().getRepository(info.getRoot());
        session.open(Policy.subMonitorFor(monitor, 10), false);
        try (Session session = new Session(location, folder, true);){
            Command.QuietOption quietness = CVSProviderPlugin.getPlugin().getQuietness();
            try {
                IStatus status;
                CVSProviderPlugin.getPlugin().setQuietness(Command.VERBOSE);
                ArrayList<Object> localOptions = new ArrayList<Object>();
                if (revision != null) {
                    localOptions.add(Annotate.makeRevisionOption((String)revision));
                }
                if (this.fBinary) {
                    localOptions.add(Annotate.FORCE_BINARY_ANNOTATE);
                }
                if ((status = Command.ANNOTATE.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{cvsResource}, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90))).getCode() == -10) {
                    throw new CVSServerException(status);
                }
            }
            finally {
                CVSProviderPlugin.getPlugin().setQuietness(quietness);
                monitor.done();
            }
        }
    }

    private RevisionInformation createRevisionInformation(AnnotateListener listener, IProgressMonitor monitor) throws CVSException {
        HashMap<String, ILogEntry> logEntriesByRevision = new HashMap<String, ILogEntry>();
        if (this.fCVSResource instanceof ICVSFile) {
            try {
                ILogEntry[] logEntries;
                ILogEntry[] iLogEntryArray = logEntries = ((ICVSFile)this.fCVSResource).getLogEntries(monitor);
                int n = logEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    ILogEntry entry = iLogEntryArray[n2];
                    logEntriesByRevision.put(entry.getRevision(), entry);
                    ++n2;
                }
            }
            catch (CVSException e) {
                throw e;
            }
            catch (TeamException e) {
                throw CVSException.wrapException((CoreException)((Object)e));
            }
        }
        final CommitterColors colors = CommitterColors.getDefault();
        RevisionInformation info = new RevisionInformation();
        class AnnotationControlCreator
        implements IInformationControlCreator {
            private final boolean isResizable;

            public AnnotationControlCreator(boolean isResizable) {
                this.isResizable = isResizable;
            }

            public IInformationControl createInformationControl(Shell parent) {
                DefaultInformationControl.IInformationPresenter presenter = (display, hoverInfo, presentation, maxWidth, maxHeight) -> {
                    StyleRange styleRange = new StyleRange();
                    styleRange.start = 0;
                    styleRange.length = hoverInfo.indexOf(10);
                    styleRange.fontStyle = 1;
                    presentation.addStyleRange(styleRange);
                    return hoverInfo;
                };
                if (this.isResizable) {
                    return new DefaultInformationControl(parent, null, presenter);
                }
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString(), presenter);
            }
        }
        info.setHoverControlCreator((IInformationControlCreator)new AnnotationControlCreator(false));
        info.setInformationPresenterControlCreator((IInformationControlCreator)new AnnotationControlCreator(true));
        HashMap<String, Revision> sets = new HashMap<String, Revision>();
        List annotateBlocks = listener.getCvsAnnotateBlocks();
        for (final CVSAnnotateBlock block : annotateBlocks) {
            final String revisionString = block.getRevision();
            Revision revision = (Revision)sets.get(revisionString);
            if (revision == null) {
                final ILogEntry entry = (ILogEntry)logEntriesByRevision.get(revisionString);
                if (entry == null) continue;
                revision = new Revision(){
                    private String fCommitter = null;

                    public Object getHoverInfo() {
                        return String.valueOf(entry.getAuthor()) + " " + entry.getRevision() + " " + DateFormat.getDateTimeInstance(2, 3).format(entry.getDate()) + "\n\n" + entry.getComment();
                    }

                    private String getCommitterId() {
                        if (this.fCommitter == null) {
                            this.fCommitter = block.toString().substring(0, block.toString().indexOf(32));
                        }
                        return this.fCommitter;
                    }

                    public String getId() {
                        return revisionString;
                    }

                    public Date getDate() {
                        return entry.getDate();
                    }

                    public RGB getColor() {
                        return colors.getCommitterRGB(this.getCommitterId());
                    }

                    public String getAuthor() {
                        return this.getCommitterId();
                    }
                };
                sets.put(revisionString, revision);
                info.addRevision(revision);
            }
            revision.addRange((ILineRange)new LineRange(block.getStartLine(), block.getEndLine() - block.getStartLine() + 1));
        }
        return info;
    }
}

