/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.diff.IThreeWayDiff;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.mapping.IResourceDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.CacheTreeContentsOperation;
import org.eclipse.ui.IWorkbenchPart;

public class CacheBaseContentsOperation
extends CacheTreeContentsOperation {
    public CacheBaseContentsOperation(IWorkbenchPart part, ResourceMapping[] mappings, IResourceDiffTree tree, boolean includeOutgoing) {
        super(part, mappings, tree);
    }

    @Override
    protected IFileRevision getRemoteFileState(IThreeWayDiff twd) {
        IResourceDiff diff = (IResourceDiff)twd.getRemoteChange();
        if (diff == null) {
            diff = (IResourceDiff)twd.getLocalChange();
        }
        IFileRevision base = diff.getBeforeState();
        return base;
    }

    @Override
    protected boolean isEnabledForDirection(int direction) {
        return true;
    }

    @Override
    protected ICVSRemoteResource buildTree(CVSTeamProvider provider) throws TeamException {
        return CVSProviderPlugin.getPlugin().getCVSWorkspaceSubscriber().buildBaseTree((IResource)provider.getProject(), true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected void execute(CVSTeamProvider provider, IResource[] resources, boolean recurse, IProgressMonitor monitor) throws CVSException, InterruptedException {
        IResource[] localChanges = this.getFilesWithLocalChanges(resources, recurse);
        super.execute(provider, resources, recurse, monitor);
        if (localChanges.length > 0) {
            this.performCleanTimestamps(localChanges[0].getProject(), localChanges, monitor);
        }
    }

    private IResource[] getFilesWithLocalChanges(IResource[] resources, boolean recurse) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IDiff[] nodes;
            IResource resource = iResourceArray[n2];
            IDiff[] iDiffArray = nodes = this.getTree().getDiffs(resource, recurse ? 2 : 1);
            int n3 = nodes.length;
            int n4 = 0;
            while (n4 < n3) {
                IDiff node = iDiffArray[n4];
                if (this.isFileWithLocalChange(node)) {
                    result.add(this.getTree().getResource(node));
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private boolean isFileWithLocalChange(IDiff node) {
        if (node instanceof IThreeWayDiff) {
            IThreeWayDiff twd = (IThreeWayDiff)node;
            return (twd.getDirection() == 256 || twd.getDirection() == 768) && this.getTree().getResource(node).getType() == 1;
        }
        return false;
    }

    private void performCleanTimestamps(IProject project, IResource[] resources, IProgressMonitor monitor) throws CVSException {
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
        folder.run(monitor1 -> {
            monitor1.beginTask(null, resources.length * 100);
            IResource[] iResourceArray2 = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceVariant remoteResource;
                IResource resource = iResourceArray2[n2];
                if (resource.exists() && resource.getType() == 1 && (remoteResource = (IResourceVariant)CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource)) != null && comparator.compareContents((IFile)resource, remoteResource, Policy.subMonitorFor(monitor1, 100))) {
                    ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                    cvsFile.checkedIn(null, false);
                }
                ++n2;
            }
            monitor1.done();
        }, Policy.subMonitorFor(monitor, 100));
    }
}

