/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.util.EventObject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tcf.te.ui.activator.UIPlugin;
import org.eclipse.tcf.te.ui.interfaces.IOptionListener;
import org.eclipse.tcf.te.ui.interfaces.IPreferenceKeys;
import org.eclipse.tcf.te.ui.interfaces.ISearchCallback;
import org.eclipse.tcf.te.ui.interfaces.ISearchable;
import org.eclipse.tcf.te.ui.jface.dialogs.CustomTitleAreaDialog;
import org.eclipse.tcf.te.ui.nls.Messages;
import org.eclipse.tcf.te.ui.search.SearchEngine;

public class TreeViewerSearchDialog
extends CustomTitleAreaDialog
implements ISearchCallback,
IOptionListener,
IPreferenceKeys {
    private static final String SEARCH_HELP_ID = "org.eclipse.tcf.te.ui.utils.TreeViewerSearchDialog.help";
    private static final int SEARCH_ID = 31;
    private static final int DEFAULT_WIDTH_TRIM = 20;
    private static final int DEFAULT_HEIGHT_TRIM = 160;
    private Button fBtnBackward;
    private Button fBtnWrap;
    private ProgressMonitorPart fPmPart;
    SearchEngine fSearcher;
    TreeViewer fViewer;
    ISearchable fSearchable;
    private Object rootElement;

    public TreeViewerSearchDialog(TreeViewer viewer, TreePath rootPath) {
        super(viewer.getTree().getShell());
        this.setShellStyle(2144);
        this.setHelpAvailable(true);
        this.setContextHelpId(SEARCH_HELP_ID);
        this.fViewer = viewer;
        this.fSearchable = this.getSearchable(rootPath);
        Assert.isNotNull((Object)this.fSearchable);
        this.fSearcher = new SearchEngine(this.fViewer, this.isDepthFirst(), this.fSearchable, rootPath);
        this.fSearchable.addOptionListener(this);
        this.rootElement = rootPath.getLastSegment();
        String text = this.fSearchable.getSearchMessage(this.rootElement);
        if (text != null) {
            this.setDefaultMessage(text, 0);
        }
    }

    protected boolean isDepthFirst() {
        return UIPlugin.getScopedPreferences().getBoolean("PrefDFS");
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 31: {
                this.searchButtonPressed();
                break;
            }
            case 12: {
                this.closePressed();
                break;
            }
            default: {
                super.buttonPressed(buttonId);
            }
        }
    }

    protected void closePressed() {
        this.fSearchable.removeOptionListener(this);
        this.fSearchable.persistValues(this.getDialogSettings());
        this.fSearcher.endSearch();
        this.setReturnCode(0);
        this.close();
    }

    private void searchButtonPressed() {
        this.getButton(31).setEnabled(false);
        this.fSearcher.startSearch(this, this.fPmPart);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 31, Messages.TreeViewerSearchDialog_BtnSearchText, true);
        this.createButton(parent, 12, Messages.TreeViewerSearchDialog_BtnCloseText, false);
        this.fSearchable.restoreValues(this.getDialogSettings());
        this.updateButtonState();
    }

    @Override
    public void searchDone(IStatus status, TreePath path) {
        Button btn = this.getButton(31);
        if (btn != null && !btn.isDisposed()) {
            btn.setEnabled(true);
            btn.setFocus();
        }
        if (status.isOK()) {
            if (path == null) {
                if (this.fSearcher.isWrap()) {
                    if (this.fSearcher.getLastResult() == null) {
                        String message = this.fSearchable.getCustomMessage(this.rootElement, "TreeViewerSearchDialog_NoSuchNode");
                        this.setMessage(message != null ? message : Messages.TreeViewerSearchDialog_NoSuchNode, 2);
                    }
                } else {
                    String message = this.fSearchable.getCustomMessage(this.rootElement, "TreeViewerSearchDialog_NoMoreNodeFound");
                    this.setMessage(message != null ? message : Messages.TreeViewerSearchDialog_NoMoreNodeFound, 2);
                }
            } else {
                this.setErrorMessage(null);
                this.setMessage(null);
            }
        } else {
            this.setErrorMessage(null);
            this.setMessage(null);
        }
    }

    protected void createDialogAreaContent(Composite parent) {
        super.createDialogAreaContent(parent);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(768));
        this.fSearchable.createCommonPart(this, container);
        this.fSearchable.createAdvancedPart(this, container);
        this.fPmPart = new ProgressMonitorPart(container, null, true);
        GridData data = new GridData(256);
        this.fPmPart.setLayoutData((Object)data);
        this.fPmPart.setVisible(false);
        String title = this.fSearchable.getSearchTitle(this.rootElement);
        this.getShell().setText(title);
        this.setTitle(title);
    }

    public void createSearchDirectionOptions(Composite container) {
        Assert.isNotNull((Object)container);
        SelectionAdapter l = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeViewerSearchDialog.this.selectionChanged(e);
            }
        };
        this.fBtnWrap = new Button(container, 32);
        this.fBtnWrap.setText(Messages.TreeViewerSearchDialog_BtnWrapText);
        this.fBtnWrap.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fBtnWrap.addSelectionListener((SelectionListener)l);
        if (this.fSearcher.isDepthFirst()) {
            this.fBtnBackward = new Button(container, 32);
            this.fBtnBackward.setText(Messages.TreeViewerSearchDialog_BtnBackText);
            this.fBtnBackward.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fBtnBackward.addSelectionListener((SelectionListener)l);
        }
    }

    private ISearchable getSearchable(TreePath path) {
        Assert.isNotNull((Object)path);
        Object element = path.getLastSegment();
        if (element != null) {
            if (element instanceof ISearchable) {
                return (ISearchable)element;
            }
            ISearchable searchable = null;
            if (element instanceof IAdaptable) {
                searchable = (ISearchable)((IAdaptable)element).getAdapter(ISearchable.class);
            }
            if (searchable == null) {
                searchable = (ISearchable)Platform.getAdapterManager().getAdapter(element, ISearchable.class);
            }
            return searchable;
        }
        return null;
    }

    void selectionChanged(SelectionEvent e) {
        Object src = e.getSource();
        if (src == this.fBtnBackward) {
            this.fSearcher.endSearch();
            this.fSearcher.setStartPath(this.fSearcher.getLastResult());
            this.fSearcher.setForeward(!this.fBtnBackward.getSelection());
        } else if (src == this.fBtnWrap) {
            this.fSearcher.setWrap(this.fBtnWrap.getSelection());
        }
    }

    protected Point getInitialSize() {
        Point size = this.fSearchable.getPreferredSize();
        if (size != null) {
            int width = size.x + 20;
            int height = size.y + 160;
            return new Point(width, height);
        }
        return super.getInitialSize();
    }

    @Override
    public void optionChanged(EventObject event) {
        this.fSearcher.resetPath();
        this.updateButtonState();
    }

    protected void updateButtonState() {
        Button button = this.getButton(31);
        if (button != null) {
            button.setEnabled(this.fSearchable.isInputValid());
        }
    }
}

