/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.ui.interfaces.IProcessMonitorUIDelegate;
import org.eclipse.tcf.te.tcf.processes.ui.navigator.runtime.AbstractLabelProviderDelegate;

public class PIDLabelProvider
extends AbstractLabelProviderDelegate
implements IFontProvider {
    Font pidFont = null;

    public PIDLabelProvider() {
        FontData fd = new FontData("Courier New", 10, 0);
        this.pidFont = new Font((Device)Display.getCurrent(), fd);
    }

    public void dispose() {
        super.dispose();
        if (this.pidFont != null) {
            this.pidFont.dispose();
        }
    }

    public String getText(Object element) {
        if (element instanceof IRuntimeModel || element instanceof IPendingOperationNode) {
            return "";
        }
        if (element instanceof IProcessContextNode) {
            IPeerNode peerNode;
            IProcessMonitorUIDelegate delegate;
            String id;
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicLong pid = new AtomicLong();
            final AtomicReference pidBI = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (node.getSysMonitorContext() != null) {
                        Object o;
                        pid.set(node.getSysMonitorContext().getPID());
                        if (pid.get() < 0L && (o = node.getSysMonitorContext().getProperties().get("PID")) instanceof BigInteger) {
                            pidBI.set((BigInteger)o);
                        }
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            String string = id = pid.get() >= 0L ? Long.toString(pid.get()) : "";
            if (pidBI.get() != null && ((BigInteger)pidBI.get()).signum() >= 0) {
                id = ((BigInteger)pidBI.get()).toString();
            }
            if (id.startsWith("P")) {
                id = id.substring(1);
            }
            String newId = (delegate = (IProcessMonitorUIDelegate)ServiceUtils.getUIServiceDelegate((Object)(peerNode = (IPeerNode)node.getAdapter(IPeerNode.class)), (Object)peerNode, IProcessMonitorUIDelegate.class)) != null ? delegate.getText(element, "PID", id) : null;
            return newId != null ? newId : id;
        }
        return "";
    }

    public Font getFont(Object element) {
        return this.pidFont;
    }
}

