/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util;

import org.eclipse.sirius.table.ui.tools.internal.paperclips.internal.util.Util;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

public class SWTUtil {
    public static FontData copy(FontData fontData) {
        return fontData == null ? null : new FontData(fontData.getName(), fontData.getHeight(), fontData.getStyle());
    }

    public static RGB copy(RGB rgb) {
        return rgb == null ? null : new RGB(rgb.red, rgb.green, rgb.blue);
    }

    public static RGB deriveRGB(int rgb) {
        int red = rgb >> 16 & 0xFF;
        int green = rgb >> 8 & 0xFF;
        int blue = rgb & 0xFF;
        return new RGB(red, green, blue);
    }

    public static boolean equal(PaletteData left, PaletteData right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return left.isDirect == right.isDirect && left.blueMask == right.blueMask && left.blueShift == right.blueShift && left.greenMask == right.greenMask && left.greenShift == right.greenShift && left.redMask == right.redMask && left.redShift == right.redShift && Util.equal((Object)left.colors, (Object)right.colors);
    }

    public static int hashCode(PaletteData data) {
        int result = 1;
        result = 31 * result + (data.isDirect ? 1231 : 1237);
        result = 31 * result + data.blueMask;
        result = 31 * result + data.blueShift;
        result = 31 * result + data.greenMask;
        result = 31 * result + data.greenShift;
        result = 31 * result + data.redMask;
        result = 31 * result + data.redShift;
        result = 31 * result + SWTUtil.hashCode(data.colors);
        return result;
    }

    private static int hashCode(Object[] array) {
        int prime = 31;
        if (array == null) {
            return 0;
        }
        int result = 1;
        int index = 0;
        while (index < array.length) {
            result = prime * result + (array[index] == null ? 0 : array[index].hashCode());
            ++index;
        }
        return result;
    }

    public static boolean equal(ImageData left, ImageData right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.width != right.width || left.height != right.height) {
            return false;
        }
        if (!SWTUtil.equal(left.palette, right.palette)) {
            return false;
        }
        int width = left.width;
        int[] leftPixels = new int[width];
        int[] rightPixels = new int[width];
        byte[] leftAlphas = new byte[width];
        byte[] rightAlphas = new byte[width];
        int y = 0;
        while (y < left.height) {
            left.getAlphas(0, y, width, leftAlphas, 0);
            right.getAlphas(0, y, width, rightAlphas, 0);
            if (!Util.equal((Object)leftAlphas, (Object)rightAlphas)) {
                return false;
            }
            left.getPixels(0, y, width, leftPixels, 0);
            right.getPixels(0, y, width, rightPixels, 0);
            if (!Util.equal((Object)leftPixels, (Object)rightPixels)) {
                int x = 0;
                while (x < width) {
                    if (leftAlphas[x] != 0 && leftPixels[x] != rightPixels[x]) {
                        return false;
                    }
                    ++x;
                }
            }
            ++y;
        }
        return true;
    }

    public static int hashCode(ImageData data) {
        int result = 1;
        result = 31 * result + data.width;
        result = 31 * result + data.height;
        result = 31 * result + SWTUtil.hashCode(data.palette);
        return result;
    }
}

