/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.tools.internal.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.internal.dialogs.ExtendedFeatureEditorDialog;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ExtensionFeatureDescription;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class ExtendedPropertySource
implements IPropertySource {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final IPropertyDescriptor[] EMPTY = new IPropertyDescriptor[0];
    private DSemanticDecorator target;
    private AdapterFactory adapterFactory;

    public ExtendedPropertySource(DSemanticDecorator target, AdapterFactory adapterFactory) {
        this.target = target;
        this.adapterFactory = adapterFactory;
    }

    protected ModelAccessor getModelAccessor() {
        return SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor((EObject)this.target);
    }

    public Object getEditableValue() {
        return this.target.getTarget();
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.target == null || this.target.getTarget() == null || this.getModelAccessor() == null) {
            return EMPTY;
        }
        ArrayList<IPropertyDescriptor> propertyDescriptors = new ArrayList<IPropertyDescriptor>();
        for (Object featureDescription : this.getModelAccessor().getAllExtensionFeatureDescriptions(this.target.getTarget())) {
            boolean isReferenceContainment;
            if (!(featureDescription instanceof ExtensionFeatureDescription)) continue;
            boolean bl = isReferenceContainment = ((ExtensionFeatureDescription)featureDescription).isReference() && ((ExtensionFeatureDescription)featureDescription).isContainment();
            if (isReferenceContainment) continue;
            propertyDescriptors.add(this.createPropertyDescriptor((ExtensionFeatureDescription)featureDescription));
        }
        return propertyDescriptors.toArray(new IPropertyDescriptor[propertyDescriptors.size()]);
    }

    private IPropertyDescriptor createPropertyDescriptor(ExtensionFeatureDescription featureDescription) {
        IItemPropertyDescriptor emfPropertyDescriptor = featureDescription.getPropertyDescriptor((Object)this.target.getTarget());
        ExtendedPropertyDescriptor result = emfPropertyDescriptor == null ? new ExtendedPropertyDescriptor(featureDescription) : new PropertyDescriptor((Object)this.target.getTarget(), emfPropertyDescriptor);
        return result;
    }

    public Object getPropertyValue(Object id) {
        Object object = null;
        if (id instanceof ExtensionFeatureDescription) {
            try {
                object = this.getModelAccessor().eGet(this.target.getTarget(), ExtendedPropertySource.getFeatureName((ExtensionFeatureDescription)id));
            }
            catch (FeatureNotFoundException featureNotFoundException) {}
        } else {
            IItemPropertySource ips = (IItemPropertySource)this.adapterFactory.adapt((Notifier)this.target.getTarget(), IItemPropertySource.class);
            if (ips != null) {
                object = ips.getPropertyDescriptor((Object)this.target.getTarget(), id).getPropertyValue((Object)this.target.getTarget());
            }
            if (this.target.getTarget() instanceof IAdaptable) {
                IPropertySource propertySource = (IPropertySource)((IAdaptable)this.target.getTarget()).getAdapter(IPropertySource.class);
                object = propertySource.getPropertyValue(id);
            }
        }
        return object != null ? object : "";
    }

    public boolean isPropertySet(Object id) {
        return this.getPropertyValue(id) != null;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (id instanceof ExtensionFeatureDescription) {
            ExtensionFeatureDescription desc = (ExtensionFeatureDescription)id;
            if (desc.isAttribute()) {
                try {
                    this.getModelAccessor().eSet(this.target.getTarget(), ExtendedPropertySource.getFeatureName((ExtensionFeatureDescription)id), value);
                }
                catch (FeatureNotFoundException e) {
                    SiriusPlugin.getDefault().error(Messages.ExtendedPropertySource_errorSettingValueMsg, (Throwable)e);
                }
            } else if (desc.isReference()) {
                this.getModelAccessor().eClear(this.target.getTarget(), ExtendedPropertySource.getFeatureName((ExtensionFeatureDescription)id));
                if (value instanceof Collection) {
                    Iterator iterValues = ((Collection)value).iterator();
                    while (iterValues.hasNext()) {
                        try {
                            this.getModelAccessor().eAdd(this.target.getTarget(), ExtendedPropertySource.getFeatureName((ExtensionFeatureDescription)id), iterValues.next());
                        }
                        catch (FeatureNotFoundException featureNotFoundException) {}
                    }
                }
            }
        } else {
            IItemPropertySource ips = (IItemPropertySource)this.adapterFactory.adapt((Notifier)this.target.getTarget(), IItemPropertySource.class);
            if (ips != null) {
                ips.getPropertyDescriptor((Object)this.target.getTarget(), id).setPropertyValue((Object)this.target.getTarget(), value);
            }
        }
    }

    private static String getFeatureName(ExtensionFeatureDescription extensionDescription) {
        return extensionDescription.getName();
    }

    private class ExtendedPropertyDescriptor
    extends BaseLabelProvider
    implements IPropertyDescriptor,
    ILabelProvider {
        private ExtensionFeatureDescription extensionDescription;

        ExtendedPropertyDescriptor(ExtensionFeatureDescription extensionDescription) {
            this.extensionDescription = extensionDescription;
        }

        public CellEditor createPropertyEditor(final Composite parent) {
            EObject editableValue = (EObject)ExtendedPropertySource.this.getEditableValue();
            Object editor = null;
            if (this.getPermissionAuthority(editableValue).canEditInstance(editableValue)) {
                if (this.extensionDescription.isAttribute()) {
                    editor = new TextCellEditor(parent);
                } else if (this.extensionDescription.isReference()) {
                    List referenceValues = Collections.emptyList();
                    try {
                        referenceValues = (List)ExtendedPropertySource.this.getModelAccessor().eGet(editableValue, ExtendedPropertySource.getFeatureName(this.extensionDescription));
                    }
                    catch (FeatureNotFoundException e) {
                        SiriusPlugin.getDefault().error(Messages.ExtendedPropertyDescriptor_errorRetrievingValueMsg, (Throwable)e);
                    }
                    final List ref = referenceValues == null ? Collections.EMPTY_LIST : referenceValues;
                    editor = new ExtendedDialogCellEditor(parent, this.getLabelProvider()){

                        protected Object openDialogBox(Control cellEditorWindow) {
                            ExtendedFeatureEditorDialog dialog = new ExtendedFeatureEditorDialog(parent.getShell(), ExtendedPropertyDescriptor.this.getChoices(), ref, ExtendedPropertyDescriptor.this.extensionDescription);
                            dialog.open();
                            return dialog.getResult();
                        }
                    };
                } else {
                    throw new UnsupportedOperationException(Messages.ExtendedPropertyDescriptor_unknownExtensionMsg);
                }
            }
            return editor;
        }

        private IPermissionAuthority getPermissionAuthority(EObject instance) {
            ModelAccessor accessor = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(instance);
            return accessor.getPermissionAuthority();
        }

        private List<EObject> getChoices() {
            LinkedList<EObject> result = new LinkedList<EObject>();
            if (this.extensionDescription.isReference() && !this.extensionDescription.isContainment()) {
                EObject root = EcoreUtil.getRootContainer((EObject)ExtendedPropertySource.this.target.getTarget());
                result.addAll(ExtendedPropertySource.this.getModelAccessor().eAllContents(root, this.extensionDescription.getTypeName()));
            }
            return result;
        }

        public String getCategory() {
            return Messages.ExtendedPropertyDescriptor_categoryName;
        }

        public String getDescription() {
            return Messages.ExtendedPropertyDescriptor_description;
        }

        public String getDisplayName() {
            return ExtendedPropertySource.getFeatureName(this.extensionDescription);
        }

        public String[] getFilterFlags() {
            return EMPTY_STRING_ARRAY;
        }

        public Object getHelpContextIds() {
            return null;
        }

        public Object getId() {
            return this.extensionDescription;
        }

        public ILabelProvider getLabelProvider() {
            return this;
        }

        public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
            if (anotherProperty instanceof ExtendedPropertyDescriptor) {
                return this.extensionDescription.equals((Object)((ExtendedPropertyDescriptor)anotherProperty).extensionDescription);
            }
            return false;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            String text = null;
            if (element instanceof EObject) {
                try {
                    text = String.valueOf(ExtendedPropertySource.this.getModelAccessor().eGet((EObject)element, ExtendedPropertySource.getFeatureName(this.extensionDescription)));
                }
                catch (FeatureNotFoundException e) {
                    SiriusPlugin.getDefault().error(Messages.ExtendedPropertyDescriptor_errorGettingValueMsg, (Throwable)e);
                    text = e.getMessage();
                }
            } else if (element instanceof Collection) {
                StringBuffer sb = new StringBuffer("[");
                boolean first = true;
                for (Object next : (Collection)element) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    if (next instanceof EObject) {
                        sb.append(EMFCoreUtil.getQualifiedName((EObject)((EObject)next), (boolean)true));
                        continue;
                    }
                    if (next instanceof Collection) {
                        sb.append(this.getText(next));
                        continue;
                    }
                    sb.append(String.valueOf(next));
                }
                sb.append("]");
                text = sb.toString();
            } else if (element == null) {
                text = "";
            } else if (element instanceof EEnumLiteral) {
                text = ((EEnumLiteral)element).getLiteral();
            } else {
                return String.valueOf(element);
            }
            return text;
        }
    }
}

